/*
 * Decompiled with CFR 0.152.
 */
package jams.components.data;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="ArrayIterator", author="Sven Kralisch", description="Iterates over arrays of double values, providing list of double values.", date="2023-07-19", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ArrayIterator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of values to extract from (all dataArrays must have the same length)")
    public Attribute.DoubleArray[] dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the index of the value to be extracted")
    public Attribute.Integer arrayIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="extracted value")
    public Attribute.Double[] dataValue;

    public void run() {
        for (int i = 0; i < this.dataArray.length; ++i) {
            this.dataValue[i].setValue(this.dataArray[i].getValue()[this.arrayIndex.getValue()]);
        }
        this.arrayIndex.setValue(this.arrayIndex.getValue() + 1);
    }
}

