/*
 * Decompiled with CFR 0.152.
 */
package jams.components.core;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSLong;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;

@JAMSComponentDescription(title="Temporal context", author="Sven Kralisch", date="2005-07-31", version="1.0_1", description="This component represents a JAMS context which can be used to represent iteration over discrete time steps typically used in conceptionalenvironmental models")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2005-07-31", comment="Initial Version"), @VersionComments.Entry(version="1.1_0", date="2015-03-16", comment="Added time step output")})
public class TemporalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of temporal context")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current date of temporal context")
    public Attribute.Calendar current;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Print the current time every \"printTime\" time steps", defaultValue="0")
    public Attribute.Integer printTime;
    private Attribute.Calendar lastValue;
    private int counter = 0;

    protected DataTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer((Context)this, store, JAMSLong.class){

            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String string;
                    if (filter.getContext() == TemporalContext.this || filter.isFiltered(string = filter.getContext().getTraceMark())) continue;
                    return;
                }
                String traceMark = TemporalContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != TemporalContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    public void init() {
        super.init();
        if (this.timeInterval == null) {
            this.getModel().getRuntime().sendErrorMsg(JAMS.i18n((String)"time_interval_for_JAMS_Temporal_context_not_provided"));
        }
        if (this.timeInterval.getEnd() == null || this.timeInterval.getStart() == null) {
            this.getModel().getRuntime().sendErrorMsg(JAMS.i18n((String)"time_interval_for_JAMS_Temporal_context_not_provided"));
        }
        this.lastValue = this.timeInterval.getEnd().clone();
        this.lastValue.add(this.timeInterval.getTimeUnit(), -this.timeInterval.getTimeUnitCount());
        this.lastValue.add(14, 1);
        if (this.current == null) {
            this.current = this.getModel().getRuntime().getDataFactory().createCalendar();
        }
    }

    public void initAll() {
        super.initAll();
    }

    public void cleanupAll() {
        super.cleanupAll();
    }

    public void run() {
        super.run();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (!dataTracer.hasOutput()) continue;
                dataTracer.endMark();
                dataTracer.setOutput(false);
            }
        }
    }

    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    protected ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new ComponentEnumerator(){
                ComponentEnumerator ce;
                {
                    this.ce = TemporalContext.this.getTCChildrenEnumerator();
                }

                public boolean hasNext() {
                    boolean nextTime = TemporalContext.this.current.before(TemporalContext.this.lastValue);
                    boolean nextComp = this.ce.hasNext();
                    return nextTime || nextComp;
                }

                public boolean hasPrevious() {
                    boolean prevTime = TemporalContext.this.current.after(TemporalContext.this.timeInterval.getStart());
                    boolean prevComp = this.ce.hasPrevious();
                    return prevTime || prevComp;
                }

                public Component next() {
                    if (!this.ce.hasNext() && TemporalContext.this.current.before(TemporalContext.this.lastValue)) {
                        for (DataTracer dataTracer : TemporalContext.this.getDataTracers()) {
                            dataTracer.trace();
                        }
                        TemporalContext.this.current.add(TemporalContext.this.timeInterval.getTimeUnit(), TemporalContext.this.timeInterval.getTimeUnitCount());
                        this.printTime();
                        this.ce.reset();
                    }
                    return this.ce.next();
                }

                public void reset() {
                    TemporalContext.this.current.setValue(TemporalContext.this.timeInterval.getStart().getValue());
                    this.printTime();
                    this.ce.reset();
                }

                public Component previous() {
                    if (this.ce.hasPrevious()) {
                        return this.ce.previous();
                    }
                    TemporalContext.this.current.add(TemporalContext.this.timeInterval.getTimeUnit(), -TemporalContext.this.timeInterval.getTimeUnitCount());
                    while (this.ce.hasNext()) {
                        this.ce.next();
                    }
                    return this.ce.previous();
                }

                private void printTime() {
                    if (TemporalContext.this.printTime.getValue() > 0) {
                        if (TemporalContext.this.counter % TemporalContext.this.printTime.getValue() == 0) {
                            TemporalContext.this.counter = 0;
                            TemporalContext.this.getModel().getRuntime().println(TemporalContext.this.getInstanceName() + " " + TemporalContext.this.current, 0);
                        }
                        TemporalContext.this.counter++;
                    }
                }
            };
        }
        return new ComponentEnumerator(){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public Component next() {
                return null;
            }

            public Component previous() {
                return null;
            }

            public void reset() {
            }
        };
    }

    private DataTracer[] getDataTracers() {
        return this.dataTracers;
    }

    private ComponentEnumerator getTCChildrenEnumerator() {
        return this.getChildrenEnumerator();
    }

    public long getNumberOfIterations() {
        return this.timeInterval.getNumberOfTimesteps();
    }

    public String getTraceMark() {
        return this.current.toString();
    }
}

