/*
 * Decompiled with CFR 0.152.
 */
package jams.components.conditional;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="BooleanConditionalContext", author="Sven Kralisch", date="7. January 2008", description="This component represents a JAMS context which can be used to conditionally execute components. This context must contain two components. If \"condition\" is true, the first one will be executed, otherwise the second one.")
public class BooleanConditionalExecutionContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Boolean attribute defining if the component should be executed")
    public Attribute.Boolean condition;

    public long getNumberOfIterations() {
        return this.condition.getValue() ? 1 : 0;
    }

    public ComponentEnumerator getInitEnumerator() {
        if (this.condition.getValue()) {
            return super.getInitEnumerator();
        }
        return new EmptyEnumerator();
    }

    public ComponentEnumerator getInitAllEnumerator() {
        if (this.condition.getValue()) {
            return super.getInitAllEnumerator();
        }
        return new EmptyEnumerator();
    }

    public ComponentEnumerator getRunEnumerator() {
        if (this.condition.getValue()) {
            return super.getRunEnumerator();
        }
        return new EmptyEnumerator();
    }

    public ComponentEnumerator getCleanupEnumerator() {
        if (this.condition.getValue()) {
            return super.getCleanupEnumerator();
        }
        return new EmptyEnumerator();
    }

    class EmptyEnumerator
    implements ComponentEnumerator {
        final DummyComponent dummy = new DummyComponent();
        boolean next = true;

        EmptyEnumerator() {
        }

        public boolean hasNext() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.hasNext();
        }

        public Component next() {
            return this.dummy;
        }

        public Component previous() {
            return this.next();
        }

        public void reset() {
            this.next = true;
        }

        public class DummyComponent
        extends JAMSComponent {
        }
    }
}

