/*
 * Decompiled with CFR 0.152.
 */
package jams.components.concurrency;

import jams.components.concurrency.CallableComponent;
import jams.model.Component;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@JAMSComponentDescription(title="ConcurrentContext", author="Sven Kralisch", description="A context that executes its child components concurrently")
public class ConcurrentContext
extends JAMSContext {
    private transient ExecutorService executor;
    transient List<Callable<Component>> callables;

    public void init() {
        super.init();
        this.executor = null;
    }

    public void run() {
        if (this.executor == null) {
            if (this.runEnumerator == null) {
                this.runEnumerator = this.getRunEnumerator();
            }
            this.runEnumerator.reset();
            this.callables = new ArrayList<Callable<Component>>();
            while (this.runEnumerator.hasNext()) {
                Component comp = this.runEnumerator.next();
                this.callables.add(new CallableComponent(comp));
            }
            this.executor = Executors.newFixedThreadPool(this.callables.size());
        }
        try {
            List<Future<Component>> futures = this.executor.invokeAll(this.callables);
            for (Future<Component> f : futures) {
                f.get();
                ++this.runCount;
            }
        }
        catch (ExecutionException ee) {
            this.getModel().getRuntime().handle((Throwable)ee, this.getInstanceName());
        }
        catch (InterruptedException ie) {
            this.getModel().getRuntime().handle((Throwable)ie, this.getInstanceName());
        }
        this.updateEntityData();
    }

    public void cleanup() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public void setExecutionState(int state) {
        switch (state) {
            case 1: {
                this.doRun = true;
                break;
            }
            case 0: {
                this.doRun = false;
                break;
            }
            case 2: {
                this.doRun = false;
            }
        }
    }
}

