/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.IOException;
import java.io.ObjectInputStream;

@JAMSComponentDescription(title="DoubleSubstract", author="Sven Kralisch", description="Substracts two double values and return the result", date="2019-12-08", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Fixed bug and added option to calc absolute values")})
public class DoubleSubstract
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="First operand")
    public Attribute.Double[] d1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Second operand")
    public Attribute.Double[] d2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculate absolute values?", defaultValue="false")
    public Attribute.Boolean abs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Result of d1-d2 (element-wise)")
    public Attribute.Double[] result;
    transient Runnable job;

    public void init() {
        if (this.d1.length != this.result.length) {
            this.getModel().getRuntime().sendHalt("Attribute result has wrong length, should be length of d1");
        }
        if (this.d1.length == this.d2.length) {
            this.job = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < DoubleSubstract.this.d1.length; ++i) {
                        double d = DoubleSubstract.this.d1[i].getValue() - DoubleSubstract.this.d2[i].getValue();
                        if (DoubleSubstract.this.abs.getValue()) {
                            d = Math.abs(d);
                        }
                        DoubleSubstract.this.result[i].setValue(d);
                    }
                }
            };
        } else if (this.d2.length == 1) {
            this.job = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < DoubleSubstract.this.d1.length; ++i) {
                        double d = DoubleSubstract.this.d1[i].getValue() - DoubleSubstract.this.d2[0].getValue();
                        if (DoubleSubstract.this.abs.getValue()) {
                            d = Math.abs(d);
                        }
                        DoubleSubstract.this.result[i].setValue(d);
                    }
                }
            };
        } else {
            this.getModel().getRuntime().sendHalt("Attribute d2 has wrong length, should be 1 or length of d1");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public void run() {
        this.job.run();
    }
}

