/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.aggregators.Aggregator;
import jams.aggregators.TemporalAggregator;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;

@JAMSComponentDescription(title="TimePeriodAggregator", author="Christian Fischer", description="Aggregates timeseries values to a given time period of day, month, year or dekade")
public abstract class TemporalAggregatorBase
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="provides the current time of the model")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current time")
    public Attribute.TimeInterval interval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="current aggregation interval start time")
    public Attribute.Calendar aggregationTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="aggregationMode: sum | avg | min | max | ind | prop | last | var | med | index")
    public Attribute.String[] aggregationMode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="enable or disable aggregation for the i-th value")
    public Attribute.Boolean[] enabled;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The reference time period for aggregation, e.g. yearly mean of months mean, possible values are: hourly, daily, monthly, seasonal, halfyear, hydhalfyear, yearly, decadly")
    public Attribute.String aggregationTimeUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="custom time period to which values should be aggregated. Is only used when timeUnit is set to custom.", defaultValue="")
    public Attribute.String customOuterTimePeriod;
    private TemporalAggregator.AggregationTimePeriod innerTimeUnitID = TemporalAggregator.AggregationTimePeriod.DAILY;
    private Aggregator.AggregationMode[] innerAggregationModeID = null;
    private boolean[] isEnabled = null;
    protected int n = 0;
    protected final ArrayList<Attribute.TimeInterval> customTimePeriods = new ArrayList();

    boolean isEnabled(int i) {
        return this.isEnabled[i];
    }

    protected Aggregator.AggregationMode getAggregationModeID(int i) {
        return this.innerAggregationModeID[i];
    }

    protected TemporalAggregator.AggregationTimePeriod getInnerTimeUnitID() {
        return this.innerTimeUnitID;
    }

    protected int getNumberOfAttributes() {
        return this.n;
    }

    protected boolean checkConfiguration() {
        if (this.aggregationMode != null && this.aggregationMode.length != this.n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"innerAggregationMode\" does not match the number of attributes");
            return false;
        }
        if (this.enabled != null && this.enabled.length != this.n) {
            this.getModel().getRuntime().sendInfoMsg("Number of values in parameter \"enabled\" does not match the number of attributes");
            return false;
        }
        return true;
    }

    private void initEnableArray() {
        this.isEnabled = new boolean[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.isEnabled[i] = this.enabled == null || this.enabled[i] == null || this.enabled[i].getValue();
        }
    }

    public void init() {
        this.getModel().getRuntime().sendInfoMsg("Init " + this.getInstanceName());
        this.n = this.aggregationMode.length;
        this.innerTimeUnitID = TemporalAggregator.AggregationTimePeriod.fromString((String)this.aggregationTimeUnit.getValue());
        if (!this.checkConfiguration()) {
            this.getModel().getRuntime().sendHalt("Configuration of component " + this.getInstanceName() + " is not valid!");
        }
        this.initEnableArray();
        this.innerAggregationModeID = new Aggregator.AggregationMode[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.innerAggregationModeID[i] = this.aggregationMode.length > i && this.aggregationMode[i] != null ? Aggregator.AggregationMode.fromAbbreviation((String)this.aggregationMode[i].getValue()) : Aggregator.AggregationMode.AVERAGE;
        }
        this.customTimePeriods.clear();
        if (!this.customOuterTimePeriod.getValue().isEmpty()) {
            String[] periods;
            for (String period : periods = this.customOuterTimePeriod.getValue().split(";")) {
                period = period + " 6 1";
                Attribute.TimeInterval ti = DefaultDataFactory.getDataFactory().createTimeInterval();
                ti.setValue(period);
                this.customTimePeriods.add(ti);
            }
            for (int i = 0; i < this.customTimePeriods.size(); ++i) {
                Attribute.TimeInterval tii = this.customTimePeriods.get(i);
                for (int j = 0; j < this.customTimePeriods.size(); ++j) {
                    if (i == j) continue;
                    Attribute.TimeInterval tij = this.customTimePeriods.get(j);
                    if ((!tii.getStart().before(tij.getStart()) || !tii.getEnd().after(tij.getStart())) && (!tii.getEnd().before(tij.getEnd()) || !tii.getEnd().after(tij.getEnd()))) continue;
                    this.getModel().getRuntime().sendHalt("Error: Time-Interval " + tii + " is overlapping with " + tij + "!");
                }
            }
        }
    }
}

