/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.aggregators.Aggregator;
import jams.aggregators.BasicTemporalAggregator;
import jams.aggregators.DoubleAggregator;
import jams.aggregators.TemporalAggregator;
import jams.components.aggregate.TemporalAggregatorBase;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.Collection;

@JAMSComponentDescription(title="TimePeriodAggregator", author="Christian Fischer", description="Aggregates timeseries values to a given time period of day, month, year or dekade")
public class TemporalAggregator
extends TemporalAggregatorBase {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The be aggregated results")
    public Attribute.Double[] outputAttributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated")
    public Attribute.Double[] inputAttributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated", defaultValue="1.0")
    public Attribute.Double weight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The value(s) to be aggregated", defaultValue="")
    public Attribute.Entity internalState;

    public void initAll() {
        this.aggregationTime.setTimeInMillis(-10000000000L);
        jams.aggregators.TemporalAggregator[] aggregators = new jams.aggregators.TemporalAggregator[this.getNumberOfAttributes()];
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!this.isEnabled(i)) continue;
            Aggregator.AggregationMode innerMode = this.getAggregationModeID(i);
            TemporalAggregator.AggregationTimePeriod innerTimeUnitID = this.getInnerTimeUnitID();
            BasicTemporalAggregator aggregator = null;
            aggregator = innerTimeUnitID.equals((Object)TemporalAggregator.AggregationTimePeriod.CUSTOM) ? new BasicTemporalAggregator((Aggregator)DoubleAggregator.create((Aggregator.AggregationMode)innerMode), innerTimeUnitID, (Collection)this.customTimePeriods) : new BasicTemporalAggregator((Aggregator)DoubleAggregator.create((Aggregator.AggregationMode)innerMode), innerTimeUnitID);
            aggregator.addConsumer((TemporalAggregator.Consumer)new DataConsumer(this.outputAttributes[i]));
            aggregator.init();
            aggregators[i] = aggregator;
        }
        this.internalState.setObject("aggregators", (Object)aggregators);
    }

    protected boolean isConsiderable(Attribute.Calendar c) {
        return true;
    }

    public void run() {
        jams.aggregators.TemporalAggregator[] aggregators = (jams.aggregators.TemporalAggregator[])this.internalState.getObject("aggregators");
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!this.isEnabled(i)) continue;
            jams.aggregators.TemporalAggregator aggregator = aggregators[i];
            if (!this.isConsiderable(this.time)) continue;
            aggregator.aggregate(this.time, (Object)this.inputAttributes[i].getValue());
        }
        this.time.add(this.interval.getTimeUnit(), this.interval.getTimeUnitCount());
        boolean isLastTimeStep = this.time.after(this.interval.getEnd());
        if (isLastTimeStep) {
            for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                if (!this.isEnabled(i)) continue;
                aggregators[i].finish();
            }
        }
        this.time.add(this.interval.getTimeUnit(), -this.interval.getTimeUnitCount());
    }

    protected class DataConsumer
    implements TemporalAggregator.Consumer<Double> {
        Attribute.Double outputAttribute;

        DataConsumer(Attribute.Double outputAttribute) {
            this.outputAttribute = outputAttribute;
        }

        public void consume(Attribute.Calendar c, Double v) {
            if (TemporalAggregator.this.aggregationTime != null) {
                TemporalAggregator.this.aggregationTime.setValue(c);
            }
            this.outputAttribute.setValue(v / TemporalAggregator.this.weight.getValue());
        }
    }
}

