/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.JAMS;
import jams.aggregators.Aggregator;
import jams.aggregators.BasicTemporalAggregator;
import jams.aggregators.DoubleIteratorAggregator;
import jams.aggregators.TemporalAggregator;
import jams.components.aggregate.TemporalAggregatorBase;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.Collection;
import java.util.Iterator;

@JAMSComponentDescription(title="SpatioTemporalAggregator", author="Christian Fischer", description="Aggregates timeseries values to a given time period of day, month, year or dekade")
public class SpatioTemporalAggregator
extends TemporalAggregatorBase {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The be aggregated results")
    public Attribute.String[] outputAttributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated")
    public Attribute.String[] inputAttributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated", defaultValue="")
    public Attribute.String weightAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value(s) to be aggregated")
    public Attribute.EntityCollection entities;
    int N = 0;
    TemporalAggregator<Iterable<Double>>[] aggregators;

    @Override
    public void init() {
        super.init();
        this.aggregationTime.setTimeInMillis(-10000000000L);
        this.N = this.entities.getEntities().size();
        this.aggregators = new TemporalAggregator[this.getNumberOfAttributes()];
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!this.isEnabled(i)) continue;
            Aggregator.AggregationMode innerMode = this.getAggregationModeID(i);
            TemporalAggregator.AggregationTimePeriod innerTimeUnitID = this.getInnerTimeUnitID();
            BasicTemporalAggregator aggregator = null;
            aggregator = innerTimeUnitID.equals((Object)TemporalAggregator.AggregationTimePeriod.CUSTOM) ? new BasicTemporalAggregator((Aggregator)DoubleIteratorAggregator.create((Aggregator.AggregationMode)innerMode, (int)this.N), innerTimeUnitID, (Collection)this.customTimePeriods) : new BasicTemporalAggregator((Aggregator)DoubleIteratorAggregator.create((Aggregator.AggregationMode)innerMode, (int)this.N), innerTimeUnitID);
            aggregator.addConsumer((TemporalAggregator.Consumer)new DataConsumer(this.outputAttributeNames[i].getValue()));
            aggregator.init();
            this.aggregators[i] = aggregator;
        }
    }

    protected boolean isConsiderable(Attribute.Calendar c) {
        return true;
    }

    protected void finish() {
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!this.isEnabled(i)) continue;
            this.aggregators[i].finish();
        }
    }

    public void run() {
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!this.isEnabled(i)) continue;
            TemporalAggregator<Iterable<Double>> aggregator = this.aggregators[i];
            if (!this.isConsiderable(this.time)) continue;
            aggregator.aggregate(this.time, (Object)new EntityIterable(this.inputAttributeNames[i].getValue(), this.weightAttribute.getValue(), this.entities));
        }
        this.time.add(this.interval.getTimeUnit(), this.interval.getTimeUnitCount());
        boolean isLastTimeStep = this.time.after(this.interval.getEnd());
        if (isLastTimeStep) {
            this.finish();
        }
        this.time.add(this.interval.getTimeUnit(), -this.interval.getTimeUnitCount());
    }

    public void cleanup() {
        this.finish();
    }

    protected class EntityIterable
    implements Iterable<Double> {
        String name;
        Attribute.EntityCollection entities;
        String wAttributeName;

        public EntityIterable(String name, String wAttributeName, Attribute.EntityCollection entities) {
            this.name = name;
            this.entities = entities;
            this.wAttributeName = wAttributeName;
        }

        @Override
        public Iterator<Double> iterator() {
            return new EntityIterator();
        }

        private class EntityIterator
        implements Iterator<Double> {
            Iterator<Attribute.Entity> iter;

            private EntityIterator() {
                this.iter = EntityIterable.this.entities.getEntities().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Double next() {
                Attribute.Entity e = this.iter.next();
                double value = e.getDouble(EntityIterable.this.name);
                double w = 1.0;
                if (value == JAMS.getMissingDataValue()) {
                    return Double.NaN;
                }
                if (!EntityIterable.this.wAttributeName.isEmpty()) {
                    w = e.getDouble(EntityIterable.this.wAttributeName);
                }
                return value / w;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    protected class DataConsumer
    implements TemporalAggregator.Consumer<Iterable<Double>> {
        String outputAttributeName;

        DataConsumer(String outputAttributeName) {
            this.outputAttributeName = outputAttributeName;
        }

        public void consume(Attribute.Calendar c, Iterable<Double> v) {
            if (SpatioTemporalAggregator.this.aggregationTime != null) {
                SpatioTemporalAggregator.this.aggregationTime.setValue(c);
            }
            Iterator<Double> iter = v.iterator();
            for (Attribute.Entity e : SpatioTemporalAggregator.this.entities.getEntities()) {
                double d = iter.next();
                if (Double.isNaN(d)) {
                    e.setDouble(this.outputAttributeName, JAMS.getMissingDataValue());
                    continue;
                }
                e.setDouble(this.outputAttributeName, d);
            }
        }
    }
}

