/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.DataSupplier;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class SpatialOutputDataStore {
    File file = null;
    BufferedWriter writer = null;
    Collection<Double> ids = null;
    DecimalFormat df2EPos = new DecimalFormat("+0.00000E000;-0.00000E000", new DecimalFormatSymbols(Locale.ENGLISH));
    DecimalFormat df2ENeg = new DecimalFormat("+0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.ENGLISH));
    static boolean text = true;

    public SpatialOutputDataStore(File file) throws IOException {
        this.file = file;
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public void setHeader(Collection<Double> ids) throws IOException {
        this.writer.write("@context\n");
        this.writer.write("jams.components.core.SpatialContext\tHRULoop\t" + ids.size() + "\n");
        this.writer.write("@ancestors\n");
        this.writer.write("jams.components.core.TemporalContext\tTimeLoop\t9999\n");
        this.writer.write("@filters\n");
        this.writer.write("@attributes\n");
        this.writer.write("ID\tvalue\n");
        this.writer.write("@types\n");
        this.writer.write("JAMSLong\tJAMSDouble\n");
        this.writer.write("@data\n");
        this.ids = ids;
    }

    public File getFile() {
        return this.file;
    }

    public void writeData(String entry, DataSupplier<Double> values) throws IOException {
        this.writer.write("TimeLoop\t" + entry + "\n");
        this.writer.write("@start\n");
        Iterator<Double> iter = this.ids.iterator();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            String result;
            double x = (Double)iterator.next();
            if (Double.isInfinite(x) || Double.isNaN(x)) {
                x = -9999.0;
            }
            if ((result = this.df2EPos.format(x)).contains("E-")) {
                result = this.df2ENeg.format(x);
            }
            if (!iter.hasNext()) continue;
            this.writer.write(iter.next().longValue() + "\t" + result + "\n");
        }
        this.writer.write("@end\n");
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

