/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;
import java.util.Collections;

public class QuantileComputer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the current modelling time step")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The efficiency time interval, a subset of modelTimeInterval")
    public Attribute.TimeInterval effTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="value attribute")
    public Attribute.Double[] input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="quantile to be computed", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double quantile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="quantile to be computed")
    public Attribute.Double[] output;
    ArrayList<Double>[] timeserie = null;

    public void run() {
        int i;
        if (this.effTimeInterval != null && this.time != null && (this.time.before(this.effTimeInterval.getStart()) || this.time.after(this.effTimeInterval.getEnd()))) {
            return;
        }
        if (this.timeserie == null) {
            this.timeserie = new ArrayList[this.input.length];
            for (i = 0; i < this.input.length; ++i) {
                this.timeserie[i] = new ArrayList();
            }
        }
        for (i = 0; i < this.input.length; ++i) {
            this.timeserie[i].add(this.input[i].getValue());
        }
    }

    public void cleanup() {
        if (this.timeserie.length == 0) {
            return;
        }
        int position = Math.round((float)this.timeserie[0].size() * (float)this.quantile.getValue());
        for (int i = 0; i < this.timeserie.length; ++i) {
            Collections.sort(this.timeserie[i]);
            this.output[i].setValue(this.timeserie[i].get(position).doubleValue());
            System.out.println("Quantile " + this.output[i]);
        }
    }
}

