/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="MinMax", author="Sven Kralisch", description="Simple calculator for minimum/maximum", date="2022-02-10", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class MinMax
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The value to calculate min/max of")
    public Attribute.Double value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="maximum value")
    public Attribute.Double maximum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="minimum value")
    public Attribute.Double minimum;

    public void initAll() {
        if (this.maximum != null) {
            this.maximum.setValue(Double.MIN_VALUE);
        }
        if (this.minimum != null) {
            this.minimum.setValue(Double.MAX_VALUE);
        }
    }

    public void run() {
        if (this.maximum != null) {
            this.maximum.setValue(Math.max(this.maximum.getValue(), this.value.getValue()));
        }
        if (this.minimum != null) {
            this.minimum.setValue(Math.min(this.minimum.getValue(), this.value.getValue()));
        }
    }
}

