/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="EntityCollectionAggregator", author="Sven Kralisch", description="Aggregate values of entities in a collection", date="2025-07-01", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntityCollectionAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of entities", defaultValue="subbasinhrus")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of attribute to be aggregated")
    public Attribute.String[] attributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of weight to be used during aggregation", defaultValue="area")
    public Attribute.String weightName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Should weight be considered?", defaultValue="true")
    public Attribute.Boolean doWeighting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculate mean?", defaultValue="true")
    public Attribute.Boolean calcMean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the result attribute")
    public Attribute.Double[] aggregateValues;

    public void run() {
        if (this.attributeNames.length != this.aggregateValues.length) {
            this.getModel().getRuntime().sendHalt("Error: length mismatch of attributeNames and aggregateValues");
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            double sum = 0.0;
            for (Attribute.Entity entity : this.entities.getEntities()) {
                double value = entity.getDouble(this.attributeNames[i].getValue());
                double weight = this.doWeighting.getValue() ? entity.getDouble(this.weightName.getValue()) : 1.0;
                sum += value * weight;
            }
            if (this.calcMean.getValue()) {
                sum /= (double)this.entities.getEntities().size();
            }
            this.aggregateValues[i].setValue(sum);
        }
    }
}

