/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="DayOfYear", author="Christian Fischer", description="calculates the first and last day in year where a boolean value is set to tre")
public class DayOfYear
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="boolean inputs")
    public Attribute.Double[] input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="day of year")
    public Attribute.Double[] day;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="day of year, when first half year")
    public Attribute.Double[] dayFirstHalfYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="day of year, when first half year")
    public Attribute.Double[] daySecondHalfYear;

    public void run() {
        int i;
        for (i = 0; i < this.input.length; ++i) {
            this.day[i].setValue(JAMS.getMissingDataValue());
            if (this.input[i].getValue() != 1.0) continue;
            this.day[i].setValue((double)this.time.get(6));
        }
        if (this.dayFirstHalfYear != null && this.daySecondHalfYear != null) {
            for (i = 0; i < this.input.length; ++i) {
                this.dayFirstHalfYear[i].setValue(JAMS.getMissingDataValue());
                this.daySecondHalfYear[i].setValue(JAMS.getMissingDataValue());
                if (this.time.get(6) <= 182) {
                    this.dayFirstHalfYear[i].setValue((double)this.time.get(6));
                    continue;
                }
                this.daySecondHalfYear[i].setValue((double)this.time.get(6));
            }
        }
    }
}

