/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

public class ProgressAnnotation
extends ScreenAnnotation {
    protected double value;
    protected double min;
    protected double max;
    protected Color outlineColor;
    protected Color interiorColor;
    protected Insets interiorInsets;

    public ProgressAnnotation(double d, double d2, double d3) {
        super("", new Point());
        this.value = d;
        this.min = d2;
        this.max = d3;
        this.outlineColor = new Color(60, 60, 60);
        this.interiorColor = new Color(171, 171, 171);
        this.interiorInsets = new Insets(2, 2, 2, 2);
    }

    public ProgressAnnotation() {
        this(0.0, 0.0, 1.0);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double d) {
        this.min = d;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineColor = color;
    }

    public Color getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorColor = color;
    }

    public Insets getInteriorInsets() {
        return (Insets)this.interiorInsets.clone();
    }

    public void setInteriorInsets(Insets insets) {
        if (insets == null) {
            String string = Logging.getMessage("nullValue.InsetsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorInsets = (Insets)insets.clone();
    }

    @Override
    protected void doDraw(DrawContext drawContext, int n, int n2, double d, Position position) {
        super.doDraw(drawContext, n, n2, d, position);
        this.drawProgress(drawContext, n, n2, d, position);
    }

    protected void drawProgress(DrawContext drawContext, int n, int n2, double d, Position position) {
        if (drawContext.isPickingMode()) {
            return;
        }
        this.drawProgressContainer(drawContext, n, n2, d, position);
        this.drawProgressBar(drawContext, n, n2, d, position);
    }

    protected void drawProgressContainer(DrawContext drawContext, int n, int n2, double d, Position position) {
        Rectangle rectangle = this.computeProgressContainerBounds(n, n2);
        GL gL = drawContext.getGL();
        gL.glEnable(2848);
        gL.glHint(3154, 4354);
        gL.glLineWidth(1.0f);
        this.applyColor(drawContext, this.getOutlineColor(), d, false);
        this.drawCallout(drawContext, 3, rectangle, false);
    }

    protected void drawProgressBar(DrawContext drawContext, int n, int n2, double d, Position position) {
        Rectangle rectangle = this.computeProgressBarBounds(n, n2);
        this.applyColor(drawContext, this.getInteriorColor(), d, true);
        this.drawCallout(drawContext, 6, rectangle, false);
    }

    protected void drawCallout(DrawContext drawContext, int n, Rectangle rectangle, boolean bl) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushModelview(gL2);
        gL2.glTranslated((double)rectangle.x, (double)rectangle.y, 0.0);
        this.drawCallout(drawContext, n, rectangle.width, rectangle.height, bl);
        oGLStackHandler.pop(gL2);
    }

    protected Rectangle computeProgressContainerBounds(int n, int n2) {
        return this.computeInsetBounds(n, n2);
    }

    protected Rectangle computeProgressBarBounds(int n, int n2) {
        Rectangle rectangle = this.computeProgressContainerBounds(n, n2);
        int n3 = this.computeProgressBarWidth(rectangle.width) - (this.interiorInsets.left + this.interiorInsets.right);
        int n4 = rectangle.height - (this.interiorInsets.bottom + this.interiorInsets.top);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Rectangle(rectangle.x + this.interiorInsets.left, rectangle.y + this.interiorInsets.bottom, n3, n4);
    }

    protected int computeProgressBarWidth(int n) {
        double d = (this.value - this.min) / (this.max - this.min);
        return (int)(d * (double)n);
    }
}

