/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import java.awt.EventQueue;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.event.EventListenerList;

public class AudioPlayer {
    private Clip clip;
    private String status = "gov.nasa.worldwind.avkey.Stop";
    protected long pausedMicrosecondPosition;
    protected EventListenerList listenerList = new EventListenerList();
    protected LineListener lineListener = new LineListener(){

        @Override
        public void update(LineEvent lineEvent) {
            AudioPlayer.this.onLineEvent(lineEvent);
        }
    };

    public AudioPlayer() {
    }

    public AudioPlayer(Clip clip) {
        this.setClip(clip);
    }

    public Clip getClip() {
        return this.clip;
    }

    public void setClip(Clip clip) {
        if (this.clip == clip) {
            return;
        }
        if (this.clip != null && this.lineListener != null) {
            this.clip.removeLineListener(this.lineListener);
        }
        this.clip = clip;
        if (this.clip != null && this.lineListener != null) {
            this.clip.addLineListener(this.lineListener);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public long getMillisecondLength() {
        if (this.clip == null) {
            return 0L;
        }
        return this.clip.getMicrosecondLength() / 1000L;
    }

    public long getMillisecondPosition() {
        if (this.clip == null) {
            return 0L;
        }
        return this.clip.getMicrosecondPosition() / 1000L;
    }

    public void setMillisecondPosition(long l) {
        if (this.clip == null) {
            return;
        }
        if (l < 0L || l > this.getMillisecondLength()) {
            return;
        }
        this.clip.setMicrosecondPosition(l * 1000L);
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        if (this.getStatus() == "gov.nasa.worldwind.avkey.Pause") {
            this.doStart(this.pausedMicrosecondPosition);
        } else if (this.getStatus() == "gov.nasa.worldwind.avkey.Stop") {
            this.doStart(0L);
        }
        this.pausedMicrosecondPosition = 0L;
    }

    public void stop() {
        if (this.clip == null) {
            return;
        }
        this.doStop(0L);
    }

    public void pause() {
        if (this.clip == null) {
            return;
        }
        if (this.getStatus() == "gov.nasa.worldwind.avkey.Play") {
            this.doPause();
        }
    }

    public LineListener[] getLineListeners() {
        return (LineListener[])this.listenerList.getListeners(LineListener.class);
    }

    public void addLineListener(LineListener lineListener) {
        this.listenerList.add(LineListener.class, lineListener);
    }

    public void removeLineListener(LineListener lineListener) {
        this.listenerList.remove(LineListener.class, lineListener);
    }

    protected void doStart(long l) {
        this.status = "gov.nasa.worldwind.avkey.Play";
        this.clip.setMicrosecondPosition(l);
        this.clip.start();
    }

    protected void doStop(long l) {
        boolean bl = this.getStatus() != "gov.nasa.worldwind.avkey.Stop";
        this.status = "gov.nasa.worldwind.avkey.Stop";
        this.pausedMicrosecondPosition = l;
        this.clip.setMicrosecondPosition(l);
        if (bl) {
            this.clip.stop();
        }
    }

    protected void doPause() {
        this.status = "gov.nasa.worldwind.avkey.Pause";
        this.pausedMicrosecondPosition = this.clip.getMicrosecondPosition();
        this.clip.stop();
    }

    protected void onLineEvent(final LineEvent lineEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioPlayer.this.processLineEvent(lineEvent);
            }
        });
    }

    protected void processLineEvent(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP && this.getStatus() == "gov.nasa.worldwind.avkey.Play") {
            long l = this.getClip().getMicrosecondLength();
            this.doStop(l);
        }
        this.fireUpdate(lineEvent);
    }

    protected void fireUpdate(LineEvent lineEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LineListener.class) continue;
            ((LineListener)objectArray[i + 1]).update(lineEvent);
        }
    }
}

