/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.shapebuilder;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.shapebuilder.ExtrudedPolygonEditor;
import gov.nasa.worldwindx.examples.util.ShapeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ExtrudedPolygonBuilder
extends ApplicationTemplate {
    protected static final String POLYGON_LAYER_NAME = "Polygons";
    protected static final String CLEAR_SELECTION = "ExtrudedPolygonBuilder.ClearSelection";
    protected static final String SIZE_NEW_SHAPES_TO_VIEWPORT = "ExtrudedPolygonBuilder.SizeNewShapesToViewport";
    protected static final String ENABLE_EDIT = "ExtrudedPolygonBuilder.EnableEdit";
    protected static final String NEW_POLYGON = "ExtrudedPolygonBuilder.NewPolygon";
    protected static final String REMOVE_SELECTED = "ExtrudedPolygonBuilder.RemoveSelected";
    protected static final String SELECTION_CHANGED = "ExtrudedPolygonBuilder.SelectionChanged";
    protected static final double DEFAULT_SHAPE_SIZE_METERS = 200000.0;
    protected static long nextEntryNumber = 1L;

    public static ShapeAttributes getDefaultAttributes() {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(new Material(Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.BLACK, 0.0f));
        basicShapeAttributes.setOutlineMaterial(Material.DARK_GRAY);
        basicShapeAttributes.setDrawOutline(true);
        basicShapeAttributes.setInteriorOpacity(0.95);
        basicShapeAttributes.setOutlineOpacity(0.95);
        basicShapeAttributes.setOutlineWidth(2.0);
        return basicShapeAttributes;
    }

    public static ShapeAttributes getSelectionAttributes() {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setInteriorMaterial(Material.WHITE);
        basicShapeAttributes.setOutlineMaterial(Material.BLACK);
        basicShapeAttributes.setDrawOutline(true);
        basicShapeAttributes.setInteriorOpacity(0.8);
        basicShapeAttributes.setOutlineOpacity(0.8);
        basicShapeAttributes.setOutlineWidth(2.0);
        return basicShapeAttributes;
    }

    public static String getNextName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(nextEntryNumber++);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Extruded Polygon Builder", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected RenderableLayer polygonLayer = new RenderableLayer();
        protected PolygonBuilderModel builderModel;
        protected PolygonBuilderPanel builderView;
        protected PolygonBuilderController builderController;

        public AppFrame() {
            this.polygonLayer.setName(ExtrudedPolygonBuilder.POLYGON_LAYER_NAME);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.polygonLayer);
            this.getLayerPanel().update(this.getWwd());
            this.builderController = new PolygonBuilderController(this);
            this.builderModel = new PolygonBuilderModel();
            this.builderView = new PolygonBuilderPanel(this.builderModel, this.builderController);
            this.getContentPane().add((Component)this.builderView, "South");
            this.builderController.setModel(this.builderModel);
            this.builderController.setView(this.builderView);
            this.builderController.setResizeNewShapesToViewport(true);
            AppFrame.makeMenuBar(this, this.builderController);
        }

        public PolygonBuilderPanel getPolygonBuilderPanel() {
            return this.builderView;
        }

        public RenderableLayer getPolygonLayer() {
            return this.polygonLayer;
        }

        public static void makeMenuBar(JFrame jFrame, final PolygonBuilderController polygonBuilderController) {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("Shape");
            JMenuItem jMenuItem = new JMenuItem("New polygon");
            jMenuItem.setActionCommand(ExtrudedPolygonBuilder.NEW_POLYGON);
            jMenuItem.addActionListener(polygonBuilderController);
            jMenu.add(jMenuItem);
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Fit new shapes to viewport");
            jCheckBoxMenuItem.setActionCommand(ExtrudedPolygonBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT);
            jCheckBoxMenuItem.addActionListener(polygonBuilderController);
            jCheckBoxMenuItem.setState(polygonBuilderController.isResizeNewShapesToViewport());
            jMenu.add(jCheckBoxMenuItem);
            final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Enable shape editing");
            jCheckBoxMenuItem2.setActionCommand(ExtrudedPolygonBuilder.ENABLE_EDIT);
            jCheckBoxMenuItem2.addActionListener(polygonBuilderController);
            jCheckBoxMenuItem2.setState(polygonBuilderController.isEnableEdit());
            jMenu.add(jCheckBoxMenuItem2);
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Selection");
            JMenuItem jMenuItem2 = new JMenuItem("Deselect");
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem2.setActionCommand(ExtrudedPolygonBuilder.CLEAR_SELECTION);
            jMenuItem2.addActionListener(polygonBuilderController);
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Delete");
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            jMenuItem2.setActionCommand(ExtrudedPolygonBuilder.REMOVE_SELECTED);
            jMenuItem2.addActionListener(polygonBuilderController);
            jMenu.add(jMenuItem2);
            jMenuBar.add(jMenu);
            jFrame.setJMenuBar(jMenuBar);
            polygonBuilderController.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == ExtrudedPolygonBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                        jCheckBoxMenuItem.setSelected(polygonBuilderController.isResizeNewShapesToViewport());
                    } else if (propertyChangeEvent.getPropertyName() == ExtrudedPolygonBuilder.ENABLE_EDIT) {
                        jCheckBoxMenuItem2.setSelected(polygonBuilderController.isEnableEdit());
                    }
                }
            });
        }
    }

    protected static class PolygonBuilderController
    extends WWObjectImpl
    implements ActionListener,
    MouseListener {
        protected AppFrame app;
        protected PolygonBuilderModel model;
        protected PolygonBuilderPanel view;
        protected PolygonEntry selectedEntry;
        protected ExtrudedPolygonEditor editor;
        protected boolean enabled = true;
        protected boolean enableEdit = true;
        protected boolean resizeNewShapes;

        public PolygonBuilderController(AppFrame appFrame) {
            this.app = appFrame;
            this.editor = new ExtrudedPolygonEditor();
            this.editor.setWorldWindow(this.app.getWwd());
            this.app.getWwd().getInputHandler().addMouseListener(this);
        }

        public AppFrame getApp() {
            return this.app;
        }

        public PolygonBuilderModel getModel() {
            return this.model;
        }

        public void setModel(PolygonBuilderModel polygonBuilderModel) {
            this.model = polygonBuilderModel;
        }

        public PolygonBuilderPanel getView() {
            return this.view;
        }

        public void setView(PolygonBuilderPanel polygonBuilderPanel) {
            this.view = polygonBuilderPanel;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            this.getView().setEnabled(bl);
            this.getApp().setEnabled(bl);
        }

        public boolean isEnableEdit() {
            return this.enableEdit;
        }

        public void setEnableEdit(boolean bl) {
            this.enableEdit = bl;
            this.handleEnableEdit(bl);
            this.firePropertyChange(ExtrudedPolygonBuilder.ENABLE_EDIT, null, bl);
        }

        public boolean isResizeNewShapesToViewport() {
            return this.resizeNewShapes;
        }

        public void setResizeNewShapesToViewport(boolean bl) {
            this.resizeNewShapes = bl;
            this.firePropertyChange(ExtrudedPolygonBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT, null, bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (actionEvent.getActionCommand() == ExtrudedPolygonBuilder.NEW_POLYGON) {
                this.createNewEntry(new ExtrudedPolygonFactory());
            } else if (actionEvent.getActionCommand() == ExtrudedPolygonBuilder.CLEAR_SELECTION) {
                this.selectEntry(null, true);
            } else if (actionEvent.getActionCommand() == ExtrudedPolygonBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setResizeNewShapesToViewport(bl);
                }
            } else if (actionEvent.getActionCommand() == ExtrudedPolygonBuilder.ENABLE_EDIT) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setEnableEdit(bl);
                }
            } else if (actionEvent.getActionCommand() == ExtrudedPolygonBuilder.REMOVE_SELECTED) {
                this.removeEntries(Arrays.asList(this.getSelectedEntries()));
            } else if (actionEvent.getActionCommand() == ExtrudedPolygonBuilder.SELECTION_CHANGED) {
                this.viewSelectionChanged();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.isConsumed()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            if (mouseEvent.getButton() == 1) {
                this.handleSelect();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        protected void handleSelect() {
            PickedObjectList pickedObjectList = this.getApp().getWwd().getObjectsAtCurrentPosition();
            Object object = pickedObjectList.getTopObject();
            if (!(object instanceof ExtrudedPolygon)) {
                return;
            }
            PolygonEntry polygonEntry = this.getEntryFor((ExtrudedPolygon)object);
            if (polygonEntry == null) {
                return;
            }
            if (this.getSelectedEntry() != polygonEntry) {
                this.selectEntry(polygonEntry, true);
            }
        }

        protected void handleEnableEdit(boolean bl) {
            if (this.getSelectedEntry() == null) {
                return;
            }
            if (this.isSelectionEditing() != bl) {
                this.setSelectionEditing(bl);
            }
        }

        public void createNewEntry(ExtrudedPolygonFactory extrudedPolygonFactory) {
            ExtrudedPolygon extrudedPolygon = extrudedPolygonFactory.createPolygon(this.getApp().getWwd(), this.isResizeNewShapesToViewport());
            PolygonEntry polygonEntry = new PolygonEntry(extrudedPolygon);
            this.addEntry(polygonEntry);
            this.selectEntry(polygonEntry, true);
        }

        public void removeEntries(Iterable<? extends PolygonEntry> iterable) {
            if (iterable != null) {
                for (PolygonEntry polygonEntry : iterable) {
                    this.removeEntry(polygonEntry);
                }
            }
        }

        public void addEntry(PolygonEntry polygonEntry) {
            this.getModel().addEntry(polygonEntry);
            this.getApp().getPolygonLayer().addRenderable(polygonEntry.getPolygon());
            this.getApp().getWwd().redraw();
        }

        public void removeEntry(PolygonEntry polygonEntry) {
            if (this.getSelectedEntry() == polygonEntry) {
                this.selectEntry(null, true);
            }
            this.getModel().removeEntry(polygonEntry);
            this.getApp().getPolygonLayer().removeRenderable(polygonEntry.getPolygon());
            this.getApp().getWwd().redraw();
        }

        public PolygonEntry getSelectedEntry() {
            return this.selectedEntry;
        }

        public void selectEntry(PolygonEntry polygonEntry, boolean bl) {
            this.setSelectedEntry(polygonEntry);
            if (bl) {
                if (polygonEntry != null) {
                    int n = this.getModel().getIndexForEntry(polygonEntry);
                    this.getView().setSelectedIndices(new int[]{n});
                } else {
                    this.getView().setSelectedIndices(new int[0]);
                }
            }
            if (this.isEnableEdit() && this.getSelectedEntry() != null && !this.isSelectionEditing()) {
                this.setSelectionEditing(true);
            }
            this.getApp().getWwd().redraw();
        }

        protected void setSelectedEntry(PolygonEntry polygonEntry) {
            if (this.selectedEntry != null) {
                if (this.selectedEntry != polygonEntry && this.selectedEntry.isEditing()) {
                    this.setSelectionEditing(false);
                }
                this.selectedEntry.setSelected(false);
            }
            this.selectedEntry = polygonEntry;
            if (this.selectedEntry != null) {
                this.selectedEntry.setSelected(true);
            }
        }

        protected boolean isSelectionEditing() {
            return this.selectedEntry != null && this.selectedEntry.isEditing();
        }

        protected void setSelectionEditing(boolean bl) {
            if (this.selectedEntry == null) {
                throw new IllegalStateException();
            }
            if (this.selectedEntry.isEditing() == bl) {
                throw new IllegalStateException();
            }
            this.selectedEntry.setEditing(bl);
            this.editor.setPolygon(this.selectedEntry.getPolygon());
            this.editor.setArmed(bl);
            if (bl) {
                ApplicationTemplate.insertBeforePlacenames(this.getApp().getWwd(), this.editor);
            } else {
                this.getApp().getWwd().getModel().getLayers().remove(this.editor);
            }
            int n = this.getModel().getIndexForEntry(this.selectedEntry);
            this.getModel().fireTableRowsUpdated(n, n);
        }

        protected void viewSelectionChanged() {
            int[] nArray = this.getView().getSelectedIndices();
            if (nArray != null) {
                for (PolygonEntry polygonEntry : this.getEntriesFor(nArray)) {
                    this.selectEntry(polygonEntry, false);
                }
            }
            this.getApp().getWwd().redraw();
        }

        protected PolygonEntry[] getSelectedEntries() {
            int[] nArray = this.getView().getSelectedIndices();
            if (nArray != null) {
                return this.getEntriesFor(nArray);
            }
            return new PolygonEntry[0];
        }

        protected PolygonEntry[] getEntriesFor(int[] nArray) {
            PolygonEntry[] polygonEntryArray = new PolygonEntry[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                polygonEntryArray[i] = this.getModel().getEntry(nArray[i]);
            }
            return polygonEntryArray;
        }

        protected PolygonEntry getEntryFor(ExtrudedPolygon extrudedPolygon) {
            for (PolygonEntry polygonEntry : this.getModel().getEntries()) {
                if (polygonEntry.getPolygon() != extrudedPolygon) continue;
                return polygonEntry;
            }
            return null;
        }
    }

    protected static class PolygonBuilderPanel
    extends JPanel {
        protected JTable entryTable;
        protected boolean ignoreSelectEvents = false;

        public PolygonBuilderPanel(PolygonBuilderModel polygonBuilderModel, PolygonBuilderController polygonBuilderController) {
            this.initComponents(polygonBuilderModel, polygonBuilderController);
        }

        public int[] getSelectedIndices() {
            return this.entryTable.getSelectedRows();
        }

        public void setSelectedIndices(int[] nArray) {
            this.ignoreSelectEvents = true;
            if (nArray != null && nArray.length != 0) {
                for (int n : nArray) {
                    this.entryTable.setRowSelectionInterval(n, n);
                }
            } else {
                this.entryTable.clearSelection();
            }
            this.ignoreSelectEvents = false;
        }

        protected void initComponents(PolygonBuilderModel polygonBuilderModel, final PolygonBuilderController polygonBuilderController) {
            JPanel jPanel = new JPanel();
            JComponent jComponent = new JButton("New shape");
            ((AbstractButton)jComponent).setActionCommand(ExtrudedPolygonBuilder.NEW_POLYGON);
            ((AbstractButton)jComponent).addActionListener(polygonBuilderController);
            jComponent.setToolTipText("Create a new shape centered in the viewport");
            final JCheckBox jCheckBox = new JCheckBox("Fit new shapes to viewport");
            jCheckBox.setActionCommand(ExtrudedPolygonBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT);
            jCheckBox.addActionListener(polygonBuilderController);
            jCheckBox.setSelected(polygonBuilderController.isResizeNewShapesToViewport());
            jCheckBox.setAlignmentX(0.0f);
            jCheckBox.setToolTipText("New shapes are sized to fit the geographic viewport");
            final JCheckBox jCheckBox2 = new JCheckBox("Enable shape editing");
            jCheckBox2.setActionCommand(ExtrudedPolygonBuilder.ENABLE_EDIT);
            jCheckBox2.addActionListener(polygonBuilderController);
            jCheckBox2.setSelected(polygonBuilderController.isEnableEdit());
            jCheckBox2.setAlignmentX(0.0f);
            jCheckBox2.setToolTipText("Allow modifications to shapes");
            JComponent jComponent2 = Box.createHorizontalBox();
            jComponent2.add(jComponent);
            jComponent2.add(Box.createHorizontalStrut(5));
            jComponent2.setAlignmentX(0.0f);
            JComponent jComponent3 = new JPanel(new GridLayout(0, 1, 0, 5));
            jComponent3.add(jComponent2);
            jComponent3.add(jCheckBox);
            jComponent3.add(jCheckBox2);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jComponent3, "North");
            jComponent = new JPanel();
            this.entryTable = new JTable(polygonBuilderModel);
            this.entryTable.setColumnSelectionAllowed(false);
            this.entryTable.setRowSelectionAllowed(true);
            this.entryTable.setSelectionMode(0);
            this.entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!PolygonBuilderPanel.this.ignoreSelectEvents) {
                        polygonBuilderController.actionPerformed(new ActionEvent(listSelectionEvent.getSource(), -1, ExtrudedPolygonBuilder.SELECTION_CHANGED));
                    }
                }
            });
            this.entryTable.setToolTipText("<html>Click to select<br>Double-Click to rename</html>");
            jComponent2 = new JScrollPane(this.entryTable);
            jComponent2.setPreferredSize(new Dimension(200, 100));
            jComponent.setLayout(new BorderLayout(0, 0));
            jComponent.add((Component)jComponent2, "Center");
            jComponent2 = new JPanel();
            jComponent3 = new JButton("Deselect");
            ((AbstractButton)jComponent3).setActionCommand(ExtrudedPolygonBuilder.CLEAR_SELECTION);
            ((AbstractButton)jComponent3).addActionListener(polygonBuilderController);
            jComponent3.setToolTipText("Clear the selection");
            JButton jButton = new JButton("Delete Selected");
            jButton.setActionCommand(ExtrudedPolygonBuilder.REMOVE_SELECTED);
            jButton.addActionListener(polygonBuilderController);
            jButton.setToolTipText("Delete selected shapes");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 5));
            jPanel2.add(jComponent3);
            jPanel2.add(jButton);
            jComponent2.setLayout(new BorderLayout());
            jComponent2.add((Component)jPanel2, "North");
            this.setLayout(new BorderLayout(30, 0));
            this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.add((Component)jPanel, "West");
            this.add((Component)jComponent, "Center");
            this.add((Component)jComponent2, "East");
            polygonBuilderController.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == ExtrudedPolygonBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                        jCheckBox.setSelected(polygonBuilderController.isResizeNewShapesToViewport());
                    } else if (propertyChangeEvent.getPropertyName() == ExtrudedPolygonBuilder.ENABLE_EDIT) {
                        jCheckBox2.setSelected(polygonBuilderController.isEnableEdit());
                    }
                }
            });
        }
    }

    protected static class ExtrudedPolygonFactory {
        public ExtrudedPolygon createPolygon(WorldWindow worldWindow, boolean bl) {
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon();
            extrudedPolygon.setAttributes(ExtrudedPolygonBuilder.getDefaultAttributes());
            extrudedPolygon.setValue("gov.nasa.worldwind.avkey.DisplayName", ExtrudedPolygonBuilder.getNextName(this.toString()));
            this.initializePolygon(worldWindow, extrudedPolygon, bl);
            return extrudedPolygon;
        }

        protected void initializePolygon(WorldWindow worldWindow, ExtrudedPolygon extrudedPolygon, boolean bl) {
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Angle angle = ShapeUtils.getNewShapeHeading(worldWindow, true);
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) : 200000.0;
            List<Position> list = ShapeUtils.createPositionSquareInViewport(worldWindow, position, angle, d);
            extrudedPolygon.setOuterBoundary(list);
            extrudedPolygon.setHeight(d);
            extrudedPolygon.setAltitudeMode(2);
        }

        public String toString() {
            return "Polygon";
        }
    }

    protected static class PolygonBuilderModel
    extends AbstractTableModel {
        protected static String[] columnName = new String[]{"Name"};
        protected static Class[] columnClass = new Class[]{String.class};
        protected static String[] columnAttribute = new String[]{"gov.nasa.worldwind.avkey.DisplayName"};
        protected ArrayList<PolygonEntry> entryList = new ArrayList();

        @Override
        public String getColumnName(int n) {
            return columnName[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return columnClass[n];
        }

        @Override
        public int getRowCount() {
            return this.entryList.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PolygonEntry polygonEntry = this.entryList.get(n);
            return polygonEntry.getValue(columnAttribute[n2]);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PolygonEntry polygonEntry = this.entryList.get(n);
            String string = columnAttribute[n2];
            polygonEntry.setValue(string, object);
        }

        public List<PolygonEntry> getEntries() {
            return Collections.unmodifiableList(this.entryList);
        }

        public void setEntries(Iterable<? extends PolygonEntry> iterable) {
            this.entryList.clear();
            if (iterable != null) {
                for (PolygonEntry polygonEntry : iterable) {
                    this.entryList.add(polygonEntry);
                }
            }
            this.fireTableDataChanged();
        }

        public void addEntry(PolygonEntry polygonEntry) {
            this.entryList.add(polygonEntry);
            int n = this.entryList.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void removeEntry(PolygonEntry polygonEntry) {
            int n = this.entryList.indexOf(polygonEntry);
            if (n != -1) {
                this.entryList.remove(polygonEntry);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void removeAllEntries() {
            this.entryList.clear();
            this.fireTableDataChanged();
        }

        public PolygonEntry getEntry(int n) {
            return this.entryList.get(n);
        }

        public PolygonEntry setEntry(int n, PolygonEntry polygonEntry) {
            return this.entryList.set(n, polygonEntry);
        }

        public int getIndexForEntry(PolygonEntry polygonEntry) {
            return this.entryList.indexOf(polygonEntry);
        }
    }

    protected static class PolygonEntry
    extends WWObjectImpl {
        protected ExtrudedPolygon polygon;
        protected ShapeAttributes attributes;
        protected boolean editing = false;
        protected boolean selected = false;

        public PolygonEntry(ExtrudedPolygon extrudedPolygon) {
            this.polygon = extrudedPolygon;
            this.attributes = this.polygon.getAttributes();
        }

        public boolean isEditing() {
            return this.editing;
        }

        public void setEditing(boolean bl) {
            this.editing = bl;
            this.updateAttributes();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.updateAttributes();
        }

        public String getName() {
            return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        }

        public void setName(String string) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }

        public ExtrudedPolygon getPolygon() {
            return this.polygon;
        }

        public ShapeAttributes getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public Object getValue(String string) {
            Object object = super.getValue(string);
            if (object == null) {
                object = this.polygon.getValue(string);
            }
            return object;
        }

        @Override
        public Object setValue(String string, Object object) {
            if (string == "gov.nasa.worldwind.avkey.DisplayName") {
                return this.polygon.setValue(string, object);
            }
            return super.setValue(string, object);
        }

        protected void updateAttributes() {
            if (this.isSelected()) {
                this.polygon.setAttributes(ExtrudedPolygonBuilder.getSelectionAttributes());
            } else {
                this.polygon.setAttributes(this.getAttributes());
            }
        }
    }
}

