/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TabbedPaneUsage
extends JFrame {
    public TabbedPaneUsage() {
        try {
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.add((Component)jTabbedPane, "Center");
            WWPanel wWPanel = new WWPanel(null, 600, 600);
            jTabbedPane.add((Component)wWPanel, "World Window A");
            Earth earth = new Earth();
            Layer[] layerArray = new Layer[]{new StarsLayer(), new CompassLayer(), new BMNGWMSLayer(), new LandsatI3WMSLayer()};
            BasicModel basicModel = new BasicModel();
            basicModel.setGlobe(earth);
            basicModel.setLayers(new LayerList(layerArray));
            wWPanel.wwd.setModel(basicModel);
            BasicModel basicModel2 = new BasicModel();
            basicModel2.setGlobe(new Earth());
            basicModel2.setLayers(new LayerList(layerArray));
            ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
            wWPanel.wwd.getModel().getLayers().add(viewControlsLayer);
            wWPanel.wwd.addSelectListener(new ViewControlsSelectListener(wWPanel.wwd, viewControlsLayer));
            ViewControlsLayer viewControlsLayer2 = new ViewControlsLayer();
            this.add((Component)jTabbedPane, "Center");
            this.setTitle("World Wind Multi-Window Tabbed Pane");
            this.setDefaultCloseOperation(3);
            this.pack();
            WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
            this.setVisible(true);
            WWPanel wWPanel2 = new WWPanel(wWPanel.wwd, wWPanel.getWidth(), wWPanel.getHeight());
            jTabbedPane.add((Component)wWPanel2, "World Window B");
            wWPanel2.wwd.setModel(basicModel2);
            wWPanel2.wwd.getModel().getLayers().add(viewControlsLayer2);
            wWPanel2.wwd.addSelectListener(new ViewControlsSelectListener(wWPanel2.wwd, viewControlsLayer2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TabbedPaneUsage();
            }
        });
    }

    private static class WWPanel
    extends JPanel {
        WorldWindowGLCanvas wwd;

        public WWPanel(WorldWindowGLCanvas worldWindowGLCanvas, int n, int n2) {
            this.wwd = worldWindowGLCanvas != null ? new WorldWindowGLCanvas(worldWindowGLCanvas) : new WorldWindowGLCanvas();
            this.wwd.setSize(new Dimension(n, n2));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.wwd), "Center");
            this.setOpaque(false);
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource(this.wwd);
            this.add((Component)statusBar, "South");
        }
    }
}

