/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.layermanager;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwindx.examples.layermanager.ElevationModelPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class ElevationModelManagerPanel
extends JPanel {
    protected JPanel modelNamesPanel;
    protected List<ElevationModelPanel> modelPanels = new ArrayList<ElevationModelPanel>();

    public ElevationModelManagerPanel(final WorldWindow worldWindow) {
        super(new BorderLayout(10, 10));
        this.modelNamesPanel = new JPanel(new GridLayout(0, 1, 0, 5));
        this.modelNamesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Elevations")));
        jPanel.setToolTipText("Elevation models to use");
        jPanel.add(this.modelNamesPanel);
        this.add((Component)jPanel, "Center");
        this.fill(worldWindow);
        worldWindow.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.ElevationModel")) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ElevationModelManagerPanel.this.update(worldWindow);
                                    }
                                });
                            }
                        });
                    } else {
                        ElevationModelManagerPanel.this.update(worldWindow);
                    }
                }
            }
        });
    }

    public void update(WorldWindow worldWindow) {
        this.fill(worldWindow);
    }

    protected void fill(WorldWindow worldWindow) {
        if (this.isUpToDate(worldWindow)) {
            return;
        }
        this.modelPanels.clear();
        this.modelNamesPanel.removeAll();
        if (!(worldWindow.getModel().getGlobe().getElevationModel() instanceof CompoundElevationModel)) {
            ElevationModelPanel elevationModelPanel = new ElevationModelPanel(worldWindow, this, worldWindow.getModel().getGlobe().getElevationModel());
            this.modelPanels.add(elevationModelPanel);
            this.modelNamesPanel.add(elevationModelPanel);
        } else {
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
            for (ElevationModel elevationModel : compoundElevationModel.getElevationModels()) {
                if (elevationModel.getValue("gov.nasa.worldwind.avkey.Ignore") != null) continue;
                ElevationModelPanel elevationModelPanel = new ElevationModelPanel(worldWindow, this, elevationModel);
                this.modelPanels.add(elevationModelPanel);
                this.modelNamesPanel.add(elevationModelPanel);
            }
        }
    }

    protected boolean isUpToDate(WorldWindow worldWindow) {
        if (!(worldWindow.getModel().getGlobe().getElevationModel() instanceof CompoundElevationModel)) {
            return this.modelPanels.get(0).getElevationModel() == worldWindow.getModel().getGlobe().getElevationModel();
        }
        CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
        if (this.modelPanels.size() != compoundElevationModel.getElevationModels().size()) {
            return false;
        }
        for (int i = 0; i < compoundElevationModel.getElevationModels().size(); ++i) {
            if (compoundElevationModel.getElevationModels().get(i) == this.modelPanels.get(i).getElevationModel()) continue;
            return false;
        }
        return true;
    }
}

