/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.dataimport;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.TiledImageProducer;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.dataimport.DataInstallUtil;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.Cursor;
import java.io.File;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;

public class InstallImagery
extends ApplicationTemplate {
    protected static final String BASE_CACHE_PATH = "Examples/";
    protected static final String IMAGE_PATH = "gov/nasa/worldwindx/examples/data/craterlake-imagery-30m.tif";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Imagery Installation", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.setCursor(new Cursor(3));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.installImagery();
                    AppFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            thread.start();
        }

        protected void installImagery() {
            FileStore fileStore;
            File file = ExampleUtil.saveResourceToTempFile(InstallImagery.IMAGE_PATH, ".tif");
            final Layer layer = this.installSurfaceImage("Crater Lake Imagery 30m", file, fileStore = WorldWind.getDataFileStore());
            if (layer == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationTemplate.insertBeforePlacenames(AppFrame.this.getWwd(), layer);
                    AppFrame.this.getLayerPanel().update(AppFrame.this.getWwd());
                    AVList aVList = (AVList)layer.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
                    Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
                    ExampleUtil.goTo(AppFrame.this.getWwd(), sector);
                }
            });
        }

        protected Layer installSurfaceImage(String string, Object object, FileStore fileStore) {
            File file = DataInstallUtil.getDefaultInstallLocation(fileStore);
            String string2 = InstallImagery.BASE_CACHE_PATH + WWIO.replaceIllegalFileNameCharacters(string);
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", file.getAbsolutePath());
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string2);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
            TiledImageProducer tiledImageProducer = new TiledImageProducer();
            try {
                tiledImageProducer.setStoreParameters(aVListImpl);
                tiledImageProducer.offerDataSource(object, null);
                tiledImageProducer.startProduction();
            }
            catch (Exception exception) {
                tiledImageProducer.removeProductionState();
                exception.printStackTrace();
                return null;
            }
            Iterable<?> iterable = tiledImageProducer.getProductionResults();
            if (iterable == null || iterable.iterator() == null || !iterable.iterator().hasNext()) {
                return null;
            }
            Object obj = iterable.iterator().next();
            if (obj == null || !(obj instanceof Document)) {
                return null;
            }
            Layer layer = (Layer)BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", ((Document)obj).getDocumentElement());
            layer.setEnabled(true);
            return layer;
        }
    }
}

