/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.dataimport;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.SurfaceImageLayer;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.SwingUtilities;

public class ImportImagery
extends ApplicationTemplate {
    protected static final String IMAGE_PATH = "gov/nasa/worldwindx/examples/data/craterlake-imagery-30m.tif";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Imagery Import", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.setCursor(new Cursor(3));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AppFrame.this.importImagery();
                    AppFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            thread.start();
        }

        protected void importImagery() {
            try {
                File file = ExampleUtil.saveResourceToTempFile(ImportImagery.IMAGE_PATH, ".tif");
                DataRasterReaderFactory dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
                DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor(file, null);
                AVList aVList = dataRasterReader.readMetadata(file, null);
                if (aVList == null || !"gov.nasa.worldwind.avkey.Image".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
                    throw new Exception("Not an image file.");
                }
                DataRaster[] dataRasterArray = dataRasterReader.read(file, null);
                if (dataRasterArray == null || dataRasterArray.length == 0) {
                    throw new Exception("Can't read the image file.");
                }
                DataRaster dataRaster = dataRasterArray[0];
                final Sector sector = (Sector)dataRaster.getValue("gov.nasa.worldwind.avKey.Sector");
                if (sector == null) {
                    throw new Exception("No location specified with image.");
                }
                int n = dataRaster.getWidth();
                int n2 = dataRaster.getHeight();
                DataRaster dataRaster2 = dataRaster.getSubRaster(n, n2, sector, null);
                dataRaster.dispose();
                if (!(dataRaster2 instanceof BufferedImageRaster)) {
                    throw new Exception("Cannot get BufferedImage.");
                }
                BufferedImage bufferedImage = ((BufferedImageRaster)dataRaster2).getBufferedImage();
                dataRaster2.dispose();
                final SurfaceImage surfaceImage = new SurfaceImage((Object)bufferedImage, sector);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SurfaceImageLayer surfaceImageLayer = new SurfaceImageLayer();
                        surfaceImageLayer.setName("Imported Surface Image");
                        surfaceImageLayer.setPickEnabled(false);
                        surfaceImageLayer.addRenderable(surfaceImage);
                        ApplicationTemplate.insertBeforeCompass(AppFrame.this.getWwd(), surfaceImageLayer);
                        AppFrame.this.getLayerPanel().update(AppFrame.this.getWwd());
                        ExampleUtil.goTo(AppFrame.this.getWwd(), sector);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

