/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.applet;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JApplet;
import netscape.javascript.JSObject;

public class WWJApplet
extends JApplet {
    protected WorldWindowGLCanvas wwd;
    protected RenderableLayer labelsLayer;

    @Override
    public void init() {
        try {
            String string = this.getParameter("InitialLatitude");
            if (string != null) {
                Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", Double.parseDouble(string));
            }
            if ((string = this.getParameter("InitialLongitude")) != null) {
                Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", Double.parseDouble(string));
            }
            if ((string = this.getParameter("InitialAltitude")) != null) {
                Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", Double.parseDouble(string));
            }
            if ((string = this.getParameter("InitialHeading")) != null) {
                Configuration.setValue("gov.nasa.worldwind.avkey.InitialHeading", Double.parseDouble(string));
            }
            if ((string = this.getParameter("InitialPitch")) != null) {
                Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", Double.parseDouble(string));
            }
            this.wwd = new WorldWindowGLCanvas();
            this.getContentPane().add((Component)((Object)this.wwd), "Center");
            Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.labelsLayer = new RenderableLayer();
            this.labelsLayer.setName("Labels");
            WWJApplet.insertBeforeLayerName(this.wwd, this.labelsLayer, "Compass");
            StatusBar statusBar = new StatusBar();
            this.getContentPane().add((Component)statusBar, "Last");
            statusBar.setEventSource(this.wwd);
            this.wwd.addSelectListener(new ClickAndGoSelectListener(this.wwd, WorldMapLayer.class));
            try {
                JSObject jSObject = JSObject.getWindow((Applet)this);
                jSObject.call("appletInit", null);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void start() {
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this);
            jSObject.call("appletStart", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this);
            jSObject.call("appletStop", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        WorldWind.shutDown();
    }

    public static void insertBeforeLayerName(WorldWindow worldWindow, Layer layer, String string) {
        LayerList layerList = worldWindow.getModel().getLayers();
        int n = layerList.size() - 1;
        for (Layer layer2 : layerList) {
            if (layer2.getName().indexOf(string) == -1) continue;
            n = layerList.indexOf(layer2);
            break;
        }
        layerList.add(n, layer);
    }

    public void gotoLatLon(double d, double d2) {
        this.gotoLatLon(d, d2, Double.NaN, 0.0, 0.0);
    }

    public void gotoLatLon(double d, double d2, double d3, double d4, double d5) {
        BasicOrbitView basicOrbitView = (BasicOrbitView)this.wwd.getView();
        if (!(Double.isNaN(d) && Double.isNaN(d2) && Double.isNaN(d3))) {
            d = Double.isNaN(d) ? basicOrbitView.getCenterPosition().getLatitude().degrees : d;
            d2 = Double.isNaN(d2) ? basicOrbitView.getCenterPosition().getLongitude().degrees : d2;
            d3 = Double.isNaN(d3) ? basicOrbitView.getZoom() : d3;
            d4 = Double.isNaN(d4) ? basicOrbitView.getHeading().degrees : d4;
            d5 = Double.isNaN(d5) ? basicOrbitView.getPitch().degrees : d5;
            basicOrbitView.addPanToAnimator(Position.fromDegrees(d, d2, 0.0), Angle.fromDegrees(d4), Angle.fromDegrees(d5), d3, true);
        }
    }

    public void setHeadingAndPitch(double d, double d2) {
        BasicOrbitView basicOrbitView = (BasicOrbitView)this.wwd.getView();
        if (!Double.isNaN(d) || !Double.isNaN(d2)) {
            d = Double.isNaN(d) ? basicOrbitView.getHeading().degrees : d;
            d2 = Double.isNaN(d2) ? basicOrbitView.getPitch().degrees : d2;
            basicOrbitView.addHeadingPitchAnimator(basicOrbitView.getHeading(), Angle.fromDegrees(d), basicOrbitView.getPitch(), Angle.fromDegrees(d2));
        }
    }

    public void setZoom(double d) {
        BasicOrbitView basicOrbitView = (BasicOrbitView)this.wwd.getView();
        if (!Double.isNaN(d)) {
            basicOrbitView.addZoomAnimator(basicOrbitView.getZoom(), d);
        }
    }

    public WorldWindowGLCanvas getWW() {
        return this.wwd;
    }

    public OrbitView getOrbitView() {
        if (this.wwd.getView() instanceof OrbitView) {
            return (OrbitView)this.wwd.getView();
        }
        return null;
    }

    public Layer getLayerByName(String string) {
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (layer.getName().indexOf(string) == -1) continue;
            return layer;
        }
        return null;
    }

    public void addLabel(String string, double d, double d2, String string2, String string3) {
        GlobeAnnotation globeAnnotation = new GlobeAnnotation(string, Position.fromDegrees(d, d2, 0.0), Font.decode(string2), Color.decode(string3));
        globeAnnotation.getAttributes().setBackgroundColor(Color.BLACK);
        globeAnnotation.getAttributes().setDrawOffset(new Point(0, 0));
        globeAnnotation.getAttributes().setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
        globeAnnotation.getAttributes().setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        globeAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.labelsLayer.addRenderable(globeAnnotation);
    }
}

