/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.TerrainProfileLayer;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TerrainProfiler
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Terrain Profiler", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private String follow;
        private boolean showEyePosition;
        private boolean keepProportions;
        private boolean zeroBased;
        private Dimension graphDimension;
        private double profileLengthFactor;
        private JLabel helpLabel;
        private JSlider lengthSlider;
        private JCheckBox showEyeCheck;
        private TerrainProfileLayer tpl;

        public AppFrame() {
            super(true, true, false);
            try {
                this.tpl = new TerrainProfileLayer();
                this.tpl.setEventSource(this.getWwd());
                this.tpl.setStartLatLon(LatLon.fromDegrees(0.0, -10.0));
                this.tpl.setEndLatLon(LatLon.fromDegrees(0.0, 65.0));
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.tpl);
                this.getLayerPanel().update(this.getWwd());
                this.follow = this.tpl.getFollow();
                this.showEyePosition = this.tpl.getShowEyePosition();
                this.keepProportions = this.tpl.getKeepProportions();
                this.zeroBased = this.tpl.getZeroBased();
                this.graphDimension = this.tpl.getSize();
                this.profileLengthFactor = this.tpl.getProfileLenghtFactor();
                this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 4));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
            this.showEyeCheck = new JCheckBox("Show eye");
            this.showEyeCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.showEyePosition = ((JCheckBox)actionEvent.getSource()).isSelected();
                    AppFrame.this.update();
                }
            });
            this.showEyeCheck.setSelected(this.showEyePosition);
            this.showEyeCheck.setEnabled(this.follow.equals("gov.nasa.worldwind.TerrainProfileLayer.FollowEye"));
            jPanel2.add(this.showEyeCheck);
            JCheckBox jCheckBox = new JCheckBox("Keep proportions");
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.keepProportions = ((JCheckBox)actionEvent.getSource()).isSelected();
                    AppFrame.this.update();
                }
            });
            jCheckBox.setSelected(this.keepProportions);
            jPanel2.add(jCheckBox);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 0, 0));
            JCheckBox jCheckBox2 = new JCheckBox("Zero based");
            jCheckBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.zeroBased = ((JCheckBox)actionEvent.getSource()).isSelected();
                    AppFrame.this.update();
                }
            });
            jCheckBox2.setSelected(this.zeroBased);
            jPanel3.add(new JLabel(""));
            jPanel3.add(jCheckBox2);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel4.add(new JLabel("  Dimension:"));
            final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"Small", "Medium", "Large"});
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)jComboBox.getSelectedItem();
                    if (string.equals("Small")) {
                        AppFrame.this.graphDimension = new Dimension(250, 100);
                    } else if (string.equals("Medium")) {
                        AppFrame.this.graphDimension = new Dimension(450, 140);
                    } else if (string.equals("Large")) {
                        AppFrame.this.graphDimension = new Dimension(655, 240);
                    }
                    AppFrame.this.update();
                }
            });
            jComboBox.setSelectedItem("Small");
            jPanel4.add(jComboBox);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 0));
            JSlider jSlider = new JSlider(0, 0, 30, (int)(this.profileLengthFactor * 10.0));
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setToolTipText("Profile length");
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        AppFrame.this.profileLengthFactor = (double)jSlider.getValue() / 10.0;
                        AppFrame.this.update();
                    }
                }
            });
            jPanel5.add(jSlider);
            this.lengthSlider = jSlider;
            JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 0));
            this.helpLabel = new JLabel("Tip: move mouse over the graph.");
            this.helpLabel.setHorizontalAlignment(0);
            jPanel6.add(this.helpLabel);
            JPanel jPanel7 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel7.add(new JLabel("  Follow:"));
            final JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{"View", "Cursor", "Eye", "None", "Object"});
            jComboBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)jComboBox2.getSelectedItem();
                    if (string.equals("View")) {
                        AppFrame.this.follow = "gov.nasa.worldwind.TerrainProfileLayer.FollowView";
                        AppFrame.this.helpLabel.setEnabled(true);
                        AppFrame.this.showEyeCheck.setEnabled(false);
                        AppFrame.this.lengthSlider.setEnabled(true);
                    } else if (string.equals("Cursor")) {
                        AppFrame.this.follow = "gov.nasa.worldwind.TerrainProfileLayer.FollowCursor";
                        AppFrame.this.helpLabel.setEnabled(false);
                        AppFrame.this.showEyeCheck.setEnabled(false);
                        AppFrame.this.lengthSlider.setEnabled(true);
                    } else if (string.equals("Eye")) {
                        AppFrame.this.follow = "gov.nasa.worldwind.TerrainProfileLayer.FollowEye";
                        AppFrame.this.helpLabel.setEnabled(true);
                        AppFrame.this.showEyeCheck.setEnabled(true);
                        AppFrame.this.lengthSlider.setEnabled(true);
                    } else if (string.equals("None")) {
                        AppFrame.this.follow = "gov.nasa.worldwind.TerrainProfileLayer.FollowNone";
                        AppFrame.this.helpLabel.setEnabled(true);
                        AppFrame.this.showEyeCheck.setEnabled(false);
                        AppFrame.this.lengthSlider.setEnabled(false);
                    } else if (string.equals("Object")) {
                        AppFrame.this.follow = "gov.nasa.worldwind.TerrainProfileLayer.FollowObject";
                        AppFrame.this.helpLabel.setEnabled(true);
                        AppFrame.this.showEyeCheck.setEnabled(true);
                        AppFrame.this.lengthSlider.setEnabled(true);
                        OrbitView orbitView = (OrbitView)AppFrame.this.getWwd().getView();
                        AppFrame.this.tpl.setObjectPosition(AppFrame.this.getWwd().getView().getEyePosition());
                        AppFrame.this.tpl.setObjectHeading(orbitView.getHeading());
                    }
                    AppFrame.this.update();
                }
            });
            jComboBox2.setSelectedItem("View");
            jPanel7.add(jComboBox2);
            jPanel.add(jPanel4);
            jPanel.add(jPanel7);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel5);
            jPanel.add(jPanel6);
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Terrain profile")));
            jPanel.setToolTipText("Terrain profile controls");
            return jPanel;
        }

        private void update() {
            this.tpl.setFollow(this.follow);
            this.tpl.setKeepProportions(this.keepProportions);
            this.tpl.setZeroBased(this.zeroBased);
            this.tpl.setSize(this.graphDimension);
            this.tpl.setShowEyePosition(this.showEyePosition);
            this.tpl.setProfileLengthFactor(this.profileLengthFactor);
            this.getWwd().redraw();
        }
    }
}

