/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.spi.IIORegistry;

public class SurfaceImages
extends ApplicationTemplate {
    protected static final String GEORSS_ICON_PATH = "gov/nasa/worldwindx/examples/images/georss.png";
    protected static final String TEST_PATTERN = "gov/nasa/worldwindx/examples/images/antenna.png";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Surface Images", AppFrame.class);
    }

    static {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        iIORegistry.registerServiceProvider(GeotiffImageReaderSpi.inst());
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                SurfaceImage surfaceImage = new SurfaceImage((Object)SurfaceImages.GEORSS_ICON_PATH, new ArrayList<LatLon>(Arrays.asList(LatLon.fromDegrees(20.0, -115.0), LatLon.fromDegrees(20.0, -105.0), LatLon.fromDegrees(32.0, -102.0), LatLon.fromDegrees(30.0, -115.0))));
                SurfaceImage surfaceImage2 = new SurfaceImage((Object)SurfaceImages.TEST_PATTERN, new ArrayList<LatLon>(Arrays.asList(LatLon.fromDegrees(37.8677, -105.1668), LatLon.fromDegrees(37.8677, -104.8332), LatLon.fromDegrees(38.1321, -104.8326), LatLon.fromDegrees(38.1321, -105.1674))));
                Polyline polyline = new Polyline(surfaceImage.getCorners(), 0.0);
                polyline.setFollowTerrain(true);
                polyline.setClosed(true);
                polyline.setPathType(2);
                polyline.setColor(new Color(0, 255, 0));
                Polyline polyline2 = new Polyline(surfaceImage2.getCorners(), 0.0);
                polyline2.setFollowTerrain(true);
                polyline2.setClosed(true);
                polyline2.setPathType(2);
                polyline2.setColor(new Color(0, 255, 0));
                RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("Surface Images");
                renderableLayer.setPickEnabled(false);
                renderableLayer.addRenderable(surfaceImage);
                renderableLayer.addRenderable(surfaceImage2);
                renderableLayer.addRenderable(polyline);
                renderableLayer.addRenderable(polyline2);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
                this.getLayerPanel().update(this.getWwd());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

