/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.PickPointFrustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.PickPointFrustumList;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.opengl.GL2;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PickFrustum
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Picking Frustum", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected JLabel lblDimension;
        protected JLabel frustumDimensionLabel;
        protected JPanel panel;
        protected JSlider slider;
        protected JToggleButton butShowPickingFrustum;
        protected JToggleButton butTogglePickingClipping;
        protected JToggleButton butToggleViewClipping;
        protected WWIcon lastPickedIcon;
        protected IconLayer iconLayer = null;
        protected PickFrustumLayer frustumLayer = new PickFrustumLayer();

        public AppFrame() {
            super(true, false, false);
            this.getWwd().addSelectListener(new SelectListener(){

                @Override
                public void selected(SelectEvent selectEvent) {
                    if (AppFrame.this.isEnabled() && selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    }
                }
            });
            this.iconLayer = new IconLayer();
            this.iconLayer.setViewClippingEnabled(true);
            this.iconLayer.setPickFrustumClippingEnabled(true);
            for (int i = -180; i < 180; i += 5) {
                for (int j = -90; j < 90; j += 5) {
                    UserFacingIcon userFacingIcon = new UserFacingIcon("gov/nasa/worldwindx/examples/images/georss.png", new Position(Angle.fromDegrees(j), Angle.fromDegrees(i), 0.0));
                    userFacingIcon.setSize(new Dimension(32, 32));
                    userFacingIcon.setHighlightScale(1.3);
                    this.iconLayer.addIcon(userFacingIcon);
                }
            }
            ApplicationTemplate.insertAfterPlacenames(this.getWwd(), this.iconLayer);
            this.frustumLayer.setEnabled(false);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.frustumLayer);
            this.getContentPane().add((Component)this.makeControlPanel(), "West");
        }

        protected void highlight(Object object) {
            if (this.lastPickedIcon == object) {
                return;
            }
            if (this.lastPickedIcon != null) {
                this.lastPickedIcon.setHighlighted(false);
                this.lastPickedIcon = null;
            }
            if (object != null && object instanceof WWIcon) {
                this.lastPickedIcon = (WWIcon)object;
                this.lastPickedIcon.setHighlighted(true);
            }
        }

        protected JPanel makeControlPanel() {
            Dimension dimension = this.getWwd().getSceneController().getDrawContext().getPickPointFrustumDimension();
            int n = dimension.width;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1));
            jPanel.setBorder(new CompoundBorder(new TitledBorder("Frustum Culling"), new EmptyBorder(20, 10, 20, 10)));
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.add((Component)jPanel, "North");
            this.butToggleViewClipping = new JToggleButton();
            this.butToggleViewClipping.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.butToggleViewClipping.isSelected()) {
                        AppFrame.this.iconLayer.setViewClippingEnabled(true);
                        AppFrame.this.butToggleViewClipping.setText("Disable View Clipping");
                    } else {
                        AppFrame.this.iconLayer.setViewClippingEnabled(false);
                        AppFrame.this.butToggleViewClipping.setText("Enable View Clipping");
                    }
                    AppFrame.this.getWwd().redraw();
                }
            });
            this.butToggleViewClipping.setSelected(true);
            this.butToggleViewClipping.setText("Disable View Clipping");
            jPanel.add(this.butToggleViewClipping);
            this.butTogglePickingClipping = new JToggleButton();
            this.butTogglePickingClipping.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.butTogglePickingClipping.isSelected()) {
                        AppFrame.this.iconLayer.setPickFrustumClippingEnabled(true);
                        AppFrame.this.butTogglePickingClipping.setText("Disable Picking Clipping");
                    } else {
                        AppFrame.this.iconLayer.setPickFrustumClippingEnabled(false);
                        AppFrame.this.butTogglePickingClipping.setText("Enable Picking Clipping");
                    }
                    AppFrame.this.getWwd().redraw();
                }
            });
            this.butTogglePickingClipping.setSelected(true);
            this.butTogglePickingClipping.setText("Disable Picking Clipping");
            jPanel.add(this.butTogglePickingClipping);
            this.butShowPickingFrustum = new JToggleButton();
            this.butShowPickingFrustum.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.butShowPickingFrustum.isSelected()) {
                        AppFrame.this.frustumLayer.setEnabled(true);
                        AppFrame.this.butShowPickingFrustum.setText("Hide Picking Frustum");
                    } else {
                        AppFrame.this.frustumLayer.setEnabled(false);
                        AppFrame.this.butShowPickingFrustum.setText("Show Picking Frustum");
                    }
                    AppFrame.this.getWwd().redraw();
                }
            });
            this.butShowPickingFrustum.setText("Show Picking Frustum");
            jPanel.add(this.butShowPickingFrustum);
            this.slider = new JSlider();
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = AppFrame.this.slider.getValue();
                    if (AppFrame.this.lblDimension != null) {
                        AppFrame.this.lblDimension.setText("(" + n + "," + n + ")");
                        AppFrame.this.getWwd().getSceneController().getDrawContext().setPickPointFrustumDimension(new Dimension(n, n));
                        AppFrame.this.getWwd().redraw();
                    }
                }
            });
            this.slider.setMaximum(200);
            this.slider.setMinimum(3);
            this.slider.setValue(n);
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            jPanel.add(this.slider);
            this.panel = new JPanel();
            this.panel.setLayout(new GridLayout(1, 0));
            jPanel.add(this.panel);
            this.frustumDimensionLabel = new JLabel();
            this.frustumDimensionLabel.setText("Frustum Dimension:");
            this.panel.add(this.frustumDimensionLabel);
            this.lblDimension = new JLabel();
            this.lblDimension.setText("(" + n + "," + n + ")");
            this.panel.add(this.lblDimension);
            jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
            return jPanel2;
        }
    }

    public static class PickFrustumLayer
    extends RenderableLayer {
        protected OrderedIcon orderedImage = new OrderedIcon();

        @Override
        public void doRender(DrawContext drawContext) {
            drawContext.addOrderedRenderable(this.orderedImage);
        }

        @Override
        public void doPick(DrawContext drawContext, Point point) {
            drawContext.addOrderedRenderable(this.orderedImage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(DrawContext drawContext) {
            GL2 gL2 = drawContext.getGL().getGL2();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            PickPointFrustumList pickPointFrustumList = drawContext.getPickFrustums();
            if (pickPointFrustumList == null) {
                return;
            }
            try {
                gL2.glPushAttrib(30977);
                bl = true;
                gL2.glEnable(3042);
                gL2.glBlendFunc(770, 771);
                gL2.glDisable(2929);
                Rectangle rectangle = drawContext.getView().getViewport();
                gL2.glMatrixMode(5889);
                gL2.glPushMatrix();
                bl3 = true;
                gL2.glLoadIdentity();
                gL2.glOrtho(0.0, (double)rectangle.width, 0.0, (double)rectangle.height, -1.0, 1.0);
                gL2.glMatrixMode(5888);
                gL2.glPushMatrix();
                bl2 = true;
                gL2.glLoadIdentity();
                gL2.glLineWidth(2.0f);
                gL2.glColor3f(1.0f, 0.0f, 0.0f);
                for (PickPointFrustum pickPointFrustum : pickPointFrustumList) {
                    Rectangle rectangle2 = pickPointFrustum.getScreenRect();
                    gL2.glBegin(3);
                    gL2.glVertex3d(rectangle2.getX(), rectangle2.getY(), 0.0);
                    gL2.glVertex3d(rectangle2.getX() + rectangle2.getWidth(), rectangle2.getY(), 0.0);
                    gL2.glVertex3d(rectangle2.getX() + rectangle2.getWidth(), rectangle2.getY() + rectangle2.getHeight(), 0.0);
                    gL2.glVertex3d(rectangle2.getX(), rectangle2.getY() + rectangle2.getHeight(), 0.0);
                    gL2.glVertex3d(rectangle2.getX(), rectangle2.getY(), 0.0);
                    gL2.glEnd();
                }
            }
            finally {
                if (bl3) {
                    gL2.glMatrixMode(5889);
                    gL2.glPopMatrix();
                }
                if (bl2) {
                    gL2.glMatrixMode(5888);
                    gL2.glPopMatrix();
                }
                if (bl) {
                    gL2.glPopAttrib();
                }
            }
        }

        protected class OrderedIcon
        implements OrderedRenderable {
            protected OrderedIcon() {
            }

            @Override
            public double getDistanceFromEye() {
                return 0.0;
            }

            @Override
            public void pick(DrawContext drawContext, Point point) {
                PickFrustumLayer.this.draw(drawContext);
            }

            @Override
            public void render(DrawContext drawContext) {
                PickFrustumLayer.this.draw(drawContext);
            }
        }
    }
}

