/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.SessionState;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;

public class PersistSessionState
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        }
        PersistSessionState.start("World Wind Persist Session State", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected SessionState sessionState = new SessionState(PersistSessionState.class.getName());

        public AppFrame() {
            this.initSessionState();
        }

        protected void initSessionState() {
            this.restoreSessionState();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    AppFrame.this.saveSessionState();
                }
            });
        }

        protected void saveSessionState() {
            try {
                this.sessionState.saveSessionState(this.getWwd());
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "Unable to save session state", exception);
            }
        }

        protected void restoreSessionState() {
            try {
                this.sessionState.restoreSessionState(this.getWwd());
                this.getLayerPanel().update(this.getWwd());
                this.getWwd().redraw();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "Unable to restore session state", exception);
            }
        }
    }
}

