/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ToolTipController;
import java.awt.Color;
import java.util.ArrayList;

public class PathPositionColors
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 47.589);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -122.3137);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 3000);
        ApplicationTemplate.start("World Wind Path Position Colors", AppFrame.class);
    }

    public static class ExamplePositionColors
    implements Path.PositionColors {
        protected Color[] colors;
        protected int pathLength;

        public ExamplePositionColors(Color[] colorArray, int n) {
            this.colors = colorArray;
            this.pathLength = n;
        }

        @Override
        public Color getColor(Position position, int n) {
            int n2 = this.colors.length * n / this.pathLength;
            return this.colors[n2];
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(47.58495213398363, -122.31517238581496, 0.0));
            arrayList.add(Position.fromDegrees(47.58557392961059, -122.31038095541774, 0.0));
            arrayList.add(Position.fromDegrees(47.585643343225826, -122.30380786403879, 0.0));
            arrayList.add(Position.fromDegrees(47.588442264013494, -122.30292363044828, 0.0));
            arrayList.add(Position.fromDegrees(47.59082509462611, -122.30354883680081, 0.0));
            arrayList.add(Position.fromDegrees(47.592022012752125, -122.30513978083029, 0.0));
            arrayList.add(Position.fromDegrees(47.59253456911678, -122.30947924950297, 0.0));
            arrayList.add(Position.fromDegrees(47.592351544411116, -122.31370241373538, 0.0));
            arrayList.add(Position.fromDegrees(47.59215114879707, -122.31893777293358, 0.0));
            arrayList.add(Position.fromDegrees(47.591633551472405, -122.32215105706649, 0.0));
            arrayList.add(Position.fromDegrees(47.59107338189763, -122.32440174494027, 0.0));
            arrayList.add(Position.fromDegrees(47.58935250213581, -122.32511028595225, 0.0));
            arrayList.add(Position.fromDegrees(47.585577065954475, -122.32436748847293, 0.0));
            arrayList.add(Position.fromDegrees(47.58476284067178, -122.32277296412886, 0.0));
            arrayList.add(Position.fromDegrees(47.584304450759085, -122.32186049274797, 0.0));
            Path path = new Path(arrayList);
            path.setAltitudeMode(1);
            path.setFollowTerrain(true);
            path.setShowPositions(true);
            path.setShowPositionsScale(3.0);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineWidth(3.0);
            path.setAttributes(basicShapeAttributes);
            Color[] colorArray = new Color[]{new Color(1.0f, 0.0f, 0.0f, 0.2f), new Color(0.0f, 1.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 1.0f, 1.0f)};
            path.setPositionColors(new ExamplePositionColors(colorArray, arrayList.size()));
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable(path);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            this.setToolTipController(new ToolTipController(this.getWwd()){

                @Override
                public void selected(SelectEvent selectEvent) {
                    PickedObject pickedObject = selectEvent.getTopPickedObject();
                    if (pickedObject != null && pickedObject.getObject() instanceof Path) {
                        String string = pickedObject.getValue("gov.nasa.worldwind.avkey.Ordinal") != null ? "Position " + pickedObject.getValue("gov.nasa.worldwind.avkey.Ordinal") : null;
                        ((Path)pickedObject.getObject()).setValue("gov.nasa.worldwind.avkey.DisplayName", string);
                    }
                    super.selected(selectEvent);
                }
            });
        }
    }
}

