/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class LineBuilder
extends AVListImpl {
    private final WorldWindow wwd;
    private boolean armed = false;
    private ArrayList<Position> positions = new ArrayList();
    private final RenderableLayer layer;
    private final Polyline line;
    private boolean active = false;

    public LineBuilder(WorldWindow worldWindow, RenderableLayer renderableLayer, Polyline polyline) {
        this.wwd = worldWindow;
        if (polyline != null) {
            this.line = polyline;
        } else {
            this.line = new Polyline();
            this.line.setFollowTerrain(true);
        }
        this.layer = renderableLayer != null ? renderableLayer : new RenderableLayer();
        this.layer.addRenderable(this.line);
        this.wwd.getModel().getLayers().add(this.layer);
        this.wwd.getInputHandler().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (LineBuilder.this.armed && mouseEvent.getButton() == 1) {
                    if (LineBuilder.this.armed && (mouseEvent.getModifiersEx() & 0x400) != 0 && !mouseEvent.isControlDown()) {
                        LineBuilder.this.active = true;
                        LineBuilder.this.addPosition();
                    }
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (LineBuilder.this.armed && mouseEvent.getButton() == 1) {
                    if (LineBuilder.this.positions.size() == 1) {
                        LineBuilder.this.removePosition();
                    }
                    LineBuilder.this.active = false;
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (LineBuilder.this.armed && mouseEvent.getButton() == 1) {
                    if (mouseEvent.isControlDown()) {
                        LineBuilder.this.removePosition();
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.wwd.getInputHandler().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (LineBuilder.this.armed && (mouseEvent.getModifiersEx() & 0x400) != 0 && LineBuilder.this.active) {
                    mouseEvent.consume();
                }
            }
        });
        this.wwd.addPositionListener(new PositionListener(){

            @Override
            public void moved(PositionEvent positionEvent) {
                if (!LineBuilder.this.active) {
                    return;
                }
                if (LineBuilder.this.positions.size() == 1) {
                    LineBuilder.this.addPosition();
                } else {
                    LineBuilder.this.replacePosition();
                }
            }
        });
    }

    public RenderableLayer getLayer() {
        return this.layer;
    }

    public Polyline getLine() {
        return this.line;
    }

    public void clear() {
        while (this.positions.size() > 0) {
            this.removePosition();
        }
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        this.armed = bl;
    }

    private void addPosition() {
        Position position = this.wwd.getCurrentPosition();
        if (position == null) {
            return;
        }
        this.positions.add(position);
        this.line.setPositions(this.positions);
        this.firePropertyChange("LineBuilder.AddPosition", null, position);
        this.wwd.redraw();
    }

    private void replacePosition() {
        Position position = this.wwd.getCurrentPosition();
        if (position == null) {
            return;
        }
        int n = this.positions.size() - 1;
        if (n < 0) {
            n = 0;
        }
        Position position2 = this.positions.get(n);
        this.positions.set(n, position);
        this.line.setPositions(this.positions);
        this.firePropertyChange("LineBuilder.ReplacePosition", position2, position);
        this.wwd.redraw();
    }

    private void removePosition() {
        if (this.positions.size() == 0) {
            return;
        }
        Position position = this.positions.get(this.positions.size() - 1);
        this.positions.remove(this.positions.size() - 1);
        this.line.setPositions(this.positions);
        this.firePropertyChange("LineBuilder.RemovePosition", position, null);
        this.wwd.redraw();
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Line Builder", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, false, false);
            LineBuilder lineBuilder = new LineBuilder(this.getWwd(), null, null);
            this.getContentPane().add((Component)new LinePanel(this.getWwd(), lineBuilder), "West");
        }
    }

    private static class LinePanel
    extends JPanel {
        private final WorldWindow wwd;
        private final LineBuilder lineBuilder;
        private JButton newButton;
        private JButton pauseButton;
        private JButton endButton;
        private JLabel[] pointLabels;

        public LinePanel(WorldWindow worldWindow, LineBuilder lineBuilder) {
            super(new BorderLayout());
            this.wwd = worldWindow;
            this.lineBuilder = lineBuilder;
            this.makePanel(new Dimension(200, 400));
            lineBuilder.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LinePanel.this.fillPointsPanel();
                }
            });
        }

        private void makePanel(Dimension dimension) {
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
            this.newButton = new JButton("New");
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinePanel.this.lineBuilder.clear();
                    LinePanel.this.lineBuilder.setArmed(true);
                    LinePanel.this.pauseButton.setText("Pause");
                    LinePanel.this.pauseButton.setEnabled(true);
                    LinePanel.this.endButton.setEnabled(true);
                    LinePanel.this.newButton.setEnabled(false);
                    ((Component)((Object)LinePanel.this.wwd)).setCursor(Cursor.getPredefinedCursor(1));
                }
            });
            jPanel.add(this.newButton);
            this.newButton.setEnabled(true);
            this.pauseButton = new JButton("Pause");
            this.pauseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinePanel.this.lineBuilder.setArmed(!LinePanel.this.lineBuilder.isArmed());
                    LinePanel.this.pauseButton.setText(!LinePanel.this.lineBuilder.isArmed() ? "Resume" : "Pause");
                    ((Component)((Object)LinePanel.this.wwd)).setCursor(Cursor.getDefaultCursor());
                }
            });
            jPanel.add(this.pauseButton);
            this.pauseButton.setEnabled(false);
            this.endButton = new JButton("End");
            this.endButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinePanel.this.lineBuilder.setArmed(false);
                    LinePanel.this.newButton.setEnabled(true);
                    LinePanel.this.pauseButton.setEnabled(false);
                    LinePanel.this.pauseButton.setText("Pause");
                    LinePanel.this.endButton.setEnabled(false);
                    ((Component)((Object)LinePanel.this.wwd)).setCursor(Cursor.getDefaultCursor());
                }
            });
            jPanel.add(this.endButton);
            this.endButton.setEnabled(false);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pointLabels = new JLabel[20];
            for (int i = 0; i < this.pointLabels.length; ++i) {
                this.pointLabels[i] = new JLabel("");
                jPanel2.add(this.pointLabels[i]);
            }
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel2, "North");
            JScrollPane jScrollPane = new JScrollPane(jPanel3);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (dimension != null) {
                jScrollPane.setPreferredSize(dimension);
            }
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Line")));
            jPanel4.setToolTipText("Line control and info");
            jPanel4.add((Component)jPanel, "North");
            jPanel4.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel4, "Center");
        }

        private void fillPointsPanel() {
            int n = 0;
            for (Position position : this.lineBuilder.getLine().getPositions()) {
                if (n == this.pointLabels.length) break;
                String string = String.format("Lat %7.4f\u00b0", position.getLatitude().getDegrees());
                String string2 = String.format("Lon %7.4f\u00b0", position.getLongitude().getDegrees());
                this.pointLabels[n++].setText(string + "  " + string2);
            }
            while (n < this.pointLabels.length) {
                this.pointLabels[n++].setText("");
                ++n;
            }
        }
    }
}

