/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class ExtrudedPolygonWithBaseDepth
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Extruded Polygon with Base Depth", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.MAGENTA);
            basicShapeAttributes.setOutlineOpacity(0.5);
            basicShapeAttributes.setInteriorOpacity(0.25);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineWidth(1.0);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(true);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes2.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes2.setInteriorOpacity(0.25);
            basicShapeAttributes2.setDrawInterior(true);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(43.84344, -114.63673, 20.0));
            arrayList.add(Position.fromDegrees(43.84343, -114.63468, 20.0));
            arrayList.add(Position.fromDegrees(43.84316, -114.63468, 20.0));
            arrayList.add(Position.fromDegrees(43.84314, -114.63675, 20.0));
            arrayList.add(Position.fromDegrees(43.84344, -114.63673, 20.0));
            ExtrudedPolygon extrudedPolygon = new ExtrudedPolygon(arrayList);
            extrudedPolygon.setAltitudeMode(2);
            extrudedPolygon.setSideAttributes(basicShapeAttributes);
            extrudedPolygon.setCapAttributes(basicShapeAttributes2);
            extrudedPolygon.setBaseDepth(20.0);
            renderableLayer.addRenderable(extrudedPolygon);
            Path path = new Path(Position.fromDegrees(43.8425, -114.6355, 0.0), Position.fromDegrees(43.8442, -114.6356, 0.0));
            BasicShapeAttributes basicShapeAttributes3 = new BasicShapeAttributes();
            basicShapeAttributes3.setOutlineOpacity(1.0);
            basicShapeAttributes3.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes3.setOutlineWidth(4.0);
            path.setAttributes(basicShapeAttributes3);
            path.setAltitudeMode(2);
            renderableLayer.addRenderable(path);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().getView().setEyePosition(Position.fromDegrees(43.843162670564354, -114.63551647988652, 2652.865781935775));
        }
    }
}

