/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.formats.tiff.GeotiffWriter;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.SectorSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ExportImageOrElevations
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 1000.0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 37.7794);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -122.4192);
        ApplicationTemplate.start("World Wind Exporting Surface Imagery and Elevations", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private static final double MISSING_DATA_SIGNAL = -32768.0;
        private JButton btnSaveElevations = null;
        private JButton btnSaveImage = null;
        private Sector selectedSector = null;
        private JFileChooser fileChooser = null;
        private SectorSelector selector = new SectorSelector(this.getWwd());

        public AppFrame() {
            super(true, true, false);
            this.selector.setInteriorColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
            this.selector.setBorderColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            this.selector.setBorderWidth(3.0);
            JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 5));
            JButton jButton = new JButton(new EnableSelectorAction());
            jButton.setToolTipText("Press Start then press and drag button 1 on globe");
            jPanel.add(jButton);
            this.btnSaveElevations = new JButton(new SaveElevationsAction());
            this.btnSaveElevations.setEnabled(false);
            this.btnSaveElevations.setToolTipText("Click the button to save elevations of the selected area");
            jPanel.add(this.btnSaveElevations);
            this.btnSaveImage = new JButton(new SaveImageAction());
            this.btnSaveImage.setEnabled(false);
            this.btnSaveImage.setToolTipText("Click the button to save image of the selected area");
            jPanel.add(this.btnSaveImage);
            this.getLayerPanel().add((Component)jPanel, "South");
            this.selector.addPropertyChangeListener("gov.nasa.worldwind.SectorSelector", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Sector sector = (Sector)propertyChangeEvent.getNewValue();
                    if (null != sector) {
                        AppFrame.this.selectedSector = sector;
                        AppFrame.this.btnSaveElevations.setEnabled(true);
                        AppFrame.this.btnSaveImage.setEnabled(true);
                    }
                }
            });
            this.enableNAIPLayer();
            this.getLayerPanel().update(this.getWwd());
        }

        private File selectDestinationFile(String string, String string2) {
            File file = null;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
                this.fileChooser.addChoosableFileFilter(new GeotiffFileFilter());
            }
            this.fileChooser.setDialogTitle(string);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogType(1);
            this.fileChooser.setName(string2);
            int n = this.fileChooser.showSaveDialog(null);
            if (n == 0 && !(file = this.fileChooser.getSelectedFile()).getName().endsWith(".tif")) {
                file = new File(file.getPath() + ".tif");
            }
            return file;
        }

        public void doSaveElevations() {
            final File file = this.selectDestinationFile("Select a destination GeoTiff file to save elevations", "elevation");
            if (file == null) {
                return;
            }
            JOptionPane jOptionPane = new JOptionPane("Requesting elevations ...", -1, -1, null, new Object[0], null);
            final JDialog jDialog = jOptionPane.createDialog(this.getRootPane().getTopLevelAncestor(), "Please wait...");
            jDialog.setModal(false);
            jDialog.setVisible(true);
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: {
                        try {
                            int[] nArray = AppFrame.this.adjustSize(AppFrame.this.selectedSector, 512);
                            int n = nArray[0];
                            int n2 = nArray[1];
                            double[] dArray = AppFrame.this.readElevations(AppFrame.this.selectedSector, n, n2);
                            if (null != dArray) {
                                jDialog.setTitle("Writing elevations to " + file.getName());
                                AppFrame.this.writeElevationsToFile(AppFrame.this.selectedSector, n, n2, dArray, file);
                                jDialog.setVisible(false);
                                JOptionPane.showMessageDialog(AppFrame.this.wwjPanel, "Elevations saved into the " + file.getName());
                                break block5;
                            }
                            jDialog.setVisible(false);
                            JOptionPane.showMessageDialog(AppFrame.this.wwjPanel, "Attempt to save elevations to the " + file.getName() + " has failed.");
                        }
                        catch (Exception exception) {
                            try {
                                exception.printStackTrace();
                                jDialog.setVisible(false);
                                JOptionPane.showMessageDialog(AppFrame.this.wwjPanel, exception.getMessage());
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AppFrame.this.setCursor(Cursor.getDefaultCursor());
                                        AppFrame.this.getWwd().redraw();
                                        jDialog.setVisible(false);
                                    }
                                });
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setCursor(new Cursor(3));
            this.getWwd().redraw();
            thread.start();
        }

        public void enableNAIPLayer() {
            LayerList layerList = this.getWwd().getModel().getLayers();
            ListIterator listIterator = layerList.listIterator();
            while (listIterator.hasNext()) {
                Layer layer = (Layer)listIterator.next();
                if (!layer.getName().contains("NAIP")) continue;
                layer.setEnabled(true);
                break;
            }
        }

        public void doSaveImage() {
            TiledImageLayer tiledImageLayer;
            Object object;
            TiledImageLayer tiledImageLayer2 = null;
            LayerList layerList = this.getWwd().getModel().getLayers();
            DrawContext drawContext = this.getWwd().getSceneController().getDrawContext();
            ListIterator listIterator = layerList.listIterator();
            while (listIterator.hasNext()) {
                object = listIterator.next();
                if (!(object instanceof TiledImageLayer) || !(tiledImageLayer = (TiledImageLayer)object).isEnabled() || !tiledImageLayer.isLayerActive(drawContext) || !tiledImageLayer.isLayerInView(drawContext)) continue;
                tiledImageLayer2 = tiledImageLayer;
            }
            if (null == tiledImageLayer2) {
                return;
            }
            object = this.selectDestinationFile("Select a destination GeoTiff file to save the image", "image");
            if (object == null) {
                return;
            }
            tiledImageLayer = tiledImageLayer2;
            JOptionPane jOptionPane = new JOptionPane("Requesting image ...", -1, -1, null, new Object[0], null);
            final JDialog jDialog = jOptionPane.createDialog(this.getRootPane().getTopLevelAncestor(), "Please wait...");
            jDialog.setModal(false);
            jDialog.setVisible(true);
            Thread thread = new Thread(new Runnable((File)object){
                final /* synthetic */ File val$saveToFile;
                {
                    this.val$saveToFile = file;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: {
                        try {
                            BufferedImage bufferedImage = AppFrame.this.captureImage(tiledImageLayer, AppFrame.this.selectedSector, 2048);
                            if (null != bufferedImage) {
                                jDialog.setTitle("Writing image to " + this.val$saveToFile.getName());
                                AppFrame.this.writeImageToFile(AppFrame.this.selectedSector, bufferedImage, this.val$saveToFile);
                                jDialog.setVisible(false);
                                JOptionPane.showMessageDialog(AppFrame.this.wwjPanel, "Image saved into the " + this.val$saveToFile.getName());
                                break block5;
                            }
                            jDialog.setVisible(false);
                            JOptionPane.showMessageDialog(AppFrame.this.wwjPanel, "Attempt to save image to the " + this.val$saveToFile.getName() + " has failed.");
                        }
                        catch (Exception exception) {
                            try {
                                exception.printStackTrace();
                                jDialog.setVisible(false);
                                JOptionPane.showMessageDialog(AppFrame.this.wwjPanel, exception.getMessage());
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AppFrame.this.setCursor(Cursor.getDefaultCursor());
                                        AppFrame.this.getWwd().redraw();
                                        jDialog.setVisible(false);
                                    }
                                });
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setCursor(new Cursor(3));
            this.getWwd().redraw();
            thread.start();
        }

        private int[] adjustSize(Sector sector, int n) {
            int[] nArray = new int[]{n, n};
            if (null != sector && n > 0) {
                LatLon latLon = sector.getCentroid();
                Angle angle = LatLon.greatCircleDistance(new LatLon(sector.getMinLatitude(), sector.getMinLongitude()), new LatLon(sector.getMaxLatitude(), sector.getMinLongitude()));
                Angle angle2 = LatLon.greatCircleDistance(new LatLon(latLon.getLatitude(), sector.getMinLongitude()), new LatLon(latLon.getLatitude(), sector.getMaxLongitude()));
                double d = Math.max(angle.radians, angle2.radians);
                double d2 = Math.min(angle.radians, angle2.radians);
                int n2 = (int)(d2 == 0.0 ? (double)n : (double)n * d2 / d);
                if (angle2.radians > angle.radians) {
                    nArray[0] = n;
                    nArray[1] = n2;
                } else {
                    nArray[0] = n2;
                    nArray[1] = n;
                }
            }
            return nArray;
        }

        private BufferedImage captureImage(TiledImageLayer tiledImageLayer, Sector sector, int n) throws Exception {
            int[] nArray = this.adjustSize(sector, n);
            int n2 = nArray[0];
            int n3 = nArray[1];
            String string = tiledImageLayer.getDefaultImageFormat();
            if (tiledImageLayer.isImageFormatAvailable("image/png")) {
                string = "image/png";
            } else if (tiledImageLayer.isImageFormatAvailable("image/jpg")) {
                string = "image/jpg";
            }
            return tiledImageLayer.composeImageForSector(this.selectedSector, n2, n3, 1.0, -1, string, true, null, 30000);
        }

        private double[] readElevations(Sector sector, int n, int n2) {
            double[] dArray;
            double d = sector.getMinLatitude().radians;
            double d2 = sector.getMaxLatitude().radians;
            double d3 = (d2 - d) / (double)(n2 - 1);
            double d4 = sector.getMinLongitude().radians;
            double d5 = sector.getMaxLongitude().radians;
            double d6 = (d5 - d4) / (double)(n - 1);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>(n * n2);
            int n3 = n - 1;
            int n4 = n2 - 1;
            double d7 = d;
            for (int i = 0; i < n2; ++i) {
                double d8 = d4;
                for (int j = 0; j < n; ++j) {
                    arrayList.add(LatLon.fromRadians(d7, d8));
                    d8 = j == n3 ? d5 : d8 + d6;
                }
                d7 = i == n4 ? d2 : d7 + d3;
            }
            try {
                Globe globe = this.getWwd().getModel().getGlobe();
                ElevationModel elevationModel = globe.getElevationModel();
                dArray = new double[arrayList.size()];
                Arrays.fill(dArray, -32768.0);
                elevationModel.composeElevations(sector, arrayList, n, dArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dArray = null;
            }
            return dArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeImageToFile(Sector sector, BufferedImage bufferedImage, File file) throws IOException {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
            GeotiffWriter geotiffWriter = new GeotiffWriter(file);
            try {
                geotiffWriter.write(BufferedImageRaster.wrapAsGeoreferencedRaster(bufferedImage, aVListImpl));
            }
            finally {
                geotiffWriter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeElevationsToFile(Sector sector, int n, int n2, double[] dArray, File file) throws IOException {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", n);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", n2);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Float32");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ElevationUnit", "gov.nasa.worldwind.avkey.Unit.Meter");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", -32768.0);
            ByteBufferRaster byteBufferRaster = (ByteBufferRaster)ByteBufferRaster.createGeoreferencedRaster(aVListImpl);
            int n3 = 0;
            for (int i = n2 - 1; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    byteBufferRaster.setDoubleAtPosition(i, j, dArray[n3++]);
                }
            }
            GeotiffWriter geotiffWriter = new GeotiffWriter(file);
            try {
                geotiffWriter.write(byteBufferRaster);
            }
            finally {
                geotiffWriter.close();
            }
        }

        public static class GeotiffFileFilter
        extends FileFilter {
            @Override
            public boolean accept(File file) {
                if (file == null) {
                    String string = Logging.getMessage("nullValue.FileIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".tif");
            }

            @Override
            public String getDescription() {
                return "Geo-TIFF (tif)";
            }
        }

        private class DisableSelectorAction
        extends AbstractAction {
            public DisableSelectorAction() {
                super("Clear selection");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.selector.disable();
                AppFrame.this.btnSaveElevations.setEnabled(false);
                AppFrame.this.btnSaveImage.setEnabled(false);
                AppFrame.this.selectedSector = null;
                ((JButton)actionEvent.getSource()).setAction(new EnableSelectorAction());
            }
        }

        private class EnableSelectorAction
        extends AbstractAction {
            public EnableSelectorAction() {
                super("Start selection");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JButton)actionEvent.getSource()).setAction(new DisableSelectorAction());
                AppFrame.this.selector.enable();
            }
        }

        private class SaveImageAction
        extends AbstractAction {
            public SaveImageAction() {
                super("Save image ...");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.doSaveImage();
            }
        }

        private class SaveElevationsAction
        extends AbstractAction {
            public SaveElevationsAction() {
                super("Save elevations ...");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.doSaveElevations();
            }
        }
    }
}

