/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;

public class ExternalLinkController
extends AbstractFeature
implements SelectListener,
Disposable {
    public ExternalLinkController(Registry registry) {
        super("External Link Controller", "gov.nasa.worldwindx.applications.worldwindow.feature.ExternalLinkController", registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.controller.getWWd().addSelectListener(this);
    }

    @Override
    public void dispose() {
        this.controller.getWWd().removeSelectListener(this);
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent.isLeftDoubleClick() && selectEvent.getTopObject() instanceof AVList) {
            String string = ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwind.avkey.ExternalLink");
            if (string == null) {
                return;
            }
            this.controller.openLink(string);
        }
    }
}

