/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.actions;

import gov.nasa.worldwindx.applications.sar.PositionTable;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AddOffsetToPositionsAction
extends AbstractAction {
    protected final PositionTable table;

    public AddOffsetToPositionsAction(PositionTable positionTable) {
        SARTrack sARTrack;
        this.table = positionTable;
        int n = positionTable.getSelectedRowCount();
        this.putValue("Name", "Add Altitude Offset To Selected");
        this.putValue("LongDescription", "Add the track altitude offset to the selected positions");
        if (n == 0) {
            this.setEnabled(false);
        }
        if ((sARTrack = positionTable.getSarTrack()) == null || sARTrack.getOffset() == 0.0) {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SARTrack sARTrack = this.table.getSarTrack();
        if (sARTrack == null || sARTrack.getOffset() == 0.0) {
            return;
        }
        double d = sARTrack.getOffset();
        for (int n : this.table.getSelectedRows()) {
            SARPosition sARPosition = sARTrack.get(n);
            sARTrack.set(n, new SARPosition(sARPosition.getLatitude(), sARPosition.getLongitude(), sARPosition.getElevation() + d));
        }
    }
}

