/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwindx.applications.sar.SARTrack;
import gov.nasa.worldwindx.applications.sar.tracks.SaveTrackFilter;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class SaveTrackDialog {
    private JFileChooser fileChooser;
    private JCheckBox saveAnnotations;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;

    public SaveTrackDialog() {
        this.initComponents();
    }

    public File getSelectedFile() {
        File file = this.fileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        SaveTrackFilter saveTrackFilter = this.getSelectedSaveFilter();
        if (saveTrackFilter != null) {
            file = saveTrackFilter.appendSuffix(file);
        }
        return file;
    }

    public void setSelectedFile(File file) {
        this.fileChooser.setSelectedFile(file);
    }

    public void setSelectedFile(SARTrack sARTrack) {
        if (sARTrack != null) {
            if (sARTrack.getFile() != null) {
                this.fileChooser.setSelectedFile(sARTrack.getFile());
            } else if (sARTrack.getName() != null && this.fileChooser.getCurrentDirectory() != null) {
                this.fileChooser.setSelectedFile(new File(this.fileChooser.getCurrentDirectory(), sARTrack.getName()));
            }
        }
    }

    public boolean isSaveAnnotations() {
        return this.saveAnnotations.isSelected();
    }

    public void setSaveAnnotations(boolean bl) {
        this.saveAnnotations.setSelected(bl);
    }

    public SaveTrackFilter getSelectedSaveFilter() {
        FileFilter fileFilter = this.fileChooser.getFileFilter();
        return fileFilter != null && fileFilter instanceof SaveTrackFilter ? (SaveTrackFilter)fileFilter : null;
    }

    public int getFileFormat() {
        SaveTrackFilter saveTrackFilter = this.getSelectedSaveFilter();
        return saveTrackFilter != null ? saveTrackFilter.getFormat() : 0;
    }

    public void setFileFormat(int n) {
        FileFilter fileFilter = this.filterForFormat(n);
        if (fileFilter != null) {
            this.fileChooser.setFileFilter(fileFilter);
        }
    }

    public void setFileFormat(SARTrack sARTrack) {
        if (sARTrack != null) {
            FileFilter fileFilter = this.filterForFormat(sARTrack.getFormat());
            if (fileFilter == null) {
                fileFilter = this.filterForFormat(2);
            }
            if (fileFilter != null) {
                this.fileChooser.setFileFilter(fileFilter);
            }
        }
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public String getDialogTitle() {
        return this.fileChooser.getDialogTitle();
    }

    public void setDialogTitle(String string) {
        this.fileChooser.setDialogTitle(string);
    }

    public void setDialogTitle(SARTrack sARTrack) {
        String string = null;
        String string2 = "Save \"%s\" As";
        if (sARTrack.getName() != null) {
            string = String.format(string2, sARTrack.getName());
        } else if (sARTrack.getFile() != null) {
            string = String.format(string2, sARTrack.getFile().getName());
        }
        if (string != null) {
            this.fileChooser.setDialogTitle(string);
        }
    }

    public int showSaveDialog(Component component) throws HeadlessException {
        return this.fileChooser.showSaveDialog(component);
    }

    public static int showSaveChangesPrompt(Component component, String string, String string2, SARTrack sARTrack) {
        if (string == null) {
            string = "Save";
        }
        String string3 = "Save changes to the Track\n\"%s\" before closing?";
        if (string2 == null) {
            if (sARTrack != null && sARTrack.getName() != null) {
                string2 = String.format(string3, sARTrack.getName());
            } else if (sARTrack != null && sARTrack.getFile() != null) {
                string2 = String.format(string3, sARTrack.getFile().getName());
            }
        }
        return JOptionPane.showOptionDialog(component, string2, string, 1, 2, null, new Object[]{"Save", "Don't Save", "Cancel"}, "Save");
    }

    public static int showOverwritePrompt(Component component, String string, String string2, File file) {
        if (string == null) {
            string = "Save";
        }
        if (string2 == null) {
            string2 = file != null ? String.format("Overwrite existing file\n\"%s\"?", file.getPath()) : "Overwrite existing file?";
        }
        return JOptionPane.showOptionDialog(component, string2, string, 0, 2, null, new Object[]{"Overwrite", "Cancel"}, "Overwrite");
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                if (SaveTrackDialog.this.doApproveSelection()) {
                    super.approveSelection();
                }
            }
        };
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.makeAccessory();
        this.makeFileFilters();
    }

    private boolean doApproveSelection() {
        int n;
        File file = this.getSelectedFile();
        return file == null || !file.exists() || (n = SaveTrackDialog.showOverwritePrompt(this.fileChooser, null, null, file)) == 0;
    }

    private void makeAccessory() {
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(0, 10, 0, 10));
        JLabel jLabel = new JLabel("Options");
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(Box.createVerticalStrut(5));
        this.saveAnnotations = new JCheckBox("Save Annotations");
        this.saveAnnotations.setAlignmentX(0.0f);
        this.saveAnnotations.setSelected(true);
        box.add(this.saveAnnotations);
        this.fileChooser.setAccessory(box);
    }

    private void makeFileFilters() {
        FileFilter[] fileFilterArray;
        for (FileFilter fileFilter : fileFilterArray = new FileFilter[]{new SaveTrackFilter(2, "Comma Separated Value (*.csv)", new String[]{".csv"}), new SaveTrackFilter(1, "GPS Exchange Format (*.xml, *.gpx)", new String[]{".xml", ".gpx"}), new SaveTrackFilter(3, "National Marine Electronics Association (*.nmea)", new String[]{".nmea"})}) {
            this.fileChooser.addChoosableFileFilter(fileFilter);
        }
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setFileFilter(fileFilterArray[0]);
    }

    private FileFilter filterForFormat(int n) {
        FileFilter fileFilter = null;
        for (FileFilter fileFilter2 : this.fileChooser.getChoosableFileFilters()) {
            if (!(fileFilter2 instanceof SaveTrackFilter) || ((SaveTrackFilter)fileFilter2).getFormat() != n) continue;
            fileFilter = fileFilter2;
            break;
        }
        return fileFilter;
    }
}

