/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CrosshairLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.applications.sar.CloudCeiling;
import gov.nasa.worldwindx.applications.sar.CloudCeilingPanel;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import gov.nasa.worldwindx.applications.sar.TerrainProfilePanel;
import gov.nasa.worldwindx.applications.sar.TrackController;
import gov.nasa.worldwindx.applications.sar.TrackViewPanel;
import gov.nasa.worldwindx.applications.sar.render.PlaneModel;
import gov.nasa.worldwindx.applications.sar.render.TrackSegmentInfo;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AnalysisPanel
extends JPanel
implements Restorable {
    public static final String ANALYSIS_PANEL_STATE = "AnalysisPanelState";
    private WorldWindow wwd;
    private TrackController trackController;
    private SARTrack currentTrack;
    private TrackViewPanel trackViewPanel;
    private TerrainProfilePanel terrainProfilePanel;
    private JFrame terrainProfileFrame;
    private CloudCeilingPanel cloudCeilingPanel;
    private JFrame cloudCeilingFrame;
    private CrosshairLayer crosshairLayer;
    private boolean crosshairNeedsUpdate = false;
    private RenderableLayer trackRenderables;
    private PlaneModel planeModel;
    private TrackSegmentInfo segmentInfo;
    private String trackInfoState;
    private String lastUpdateViewMode;
    private ViewState examineViewState;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "TrackViewPanel.ViewChange") {
                AnalysisPanel.this.updateView(true);
            } else if (propertyChangeEvent.getPropertyName() == "TrackViewPanel.PositionChange") {
                AnalysisPanel.this.updateView(false);
                AnalysisPanel.this.cloudCeilingPanel.setTrackCurrentPositionNumber(AnalysisPanel.this.getCurrentPositionNumber());
            } else if (propertyChangeEvent.getPropertyName() == "TrackController.TrackModified") {
                AnalysisPanel.this.updateView(false);
                AnalysisPanel.this.terrainProfilePanel.updatePath(AnalysisPanel.this.currentTrack.getPositions());
                AnalysisPanel.this.cloudCeilingPanel.setTrack(AnalysisPanel.this.currentTrack);
                if (AnalysisPanel.this.getTrackController().isExtending() && AnalysisPanel.this.trackViewPanel.isFreeViewMode()) {
                    AnalysisPanel.this.gotoTrackEnd();
                }
            } else if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.avkey.ElevationModel" && AnalysisPanel.this.trackViewPanel.isExamineViewMode() && !AnalysisPanel.this.wwd.getView().isAnimating()) {
                AnalysisPanel.this.updateView(false);
            } else if (propertyChangeEvent.getPropertyName() == "ElevationUnit") {
                AnalysisPanel.this.updateElevationUnit(propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "AngleFormat") {
                AnalysisPanel.this.updateAngleFormat(propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "TerrainProfilePanel.Open") {
                AnalysisPanel.this.terrainProfileFrame.setVisible(true);
            } else if (propertyChangeEvent.getPropertyName() == "TerrainProfilePanel.Change") {
                AnalysisPanel.this.wwd.redraw();
            } else if (propertyChangeEvent.getPropertyName() == "CloudCeilingPanel.CloudCeilingOpen") {
                AnalysisPanel.this.cloudCeilingFrame.setVisible(true);
            } else if (propertyChangeEvent.getPropertyName() == "CloudCeilingPanel.CloudCeilingChange") {
                AnalysisPanel.this.wwd.redraw();
            } else if (propertyChangeEvent.getPropertyName() == "TrackViewPanel.ViewModeChange") {
                AnalysisPanel.this.trackViewPanel.setViewMode((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "TrackViewPanel.ShowTrackInformation") {
                AnalysisPanel.this.trackInfoState = (String)propertyChangeEvent.getNewValue();
                AnalysisPanel.this.updateShowTrackInformation();
            }
            if ((propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.avkey.ViewObject" || propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.avkey.ViewQuiet") && AnalysisPanel.this.trackViewPanel.isFollowViewMode()) {
                AnalysisPanel.this.doUpdateCrosshair();
            }
        }
    };
    private final RenderingListener renderingListener = new RenderingListener(){

        @Override
        public void stageChanged(RenderingEvent renderingEvent) {
            if (AnalysisPanel.this.crosshairNeedsUpdate && renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap")) {
                AnalysisPanel.this.doUpdateCrosshair();
            }
        }
    };

    public AnalysisPanel() {
        this.initComponents();
        this.layoutComponents();
        this.planeModel = new PlaneModel(100.0, 100.0, Color.YELLOW);
        this.planeModel.setShadowScale(0.1);
        this.planeModel.setShadowColor(new Color(255, 255, 0, 192));
        this.segmentInfo = new TrackSegmentInfo();
        this.trackRenderables = new RenderableLayer();
        this.trackRenderables.addRenderable(this.planeModel);
        this.trackRenderables.addRenderable(this.segmentInfo);
        this.crosshairLayer = new CrosshairLayer("images/64x64-crosshair.png");
        this.crosshairLayer.setOpacity(0.4);
        this.crosshairLayer.setEnabled(false);
        this.terrainProfilePanel = new TerrainProfilePanel();
        this.terrainProfileFrame = new JFrame("Terrain Profile");
        this.terrainProfileFrame.setResizable(false);
        this.terrainProfileFrame.setAlwaysOnTop(true);
        this.terrainProfileFrame.add(this.terrainProfilePanel);
        this.terrainProfileFrame.pack();
        SAR2.centerWindowInDesktop(this.terrainProfileFrame);
        this.cloudCeilingPanel = new CloudCeilingPanel();
        this.cloudCeilingFrame = new JFrame("Cloud Contour");
        this.cloudCeilingFrame.setResizable(false);
        this.cloudCeilingFrame.setAlwaysOnTop(true);
        this.cloudCeilingFrame.add(this.cloudCeilingPanel);
        this.cloudCeilingFrame.pack();
        SAR2.centerWindowInDesktop(this.cloudCeilingFrame);
        this.trackViewPanel.addPropertyChangeListener(this.propertyChangeListener);
        this.cloudCeilingPanel.addPropertyChangeListener(this.propertyChangeListener);
        this.updateShowTrackInformation();
    }

    public void setWwd(WorldWindow worldWindow) {
        if (this.wwd != null) {
            this.wwd.removePropertyChangeListener(this.propertyChangeListener);
            this.wwd.getView().removePropertyChangeListener(this.propertyChangeListener);
            this.wwd.removeRenderingListener(this.renderingListener);
        }
        this.wwd = worldWindow;
        this.terrainProfilePanel.setWwd(worldWindow);
        if (this.wwd != null) {
            this.wwd.addPropertyChangeListener(this.propertyChangeListener);
            this.wwd.getView().addPropertyChangeListener(this.propertyChangeListener);
            this.wwd.addRenderingListener(this.renderingListener);
            ApplicationTemplate.insertBeforeCompass(worldWindow, this.trackRenderables);
            ApplicationTemplate.insertBeforeCompass(worldWindow, this.crosshairLayer);
            this.cloudCeilingPanel.setCloudCeiling(new CloudCeiling(this.wwd));
        }
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public TrackController getTrackController() {
        return this.trackController;
    }

    public void setTrackController(TrackController trackController) {
        this.trackController = trackController;
    }

    public String getViewMode() {
        return this.trackViewPanel.getViewMode();
    }

    public void setCurrentTrack(SARTrack sARTrack) {
        if (this.currentTrack != null) {
            this.currentTrack.removePropertyChangeListener(this.propertyChangeListener);
            this.currentTrack.setValue(ANALYSIS_PANEL_STATE, this.getRestorableState());
        }
        this.currentTrack = sARTrack;
        this.segmentInfo.setTrack(sARTrack);
        this.trackViewPanel.setCurrentTrack(sARTrack);
        if (this.currentTrack != null) {
            this.currentTrack.addPropertyChangeListener(this.propertyChangeListener);
            this.terrainProfilePanel.updatePath(sARTrack.getPositions());
            this.cloudCeilingPanel.setTrack(this.currentTrack);
            String string = (String)this.currentTrack.getValue(ANALYSIS_PANEL_STATE);
            if (string != null) {
                this.restoreState(string);
            }
        }
    }

    private void updateElevationUnit(Object object) {
        if (object != null) {
            this.segmentInfo.setElevationUnit(object);
            this.trackViewPanel.setElevationUnit(object.toString());
            this.trackViewPanel.updateReadout(this.getPositionAlongSegment());
            this.cloudCeilingPanel.setElevationUnit(object.toString());
        }
    }

    private void updateAngleFormat(Object object) {
        if (object != null) {
            this.segmentInfo.setAngleFormat(object);
            this.trackViewPanel.setAngleFormat(object.toString());
            this.trackViewPanel.updateReadout(this.getPositionAlongSegment());
        }
    }

    private Angle getControlHeading() {
        return Angle.ZERO;
    }

    private Angle getControlPitch() {
        return Angle.fromDegrees(80.0);
    }

    private Angle getControlFOV() {
        return Angle.fromDegrees(45.0);
    }

    private void updateView(boolean bl) {
        BasicOrbitView basicOrbitView = (BasicOrbitView)this.wwd.getView();
        basicOrbitView.setFieldOfView(this.getControlFOV());
        Position position = this.getPositionAlongSegment();
        if ("TrackViewPanel.ViewModeExamine".equals(this.lastUpdateViewMode) && !this.trackViewPanel.getViewMode().equals(this.lastUpdateViewMode)) {
            this.saveExamineViewState();
        }
        this.lastUpdateViewMode = this.trackViewPanel.getViewMode();
        if (position != null) {
            Angle angle = this.getHeading().add(this.getControlHeading());
            this.terrainProfilePanel.updatePosition(position, angle);
            this.planeModel.setPosition(position);
            this.planeModel.setHeading(angle);
            if (this.trackViewPanel.isExamineViewMode()) {
                this.crosshairLayer.setEnabled(false);
                this.terrainProfilePanel.setFollowObject();
                Position position2 = this.getSmoothedGroundPositionAlongSegment();
                if (position2 == null) {
                    position2 = this.getGroundPositionAlongSegment();
                }
                if (bl) {
                    Angle angle2 = Angle.fromDegrees(Math.min(60.0, basicOrbitView.getPitch().degrees));
                    Angle angle3 = basicOrbitView.getHeading();
                    double d = 10000.0;
                    if (this.examineViewState != null) {
                        angle2 = this.examineViewState.pitch;
                        angle3 = this.examineViewState.relativeHeading.add(this.getHeading());
                        d = this.examineViewState.zoom;
                    }
                    if (this.trackViewPanel.isPlayerActive()) {
                        basicOrbitView.setCenterPosition(position2);
                        basicOrbitView.setZoom(d);
                        basicOrbitView.setPitch(angle2);
                        basicOrbitView.setHeading(angle3);
                    } else {
                        basicOrbitView.stopAnimations();
                        basicOrbitView.addPanToAnimator(position2, angle3, angle2, d, true);
                    }
                } else {
                    basicOrbitView.stopMovementOnCenter();
                    try {
                        Position position3 = basicOrbitView.getCurrentEyePosition();
                        Position position4 = position3.add(position2.subtract(basicOrbitView.getCenterPosition()));
                        double d = position3.getElevation() < position2.getElevation() ? position2.getElevation() : position3.getElevation();
                        Position position5 = new Position(position4, d);
                        basicOrbitView.setOrientation(position5, position2);
                    }
                    catch (Exception exception) {
                        basicOrbitView.setCenterPosition(position2);
                    }
                }
            } else if (this.trackViewPanel.isFollowViewMode()) {
                Angle angle4 = Angle.POS90;
                double d = 0.0;
                angle = this.getSmoothedHeading(0.1);
                this.terrainProfilePanel.setFollowObject();
                if (bl) {
                    if (this.trackViewPanel.isPlayerActive()) {
                        basicOrbitView.setCenterPosition(position);
                        basicOrbitView.setHeading(angle);
                        basicOrbitView.setPitch(angle4);
                        basicOrbitView.setZoom(d);
                    } else {
                        basicOrbitView.stopAnimations();
                        basicOrbitView.addPanToAnimator(position, angle, angle4, d);
                    }
                } else {
                    basicOrbitView.stopAnimations();
                    basicOrbitView.stopMovement();
                    basicOrbitView.setCenterPosition(position);
                    basicOrbitView.setHeading(angle);
                    basicOrbitView.setPitch(angle4);
                    basicOrbitView.setZoom(d);
                }
                this.updateCrosshair();
            } else if (this.trackViewPanel.isFreeViewMode()) {
                this.crosshairLayer.setEnabled(false);
                if (bl) {
                    basicOrbitView.stopAnimations();
                    basicOrbitView.stopMovement();
                    basicOrbitView.setViewOutOfFocus(true);
                }
            }
        }
        this.updateShowTrackInformation();
        this.segmentInfo.setSegmentIndex(this.getCurrentPositionNumber());
        this.segmentInfo.setSegmentPosition(position);
        this.trackViewPanel.updateReadout(position);
        this.wwd.redraw();
    }

    private void saveExamineViewState() {
        this.examineViewState = new ViewState((OrbitView)this.wwd.getView(), this.getHeading(), this.getPositionAlongSegment());
    }

    private int getCurrentPositionNumber() {
        return this.trackViewPanel.getCurrentPositionNumber();
    }

    private boolean isLastPosition(int n) {
        return n >= this.currentTrack.size() - 1;
    }

    public void gotoTrackEnd() {
        this.trackViewPanel.gotoTrackEnd();
    }

    public Position getCurrentSegmentStartPosition() {
        int n = this.getCurrentPositionNumber();
        return this.getSegmentStartPosition(n);
    }

    public Position getSegmentStartPosition(int n) {
        if (this.currentTrack == null || this.currentTrack.size() == 0) {
            return null;
        }
        SARPosition sARPosition = this.isLastPosition(n) ? this.currentTrack.get(this.currentTrack.size() - 1) : this.currentTrack.get(n);
        return new Position(sARPosition.getLatitude(), sARPosition.getLongitude(), sARPosition.getElevation() + this.currentTrack.getOffset());
    }

    public Position getCurrentSegmentEndPosition() {
        int n = this.getCurrentPositionNumber();
        return this.getSegmentEndPosition(n);
    }

    public Position getSegmentEndPosition(int n) {
        if (this.currentTrack == null || this.currentTrack.size() == 0) {
            return null;
        }
        SARPosition sARPosition = this.isLastPosition(n + 1) ? this.currentTrack.get(this.currentTrack.size() - 1) : this.currentTrack.get(n + 1);
        return new Position(sARPosition.getLatitude(), sARPosition.getLongitude(), sARPosition.getElevation() + this.currentTrack.getOffset());
    }

    public double getSegmentLength(int n) {
        Vec4 vec4 = this.wwd.getModel().getGlobe().computePointFromPosition(this.getSegmentStartPosition(n));
        Vec4 vec42 = this.wwd.getModel().getGlobe().computePointFromPosition(this.getSegmentEndPosition(n));
        return vec4.distanceTo3(vec42);
    }

    public Position getPositionAlongSegment() {
        double d = this.trackViewPanel.getPositionDelta();
        return this.getPositionAlongSegment(d);
    }

    private Position getPositionAlongSegment(double d) {
        Position position = this.getCurrentSegmentStartPosition();
        if (position == null) {
            return null;
        }
        Position position2 = this.getCurrentSegmentEndPosition();
        if (position2 == null) {
            return position;
        }
        return this.interpolateTrackPosition(d, position, position2);
    }

    public Angle getHeading() {
        return this.getHeading(this.getCurrentPositionNumber());
    }

    public Angle getHeading(int n) {
        SARPosition sARPosition;
        SARPosition sARPosition2;
        if (n < 1 && this.isLastPosition(n)) {
            return Angle.ZERO;
        }
        if (!this.isLastPosition(n)) {
            sARPosition2 = this.currentTrack.get(n);
            sARPosition = this.currentTrack.get(n + 1);
        } else {
            sARPosition2 = this.currentTrack.get(n - 1);
            sARPosition = this.currentTrack.get(n);
        }
        return LatLon.greatCircleAzimuth(sARPosition2, sARPosition);
    }

    private Angle getSmoothedHeading(double d) {
        double d2;
        Angle angle;
        int n = this.getCurrentPositionNumber();
        Angle angle2 = this.getHeading(n);
        double d3 = this.trackViewPanel.getPositionDelta();
        if (d3 <= d && n > 0) {
            angle = this.getHeading(n - 1);
            d2 = (1.0 - d3 / d) * 0.5;
        } else if (d3 >= 1.0 - d && !this.isLastPosition(n)) {
            angle = this.getHeading(n + 1);
            d2 = (1.0 - (1.0 - d3) / d) * 0.5;
        } else {
            return angle2;
        }
        return Angle.mix(d2, angle2, angle);
    }

    private Position getGroundPositionAlongSegment() {
        if (this.wwd == null) {
            return null;
        }
        Position position = this.getPositionAlongSegment();
        if (position == null) {
            return null;
        }
        return this.getGroundPosition(position);
    }

    private Position getGroundPosition(LatLon latLon) {
        double d = this.wwd.getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude());
        return new Position(latLon, d);
    }

    private Position getSmoothedGroundPositionAlongSegment() {
        if (this.currentTrack == null || this.currentTrack.size() == 0) {
            return null;
        }
        Position position = this.getCurrentSegmentStartPosition();
        Position position2 = this.getCurrentSegmentEndPosition();
        if (position == null || position2 == null) {
            return null;
        }
        Globe globe = this.wwd.getModel().getGlobe();
        if (globe == null) {
            return null;
        }
        int n = this.getCurrentPositionNumber();
        double d = this.trackViewPanel.getPositionDelta();
        if (this.isLastPosition(n)) {
            d = 0.0;
        }
        double d2 = 0.01;
        int n2 = 15;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d5;
            double d6 = d - (double)i * d2;
            Position position3 = null;
            if (d6 >= 0.0) {
                position3 = this.interpolateTrackPosition(d6, position, position2);
            } else if (d6 < 0.0 && n > 0) {
                position3 = this.interpolateTrackPosition(d6 + 1.0, this.currentTrack.get(n - 1), position);
            }
            if (position3 != null) {
                d5 = globe.getElevation(position3.getLatitude(), position3.getLongitude());
                d3 += (double)(n2 - i) * d5;
                d4 += (double)(n2 - i);
            }
            if (i == 0) continue;
            d6 = d + (double)i * d2;
            position3 = null;
            if (d6 <= 1.0) {
                position3 = this.interpolateTrackPosition(d6, position, position2);
            } else if (d6 > 1.0 && !this.isLastPosition(n + 1)) {
                position3 = this.interpolateTrackPosition(d6 - 1.0, position2, this.currentTrack.get(n + 2));
            }
            if (position3 == null) continue;
            d5 = globe.getElevation(position3.getLatitude(), position3.getLongitude());
            d3 += (double)(n2 - i) * d5;
            d4 += (double)(n2 - i);
        }
        Position position4 = this.interpolateTrackPosition(d, position, position2);
        return new Position(position4, d3 /= d4);
    }

    private Position interpolateTrackPosition(double d, Position position, Position position2) {
        if (position == null || position2 == null) {
            return null;
        }
        return Position.interpolateRhumb(d, position, position2);
    }

    private void updateCrosshair() {
        this.crosshairNeedsUpdate = true;
        this.wwd.redraw();
    }

    private void doUpdateCrosshair() {
        Vec4 vec4 = this.computeCrosshairPosition();
        if (vec4 != null) {
            this.crosshairLayer.setEnabled(true);
            this.crosshairLayer.setLocationCenter(vec4);
        } else {
            this.crosshairLayer.setEnabled(false);
        }
        this.crosshairNeedsUpdate = false;
    }

    private void updateShowTrackInformation() {
        if (this.trackInfoState != null && this.trackInfoState.equals("TrackViewPanel.CurrentSegment") && !this.trackViewPanel.isFollowViewMode()) {
            this.segmentInfo.setEnabled(true);
        } else {
            this.segmentInfo.setEnabled(false);
        }
    }

    private Vec4 computeCrosshairPosition() {
        Position position = this.getCurrentSegmentStartPosition();
        Position position2 = this.getCurrentSegmentEndPosition();
        Angle angle = LatLon.rhumbAzimuth(position, position2);
        Angle angle2 = LatLon.rhumbDistance(position, position2);
        int n = 10;
        double d = 1.0 / (double)n;
        double d2 = position2.getElevation() - position.getElevation();
        LatLon latLon = LatLon.rhumbEndPosition((LatLon)position, angle.addRadians(Math.PI), Angle.fromRadians(angle2.radians / (double)n));
        position = new Position(latLon, position.getElevation() - d2 / (double)n);
        latLon = LatLon.rhumbEndPosition((LatLon)position2, angle, Angle.fromRadians(angle2.radians / (double)n));
        position2 = new Position(latLon, position2.getElevation() + d2 / (double)n);
        angle2 = LatLon.rhumbDistance(position, position2);
        Globe globe = this.wwd.getModel().getGlobe();
        Plane plane = this.wwd.getView().getFrustumInModelCoordinates().getNear();
        Position position3 = null;
        for (double d3 = 0.0; d3 <= 1.0; d3 += d) {
            Vec4 vec4;
            Vec4 vec42;
            Object object;
            Position position4;
            if (d3 == 0.0) {
                position4 = position;
            } else if (d3 >= 1.0) {
                position4 = position2;
            } else {
                object = Angle.fromRadians(d3 * angle2.radians);
                latLon = LatLon.rhumbEndPosition((LatLon)position, angle, (Angle)object);
                position4 = new Position(latLon, (1.0 - d3) * position.getElevation() + d3 * position2.getElevation());
            }
            if (position3 != null && ((Vec4)(object = globe.computePointFromPosition(position3))).distanceTo3(vec42 = globe.computePointFromPosition(position4)) > 0.0 && (vec4 = plane.intersect((Vec4)object, vec42)) != null) {
                return this.wwd.getView().project(vec4);
            }
            position3 = position4;
        }
        return null;
    }

    protected void initComponents() {
        this.trackViewPanel = new TrackViewPanel(this);
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.trackViewPanel, "North");
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if ("TrackViewPanel.ViewModeExamine".equals(this.trackViewPanel.getViewMode())) {
            this.saveExamineViewState();
        }
        if (this.examineViewState != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "examinePitch", this.examineViewState.pitch.getDegrees());
            restorableSupport.addStateValueAsDouble(stateObject, "examineRelativeHeading", this.examineViewState.relativeHeading.getDegrees());
            restorableSupport.addStateValueAsDouble(stateObject, "examineZoom", this.examineViewState.zoom);
            restorableSupport.addStateValueAsLatLon(stateObject, "examineCenter", this.examineViewState.relativeCenterLocation);
        }
        if (this.trackViewPanel != null) {
            this.trackViewPanel.doGetRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "trackView"));
        }
        if (this.terrainProfilePanel != null) {
            this.terrainProfilePanel.doGetRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "terrainProfile"));
        }
        if (this.cloudCeilingPanel != null) {
            this.cloudCeilingPanel.doGetRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "cloudCeiling"));
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        RestorableSupport.StateObject stateObject3;
        RestorableSupport.StateObject stateObject4;
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "examinePitch");
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "examineRelativeHeading");
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "examineZoom");
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "examineCenter");
        if (d != null && d2 != null && d3 != null && latLon != null) {
            this.examineViewState = new ViewState(Angle.fromDegrees(d2), Angle.fromDegrees(d), d3, latLon);
            this.lastUpdateViewMode = null;
        }
        if ((stateObject4 = restorableSupport.getStateObject(stateObject, "trackView")) != null && this.trackViewPanel != null) {
            this.trackViewPanel.doRestoreState(restorableSupport, stateObject4);
        }
        if ((stateObject3 = restorableSupport.getStateObject(stateObject, "terrainProfile")) != null && this.terrainProfilePanel != null) {
            this.terrainProfilePanel.doRestoreState(restorableSupport, stateObject3);
        }
        if (this.cloudCeilingPanel != null && this.currentTrack != null) {
            this.cloudCeilingPanel.setTrackCurrentPositionNumber(this.getCurrentPositionNumber());
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "cloudCeiling")) != null && this.cloudCeilingPanel != null) {
            this.cloudCeilingPanel.doRestoreState(restorableSupport, stateObject2);
        }
    }

    private class ViewState {
        public Angle pitch;
        public Angle relativeHeading;
        public double zoom;
        public LatLon relativeCenterLocation;

        public ViewState(OrbitView orbitView, Angle angle, Position position) {
            this.pitch = orbitView.getPitch();
            this.relativeHeading = orbitView.getHeading().subtract(angle);
            this.zoom = orbitView.getZoom();
            this.relativeCenterLocation = orbitView.getCenterPosition().subtract(position);
        }

        public ViewState(Angle angle, Angle angle2, double d, LatLon latLon) {
            this.pitch = angle2;
            this.relativeHeading = angle;
            this.zoom = d;
            this.relativeCenterLocation = latLon;
        }
    }
}

