/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.dataimporter.ColorAllocator;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileStoreDataSet
extends AVListImpl {
    public static final String IMAGERY = "Imagery";
    public static final String ELEVATION = "Elevation";
    protected final String dataSetPath;
    protected final String filestorePath;
    protected final String configFilePath;

    public FileStoreDataSet(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            String string4 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.filestorePath = string;
        this.dataSetPath = string2;
        this.configFilePath = string3;
        this.setValue("gov.nasa.worldwind.avkey.Color", ColorAllocator.getNextColor());
        this.attachMetadata();
    }

    public String getPath() {
        return this.dataSetPath;
    }

    public String getName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public String getDatasetType() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DatasetTypeKey");
    }

    public boolean isImagery() {
        return this.getDatasetType() != null && this.getDatasetType().equals(IMAGERY);
    }

    public boolean isElevation() {
        return this.getDatasetType() != null && this.getDatasetType().equals(ELEVATION);
    }

    public Sector getSector() {
        return (Sector)this.getValue("gov.nasa.worldwind.avKey.Sector");
    }

    public Color getColor() {
        return (Color)this.getValue("gov.nasa.worldwind.avkey.Color");
    }

    public long getSize() {
        return this.getSize(this.dataSetPath);
    }

    public long getSize(String string) {
        File[] fileArray;
        long l = 0L;
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            try {
                if (file2.isDirectory()) {
                    l += this.getSize(file2.getPath());
                    continue;
                }
                FileInputStream fileInputStream = new FileInputStream(file2);
                l += (long)fileInputStream.available();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                String string2 = Logging.getMessage("generic.ExceptionWhileComputingSize", file2.getAbsolutePath());
                Logging.logger().fine(string2);
            }
        }
        return l;
    }

    protected void attachMetadata() {
        Document document = null;
        try {
            document = WWXML.openDocument(new File(this.configFilePath));
            document = DataConfigurationUtils.convertToStandardDataConfigDocument(document);
        }
        catch (WWRuntimeException wWRuntimeException) {
            Logging.logger().log(Level.SEVERE, "Exception reading data configuration", wWRuntimeException);
        }
        if (document == null) {
            return;
        }
        FileStoreDataSet.setFallbackParams(document, this.configFilePath, this);
        Element element = document.getDocumentElement();
        Sector sector = WWXML.getSector(element, "Sector", null);
        if (sector != null) {
            this.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        String string = DataConfigurationUtils.getDataConfigDisplayName(element);
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        String string2 = DataConfigurationUtils.getDataConfigType(element);
        if (string2.equalsIgnoreCase("Layer")) {
            this.setValue("gov.nasa.worldwind.avkey.DatasetTypeKey", IMAGERY);
        } else if (string2.equalsIgnoreCase("ElevationModel")) {
            this.setValue("gov.nasa.worldwind.avkey.DatasetTypeKey", ELEVATION);
        }
    }

    protected static void setFallbackParams(Document document, String string, AVList aVList) {
        String string2;
        XPath xPath = WWXML.makeXPath();
        Element element = document.getDocumentElement();
        String string3 = WWXML.getText(element, "DataCacheName", xPath);
        if (string3 == null || string3.length() == 0) {
            DataConfigurationUtils.getDataConfigCacheName(string, aVList);
        }
        if ((string2 = DataConfigurationUtils.getDataConfigType(element)).equalsIgnoreCase("ElevationModel")) {
            if (WWXML.getDouble(element, "ExtremeElevations/@min", xPath) == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", -11000.0);
            }
            if (WWXML.getDouble(element, "ExtremeElevations/@max", xPath) == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", 8500.0);
            }
        }
    }

    public void delete() {
        FileStoreDataSet.removeDirectory(new File(this.dataSetPath));
    }

    protected static boolean removeDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!(file2.isDirectory() ? !FileStoreDataSet.removeDirectory(file2) : !file2.delete())) continue;
                return false;
            }
        }
        return file.delete();
    }
}

