/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ColorCube;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AddConstDescriptor;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.AndDescriptor;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.BinarizeDescriptor;
import javax.media.jai.operator.ColorConvertDescriptor;
import javax.media.jai.operator.ErrorDiffusionDescriptor;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.MultiplyDescriptor;
import javax.media.jai.operator.NotDescriptor;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.OrderedDitherDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.media.jai.operator.XorConstDescriptor;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageWorker {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.image");
    public static final Hints.Key TILING_ALLOWED = new Hints.Key(Boolean.class);
    private static final String EXTREMA = "extrema";
    private RenderedImage inheritanceStopPoint;
    protected RenderedImage image;
    private ROI roi;
    private RenderingHints commonHints;
    private int tileCacheDisabled = 0;

    public ImageWorker() {
        this.image = null;
        this.inheritanceStopPoint = null;
    }

    public ImageWorker(File input) throws IOException {
        this(ImageIO.read(input));
    }

    public ImageWorker(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
    }

    public final ImageWorker setImage(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
        return this;
    }

    private ImageWorker fork(RenderedImage image) {
        ImageWorker worker = new ImageWorker(image);
        if (this.commonHints != null && !this.commonHints.isEmpty()) {
            RenderingHints hints = new RenderingHints(null);
            hints.add(worker.commonHints);
            worker.commonHints = hints;
        }
        return worker;
    }

    @Deprecated
    public static PlanarImage loadPlanarImageImage(String source, RenderingHints hints, int imageChoice, boolean readMetadata) {
        ImageWorker worker = new ImageWorker();
        worker.commonHints = new RenderingHints(hints);
        worker.load(source, imageChoice, readMetadata);
        return worker.getPlanarImage();
    }

    public final void load(String source, int imageChoice, boolean readMetadata) {
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        pbj.setParameter("Input", (Object)source).setParameter("ImageChoice", (Object)imageChoice).setParameter("ReadMetadata", (Object)readMetadata).setParameter("VerifyInput", (Object)Boolean.TRUE);
        this.image = JAI.create((String)"ImageRead", (ParameterBlock)pbj, (RenderingHints)this.getRenderingHints());
    }

    public final RenderedImage getRenderedImage() {
        return this.image;
    }

    public final BufferedImage getBufferedImage() {
        if (this.image instanceof BufferedImage) {
            return (BufferedImage)this.image;
        }
        return this.getPlanarImage().getAsBufferedImage();
    }

    public final PlanarImage getPlanarImage() {
        return PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
    }

    public final RenderedOp getRenderedOperation() {
        RenderedImage image = this.getRenderedImage();
        if (image instanceof RenderedOp) {
            return (RenderedOp)image;
        }
        return NullDescriptor.create((RenderedImage)image, (RenderingHints)this.getRenderingHints());
    }

    public final ROI getImageAsROI() {
        this.binarize();
        return new ROI(this.getRenderedImage());
    }

    public final ROI getROI() {
        return this.roi;
    }

    public final ImageWorker setROI(ROI roi) {
        this.roi = roi;
        this.invalidateStatistics();
        return this;
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.commonHints != null ? this.commonHints.get(key) : null;
    }

    public final ImageWorker setRenderingHint(RenderingHints.Key key, Object value) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        this.commonHints.add(new RenderingHints(key, value));
        return this;
    }

    public final ImageWorker setRenderingHints(RenderingHints hints) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        if (hints != null) {
            this.commonHints.add(hints);
        }
        return this;
    }

    public final ImageWorker removeRenderingHint(RenderingHints.Key key) {
        if (this.commonHints != null) {
            this.commonHints.remove(key);
        }
        return this;
    }

    public final RenderingHints getRenderingHints() {
        RenderingHints hints = ImageUtilities.getRenderingHints(this.image);
        if (hints == null) {
            hints = new RenderingHints(null);
            if (this.commonHints != null) {
                hints.add(this.commonHints);
            }
        } else if (this.commonHints != null) {
            hints.putAll((Map<?, ?>)this.commonHints);
        }
        if (Boolean.FALSE.equals(hints.get(TILING_ALLOWED))) {
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            if (this.commonHints == null || layout != this.commonHints.get(JAI.KEY_IMAGE_LAYOUT)) {
                layout.setTileWidth(this.image.getWidth());
                layout.setTileHeight(this.image.getHeight());
                layout.setTileGridXOffset(this.image.getMinX());
                layout.setTileGridYOffset(this.image.getMinY());
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (this.tileCacheDisabled != 0 && this.commonHints != null && !this.commonHints.containsKey(JAI.KEY_TILE_CACHE)) {
            hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        }
        return hints;
    }

    private final RenderingHints getRenderingHints(int type) {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(512)) {
            return hints;
        }
        ColorModel oldCm = this.image.getColorModel();
        ComponentColorModel newCm = new ComponentColorModel(oldCm.getColorSpace(), oldCm.hasAlpha(), oldCm.isAlphaPremultiplied(), oldCm.getTransparency(), type);
        layout.setColorModel((ColorModel)newCm);
        layout.setSampleModel(((ColorModel)newCm).createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        return hints;
    }

    private static ImageLayout getImageLayout(RenderingHints hints) {
        Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (candidate instanceof ImageLayout) {
            return (ImageLayout)candidate;
        }
        return new ImageLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ImageWorker tileCacheEnabled(boolean status) {
        if (status) {
            if (this.tileCacheDisabled == 0) throw new IllegalStateException();
            --this.tileCacheDisabled;
            return this;
        } else {
            ++this.tileCacheDisabled;
        }
        return this;
    }

    public final int getNumBands() {
        return this.image.getSampleModel().getNumBands();
    }

    public final int getTransparentPixel() {
        ColorModel cm = this.image.getColorModel();
        return cm instanceof IndexColorModel ? ((IndexColorModel)cm).getTransparentPixel() : -1;
    }

    private Object getComputedProperty(String name) {
        Object value = this.image.getProperty(name);
        return value == this.inheritanceStopPoint.getProperty(name) ? Image.UndefinedProperty : value;
    }

    private double[][] getExtremas() {
        Object extrema = this.getComputedProperty(EXTREMA);
        if (!(extrema instanceof double[][])) {
            Integer ONE = 1;
            this.image = ExtremaDescriptor.create((RenderedImage)this.image, (ROI)this.roi, (Integer)ONE, (Integer)ONE, null, (Integer)ONE, (RenderingHints)this.getRenderingHints());
            extrema = this.getComputedProperty(EXTREMA);
        }
        return (double[][])extrema;
    }

    private ImageWorker invalidateStatistics() {
        this.inheritanceStopPoint = this.image;
        return this;
    }

    public final double[] getMinimums() {
        return this.getExtremas()[0];
    }

    public final double[] getMaximums() {
        return this.getExtremas()[1];
    }

    public final boolean isBytes() {
        return this.image.getSampleModel().getDataType() == 0;
    }

    public final boolean isBinary() {
        return ImageUtil.isBinary((SampleModel)this.image.getSampleModel());
    }

    public final boolean isIndexed() {
        return this.image.getColorModel() instanceof IndexColorModel;
    }

    public final boolean isColorSpaceRGB() {
        return this.image.getColorModel().getColorSpace().getType() == 5;
    }

    public final boolean isColorSpaceGRAYScale() {
        return this.image.getColorModel().getColorSpace().getType() == 6;
    }

    public final boolean isTranslucent() {
        return this.image.getColorModel().getTransparency() == 3;
    }

    public final ImageWorker rescaleToBytes() {
        if (this.isBytes()) {
            return this;
        }
        if (this.isIndexed()) {
            throw new UnsupportedOperationException("Rescaling not yet implemented for IndexColorModel.");
        }
        double[][] extrema = this.getExtremas();
        int length = extrema[0].length;
        double[] scale = new double[length];
        double[] offset = new double[length];
        for (int i = 0; i < length; ++i) {
            double delta = extrema[1][i] - extrema[0][i];
            scale[i] = 255.0 / delta;
            offset[i] = -scale[i] * extrema[0][i];
        }
        RenderingHints hints = this.getRenderingHints(0);
        this.image = RescaleDescriptor.create((RenderedImage)this.image, (double[])scale, (double[])offset, (RenderingHints)hints);
        this.invalidateStatistics();
        assert (this.isBytes());
        return this;
    }

    public final ImageWorker forceIndexColorModel(boolean error) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this;
        }
        this.tileCacheEnabled(false);
        if (this.getNumBands() % 2 == 0) {
            this.retainBands(this.getNumBands() - 1);
        }
        this.forceColorSpaceRGB();
        RenderingHints hints = this.getRenderingHints();
        if (error) {
            KernelJAI ditherMask = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
            ColorCube colorMap = ColorCube.BYTE_496;
            this.image = ErrorDiffusionDescriptor.create((RenderedImage)this.image, (LookupTableJAI)colorMap, (KernelJAI)ditherMask, (RenderingHints)hints);
        } else {
            KernelJAI[] ditherMask = KernelJAI.DITHER_MASK_443;
            ColorCube colorMap = ColorCube.BYTE_496;
            this.image = OrderedDitherDescriptor.create((RenderedImage)this.image, (ColorCube)colorMap, (KernelJAI[])ditherMask, (RenderingHints)hints);
        }
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        assert (this.isIndexed());
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel() {
        this.forceBitmaskIndexColorModel(this.getTransparentPixel(), true);
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel(int transparent, boolean errorDiffusion) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            LookupTableJAI lookupTable;
            int i;
            Object[] table;
            IndexColorModel oldCM = (IndexColorModel)cm;
            switch (oldCM.getTransparency()) {
                case 1: {
                    return this;
                }
                case 2: {
                    if (oldCM.getTransparentPixel() != transparent) break;
                    return this;
                }
            }
            int pixelSize = oldCM.getPixelSize();
            int mapSize = oldCM.getMapSize();
            int newSize = Math.max(mapSize, (transparent &= (1 << pixelSize) - 1) + 1);
            if (newSize <= 255) {
                table = new byte[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (byte)(oldCM.getAlpha(i) == 0 ? transparent : i);
                }
                lookupTable = new LookupTableJAI(table);
            } else if (newSize <= 65535) {
                table = new short[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (short)(oldCM.getAlpha(i) == 0 ? transparent : i);
                }
                lookupTable = new LookupTableJAI((short[])table, true);
            } else {
                throw new AssertionError(mapSize);
            }
            byte[][] rgb = new byte[3][newSize];
            oldCM.getReds(rgb[0]);
            oldCM.getGreens(rgb[1]);
            oldCM.getBlues(rgb[2]);
            IndexColorModel newCM = new IndexColorModel(pixelSize, newSize, rgb[0], rgb[1], rgb[2], transparent);
            RenderingHints hints = this.getRenderingHints();
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel((ColorModel)newCM);
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)lookupTable, (RenderingHints)hints);
        } else {
            RenderedOp alphaChannel = null;
            if (cm.hasAlpha()) {
                this.tileCacheEnabled(false);
                int numBands = this.getNumBands();
                RenderingHints hints = this.getRenderingHints();
                alphaChannel = BandSelectDescriptor.create((RenderedImage)this.image, (int[])new int[]{--numBands}, (RenderingHints)hints);
                this.retainBands(numBands);
                this.forceIndexColorModel(errorDiffusion);
                this.tileCacheEnabled(true);
            }
            this.addTransparencyToIndexColorModel((RenderedImage)alphaChannel, false, transparent, errorDiffusion);
        }
        assert (this.isIndexed());
        assert (!this.isTranslucent());
        return this;
    }

    public final ImageWorker forceIndexColorModelForGIF(boolean errorDiffusion) {
        this.tileCacheEnabled(false);
        if (this.image.getColorModel() instanceof PackedColorModel) {
            this.forceComponentColorModel();
        }
        this.rescaleToBytes();
        this.tileCacheEnabled(true);
        if (this.isTranslucent()) {
            this.forceBitmaskIndexColorModel(255, errorDiffusion);
        } else {
            this.forceIndexColorModel(errorDiffusion);
        }
        assert (this.isBytes());
        assert (this.isIndexed());
        assert (!this.isTranslucent());
        return this;
    }

    public final ImageWorker forceComponentColorModel() {
        return this.forceComponentColorModel(false);
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof ComponentColorModel) {
            return this;
        }
        if (cm instanceof IndexColorModel) {
            ImageLayout layout;
            IndexColorModel icm = (IndexColorModel)cm;
            boolean gray = ColorUtilities.isGrayPalette(icm, checkTransparent);
            boolean alpha = icm.hasAlpha();
            int numSourceBands = icm.getNumComponents();
            int numDestinationBands = gray ? (alpha ? 2 : 1) : (alpha ? 4 : 3);
            byte[][] data = new byte[numDestinationBands][icm.getMapSize()];
            icm.getReds(data[0]);
            if (numDestinationBands >= 2) {
                icm.getGreens(data[1]);
            }
            if (numDestinationBands >= 3) {
                icm.getBlues(data[2]);
            }
            if (numDestinationBands == 4) {
                icm.getAlphas(data[3]);
            }
            LookupTableJAI lut = new LookupTableJAI(data);
            RenderingHints hints = this.getRenderingHints();
            Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
            if (candidate instanceof ImageLayout) {
                layout = (ImageLayout)candidate;
            } else {
                layout = new ImageLayout(this.image);
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            ComponentColorModel destinationColorModel = new ComponentColorModel(numDestinationBands >= 3 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003), alpha, cm.isAlphaPremultiplied(), cm.getTransparency(), cm.getTransferType());
            SampleModel destinationSampleModel = destinationColorModel.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight());
            layout.setColorModel((ColorModel)destinationColorModel);
            layout.setSampleModel(destinationSampleModel);
            this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)lut, (RenderingHints)hints);
        } else {
            int type = cm instanceof DirectColorModel ? 0 : this.image.getSampleModel().getTransferType();
            RenderingHints hints = this.getRenderingHints(type);
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)type, (RenderingHints)hints);
        }
        this.invalidateStatistics();
        assert (this.image.getColorModel() instanceof ComponentColorModel);
        return this;
    }

    public final ImageWorker forceColorSpaceRGB() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
            this.image = ColorConvertDescriptor.create((RenderedImage)this.image, (ColorModel)cm, (RenderingHints)this.getRenderingHints());
            this.invalidateStatistics();
        }
        assert (this.isColorSpaceRGB());
        return this;
    }

    public final ImageWorker forceColorSpaceIHS() {
        if (!(this.image.getColorModel().getColorSpace() instanceof IHSColorSpace)) {
            this.forceComponentColorModel();
            IHSColorSpace ihs = IHSColorSpace.getInstance();
            int numBits = this.image.getColorModel().getComponentSize(0);
            ComponentColorModel ihsColorModel = new ComponentColorModel((ColorSpace)ihs, new int[]{numBits, numBits, numBits}, false, false, 1, this.image.getSampleModel().getDataType());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.image);
            pb.add(ihsColorModel);
            this.image = JAI.create((String)"colorconvert", (ParameterBlock)pb);
            this.invalidateStatistics();
        }
        assert (this.image.getColorModel().getColorSpace() instanceof IHSColorSpace);
        return this;
    }

    public final ImageWorker bandMerge(int writeband) {
        ParameterBlock pb = new ParameterBlock();
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
        int numBands = sourceImage.getSampleModel().getNumBands();
        RenderedOp firstBand = JAI.create((String)"bandSelect", (RenderedImage)sourceImage, (Object)new int[]{0});
        int length = writeband - numBands;
        for (int i = 0; i < length; ++i) {
            pb.removeParameters();
            pb.removeSources();
            pb.addSource(sourceImage);
            pb.addSource(firstBand);
            sourceImage = JAI.create((String)"bandmerge", (ParameterBlock)pb);
            pb.removeParameters();
            pb.removeSources();
        }
        this.image = sourceImage;
        this.invalidateStatistics();
        assert (this.image.getSampleModel().getNumBands() == writeband);
        return this;
    }

    public final ImageWorker addBand(RenderedImage image, boolean before) {
        this.image = BandMergeDescriptor.create((RenderedImage)this.image, (RenderedImage)image, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker forceColorSpaceGRAYScale() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            this.image = ColorConvertDescriptor.create((RenderedImage)this.image, (ColorModel)cm, (RenderingHints)this.getRenderingHints());
            this.invalidateStatistics();
        }
        assert (this.isColorSpaceGRAYScale());
        return this;
    }

    public final ImageWorker intensity() {
        ColorModel cm = this.image.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        if (cs.getType() == 6 || cs instanceof IHSColorSpace) {
            this.retainFirstBand();
            return this;
        }
        if (cm instanceof IndexColorModel) {
            this.forceComponentColorModel();
            cm = this.image.getColorModel();
        }
        int numBands = cm.getNumComponents();
        int numColorBands = cm.getNumColorComponents();
        boolean hasAlpha = cm.hasAlpha();
        if (numBands == 1) {
            return this;
        }
        if (numColorBands == 1 && hasAlpha) {
            this.retainFirstBand();
            return this;
        }
        if (numColorBands != numBands) {
            this.retainBands(numBands);
        }
        double[][] coeff = new double[1][numBands + 1];
        Arrays.fill(coeff[0], 0, numColorBands, 1.0 / (double)numColorBands);
        this.image = BandCombineDescriptor.create((RenderedImage)this.image, (double[][])coeff, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainFirstBand() {
        this.retainBands(1);
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainLastBand() {
        int band = this.getNumBands() - 1;
        if (band != 0) {
            this.retainBands(new int[]{band});
        }
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainBands(int numBands) {
        if (numBands <= 0) {
            throw new IndexOutOfBoundsException(Errors.format((int)42, (Object)"numBands", (Object)numBands));
        }
        if (this.getNumBands() > numBands) {
            int[] bands = new int[numBands];
            for (int i = 0; i < bands.length; ++i) {
                bands[i] = i;
            }
            this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])bands, (RenderingHints)this.getRenderingHints());
        }
        assert (this.getNumBands() <= numBands);
        return this;
    }

    public final ImageWorker retainBands(int[] bands) {
        this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])bands, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public final ImageWorker format(int dataType) {
        this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)dataType, (RenderingHints)this.getRenderingHints());
        assert (this.image.getSampleModel().getDataType() == dataType);
        return this;
    }

    public final ImageWorker binarize() {
        this.binarize(Double.NaN);
        assert (this.isBinary());
        return this;
    }

    public final ImageWorker binarize(double threshold) {
        if (!this.isBinary()) {
            if (Double.isNaN(threshold)) {
                if (this.getNumBands() != 1) {
                    this.tileCacheEnabled(false);
                    this.intensity();
                    this.tileCacheEnabled(true);
                }
                double[][] extremas = this.getExtremas();
                threshold = 0.5 * (extremas[0][0] + extremas[1][0]);
            }
            RenderingHints hints = this.getRenderingHints();
            this.image = BinarizeDescriptor.create((RenderedImage)this.image, (Double)threshold, (RenderingHints)hints);
            this.invalidateStatistics();
        }
        assert (this.isBinary());
        return this;
    }

    public final ImageWorker binarize(int value0, int value1) {
        int max;
        this.tileCacheEnabled(false);
        this.binarize();
        this.tileCacheEnabled(true);
        int min = Math.min(value0, value1);
        LookupTableJAI table = min >= 0 ? ((max = Math.max(value0, value1)) < 256 ? new LookupTableJAI(new byte[]{(byte)value0, (byte)value1}) : (max < 65536 ? new LookupTableJAI(new short[]{(short)value0, (short)value1}, true) : new LookupTableJAI(new int[]{value0, value1}))) : new LookupTableJAI(new int[]{value0, value1});
        this.image = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)table, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker makeColorTransparent(Color transparentColor) throws IllegalStateException {
        if (transparentColor == null) {
            throw new IllegalArgumentException(Errors.format((int)105, (Object)"transparentColor"));
        }
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this.maskIndexColorModelByte(transparentColor);
        }
        if (cm instanceof ComponentColorModel) {
            switch (this.image.getSampleModel().getDataType()) {
                case 0: {
                    return this.maskComponentColorModelByte(transparentColor);
                }
            }
        }
        throw new IllegalStateException(Errors.format((int)142));
    }

    @Deprecated
    public final ImageWorker maskIndexColorModelByte(Color transparentColor) {
        int found;
        int transpColor;
        assert (this.image.getColorModel() instanceof IndexColorModel);
        IndexColorModel cm = (IndexColorModel)this.image.getColorModel();
        int numComponents = cm.getNumComponents();
        int transparency = cm.getTransparency();
        int transparencyIndex = cm.getTransparentPixel();
        int mapSize = cm.getMapSize();
        int transparentRGB = transparentColor.getRGB() & 0xFFFFFF;
        if (transparency == 2 && transparencyIndex != -1 && (transpColor = cm.getRGB(transparencyIndex) & 0xFFFFFF) == transparentRGB) {
            return this;
        }
        ArrayList<Integer> transparentPixelsIndexes = new ArrayList<Integer>();
        for (int i = 0; i < mapSize; ++i) {
            int color = cm.getRGB(i) & 0xFFFFFF;
            if (transparentRGB != color) continue;
            transparentPixelsIndexes.add(i);
            if (2 == transparency) break;
        }
        if ((found = transparentPixelsIndexes.size()) == 1) {
            transparencyIndex = (Integer)transparentPixelsIndexes.get(0);
            transparency = 2;
        } else {
            if (found == 0) {
                return this;
            }
            transparencyIndex = -1;
            transparency = 3;
        }
        byte[][] rgb = new byte[4][mapSize];
        cm.getReds(rgb[0]);
        cm.getGreens(rgb[1]);
        cm.getBlues(rgb[2]);
        if (numComponents == 4) {
            cm.getAlphas(rgb[3]);
        } else {
            Arrays.fill(rgb[3], (byte)-1);
        }
        if (transparency != 3) {
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], transparencyIndex);
        } else {
            for (int k = 0; k < found; ++k) {
                rgb[3][((Integer)transparentPixelsIndexes.get((int)k)).intValue()] = 0;
            }
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], rgb[3]);
        }
        ImageLayout layout = new ImageLayout(this.image);
        layout.setColorModel((ColorModel)cm);
        RenderingHints hints = this.getRenderingHints();
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)this.image.getSampleModel().getDataType(), (RenderingHints)hints);
        this.invalidateStatistics();
        return this;
    }

    @Deprecated
    public final ImageWorker maskComponentColorModelByte(Color transparentColor) {
        boolean singleStep;
        assert (this.image.getColorModel() instanceof ComponentColorModel);
        assert (this.image.getSampleModel().getDataType() == 0);
        int numBands = this.image.getSampleModel().getNumBands();
        int numColorBands = this.image.getColorModel().getNumColorComponents();
        RenderingHints hints = this.getRenderingHints();
        RenderedOp transparentBand = null;
        if (numColorBands != numBands) {
            transparentBand = BandSelectDescriptor.create((RenderedImage)this.image, (int[])new int[]{numColorBands}, (RenderingHints)hints);
            int[] opaqueBands = new int[numColorBands];
            for (int i = 0; i < opaqueBands.length; ++i) {
                opaqueBands[i] = i;
            }
            this.image = BandSelectDescriptor.create((RenderedImage)this.image, (int[])opaqueBands, (RenderingHints)hints);
        }
        byte[][] tableData = new byte[numColorBands][256];
        boolean bl = singleStep = numColorBands == 1;
        if (singleStep) {
            byte[] data = tableData[0];
            Arrays.fill(data, (byte)-1);
            data[transparentColor.getRed()] = 0;
        } else {
            for (int j = 0; j < numColorBands; ++j) {
                byte[] data = tableData[j];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (byte)i;
                }
            }
            Arrays.fill(tableData[1], (byte)0);
            Arrays.fill(tableData[2], (byte)-1);
            switch (numColorBands) {
                case 3: {
                    tableData[2][transparentColor.getBlue()] = 0;
                }
                case 2: {
                    tableData[1][transparentColor.getGreen()] = 0;
                }
                case 1: {
                    tableData[0][transparentColor.getRed()] = 0;
                }
            }
        }
        LookupTableJAI table = new LookupTableJAI(tableData);
        RenderedOp luImage = LookupDescriptor.create((RenderedImage)this.image, (LookupTableJAI)table, (RenderingHints)hints);
        if (!singleStep) {
            double[][] matrix = new double[1][4];
            Arrays.fill(matrix[0], 0, 3, 1.0);
            luImage = BandCombineDescriptor.create((RenderedImage)luImage, (double[][])matrix, (RenderingHints)hints);
            if (transparentBand != null) {
                luImage = this.fork((RenderedImage)luImage).binarize(254.0).forceComponentColorModel().retainFirstBand().getPlanarImage();
                luImage = MultiplyDescriptor.create((RenderedImage)transparentBand, (RenderedImage)luImage, (RenderingHints)hints);
            }
        }
        this.image = BandMergeDescriptor.create((RenderedImage)this.image, (RenderedImage)luImage, (RenderingHints)hints);
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker invert() {
        this.image = InvertDescriptor.create((RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker mask(RenderedImage mask, boolean maskValue, int newValue) {
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(true);
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        if (newValue == 255 && !maskValue) {
            byte[] lutData = new byte[256];
            Arrays.fill(lutData, (byte)0);
            lutData[0] = -1;
            LookupTableJAI lut = new LookupTableJAI(lutData);
            mask = LookupDescriptor.create((RenderedImage)mask, (LookupTableJAI)lut, (RenderingHints)hints);
            this.image = AddDescriptor.create((RenderedImage)this.image, (RenderedImage)mask, (RenderingHints)this.getRenderingHints());
            this.tileCacheEnabled(true);
            this.invalidateStatistics();
            return this;
        }
        if (!this.isBinary()) {
            this.binarize();
        }
        if (maskValue) {
            mask = NotDescriptor.create((RenderedImage)mask, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        }
        this.tileCacheEnabled(false);
        this.image = AndDescriptor.create((RenderedImage)mask, (RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        mask = AddConstDescriptor.create((RenderedImage)mask, (double[])new double[]{newValue}, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        this.image = AddDescriptor.create((RenderedImage)mask, (RenderedImage)this.image, (RenderingHints)this.getRenderingHints());
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker addImage(RenderedImage renderedImage) {
        this.image = AddDescriptor.create((RenderedImage)this.image, (RenderedImage)renderedImage, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker multiplyConst(double[] inValues) {
        this.image = MultiplyConstDescriptor.create((RenderedImage)this.image, (double[])inValues, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker xorConst(int[] values) {
        this.image = XorConstDescriptor.create((RenderedImage)this.image, (int[])values, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean errorDiffusion) {
        this.addTransparencyToIndexColorModel(alphaChannel, true, this.getTransparentPixel(), errorDiffusion);
        return this;
    }

    public final ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean translucent, int transparent, boolean errorDiffusion) {
        boolean forceBitmask;
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(errorDiffusion);
        this.tileCacheEnabled(true);
        ImageWorker worker = this.fork(this.image);
        RenderingHints hints = worker.getRenderingHints();
        IndexColorModel oldCM = (IndexColorModel)this.image.getColorModel();
        int pixelSize = oldCM.getPixelSize();
        boolean bl = forceBitmask = !translucent && oldCM.getTransparency() == 3;
        if (forceBitmask || oldCM.getTransparentPixel() != (transparent &= (1 << pixelSize) - 1)) {
            IndexColorModel newCM;
            int mapSize = Math.max(oldCM.getMapSize(), transparent + 1);
            byte[][] RGBA = new byte[translucent ? 4 : 3][mapSize];
            oldCM.getReds(RGBA[0]);
            oldCM.getGreens(RGBA[1]);
            oldCM.getBlues(RGBA[2]);
            if (translucent) {
                oldCM.getAlphas(RGBA[3]);
                RGBA[3][transparent] = 0;
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], RGBA[3]);
            } else {
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], transparent);
            }
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel((ColorModel)newCM);
            worker.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        worker.setRenderingHint(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        worker.mask(alphaChannel, false, transparent);
        this.image = worker.image;
        this.invalidateStatistics();
        assert (this.isIndexed());
        assert (translucent || !this.isTranslucent()) : translucent;
        assert (((IndexColorModel)this.image.getColorModel()).getAlpha(transparent) == 0);
        return this;
    }

    public final ImageWorker tile() {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(64) || layout.isValid(128)) {
            int type = this.image.getSampleModel().getDataType();
            this.image = FormatDescriptor.create((RenderedImage)this.image, (Integer)type, (RenderingHints)hints);
        }
        return this;
    }

    public final ImageWorker write(File output) throws IOException {
        String filename = output.getName();
        int dot = filename.lastIndexOf(46);
        if (dot < 0) {
            throw new IIOException(Errors.format((int)192));
        }
        String extension = filename.substring(dot + 1).trim();
        this.write(output, ImageIO.getImageWritersBySuffix(extension));
        return this;
    }

    public final void writePNG(Object destination, String compression, float compressionRate, boolean nativeAcc, boolean paletted) throws IOException {
        this.tileCacheEnabled(false);
        if (!paletted) {
            this.forceComponentColorModel();
        } else {
            this.forceIndexColorModelForGIF(true);
        }
        LOGGER.finer("Encoded input image for png writer");
        LOGGER.finer("Getting a writer");
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("PNG");
        if (!it.hasNext()) {
            throw new IllegalStateException(Errors.format((int)192));
        }
        ImageWriter writer = it.next();
        LOGGER.finer("Setting write parameters for this writer");
        ImageWriteParam iwp = null;
        ImageOutputStream memOutStream = ImageIO.createImageOutputStream(destination);
        if (nativeAcc && writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter")) {
            LOGGER.finer("Writer is native");
            iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionType(compression);
            iwp.setCompressionQuality(compressionRate);
            iwp.setDestinationType(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
        } else {
            if (nativeAcc && it.hasNext() && writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter")) {
                writer = it.next();
            }
            LOGGER.finer("Writer is NOT native");
            iwp = new PNGImageWriteParam();
            iwp.setCompressionMode(1);
        }
        LOGGER.finer("About to write png image");
        writer.setOutput(memOutStream);
        writer.write(null, new IIOImage(this.image, null, null), iwp);
        this.tileCacheEnabled(true);
        memOutStream.flush();
        writer.dispose();
        memOutStream.close();
    }

    public final ImageWorker writeGIF(Object destination, String compression, float compressionRate) throws IOException {
        this.tileCacheEnabled(false);
        this.forceIndexColorModelForGIF(true);
        this.tileCacheEnabled(true);
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<ImageWriterSpi> it = registry.getServiceProviders(ImageWriterSpi.class, true);
        ImageWriterSpi spi = null;
        while (it.hasNext()) {
            ImageWriterSpi candidate = it.next();
            if (!ImageWorker.containsFormatName(candidate.getFormatNames(), "gif")) continue;
            if (spi == null) {
                spi = candidate;
                continue;
            }
            String name = candidate.getClass().getName();
            if (!name.equals("com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi")) continue;
            spi = candidate;
            break;
        }
        if (spi == null) {
            throw new IIOException(Errors.format((int)192));
        }
        ImageOutputStream stream = ImageIO.createImageOutputStream(destination);
        ImageWriter writer = spi.createWriterInstance();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType(compression);
        param.setCompressionQuality(compressionRate);
        writer.setOutput(stream);
        writer.write(null, new IIOImage(this.image, null, null), param);
        stream.close();
        writer.dispose();
        return this;
    }

    public final void writeJPEG(Object destination, String compression, float compressionRate, boolean nativeAcc) throws IOException {
        LOGGER.finer("Encoding input image to write out as JPEG.");
        this.tileCacheEnabled(false);
        ColorModel cm = this.image.getColorModel();
        boolean indexColorModel = this.image.getColorModel() instanceof IndexColorModel;
        int numBands = this.image.getSampleModel().getNumBands();
        boolean hasAlpha = cm.hasAlpha();
        if (indexColorModel || hasAlpha) {
            if (indexColorModel) {
                this.forceComponentColorModel();
            }
            if (hasAlpha) {
                this.retainBands(numBands - 1);
            }
        }
        this.tileCacheEnabled(true);
        LOGGER.finer("Getting a JPEG writer and configuring it.");
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("JPEG");
        if (!it.hasNext()) {
            throw new IllegalStateException(Errors.format((int)192));
        }
        ImageWriter writer = it.next();
        if (!nativeAcc && writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter")) {
            writer = it.next();
        }
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        ImageOutputStream outStream = ImageIO.createImageOutputStream(destination);
        iwp.setCompressionMode(2);
        iwp.setCompressionType(compression);
        iwp.setCompressionQuality(compressionRate);
        writer.setOutput(outStream);
        if (iwp instanceof JPEGImageWriteParam) {
            JPEGImageWriteParam param = (JPEGImageWriteParam)iwp;
            param.setOptimizeHuffmanTables(true);
            try {
                param.setProgressiveMode(1);
            }
            catch (UnsupportedOperationException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        LOGGER.finer("Writing out...");
        writer.write(null, new IIOImage(this.image, null, null), iwp);
        outStream.flush();
        writer.dispose();
        outStream.close();
    }

    private ImageWorker write(Object output, Iterator<? extends ImageWriter> encoders) throws IOException {
        if (encoders != null) {
            while (encoders.hasNext()) {
                ImageOutputStream stream;
                Class<?>[] outputTypes;
                ImageWriter writer = encoders.next();
                ImageWriterSpi spi = writer.getOriginatingProvider();
                if (spi == null) {
                    outputTypes = ImageWriterSpi.STANDARD_OUTPUT_TYPE;
                } else {
                    String[] formats = spi.getFormatNames();
                    if (ImageWorker.containsFormatName(formats, "gif")) {
                        this.forceIndexColorModelForGIF(true);
                    } else {
                        this.tile();
                    }
                    if (!spi.canEncodeImage(this.image)) continue;
                    outputTypes = spi.getOutputTypes();
                }
                if (ImageWorker.acceptInputType(outputTypes, output.getClass())) {
                    writer.setOutput(output);
                    stream = null;
                } else {
                    if (!ImageWorker.acceptInputType(outputTypes, ImageOutputStream.class)) continue;
                    stream = ImageIO.createImageOutputStream(output);
                    writer.setOutput(stream);
                }
                writer.write(this.image);
                writer.dispose();
                if (stream != null) {
                    stream.close();
                }
                return this;
            }
        }
        throw new IIOException(Errors.format((int)192));
    }

    private static boolean acceptInputType(Class<?>[] types, Class<?> searchFor) {
        int i = types.length;
        while (--i >= 0) {
            if (!searchFor.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFormatName(String[] formats, String searchFor) {
        int i = formats.length;
        while (--i >= 0) {
            if (!searchFor.equalsIgnoreCase(formats[i])) continue;
            return true;
        }
        return false;
    }

    public final ImageWorker show() throws HeadlessException {
        Class<?> c;
        try {
            c = Class.forName("org.geotools.gui.swing.image.OperationTreeBrowser");
        }
        catch (ClassNotFoundException cause) {
            HeadlessException e = new HeadlessException("The \"gt2-widgets-swing.jar\" file is required.");
            e.initCause(cause);
            throw e;
        }
        try {
            c.getMethod("show", RenderedImage.class).invoke(null, this.image);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        String operation = arguments.getOptionalString("-operation");
        args = arguments.getRemainingArguments(1);
        if (args.length != 0) {
            try {
                ImageWorker worker = new ImageWorker(new File(args[0]));
                worker.setRenderingHint(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache());
                if (operation != null) {
                    worker.getClass().getMethod(operation, null).invoke((Object)worker, (Object[])null);
                }
                worker.show();
            }
            catch (FileNotFoundException e) {
                arguments.printSummary((Exception)e);
            }
            catch (NoSuchMethodException e) {
                arguments.printSummary((Exception)e);
            }
            catch (Exception e) {
                e.printStackTrace(arguments.err);
            }
        }
    }

    public static final class PNGImageWriteParam
    extends ImageWriteParam {
        public PNGImageWriteParam() {
            this.canWriteProgressive = true;
            this.canWriteCompressed = true;
            this.locale = Locale.getDefault();
        }
    }
}

