/*
 * Decompiled with CFR 0.152.
 */
package jamsui.launcher;

import jams.JAMS;
import jams.JAMSFileFilter;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.explorer.JAMSExplorer;
import jams.explorer.ensembles.gui.EnsembleControlPanel;
import jams.gui.AboutDlg;
import jams.gui.JAMSLauncher;
import jams.gui.LogViewDlg;
import jams.gui.PropertyDlg;
import jams.gui.RuntimeManagerPanel;
import jams.gui.tools.GUIHelper;
import jams.io.ParameterProcessor;
import jams.io.XMLProcessor;
import jams.model.JAMSFullModelState;
import jams.model.Model;
import jams.tools.FileTools;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import jams.tools.XMLTools;
import jams.workspace.InvalidWorkspaceException;
import jamsui.juice.JUICE;
import jamsui.launcher.JAMSui;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAMSFrame
extends JAMSLauncher {
    private JMenuBar mainMenu;
    private JMenu logsMenu;
    private JMenu modelMenu;
    private JMenu recentMenu;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem startEnsembleManagerItem;
    private JFileChooser jfcProps;
    private JFileChooser jfcSer;
    private JFileChooser jfcModel;
    private JFileChooser jfcParam;
    private JDialog rtManagerDlg;
    private PropertyDlg propertyDlg;
    private LogViewDlg infoDlg = new LogViewDlg((Frame)((Object)this), 400, 400, JAMS.i18n((String)"Info_Log"));
    private LogViewDlg errorDlg = new LogViewDlg((Frame)((Object)this), 400, 400, JAMS.i18n((String)"Error_Log"));
    private String modelFilename;
    private Action editPrefsAction;
    private Action loadPrefsAction;
    private Action savePrefsAction;
    private Action loadModelAction;
    private Action saveModelAction;
    private Action saveAsModelAction;
    private Action exitAction;
    private Action aboutAction;
    private Action loadModelParamAction;
    private Action saveModelParamAction;
    private Action loadModelExecutionStateAction;
    private Action rtManagerAction;
    private Action infoLogAction;
    private Action errorLogAction;
    private Action onlineAction;
    private Action explorerAction;
    private Action browserAction;
    private Action editModelAction;
    private Action startEnsembleManagerAction;
    private static JAMSExplorer theExplorer;

    public JAMSFrame(Frame parent, SystemProperties properties) {
        super((Window)parent, properties);
        String vmArch;
        String osArch;
        int result;
        boolean os64 = JAMSTools.is64Bit();
        boolean vm64 = System.getProperty("os.arch").endsWith("64");
        if (os64 != vm64 && (result = GUIHelper.showYesNoDlg(null, (String)String.format("Architectures of OS (%s) and Java VM (%s) used with JAMS seem to differ.\nYou should update your Java VM to a matching version to avoid strange model behaviour.\nContinue anyway?", osArch = os64 ? "64 bit" : "32 bit", vmArch = vm64 ? "64 bit" : "32 bit"), (String)"Warning")) == 1) {
            System.exit(0);
        }
        JAMSLogging.getInstance().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                List loggers = JAMSLogging.getLoggers();
                Logger logger = (Logger)arg;
                JAMSLogging.LogOption option = JAMSLogging.getLogOption((Logger)logger);
                if (loggers.contains(logger)) {
                    JAMSui.registerLogger(option, logger);
                } else {
                    JAMSui.unregisterLogger(option, logger);
                }
            }
        });
    }

    public JAMSFrame(Frame parent, SystemProperties properties, String modelFilename, String cmdLineArgs, Properties jmpParameters) {
        this(parent, properties);
        this.loadModelDefinition(modelFilename, StringTools.toArray((String)cmdLineArgs, (String)";"), jmpParameters);
        this.loadPath = new File(modelFilename);
    }

    protected void loadModelDefinition(String fileName, String[] args, Properties jmpParameters) {
        if (!this.closeModel()) {
            return;
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"Model_file_") + fileName + JAMS.i18n((String)"_could_not_be_found!")), (String)JAMS.i18n((String)"File_Open_Error"));
                return;
            }
            this.loadPath = file;
            String newFilename = XMLProcessor.modelDocConverter((String)fileName);
            if (!newFilename.equalsIgnoreCase(fileName)) {
                fileName = newFilename;
                GUIHelper.showInfoDlg((Component)((Object)this), (String)(JAMS.i18n((String)"The_model_definition_in_") + fileName + JAMS.i18n((String)"_has_been_adapted_in_order_to_meet_changes_in_the_JAMS_model_specification.The_new_definition_has_been_stored_in_") + newFilename + JAMS.i18n((String)"_while_your_original_file_was_left_untouched.")), (String)JAMS.i18n((String)"Info"));
            }
            String xmlString = FileTools.fileToString((String)fileName);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    xmlString = xmlString.replaceAll("%" + i + "%", args[i]);
                }
            }
            this.modelDocument = XMLTools.getDocumentFromString((String)xmlString);
            if (jmpParameters != null) {
                this.modelDocument = ParameterProcessor.loadParams((Document)this.modelDocument, (Properties)jmpParameters);
            }
            ParameterProcessor.preProcess((Document)this.modelDocument);
            this.initialModelDocString = XMLTools.getStringFromDocument((Document)this.modelDocument);
        }
        catch (IOException ioe) {
            GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"The_specified_model_configuration_file_") + fileName + JAMS.i18n((String)"_could_not_be_found!")), (String)JAMS.i18n((String)"Error"));
        }
        catch (SAXException se) {
            if (se instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)se;
                GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"The_specified_model_configuration_file_") + fileName + JAMS.i18n((String)"_contains_errors!") + "\n[Fatal Error] :" + spe.getLineNumber() + ":" + spe.getColumnNumber() + ":" + spe.getMessage()), (String)JAMS.i18n((String)"Error"));
            }
            GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"The_specified_model_configuration_file_") + fileName + JAMS.i18n((String)"_contains_errors!")), (String)JAMS.i18n((String)"Error"));
        }
        this.modelFilename = fileName;
        this.fillAttributes(this.getModelDocument());
        this.fillTabbedPane(this.getModelDocument());
        this.saveModelAction.setEnabled(true);
        this.saveAsModelAction.setEnabled(true);
        this.modelMenu.setEnabled(true);
        this.editModelAction.setEnabled(true);
        this.explorerAction.setEnabled(true);
        this.getRunModelAction().setEnabled(true);
        JAMSTools.addToRecentFiles((SystemProperties)this.getProperties(), (String)"recentfiles", (String)fileName);
        this.updateRecentMenu();
    }

    protected void init() throws HeadlessException, DOMException, NumberFormatException {
        super.init();
        this.getRunModelAction().setEnabled(false);
        this.editPrefsAction = new AbstractAction(JAMS.i18n((String)"Edit_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.propertyDlg.setProperties(JAMSFrame.this.getProperties());
                JAMSFrame.this.propertyDlg.setVisible(true);
                if (JAMSFrame.this.propertyDlg.getResult() == 1) {
                    JAMSFrame.this.propertyDlg.validateProperties();
                }
            }
        };
        this.loadPrefsAction = new AbstractAction(JAMS.i18n((String)"Load_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.jfcProps.setSelectedFile(new File(""));
                int result = JAMSFrame.this.jfcProps.showOpenDialog((Component)((Object)JAMSFrame.this));
                if (result == 0) {
                    String stringValue = JAMSFrame.this.jfcProps.getSelectedFile().getAbsolutePath();
                    try {
                        JAMSFrame.this.getProperties().load(stringValue);
                    }
                    catch (IOException ioe) {
                        JAMSTools.handle((Throwable)ioe);
                    }
                }
            }
        };
        this.savePrefsAction = new AbstractAction(JAMS.i18n((String)"Save_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.jfcProps.setSelectedFile(new File(""));
                int result = JAMSFrame.this.jfcProps.showSaveDialog((Component)((Object)JAMSFrame.this));
                if (result == 0) {
                    String stringValue = JAMSFrame.this.jfcProps.getSelectedFile().getAbsolutePath();
                    try {
                        JAMSFrame.this.getProperties().save(stringValue);
                    }
                    catch (IOException ioe) {
                        JAMSTools.handle((Throwable)ioe);
                    }
                }
            }
        };
        this.loadModelExecutionStateAction = new AbstractAction(JAMS.i18n((String)"Resume_Model_Execution")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JAMSFrame.this.jfcSer == null) {
                    JAMSFrame.this.jfcSer = new JFileChooser();
                }
                JAMSFrame.this.jfcSer.setSelectedFile(new File(""));
                int result = JAMSFrame.this.jfcSer.showOpenDialog((Component)((Object)JAMSFrame.this));
                if (result == 0) {
                    try {
                        JAMSFrame.this.state = new JAMSFullModelState(JAMSFrame.this.jfcSer.getSelectedFile());
                        Model model = JAMSFrame.this.state.getModel();
                        Document doc = model.getRuntime().getModelDocument();
                        JAMSFrame.this.loadModelDefinition(doc);
                        JAMSFrame.this.modelFilename = model.getWorkspacePath() + "/" + model.getName();
                        JAMSFrame.this.saveModelAction.setEnabled(true);
                        JAMSFrame.this.explorerAction.setEnabled(true);
                        JAMSFrame.this.saveAsModelAction.setEnabled(true);
                        JAMSFrame.this.modelMenu.setEnabled(true);
                        JAMSFrame.this.editModelAction.setEnabled(true);
                        JAMSFrame.this.getRunModelAction().setEnabled(true);
                    }
                    catch (IOException ioe) {
                        GUIHelper.showErrorDlg((Component)((Object)JAMSFrame.this), (String)(JAMS.i18n((String)"Could_not_resume_model_execution_because") + ioe), (String)JAMS.i18n((String)"Resume_error"));
                    }
                    catch (ClassNotFoundException cnfe) {
                        GUIHelper.showErrorDlg((Component)((Object)JAMSFrame.this), (String)(JAMS.i18n((String)"Could_not_resume_model_execution_because") + cnfe), (String)JAMS.i18n((String)"Resume_error"));
                    }
                }
            }
        };
        this.loadModelAction = new AbstractAction(JAMS.i18n((String)"Open_Model...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringTools.isEmptyString((String)JAMSFrame.this.modelFilename)) {
                    JAMSFrame.this.jfcModel.setSelectedFile(new File(JAMSFrame.this.modelFilename));
                } else {
                    JAMSFrame.this.jfcModel.setSelectedFile(new File(""));
                }
                if (JAMSFrame.this.jfcModel.showOpenDialog((Component)((Object)JAMSFrame.this)) == 0) {
                    JAMSFrame.this.state = null;
                    JAMSFrame.this.loadModelDefinition(JAMSFrame.this.jfcModel.getSelectedFile().getAbsolutePath(), null, null);
                }
            }
        };
        this.saveModelAction = new AbstractAction(JAMS.i18n((String)"Save_Model")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.saveModel();
            }
        };
        this.saveModelAction.setEnabled(false);
        this.saveAsModelAction = new AbstractAction(JAMS.i18n((String)"Save_Model_As...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringTools.isEmptyString((String)JAMSFrame.this.modelFilename)) {
                    JAMSFrame.this.jfcModel.setSelectedFile(new File(JAMSFrame.this.modelFilename));
                } else {
                    JAMSFrame.this.jfcModel.setSelectedFile(new File(""));
                }
                if (JAMSFrame.this.jfcModel.showSaveDialog((Component)((Object)JAMSFrame.this)) == 0) {
                    JAMSFrame.this.modelFilename = JAMSFrame.this.jfcModel.getSelectedFile().getAbsolutePath();
                    JAMSFrame.this.saveModel();
                }
            }
        };
        this.saveAsModelAction.setEnabled(false);
        this.startEnsembleManagerAction = new AbstractAction(JAMS.i18n((String)"Start_Ensemble_Manager")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.openEnsembleManager();
            }
        };
        this.editModelAction = new AbstractAction(JAMS.i18n((String)"Edit_Model...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JAMSFrame.this.closeModel()) {
                    return;
                }
                JAMSFrame.this.dispose();
                if (JUICE.getJuiceFrame() == null) {
                    JUICE.createJUICEFrame(JAMSFrame.this.getProperties());
                }
                if (JAMSFrame.this.modelFilename != null) {
                    JUICE.getJuiceFrame().loadModel(JAMSFrame.this.modelFilename);
                }
            }
        };
        this.editModelAction.setEnabled(true);
        this.exitAction = new AbstractAction(JAMS.i18n((String)"Exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.exit();
            }
        };
        this.aboutAction = new AbstractAction(JAMS.i18n((String)"About")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDlg((Frame)((Object)JAMSFrame.this)).setVisible(true);
            }
        };
        this.onlineAction = new AbstractAction(JAMS.i18n((String)"JAMS_online...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.openURL((String)JAMS.i18n((String)"JAMS_URL"));
            }
        };
        this.loadModelParamAction = new AbstractAction(JAMS.i18n((String)"Load_Model_Parameter...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.jfcParam.setSelectedFile(new File(""));
                int result = JAMSFrame.this.jfcParam.showOpenDialog((Component)((Object)JAMSFrame.this));
                if (result == 0) {
                    String path = JAMSFrame.this.jfcParam.getSelectedFile().getAbsolutePath();
                    JAMSFrame.this.loadParams(new File(path));
                }
            }
        };
        this.saveModelParamAction = new AbstractAction(JAMS.i18n((String)"Save_Model_Parameter...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.jfcParam.setSelectedFile(new File(""));
                int result = JAMSFrame.this.jfcParam.showSaveDialog((Component)((Object)JAMSFrame.this));
                if (result == 0) {
                    String path = JAMSFrame.this.jfcParam.getSelectedFile().getAbsolutePath();
                    JAMSFrame.this.saveParams(new File(path));
                }
            }
        };
        this.rtManagerAction = new AbstractAction(JAMS.i18n((String)"Show_Runtime_Manager...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.rtManagerDlg.setVisible(true);
            }
        };
        this.infoLogAction = new AbstractAction(JAMS.i18n((String)"Info_Log...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.getInfoDlg().setVisible(true);
            }
        };
        this.errorLogAction = new AbstractAction(JAMS.i18n((String)"Error_Log...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.getErrorDlg().setVisible(true);
            }
        };
        this.explorerAction = new AbstractAction(JAMS.i18n((String)"DATA_EXPLORER")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.openExplorer();
            }
        };
        this.browserAction = new AbstractAction(JAMS.i18n((String)"Browse_WS_Dir")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.browseWSDir();
            }
        };
        this.propertyDlg = new PropertyDlg((Frame)((Object)this), this.getProperties());
        this.jfcProps = GUIHelper.getJFileChooser((FileFilter)JAMSFileFilter.getPropertyFilter());
        this.jfcProps.setFileSelectionMode(0);
        this.jfcProps.setCurrentDirectory(JAMS.getBaseDir());
        this.jfcModel = GUIHelper.getJFileChooser((FileFilter)JAMSFileFilter.getModelFilter());
        this.jfcModel.setFileSelectionMode(0);
        this.jfcModel.setCurrentDirectory(JAMS.getBaseDir());
        this.jfcParam = GUIHelper.getJFileChooser((FileFilter)JAMSFileFilter.getParameterFilter());
        this.jfcParam.setFileSelectionMode(0);
        this.jfcParam.setCurrentDirectory(JAMS.getBaseDir());
        this.rtManagerDlg = new JDialog((Frame)((Object)this), JAMS.i18n((String)"Runtime_Manager"));
        this.rtManagerDlg.setDefaultCloseOperation(1);
        this.rtManagerDlg.setLocationByPlatform(true);
        RuntimeManagerPanel rtManagerPanel = new RuntimeManagerPanel();
        this.rtManagerDlg.getContentPane().add((Component)rtManagerPanel);
        this.rtManagerDlg.pack();
        JButton closeButton = new JButton(JAMS.i18n((String)"Close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAMSFrame.this.rtManagerDlg.setVisible(false);
            }
        });
        rtManagerPanel.getButtonPanel().add(closeButton);
        this.mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu(JAMS.i18n((String)"File"));
        JMenuItem loadItem = new JMenuItem(this.loadModelAction);
        loadItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(loadItem);
        this.recentMenu = new JMenu(JAMS.i18n((String)"Recent_Files"));
        this.updateRecentMenu();
        fileMenu.add(this.recentMenu);
        this.saveItem = new JMenuItem(this.saveModelAction);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem(this.saveAsModelAction);
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        fileMenu.add(this.saveAsItem);
        if (this.isEnsembleManagerEnabled) {
            this.startEnsembleManagerItem = new JMenuItem(this.startEnsembleManagerAction);
            this.startEnsembleManagerItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            fileMenu.add(new JSeparator());
            fileMenu.add(this.startEnsembleManagerItem);
            fileMenu.add(new JSeparator());
        }
        JMenuItem exitItem = new JMenuItem(this.exitAction);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        fileMenu.add(exitItem);
        this.getMainMenu().add(fileMenu);
        JMenu editMenu = new JMenu(JAMS.i18n((String)"Edit"));
        JMenuItem editOptionsItem = new JMenuItem(this.editPrefsAction);
        editOptionsItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        editMenu.add(editOptionsItem);
        JMenuItem loadOptionsItem = new JMenuItem(this.loadPrefsAction);
        editMenu.add(loadOptionsItem);
        JMenuItem saveOptionsItem = new JMenuItem(this.savePrefsAction);
        editMenu.add(saveOptionsItem);
        this.getMainMenu().add(editMenu);
        this.modelMenu = new JMenu(JAMS.i18n((String)"Model"));
        this.modelMenu.setEnabled(false);
        this.mainMenu.add(this.modelMenu);
        JMenuItem runModelItem = new JMenuItem(this.getRunModelAction());
        runModelItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.modelMenu.add(runModelItem);
        JMenuItem explorerItem = new JMenuItem(this.explorerAction);
        explorerItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.modelMenu.add(explorerItem);
        JMenuItem fileBrowserItem = new JMenuItem(this.browserAction);
        fileBrowserItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.modelMenu.add(fileBrowserItem);
        JMenuItem editModelItem = new JMenuItem(this.editModelAction);
        editModelItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.modelMenu.add(editModelItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem loadModelParamItem = new JMenuItem(this.loadModelParamAction);
        this.modelMenu.add(loadModelParamItem);
        JMenuItem saveModelParamItem = new JMenuItem(this.saveModelParamAction);
        this.modelMenu.add(saveModelParamItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem rtManagerItem = new JMenuItem(this.rtManagerAction);
        this.modelMenu.add(rtManagerItem);
        JMenuItem loadModelExecutionStateItem = new JMenuItem(this.loadModelExecutionStateAction);
        this.modelMenu.add(loadModelExecutionStateItem);
        this.logsMenu = new JMenu(JAMS.i18n((String)"Logs"));
        JMenuItem infoLogItem = new JMenuItem(this.infoLogAction);
        this.getLogsMenu().add(infoLogItem);
        JMenuItem errorLogItem = new JMenuItem(this.errorLogAction);
        this.getLogsMenu().add(errorLogItem);
        this.getMainMenu().add(this.getLogsMenu());
        JMenu helpMenu = new JMenu(JAMS.i18n((String)"Help"));
        JMenuItem onlineItem = new JMenuItem(this.onlineAction);
        helpMenu.add(onlineItem);
        JMenuItem aboutItem = new JMenuItem(this.aboutAction);
        helpMenu.add(aboutItem);
        this.getMainMenu().add(helpMenu);
        this.setJMenuBar(this.getMainMenu());
        this.getToolBar().remove(1);
        JButton loadButton = new JButton(this.loadModelAction);
        loadButton.setText("");
        loadButton.setToolTipText(JAMS.i18n((String)"Open_Model..."));
        loadButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/ModelOpen.png")));
        this.getToolBar().add((Component)loadButton, 0);
        JButton saveButton = new JButton(this.saveModelAction);
        saveButton.setText("");
        saveButton.setToolTipText(JAMS.i18n((String)"Save_Model"));
        saveButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/ModelSave.png")));
        this.getToolBar().add((Component)saveButton, 1);
        JButton prefsButton = new JButton(this.editPrefsAction);
        prefsButton.setText("");
        prefsButton.setToolTipText(JAMS.i18n((String)"Edit_Preferences..."));
        prefsButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/Preferences.png")));
        this.getToolBar().add((Component)prefsButton, 2);
        this.getToolBar().add((Component)new JToolBar.Separator(null), 3);
        JButton explorerButton = new JButton(this.explorerAction);
        explorerButton.setText("");
        explorerButton.setToolTipText(JAMS.i18n((String)"JADE"));
        explorerButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/Layers_small.png")));
        this.explorerAction.setEnabled(false);
        this.getToolBar().add(explorerButton);
        JButton juiceButton = new JButton(this.editModelAction);
        juiceButton.setText("");
        juiceButton.setToolTipText(JAMS.i18n((String)"Edit_Model..."));
        juiceButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/JUICEicon32.png")));
        this.getToolBar().add(juiceButton);
        this.getToolBar().addSeparator();
        JButton infoLogButton = new JButton(this.infoLogAction);
        infoLogButton.setText("");
        infoLogButton.setToolTipText(JAMS.i18n((String)"Show_Info_Log..."));
        infoLogButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/InfoLog.png")));
        this.getToolBar().add(infoLogButton);
        JButton errorLogButton = new JButton(this.errorLogAction);
        errorLogButton.setText("");
        errorLogButton.setToolTipText(JAMS.i18n((String)"Show_Error_Log..."));
        errorLogButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/ErrorLog.png")));
        this.getToolBar().add(errorLogButton);
        JButton exitButton = new JButton(this.exitAction);
        exitButton.setText("");
        exitButton.setToolTipText(JAMS.i18n((String)"Exit"));
        exitButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/images/system-shutdown.png")));
        this.getToolBar().add(exitButton);
    }

    public void loadParams(File paramsFile) {
        try {
            ParameterProcessor.loadParams((Document)this.getModelDocument(), (File)paramsFile);
            this.loadModelDefinition(this.getModelDocument());
        }
        catch (Exception ex) {
            GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"File_") + paramsFile.getName() + JAMS.i18n((String)"_could_not_be_loaded.")), (String)JAMS.i18n((String)"File_Open_Error"));
        }
    }

    public void saveParams(File paramsFile) {
        try {
            ParameterProcessor.saveParams((Document)this.getModelDocument(), (File)paramsFile, (String)this.getProperties().getProperty("username"), (String)this.modelFilename);
        }
        catch (Exception ex) {
            GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"File_") + paramsFile.getName() + JAMS.i18n((String)"_could_not_be_saved.")), (String)JAMS.i18n((String)"File_saving_error"));
        }
    }

    protected void processInfoLog(String logText) {
        this.getInfoDlg().appendText(logText);
    }

    protected void processErrorLog(String logText) {
        this.getErrorDlg().appendText(logText);
    }

    protected void exit() {
        if (!this.closeModel()) {
            return;
        }
        try {
            this.getProperties().save();
        }
        catch (IOException ioe) {
            JAMSTools.handle((Throwable)ioe);
        }
        super.exit();
        System.exit(0);
    }

    private boolean closeModel() {
        int result;
        this.state = null;
        if (this.getModelDocument() == null) {
            return true;
        }
        if (!this.verifyInputs(false) && (result = GUIHelper.showYesNoDlg((Component)((Object)this), (String)JAMS.i18n((String)"Found_invalid_parameter_values_which_won't_be_saved._Proceed_anyway?"), (String)JAMS.i18n((String)"Invalid_parameter_values"))) == 1) {
            return false;
        }
        this.updateProperties();
        if (this.getModelDocument() != null) {
            String modelDocString = XMLTools.getStringFromDocument((Document)this.getModelDocument());
            if (!this.getInitialModelDocString().equals(modelDocString)) {
                int result2 = GUIHelper.showYesNoCancelDlg((Component)((Object)this), (String)(JAMS.i18n((String)"Save_modifications_in_") + this.modelFilename + JAMS.i18n((String)"_?")), (String)JAMS.i18n((String)"JAMS_Launcher:_unsaved_modifications"));
                if (result2 == 2) {
                    return false;
                }
                if (result2 == 0) {
                    this.saveModel();
                }
            }
        }
        return true;
    }

    private void saveModel() {
        this.updateProperties();
        try {
            XMLTools.writeXmlFile((Document)this.getModelDocument(), (String)this.modelFilename);
            this.initialModelDocString = XMLTools.getStringFromDocument((Document)this.modelDocument);
            this.fillAttributes(this.getModelDocument());
        }
        catch (IOException ioe) {
            GUIHelper.showErrorDlg((Component)((Object)this), (String)(JAMS.i18n((String)"Error_saving_configuration_to_") + this.modelFilename), (String)JAMS.i18n((String)"Error"));
            return;
        }
    }

    protected void fillAttributes(Document doc) {
        Element root = doc.getDocumentElement();
        this.setTitle(BASE_TITLE + ": " + root.getAttribute("name") + " [" + this.modelFilename + "]");
        this.setHelpBaseUrl(root.getAttribute("helpbaseurl"));
    }

    private void browseWSDir() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Document modelDoc = this.getModelDocument();
        File workspaceFile = new File(XMLProcessor.getWorkspacePath((Document)modelDoc));
        if (!workspaceFile.isDirectory()) {
            if (this.loadPath != null) {
                workspaceFile = this.loadPath.getParentFile();
            } else {
                GUIHelper.showErrorDlg((Component)((Object)this), (String)("\"" + workspaceFile + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
                return;
            }
        }
        try {
            URI workspaceURI = workspaceFile.toURI();
            Desktop.getDesktop().browse(workspaceURI);
        }
        catch (IOException ex) {
            GUIHelper.showErrorDlg((Component)((Object)this), (String)("\"" + workspaceFile + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
        }
    }

    private void openEnsembleManager() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                EnsembleControlPanel ecp = new EnsembleControlPanel((JAMSLauncher)JAMSFrame.this);
                JFrame frame = new JFrame("Ensemble Manager");
                frame.add((Component)ecp);
                frame.pack();
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
                return null;
            }
        };
        worker.run();
    }

    private void openExplorer() {
        if (!this.verifyInputs()) {
            return;
        }
        this.updateProperties();
        Document modelDoc = this.getModelDocument();
        File workspaceFile = new File(XMLProcessor.getWorkspacePath((Document)modelDoc));
        if (!workspaceFile.isDirectory()) {
            if (this.loadPath != null) {
                workspaceFile = this.loadPath.getParentFile();
            } else {
                GUIHelper.showErrorDlg((Component)((Object)this), (String)("\"" + workspaceFile + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
                return;
            }
        }
        try {
            if (theExplorer == null) {
                theExplorer = new JAMSExplorer(null, false);
            }
            if (theExplorer.getWorkspace() == null || !theExplorer.getWorkspace().getDirectory().equals(workspaceFile)) {
                theExplorer.getExplorerFrame().open(workspaceFile);
            }
            theExplorer.getExplorerFrame().setVisible(true);
        }
        catch (NoClassDefFoundError ncdfe) {
            GUIHelper.showInfoDlg((Component)((Object)this), (String)JAMS.i18n((String)"ExplorerDisabled"), (String)JAMS.i18n((String)"Info"));
        }
        catch (InvalidWorkspaceException ex) {
            GUIHelper.showErrorDlg((Component)((Object)this), (String)("\"" + workspaceFile + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
        }
    }

    public JMenuBar getMainMenu() {
        return this.mainMenu;
    }

    protected JMenu getLogsMenu() {
        return this.logsMenu;
    }

    protected LogViewDlg getInfoDlg() {
        return this.infoDlg;
    }

    protected LogViewDlg getErrorDlg() {
        return this.errorDlg;
    }

    private void updateRecentMenu() {
        String[] recentFiles;
        this.recentMenu.removeAll();
        for (String fileName : recentFiles = JAMSTools.getRecentFiles((SystemProperties)this.getProperties(), (String)"recentfiles")) {
            AbstractAction openAction = new AbstractAction(fileName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JAMSFrame.this.loadModelDefinition(this.getValue("Name").toString(), null, null);
                }
            };
            JMenuItem recentItem = new JMenuItem(openAction);
            this.recentMenu.add(recentItem);
        }
    }
}

