/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui.tree;

import jamsui.juice.gui.tree.JAMSNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Arrays;
import java.util.Vector;

public class TransferableNode
implements Transferable {
    public static final DataFlavor NODE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "Node");
    public static final DataFlavor EXPANDED_STATE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "Vector");
    private JAMSNode node;
    private Vector expandedStates;
    private DataFlavor[] flavors = new DataFlavor[]{NODE_FLAVOR, EXPANDED_STATE_FLAVOR};

    public TransferableNode(JAMSNode nd, Vector es) {
        this.node = nd;
        this.expandedStates = es;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor == NODE_FLAVOR) {
            return this.node;
        }
        if (flavor == EXPANDED_STATE_FLAVOR) {
            return this.expandedStates;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(this.flavors).contains(flavor);
    }
}

