/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui.tree;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jams.meta.ContextDescriptor;
import jams.meta.ModelNode;
import jams.model.JAMSComponent;
import jams.model.JAMSContext;
import jams.tools.StringTools;
import jamsui.juice.JUICE;
import jamsui.juice.gui.ComponentInfoDlg;
import jamsui.juice.gui.tree.DefaultTreeTransferHandler;
import jamsui.juice.gui.tree.JAMSNode;
import jamsui.juice.gui.tree.JAMSTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibTree
extends JAMSTree {
    private static final String ROOT_NAME = JAMS.i18n((String)"Model_Components");
    private JPopupMenu popup;
    private String[] libsArray;
    private int contextCount;
    private int componentCount;
    private int i;
    private int maxClasses;

    public LibTree(ComponentCollection componentCollection, int maxClasses) {
        super(componentCollection);
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger(this.getClass().getName()));
        this.setEditable(false);
        new DefaultTreeTransferHandler(this, 1);
        this.maxClasses = maxClasses;
        JMenuItem detailItem = new JMenuItem(JAMS.i18n((String)"Show_Metadata..."));
        detailItem.setAccelerator(KeyStroke.getKeyStroke('M'));
        detailItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibTree.this.displayComponentDlg();
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(detailItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    LibTree.this.showPopup(evt);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    LibTree.this.displayComponentDlg();
                }
            }
        });
    }

    private void showPopup(MouseEvent evt) {
        TreePath p = this.getClosestPathForLocation(evt.getX(), evt.getY());
        this.setSelectionPath(p);
        JAMSNode node = (JAMSNode)((Object)this.getLastSelectedPathComponent());
        if (node != null) {
            try {
                Class clazz = ((ComponentDescriptor)node.getUserObject()).getClazz();
                if (clazz != null) {
                    this.popup.show(this, evt.getX(), evt.getY());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void displayComponentDlg() {
        JAMSNode node = (JAMSNode)((Object)this.getLastSelectedPathComponent());
        if (node == null || !(node.getUserObject() instanceof ComponentDescriptor)) {
            return;
        }
        ComponentDescriptor cd = (ComponentDescriptor)node.getUserObject();
        ComponentInfoDlg.displayMetadataDlg((JFrame)this.getTopLevelAncestor(), cd.getClazz());
    }

    public void update(String libFileNames) {
        JAMSNode rootNode;
        this.libsArray = StringTools.toArray((String)libFileNames, (String)";");
        this.contextCount = 0;
        this.componentCount = 0;
        JUICE.setStatusText(JAMS.i18n((String)"Loading_Libraries"));
        this.setVisible(false);
        if (this.getModel() != null && this.getModel().getRoot() instanceof JAMSNode) {
            rootNode = (JAMSNode)((Object)this.getModel().getRoot());
            rootNode.remove();
            this.setModel(null);
        }
        rootNode = this.createLibTree(this.libsArray);
        this.setModel(new DefaultTreeModel((TreeNode)((Object)rootNode)));
        this.setVisible(true);
        JUICE.setStatusText(JAMS.i18n((String)"Contexts:") + this.contextCount + " " + JAMS.i18n((String)"Components:") + this.componentCount);
    }

    private JAMSNode createLibTree(String[] libsArray) {
        JAMSNode root = new JAMSNode(ROOT_NAME, 3, this);
        this.i = 1;
        for (int i = 0; i < libsArray.length; ++i) {
            JAMSNode jarNode;
            File file = new File(libsArray[i]);
            int overhead = 0;
            if (!file.isAbsolute()) {
                File file2 = file.getAbsoluteFile();
                overhead = file2.getPath().length() - file.getPath().length();
                file = file.getAbsoluteFile();
            }
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] f = file.listFiles();
                for (int j = 0; j < f.length; ++j) {
                    if (!f[j].getName().endsWith(".jar") || (jarNode = this.createJARNode(f[j].toString(), JUICE.getLoader(), overhead)) == null) continue;
                    root.add((MutableTreeNode)((Object)jarNode));
                }
                continue;
            }
            jarNode = this.createJARNode(file.toString(), JUICE.getLoader(), overhead);
            if (jarNode == null) continue;
            root.add((MutableTreeNode)((Object)jarNode));
        }
        return root;
    }

    private JAMSNode createJARNode(String jar, ClassLoader loader, int overhead) {
        if (this.i >= this.maxClasses) {
            return null;
        }
        JAMSNode jarRoot = new JAMSNode(jar.substring(overhead), 5, this);
        ArrayList components = new ArrayList();
        String jarName = "";
        String clazzName = "";
        String clazzFullName = "";
        try {
            JarFile jfile = new JarFile(jar);
            File file = new File(jar);
            jarName = file.getCanonicalFile().getName();
            Enumeration<JarEntry> jarentries = jfile.entries();
            while (jarentries.hasMoreElements()) {
                String entry = ((Object)jarentries.nextElement()).toString();
                if (!entry.endsWith(".class")) continue;
                String classString = entry.substring(0, entry.length() - 6);
                classString = classString.replaceAll("/", ".");
                try {
                    if (this.i >= this.maxClasses) {
                        GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)MessageFormat.format(JAMS.i18n((String)"To_many_classes_error"), this.i), (String)JAMS.i18n((String)"Error_while_loading_archive"));
                        break;
                    }
                    ++this.i;
                    Class<?> clazz = loader.loadClass(classString);
                    if (clazz.isMemberClass() || clazz.getCanonicalName() == null || !JAMSComponent.class.isAssignableFrom(clazz)) continue;
                    components.add(clazz);
                }
                catch (ClassNotFoundException cnfe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, JAMS.i18n((String)"Error_while_loading_archive_") + jarName + "\"" + JAMS.i18n((String)"_(class_") + classString + JAMS.i18n((String)"_could_not_be_found)!"), cnfe);
                }
                catch (NoClassDefFoundError cnfe) {
                }
                catch (UnsupportedClassVersionError ucve) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(JAMS.i18n((String)"ClassVersionErrorWhileLoadingComponentLib"), classString + " (" + jarName + ")") + "\n" + ucve.getMessage(), ucve);
                }
                catch (Throwable e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, JAMS.i18n((String)"Error_while_loading_archive_") + jarName + "\"" + JAMS.i18n((String)"_(class_") + classString + JAMS.i18n((String)"_could_not_be_loaded)!") + "\n" + e.getMessage(), e);
                }
            }
            String oldPackage = "";
            String newPackage = "";
            JAMSNode packageNode = null;
            for (Class clazz : components) {
                newPackage = clazz.getPackage() != null && !clazz.getPackage().getName().isEmpty() ? clazz.getPackage().getName() : "default package";
                if (!newPackage.equals(oldPackage)) {
                    packageNode = new JAMSNode(newPackage, 4, this);
                    oldPackage = newPackage;
                }
                clazzName = clazz.getSimpleName();
                clazzFullName = clazz.getName();
                if (!(clazzName.equals("JAMSComponent") || clazzName.equals("JAMSContext_") || clazzName.equals("JAMSGUIComponent") || clazzName.equals("JAMSModel"))) {
                    try {
                        JAMSNode compNode;
                        Object no = JAMSContext.class.isAssignableFrom(clazz) ? new ContextDescriptor(clazz, null, this.getComponentCollection()) : new ComponentDescriptor(clazz, null, this.getComponentCollection());
                        no.addObserver(new Observer(){

                            @Override
                            public void update(Observable o, Object arg) {
                                LibTree.this.updateUI();
                            }
                        });
                        if (JAMSContext.class.isAssignableFrom(clazz)) {
                            compNode = new JAMSNode(no, 1, this);
                            ++this.contextCount;
                        } else {
                            compNode = new JAMSNode(no, 0, this);
                            ++this.componentCount;
                        }
                        no.setNode((ModelNode)compNode);
                        packageNode.add((MutableTreeNode)((Object)compNode));
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"Missing_class_while_loading_component_") + clazzFullName + JAMS.i18n((String)"_in_archive_") + jarName + "\"!"), (String)JAMS.i18n((String)"Error_while_loading_archive"));
                        Logger.getLogger(LibTree.class.getName()).log(Level.SEVERE, null, ncdfe);
                    }
                    catch (JAMSException jex) {
                        GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)jex.getMessage(), (String)jex.getHeader());
                        Logger.getLogger(LibTree.class.getName()).log(Level.SEVERE, null, jex);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (packageNode.getChildCount() <= 0) continue;
                jarRoot.add((MutableTreeNode)((Object)packageNode));
            }
        }
        catch (IOException ioe) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"File_") + jar + JAMS.i18n((String)"_could_not_be_loaded.")), (String)JAMS.i18n((String)"Error_while_loading_archive"));
            jarRoot = null;
        }
        if (jarRoot.getChildCount() > 0) {
            return jarRoot;
        }
        return null;
    }
}

