/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSFileFilter;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.explorer.JAMSExplorer;
import jams.gui.JAMSLauncher;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.gui.tools.GUIState;
import jams.io.ParameterProcessor;
import jams.io.XMLProcessor;
import jams.meta.ModelDescriptor;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.server.client.Controller;
import jams.server.client.gui.JAMSCloudGraphicalController;
import jams.server.entities.Job;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.JAMSTools;
import jams.tools.XMLTools;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jamsui.juice.JUICE;
import jamsui.juice.ViewList;
import jamsui.juice.gui.ComponentPanel;
import jamsui.juice.gui.ModelEditPanel;
import jamsui.juice.gui.ModelGUIPanel;
import jamsui.juice.gui.OutputDSDlg;
import jamsui.juice.gui.TreePanel;
import jamsui.juice.gui.tree.ModelTree;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.w3c.dom.Document;

public class ModelView {
    private static Logger log = Logger.getLogger(ModelView.class.getName());
    private static final int TREE_PANE_WIDTH = 250;
    private JInternalFrame frame;
    private File savePath;
    private Document initialDoc;
    private Document beforeLauncherDoc;
    private ModelTree tree;
    private ComponentPanel compEditPanel;
    private ModelGUIPanel launcherPanel;
    private ModelEditPanel modelEditPanel;
    private TreePanel modelTreePanel;
    private JDesktopPane parentPanel;
    private WorkerDlg loadModelDlg;
    private Runnable modelLoading;
    private static int viewCounter = 0;
    public static ViewList viewList = new ViewList();
    private JAMSRuntime runtime;
    private static JAMSExplorer theExplorer;
    private ModelDescriptor modelDescriptor = new ModelDescriptor();
    private OutputDSDlg outputDSDlg;

    public ModelView(JDesktopPane parentPanel) {
        this(ModelView.getNextViewName(), parentPanel);
    }

    public ModelView(String title, JDesktopPane parentPanel) {
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)log);
        this.parentPanel = parentPanel;
        this.modelEditPanel = new ModelEditPanel(this);
        this.compEditPanel = new ComponentPanel(this);
        this.launcherPanel = new ModelGUIPanel(this);
        this.modelTreePanel = new TreePanel();
        this.modelLoading = new Runnable(){

            @Override
            public void run() {
                try {
                    ModelView.this.runtime = ModelView.this.createRuntime();
                    Document modelDoc = ModelView.this.getModelDoc();
                    if (modelDoc != null) {
                        String defaultWorkspacePath = null;
                        if (Boolean.parseBoolean(JUICE.getJamsProperties().getProperty("defaultworkspace")) && ModelView.this.getSavePath() != null) {
                            defaultWorkspacePath = ModelView.this.getSavePath().getParent();
                        }
                        String modelFilePath = null;
                        if (ModelView.this.getSavePath() != null) {
                            modelFilePath = ModelView.this.getSavePath().getAbsolutePath();
                        }
                        ModelView.this.runtime.loadModel(modelDoc, defaultWorkspacePath, modelFilePath);
                    } else {
                        ModelView.this.runtime = null;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        };
        this.loadModelDlg = new WorkerDlg((Window)JUICE.getJuiceFrame(), JAMS.i18n((String)"Model_Setup"));
        this.frame = new JInternalFrame();
        this.frame.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                GUIState.setWorkspace((Workspace)ModelView.this.getWorkspace());
                GUIState.setSavePath((File)ModelView.this.getSavePath());
                GUIState.setModelDescriptor((ModelDescriptor)ModelView.this.getModelDescriptor());
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }
        });
        this.frame.setClosable(true);
        this.frame.setIconifiable(true);
        this.frame.setMaximizable(true);
        this.frame.setResizable(true);
        this.frame.setTitle(title);
        this.frame.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/images/Context_si.png")));
        this.frame.setBounds(0, 0, 600, 600);
        this.frame.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                ModelView.this.exit();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.frame.setDefaultCloseOperation(0);
        JSplitPane modelSplitPane = new JSplitPane();
        modelSplitPane.setAutoscrolls(true);
        modelSplitPane.setContinuousLayout(true);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab(JAMS.i18n((String)"Component_configuration"), new JScrollPane(this.compEditPanel));
        tabPane.addTab(JAMS.i18n((String)"GUI_Builder"), new JScrollPane(this.launcherPanel));
        modelSplitPane.setLeftComponent(this.modelTreePanel);
        modelSplitPane.setRightComponent(tabPane);
        modelSplitPane.setDividerLocation(250);
        this.frame.getContentPane().add((Component)modelSplitPane, "Center");
        viewList.addView(this.frame, this);
        ModelView currentView = JUICE.getJuiceFrame().getCurrentView();
        parentPanel.add((Component)this.frame, JLayeredPane.DEFAULT_LAYER);
        try {
            if (currentView == null) {
                this.frame.setMaximum(true);
            }
        }
        catch (PropertyVetoException pve) {
            JAMSTools.handle((Throwable)pve);
        }
    }

    public void runModelFromLauncher() {
        if (this.tree == null) {
            return;
        }
        this.beforeLauncherDoc = this.getModelDoc();
        JAMSLauncher launcher = new JAMSLauncher((Window)JUICE.getJuiceFrame(), JUICE.getJamsProperties(), this.getModelDoc(), this.getSavePath());
        launcher.setObserver(new Observer(){

            @Override
            public void update(Observable o, Object obj) {
                int result;
                String oldXMLString;
                String newXMLString = XMLTools.getStringFromDocument((Document)ModelView.this.getModelDoc());
                if (newXMLString.compareTo(oldXMLString = XMLTools.getStringFromDocument((Document)ModelView.this.beforeLauncherDoc)) != 0 && (result = GUIHelper.showYesNoDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"The_model_was_modified._Reload_anyway?"), (String)JAMS.i18n((String)"Unsaved_modifications"))) == 1) {
                    return;
                }
                ModelView.this.setTree(new ModelTree(ModelView.this, (Document)obj));
            }
        });
        launcher.setVisible(true);
    }

    public void runModel() {
        this.loadModelDlg.setTask(this.modelLoading);
        this.loadModelDlg.execute();
        if (this.runtime == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ModelView.this.runtime.runModel();
                }
                catch (Exception ex) {
                    ModelView.this.runtime.handle((Throwable)ex);
                }
                JUICE.getJuiceFrame().getInfoDlg().appendText("\n\n");
                JUICE.getJuiceFrame().getErrorDlg().appendText("\n\n");
                ModelView.this.runtime = null;
                Runtime.getRuntime().gc();
            }
        };
        try {
            t.start();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private File getJAMSuiLib() {
        File jamsuiLib = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        if (jamsuiLib.getName().endsWith("classes")) {
            try {
                File distDir = new File(jamsuiLib.getParentFile(), "../dist");
                while (!distDir.exists()) {
                    JFileChooser jfc = GUIHelper.getJFileChooser((javax.swing.filechooser.FileFilter)JAMSFileFilter.getJarFilter());
                    jfc.setDialogTitle(JAMS.i18n((String)"Please_select_the_jams-ui.jar"));
                    if (jfc.showOpenDialog(this.frame) == 0) {
                        jamsuiLib = jfc.getSelectedFile();
                        if (!jamsuiLib.exists()) continue;
                        distDir = new File(jamsuiLib.getParentFile(), "../dist");
                        continue;
                    }
                    log.severe("Unable_to_locate_any_jams-ui.jar");
                    return null;
                }
                jamsuiLib = distDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                })[0];
            }
            catch (HeadlessException t) {
                log.log(Level.SEVERE, "Unable_to_locate_any_jams-ui.jar", t);
                return null;
            }
        }
        return jamsuiLib;
    }

    public Job runModelInCloud() throws IOException {
        JAMSCloudGraphicalController connector = JAMSCloudGraphicalController.createInstance((Window)JUICE.getJuiceFrame(), (SystemProperties)JUICE.getJamsProperties());
        if (!connector.isConnected() && connector.reconnect() == null) {
            return null;
        }
        Controller client = connector.getClient();
        this.loadModelDlg.setTask(this.modelLoading);
        this.loadModelDlg.execute();
        if (this.runtime == null) {
            return null;
        }
        if (this.runtime.getModel() == null) {
            log.log(Level.SEVERE, "Unable to load model. Please make sure, your model can be run locally!");
            return null;
        }
        Workspace jamsWorkspace = this.runtime.getModel().getWorkspace();
        String libs = JUICE.getJamsProperties().getProperty("libs");
        String newLibs = "";
        String[] compLibArray = libs.split(";");
        File[] compLibFile = new File[compLibArray.length];
        for (int i = 0; i < compLibArray.length; ++i) {
            compLibFile[i] = new File(compLibArray[i]);
            newLibs = newLibs + "components/" + i + "/" + compLibFile[i].getName() + ";";
        }
        newLibs = newLibs.substring(0, newLibs.length() - 1);
        File libDir = JAMS.getLibDir();
        String uploadFileFilter = JUICE.getJamsProperties().getProperty("uploadFileFilter");
        if (uploadFileFilter == null) {
            uploadFileFilter = "(.*\\.cache)|(.*\\.ser)|(.*\\.svn)|(.*/output/.*)|(.*/documentation/.*)|(.*\\.cdat)|(.*\\.log)";
        }
        jamsWorkspace.loadConfig();
        String title = jamsWorkspace.getTitle();
        jams.server.entities.Workspace ws = null;
        if (title == null || title.isEmpty()) {
            title = JOptionPane.showInputDialog(this.parentPanel, JAMS.i18n((String)"The_workspace_you_are_going_to_upload_has_no_name"), JAMS.i18n((String)"Name_of_workspace"), 3);
            if (title == null) {
                title = "unnamed";
            } else {
                this.runtime.getModel().getWorkspace().setTitle(title);
            }
        }
        if ((ws = connector.uploadWorkspace(jamsWorkspace, compLibFile, libDir, uploadFileFilter)) == null) {
            return null;
        }
        this.runtime.getModel().getWorkspace().setID(ws.getId().intValue());
        InputStream inputStream = XMLTools.writeXmlToStream((Document)this.initialDoc);
        jams.server.entities.File f = client.files().uploadFile(inputStream);
        ws = client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, f, 2, this.savePath.getName()));
        Properties props = (Properties)JUICE.getJamsProperties().getProperties().clone();
        props.setProperty("libs", newLibs);
        props.setProperty("progressperiod", "1000");
        props.setProperty("progressfilename", "progress.log");
        inputStream = XMLTools.propertiesToStream((Properties)props);
        f = client.files().uploadFile(inputStream);
        ws = client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, f, 8, "cloud.jap"));
        return connector.startJob(ws, new File(this.savePath.getName()));
    }

    public static String getNextViewName() {
        return JAMS.i18n((String)"Model") + ++viewCounter;
    }

    public boolean save() {
        boolean result = false;
        Document doc = this.getModelDoc();
        try {
            result = XMLTools.writeXmlFile((Document)doc, (File)this.savePath);
        }
        catch (IOException ioe) {
            return false;
        }
        return result;
    }

    public ModelTree getTree() {
        return this.tree;
    }

    public void setTree(ModelTree tree) {
        this.tree = tree;
        this.modelTreePanel.setTree(tree);
        this.updateLauncherPanel();
    }

    public void updateLauncherPanel() {
        this.launcherPanel.updatePanel();
    }

    public TreePanel getModelTreePanel() {
        return this.modelTreePanel;
    }

    public void setModelTreePanel(TreePanel modelTreePanel) {
        this.modelTreePanel = modelTreePanel;
    }

    public File getSavePath() {
        return this.savePath;
    }

    public void setSavePath(File savePath) {
        if (savePath != null) {
            if (!savePath.getAbsolutePath().endsWith(".jam") && !savePath.getAbsolutePath().endsWith(".xml")) {
                savePath = new File(savePath.getAbsolutePath() + ".jam");
            }
            this.frame.setTitle(savePath.getAbsolutePath());
        }
        this.savePath = savePath;
    }

    public void loadParams(File paramsFile) {
        try {
            Document doc = ParameterProcessor.loadParams((Document)this.getModelDoc(), (File)paramsFile);
            this.modelDescriptor = new ModelDescriptor();
            this.setTree(new ModelTree(this, doc));
        }
        catch (Exception ex) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"File_") + paramsFile.getName() + JAMS.i18n((String)"_could_not_be_loaded.")), (String)JAMS.i18n((String)"File_open_error"));
        }
    }

    public void saveParams(File paramsFile) {
        try {
            String path = null;
            if (this.getSavePath() != null) {
                path = this.getSavePath().getAbsolutePath();
            }
            ParameterProcessor.saveParams((Document)this.getModelDoc(), (File)paramsFile, (String)JUICE.getJamsProperties().getProperty("username"), (String)path);
        }
        catch (Exception ex) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"File_") + paramsFile.getName() + JAMS.i18n((String)"_could_not_be_saved.")), (String)JAMS.i18n((String)"File_saving_error"));
        }
    }

    public boolean exit() {
        String oldXMLString;
        boolean returnValue = false;
        String newXMLString = XMLTools.getStringFromDocument((Document)this.getModelDoc());
        if (newXMLString.compareTo(oldXMLString = XMLTools.getStringFromDocument((Document)this.initialDoc)) != 0) {
            int result = GUIHelper.showYesNoCancelDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"Save_modifications_in_") + this.getFrame().getTitle() + JAMS.i18n((String)"_?")), (String)JAMS.i18n((String)"Unsaved_modifications"));
            if (result == 0) {
                JUICE.getJuiceFrame().saveModel(this);
                this.closeView();
                returnValue = true;
            } else if (result == 1) {
                this.closeView();
                returnValue = true;
            }
        } else {
            this.closeView();
            returnValue = true;
        }
        return returnValue;
    }

    private void closeView() {
        boolean maximized = this.getFrame().isMaximum();
        viewList.removeView(this.getFrame());
        this.parentPanel.remove(this.getFrame());
        this.getFrame().dispose();
        this.parentPanel.updateUI();
        if (maximized) {
            try {
                ModelView currentView = JUICE.getJuiceFrame().getCurrentView();
                if (currentView != null) {
                    currentView.getFrame().setMaximum(true);
                }
            }
            catch (PropertyVetoException pve) {
                JAMSTools.handle((Throwable)pve);
            }
        }
    }

    public Document getModelDoc() {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getModelDocument(this.getModelDescriptor());
    }

    public void loadModel(String fileName) {
        try {
            String newModelFilename = XMLProcessor.modelDocConverter((String)fileName);
            if (!newModelFilename.equalsIgnoreCase(fileName)) {
                GUIHelper.showInfoDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"The_model_definition_in_") + fileName + JAMS.i18n((String)"_has_been_adapted_in_order_to_meet_changes_in_the_JAMS_model_specification.The_new_definition_has_been_stored_in_") + newModelFilename + JAMS.i18n((String)"_while_your_original_file_was_left_untouched.")), (String)JAMS.i18n((String)"Info"));
            }
            fileName = newModelFilename;
            this.setSavePath(new File(fileName));
            this.setTree(new ModelTree(this, XMLTools.getDocument((String)fileName)));
            this.setInitialState();
        }
        catch (JAMSException jex) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"File_") + fileName + JAMS.i18n((String)"_could_not_be_loaded.") + "\n" + jex.getMessage()), (String)JAMS.i18n((String)"File_open_error"));
        }
        catch (Exception e) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Unknown_error_during_Model_loading"), (String)JAMS.i18n((String)"Error_loading_model"));
            e.printStackTrace();
        }
    }

    public void loadModel(Document doc) {
        try {
            this.setTree(new ModelTree(this, doc));
            this.setInitialState();
        }
        catch (Exception e) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Unknown_error_during_Model_loading"), (String)JAMS.i18n((String)"Error_loading_model"));
            e.printStackTrace();
        }
    }

    public JInternalFrame getFrame() {
        return this.frame;
    }

    public ComponentPanel getCompEditPanel() {
        return this.compEditPanel;
    }

    public ModelEditPanel getModelEditPanel() {
        return this.modelEditPanel;
    }

    public void setCompEditPanel(ComponentPanel compEditPanel) {
        this.compEditPanel = compEditPanel;
    }

    public void setInitialState() {
        this.initialDoc = this.getModelDoc();
    }

    public ModelDescriptor getModelDescriptor() {
        return this.modelDescriptor;
    }

    public void setModelDescriptor(ModelDescriptor md) {
        this.modelDescriptor = md;
    }

    private JAMSRuntime createRuntime() {
        StandardRuntime rt = new StandardRuntime(JUICE.getJamsProperties());
        rt.addInfoLogObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                JUICE.getJuiceFrame().getInfoDlg().appendText(obj.toString());
            }
        });
        rt.addErrorLogObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                JUICE.getJuiceFrame().getErrorDlg().appendText(obj.toString());
            }
        });
        return rt;
    }

    public JAMSWorkspace getWorkspace() {
        File workspaceFile = new File(this.getModelDescriptor().getWorkspacePath());
        if (!workspaceFile.isDirectory()) {
            if (this.getSavePath() != null) {
                workspaceFile = this.getSavePath().getParentFile();
            } else {
                return null;
            }
        }
        return new JAMSWorkspace(workspaceFile, this.createRuntime(), true);
    }

    public void openExplorer() {
        File workspaceFile = new File(this.getModelDescriptor().getWorkspacePath());
        if (!workspaceFile.isDirectory()) {
            if (this.getSavePath() != null) {
                workspaceFile = this.getSavePath().getParentFile();
            } else {
                GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)("\"" + workspaceFile + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
                return;
            }
        }
        try {
            if (theExplorer == null) {
                theExplorer = new JAMSExplorer(null, false);
            }
            if (theExplorer.getWorkspace() == null || !theExplorer.getWorkspace().getDirectory().equals(workspaceFile)) {
                theExplorer.getExplorerFrame().open(workspaceFile);
            }
            theExplorer.getExplorerFrame().setVisible(true);
        }
        catch (NoClassDefFoundError ncdfe) {
            Logger.getLogger(ModelView.class.getName()).log(Level.SEVERE, ncdfe.getMessage(), ncdfe);
            GUIHelper.showInfoDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"ExplorerDisabled"), (String)JAMS.i18n((String)"Info"));
        }
        catch (InvalidWorkspaceException ex) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)("\"" + workspaceFile + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
        }
    }

    public void openWSBrowser() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        File workspacePath = new File(XMLProcessor.getWorkspacePath((Document)this.getModelDoc()));
        if (!workspacePath.isDirectory()) {
            if (this.savePath != null) {
                workspacePath = this.savePath.getParentFile();
            } else {
                return;
            }
        }
        try {
            Desktop.getDesktop().open(workspacePath);
        }
        catch (IOException ex) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)("\"" + workspacePath + "\"" + JAMS.i18n((String)"Invalid_Workspace")), (String)JAMS.i18n((String)"Error"));
        }
    }

    public void createWS() {
    }

    public OutputDSDlg getOutputDSDlg() {
        if (this.outputDSDlg == null) {
            this.outputDSDlg = new OutputDSDlg((Frame)JUICE.getJuiceFrame(), this.getModelDescriptor());
        }
        return this.outputDSDlg;
    }
}

