/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.data.Attribute;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIHelper;
import jamsui.juice.gui.ModelView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class ModelEditPanel
extends JPanel {
    private static final int TEXTAREA_WIDTH = 450;
    private static final int TEXTAREA_HEIGHT = 100;
    private static final int TEXTFIELD_WIDTH = 35;
    private JPanel componentPanel;
    private GridBagLayout mainLayout;
    private ModelView view;
    private InputComponent workspace;
    private InputComponent author;
    private InputComponent date;
    private InputComponent helpBaseURL;
    private JTextPane description;

    public ModelEditPanel(ModelView view) {
        this.view = view;
        this.init();
    }

    private void init() {
        this.componentPanel = new JPanel();
        this.mainLayout = new GridBagLayout();
        this.componentPanel.setLayout(this.mainLayout);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Workspace:")), (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Author:")), (int)1, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Help_Base_URL:")), (int)1, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Date:")), (int)1, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Description:")), (int)1, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
        this.workspace = InputComponentFactory.createInputComponent(Attribute.DirName.class);
        this.workspace.setLength(35);
        this.author = InputComponentFactory.createInputComponent(Attribute.String.class);
        this.author.setLength(35);
        this.date = InputComponentFactory.createInputComponent(Attribute.Calendar.class);
        this.date.setLength(35);
        this.helpBaseURL = InputComponentFactory.createInputComponent(Attribute.String.class);
        this.helpBaseURL.setLength(35);
        this.description = new JTextPane();
        this.description.setContentType("text/plain;charset=UTF-8");
        this.description.setEditable(true);
        JScrollPane scroll = new JScrollPane(this.description);
        scroll.setBorder(BorderFactory.createEtchedBorder());
        scroll.setPreferredSize(new Dimension(450, 100));
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)this.workspace.getComponent(), (int)2, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)0, (int)17);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)this.author.getComponent(), (int)2, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)0, (int)17);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)this.helpBaseURL.getComponent(), (int)2, (int)5, (int)1, (int)1, (double)1.0, (double)1.0, (int)0, (int)17);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)this.date.getComponent(), (int)2, (int)3, (int)1, (int)1, (double)1.0, (double)1.0, (int)0, (int)17);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)this.mainLayout, (Component)scroll, (int)2, (int)4, (int)2, (int)1, (double)1.0, (double)1.0);
        this.workspace.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                ModelEditPanel.this.view.getModelDescriptor().setWorkspacePath(ModelEditPanel.this.workspace.getValue());
            }
        });
        this.author.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                ModelEditPanel.this.updateAuthor();
            }
        });
        this.date.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                ModelEditPanel.this.updateDate();
            }
        });
        this.helpBaseURL.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                ModelEditPanel.this.updateHelpBaseUrl();
            }
        });
        this.description.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ModelEditPanel.this.updateDescription();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ModelEditPanel.this.updateDescription();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ModelEditPanel.this.updateDescription();
            }
        });
        this.add(this.componentPanel);
    }

    public void updatePanel() {
        this.author.setValue(this.view.getModelDescriptor().getAuthor());
        this.date.setValue(this.view.getModelDescriptor().getDate());
        this.helpBaseURL.setValue(this.view.getModelDescriptor().getHelpBaseUrl());
        this.description.setText(this.view.getModelDescriptor().getDescription());
        this.workspace.setValue(this.view.getModelDescriptor().getWorkspacePath());
    }

    private void updateAuthor() {
        this.view.getModelDescriptor().setAuthor(this.author.getValue());
    }

    private void updateDate() {
        this.view.getModelDescriptor().setDate(this.date.getValue());
    }

    private void updateDescription() {
        try {
            this.view.getModelDescriptor().setDescription(this.description.getDocument().getText(0, this.description.getDocument().getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void updateHelpBaseUrl() {
        this.view.getModelDescriptor().setHelpBaseUrl(this.helpBaseURL.getValue());
    }
}

