/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.JAMSException;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelNode;
import jams.tools.StringTools;
import jamsui.juice.JUICE;
import jamsui.juice.gui.ComponentAttributePanel;
import jamsui.juice.gui.ContextAttributeDlg;
import jamsui.juice.gui.ModelView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ComponentPanel
extends JPanel {
    private static final String DEFAULT_STRING = JAMS.i18n((String)"[none]");
    private static final Dimension TABLE_DIMENSION = new Dimension(650, 300);
    private ComponentDescriptor componentDescriptor = null;
    private HashMap<String, JTextField> textFields = new HashMap();
    private JPanel componentPanel;
    private JTable varTable;
    private JTable attributeTable;
    private Vector<String> varTableColumnIds = new Vector();
    private Vector<String> attributeTableColumnIds = new Vector();
    private DefaultTableModel varTableModel;
    private DefaultTableModel attributeTableModel;
    private List<String> varNameList;
    private List<String> attrNameList;
    private List<Color> varValueFont;
    private int selectedVarRow;
    private int selectedAttrRow;
    private JButton attributeEditButton;
    private JButton attributeAddButton;
    private JButton attributeDeleteButton;
    private ContextAttributeDlg attrEditDlg;
    private ModelView view;
    private JTabbedPane tabPane;
    private ComponentAttributePanel attributeConfigPanel;
    private JPanel switchPanel;

    public ComponentPanel(ModelView view) {
        this.view = view;
        this.init();
    }

    private void init() {
        this.componentPanel = new JPanel();
        Font labelFont = (Font)UIManager.getDefaults().get("Label.font");
        labelFont = new Font(labelFont.getName(), 1, labelFont.getSize());
        GridBagLayout mainLayout = new GridBagLayout();
        this.componentPanel.setLayout(mainLayout);
        JLabel nameLabel = new JLabel(JAMS.i18n((String)"Name:"));
        nameLabel.setFont(labelFont);
        JLabel typeLabel = new JLabel(JAMS.i18n((String)"Type:"));
        typeLabel.setFont(labelFont);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)mainLayout, (Component)nameLabel, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)mainLayout, (Component)typeLabel, (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        JButton nameEditButton = new JButton(JAMS.i18n((String)"..."));
        nameEditButton.setMargin(new Insets(0, 0, 0, 0));
        nameEditButton.setPreferredSize(new Dimension(20, 20));
        nameEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String oldName = ((JTextField)ComponentPanel.this.textFields.get("name")).getText();
                String newName = GUIHelper.showInputDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"New_component_name"), (String)oldName);
                if (newName != null && !newName.equals(oldName)) {
                    ((JTextField)ComponentPanel.this.textFields.get("name")).setText(newName);
                    ComponentPanel.this.setComponentName();
                }
            }
        });
        JPanel namePanel = new JPanel();
        ((FlowLayout)namePanel.getLayout()).setVgap(0);
        namePanel.add(this.getTextField("name", "", false));
        namePanel.add(nameEditButton);
        JPanel typePanel = new JPanel();
        ((FlowLayout)typePanel.getLayout()).setVgap(0);
        typePanel.add(this.getTextField("type", "", false));
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)mainLayout, (Component)namePanel, (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)3, (int)17);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)mainLayout, (Component)typePanel, (int)1, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)3, (int)17);
        this.varTable = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                c.setForeground(ComponentPanel.this.getCellFontColor(row, column));
                return c;
            }
        };
        this.varTable.setSelectionMode(0);
        ListSelectionModel varRowSM = this.varTable.getSelectionModel();
        varRowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    ComponentPanel.this.selectedVarRow = lsm.getMinSelectionIndex();
                } else {
                    ComponentPanel.this.selectedVarRow = -1;
                }
                ComponentPanel.this.updateAttributeConfigPanel();
            }
        });
        this.varTableColumnIds.add(JAMS.i18n((String)"Name"));
        this.varTableColumnIds.add(JAMS.i18n((String)"Type"));
        this.varTableColumnIds.add("R/W");
        this.varTableColumnIds.add(JAMS.i18n((String)"Context_Attribute"));
        this.varTableColumnIds.add(JAMS.i18n((String)"Value"));
        this.varTableColumnIds.add(JAMS.i18n((String)"Unit"));
        this.varTableModel = new DefaultTableModel(this.varTableColumnIds, 0);
        this.varTable.setModel(this.varTableModel);
        this.varTable.setAutoResizeMode(3);
        JScrollPane varTableScroll = new JScrollPane(this.varTable);
        varTableScroll.setPreferredSize(TABLE_DIMENSION);
        JPanel varPanel = new JPanel();
        varPanel.setLayout(new BorderLayout());
        varPanel.add((Component)varTableScroll, "Center");
        this.attributeTable = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.attributeTable.setSelectionMode(0);
        ListSelectionModel attrRowSM = this.attributeTable.getSelectionModel();
        attrRowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    ComponentPanel.this.selectedAttrRow = lsm.getMinSelectionIndex();
                    ComponentPanel.this.attributeEditButton.setEnabled(true);
                    ComponentPanel.this.attributeDeleteButton.setEnabled(true);
                } else {
                    ComponentPanel.this.selectedAttrRow = -1;
                    ComponentPanel.this.attributeEditButton.setEnabled(false);
                    ComponentPanel.this.attributeDeleteButton.setEnabled(false);
                }
            }
        });
        this.attributeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ComponentPanel.this.showAttributeEditDlg();
                }
            }
        });
        this.attributeTableColumnIds.add(JAMS.i18n((String)"Name"));
        this.attributeTableColumnIds.add(JAMS.i18n((String)"Type"));
        this.attributeTableColumnIds.add(JAMS.i18n((String)"Value"));
        this.attributeTableModel = new DefaultTableModel(this.attributeTableColumnIds, 0);
        this.attributeTable.setModel(this.attributeTableModel);
        this.attributeTable.setAutoResizeMode(3);
        JScrollPane attributeTableScroll = new JScrollPane(this.attributeTable);
        attributeTableScroll.setPreferredSize(TABLE_DIMENSION);
        JPanel attributePanel = new JPanel();
        attributePanel.setLayout(new BorderLayout());
        attributePanel.add((Component)attributeTableScroll, "Center");
        this.attributeEditButton = new JButton(JAMS.i18n((String)"Edit"));
        this.attributeEditButton.setEnabled(false);
        this.attributeEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentPanel.this.showAttributeEditDlg();
            }
        });
        this.attributeAddButton = new JButton(JAMS.i18n((String)"Add"));
        this.attributeAddButton.setEnabled(true);
        this.attributeAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentPanel.this.showAttributeAddDlg();
            }
        });
        this.attributeDeleteButton = new JButton(JAMS.i18n((String)"Delete"));
        this.attributeDeleteButton.setEnabled(false);
        this.attributeDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentPanel.this.showAttributeDeleteDlg();
            }
        });
        JPanel attributeButtonPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        attributeButtonPanel.setLayout(gbl);
        GUIHelper.addGBComponent((Container)attributeButtonPanel, (GridBagLayout)gbl, (Component)this.attributeAddButton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)attributeButtonPanel, (GridBagLayout)gbl, (Component)this.attributeDeleteButton, (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)attributeButtonPanel, (GridBagLayout)gbl, (Component)this.attributeEditButton, (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)attributeButtonPanel, (GridBagLayout)gbl, (Component)new JPanel(), (int)0, (int)3, (int)1, (int)1, (double)1.0, (double)1.0);
        attributePanel.add((Component)attributeButtonPanel, "East");
        this.tabPane = new JTabbedPane();
        this.tabPane.add(JAMS.i18n((String)"Component_attributes"), varPanel);
        this.tabPane.add(JAMS.i18n((String)"Context_attributes"), attributePanel);
        this.tabPane.setEnabledAt(1, false);
        this.attributeConfigPanel = new ComponentAttributePanel();
        this.switchPanel = new JPanel();
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)mainLayout, (Component)this.tabPane, (int)0, (int)20, (int)4, (int)1, (double)1.0, (double)1.0, (int)3, (int)17);
        GUIHelper.addGBComponent((Container)this.componentPanel, (GridBagLayout)mainLayout, (Component)this.switchPanel, (int)0, (int)30, (int)4, (int)1, (double)1.0, (double)1.0);
        this.switchPanel.add(this.attributeConfigPanel);
        ((FlowLayout)this.switchPanel.getLayout()).setHgap(0);
        ((FlowLayout)this.switchPanel.getLayout()).setVgap(0);
        this.reset(DEFAULT_STRING);
        this.setLayout(new FlowLayout(0));
        this.add(this.componentPanel);
    }

    private Color getCellFontColor(int row, int column) {
        if (column != 4) {
            return Color.BLACK;
        }
        return this.varValueFont.get(row);
    }

    private void showAttributeEditDlg() {
        int tmpSelectedAttrRow = this.selectedAttrRow;
        if (this.attrEditDlg == null) {
            this.attrEditDlg = new ContextAttributeDlg(JUICE.getJuiceFrame());
        }
        String attributeName = this.attrNameList.get(this.selectedAttrRow);
        ContextAttribute attr = (ContextAttribute)((ContextDescriptor)this.componentDescriptor).getStaticAttributes().get(attributeName);
        this.attrEditDlg.show(attr.getName(), attr.getType(), attr.getValue());
        if (this.attrEditDlg.getResult() == 1) {
            attr.setValue(this.attrEditDlg.getValue());
            attr.setType(this.attrEditDlg.getAttributeType());
            try {
                attr.setName(this.attrEditDlg.getAttributeName());
            }
            catch (JAMSException ex) {
                GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)ex.getMessage(), (String)ex.getHeader());
                Logger.getLogger(ComponentPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateCtxtAttrs();
            this.attributeTable.setRowSelectionInterval(tmpSelectedAttrRow, tmpSelectedAttrRow);
        }
    }

    private void showAttributeAddDlg() {
        if (this.attrEditDlg == null) {
            this.attrEditDlg = new ContextAttributeDlg(JUICE.getJuiceFrame());
        }
        this.attrEditDlg.show("", JUICE.JAMS_DATA_TYPES[10], "");
        if (this.attrEditDlg.getResult() == 1) {
            try {
                ((ContextDescriptor)this.componentDescriptor).addStaticAttribute(this.attrEditDlg.getAttributeName(), this.attrEditDlg.getAttributeType(), this.attrEditDlg.getValue());
                this.updateCtxtAttrs();
            }
            catch (JAMSException ex) {
                GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)ex.getMessage(), (String)ex.getHeader());
                Logger.getLogger(ComponentPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void showAttributeDeleteDlg() {
        int tmpSelectedAttrRow = this.selectedAttrRow;
        String attrName = this.attrNameList.get(this.selectedAttrRow);
        int result = GUIHelper.showYesNoDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"Delete_Attribute_") + attrName + "\"?"), (String)JAMS.i18n((String)"Confirm"));
        if (result == 1) {
            return;
        }
        ((ContextDescriptor)this.componentDescriptor).removeStaticAttribute(attrName);
        this.updateCtxtAttrs();
        if (tmpSelectedAttrRow > this.attributeTable.getRowCount() - 1) {
            --tmpSelectedAttrRow;
        }
        if (tmpSelectedAttrRow >= 0) {
            this.attributeTable.setRowSelectionInterval(tmpSelectedAttrRow, tmpSelectedAttrRow);
        }
    }

    public JTextField getTextField(String key, String value, boolean editable) {
        JTextField text = new JTextField();
        text.setBorder(BorderFactory.createEtchedBorder());
        text.setEditable(editable);
        text.setText(value);
        text.setColumns(30);
        this.textFields.put(key, text);
        return text;
    }

    public void setComponentDescriptor(ComponentDescriptor cd) {
        this.componentDescriptor = cd;
        if (this.componentDescriptor.getType() == 2) {
            if (this.switchPanel.getComponents()[0] != this.view.getModelEditPanel()) {
                this.switchPanel.remove(this.switchPanel.getComponents()[0]);
                this.view.getModelEditPanel().setPreferredSize(this.switchPanel.getSize());
                this.switchPanel.add(this.view.getModelEditPanel());
                this.switchPanel.updateUI();
            }
        } else if (this.switchPanel.getComponents()[0] != this.attributeConfigPanel) {
            this.switchPanel.remove(this.switchPanel.getComponents()[0]);
            this.attributeConfigPanel.setPreferredSize(new Dimension(this.switchPanel.getSize().width - 10, this.switchPanel.getSize().height));
            this.switchPanel.add(this.attributeConfigPanel);
            this.updateUI();
        }
        if (this.componentDescriptor.getType() == 0) {
            this.tabPane.setEnabledAt(1, false);
            this.tabPane.setEnabledAt(0, true);
            this.tabPane.setSelectedIndex(0);
        } else if (this.componentDescriptor.getType() == 2) {
            this.tabPane.setEnabledAt(0, false);
            this.tabPane.setEnabledAt(1, true);
            this.tabPane.setSelectedIndex(1);
        } else {
            this.tabPane.setEnabledAt(0, true);
            this.tabPane.setEnabledAt(1, true);
        }
        this.textFields.get("type").setText(this.componentDescriptor.getClazz().getCanonicalName());
        this.textFields.get("name").setText(this.componentDescriptor.getInstanceName());
        this.updateCmpAttrs();
        this.updateCtxtAttrs();
        this.componentDescriptor.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg == null) {
                    return;
                }
                ComponentField var = (ComponentField)arg;
                int i = 0;
                for (String name : ComponentPanel.this.varNameList) {
                    if (var.getName().equals(name)) {
                        if (!var.getAttribute().equals("")) {
                            ComponentPanel.this.varTable.getModel().setValueAt(var.getContext() + "." + var.getAttribute(), i, 3);
                        } else {
                            ComponentPanel.this.varTable.getModel().setValueAt("", i, 3);
                        }
                        if (StringTools.isEmptyString((String)var.getValue())) {
                            if (!"%NULL%".equals(var.getDefaultValue())) {
                                ComponentPanel.this.varTable.getModel().setValueAt(var.getDefaultValue(), i, 4);
                            } else {
                                ComponentPanel.this.varTable.getModel().setValueAt("", i, 4);
                            }
                            ComponentPanel.this.varValueFont.set(i, Color.LIGHT_GRAY);
                            break;
                        }
                        ComponentPanel.this.varTable.getModel().setValueAt(var.getValue(), i, 4);
                        ComponentPanel.this.varValueFont.set(i, Color.BLACK);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    public void updateCtxtAttrs() {
        if (!(this.componentDescriptor instanceof ContextDescriptor)) {
            return;
        }
        this.selectedAttrRow = -1;
        HashMap attributes = ((ContextDescriptor)this.componentDescriptor).getStaticAttributes();
        this.attrNameList = new ArrayList(attributes.keySet());
        Collections.sort(this.attrNameList);
        Vector tableData = new Vector();
        for (String name : this.attrNameList) {
            ContextAttribute attr = (ContextAttribute)attributes.get(name);
            Vector<String> rowData = new Vector<String>();
            rowData.add(attr.getName());
            rowData.add(attr.getType().getSimpleName());
            rowData.add(attr.getValue());
            tableData.add(rowData);
        }
        this.attributeTableModel.setDataVector(tableData, this.attributeTableColumnIds);
        this.attributeTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.attributeTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.attributeTable.getColumnModel().getColumn(2).setPreferredWidth(150);
    }

    private void updateCmpAttrs() {
        this.selectedVarRow = -1;
        this.varNameList = this.componentDescriptor.getComponentFieldList();
        this.varValueFont = new ArrayList<Color>();
        Vector tableData = new Vector();
        for (String name : this.varNameList) {
            ComponentField var = (ComponentField)this.componentDescriptor.getComponentFields().get(name);
            Vector<String> rowData = new Vector<String>();
            rowData.add(var.getName());
            String type = var.getType().getSimpleName();
            rowData.add(type);
            String accessType = "";
            if (var.getAccessType() == 0) {
                accessType = "R";
            }
            if (var.getAccessType() == 1) {
                accessType = "W";
            }
            if (var.getAccessType() == 2) {
                accessType = "R/W";
            }
            rowData.add(accessType);
            if (!var.getAttribute().equals("")) {
                rowData.add(var.getContext() + "." + var.getAttribute());
            } else {
                rowData.add("");
            }
            if (StringTools.isEmptyString((String)var.getValue())) {
                if (!"%NULL%".equals(var.getDefaultValue())) {
                    rowData.add(var.getDefaultValue());
                } else {
                    rowData.add("");
                }
                this.varValueFont.add(Color.LIGHT_GRAY);
            } else {
                rowData.add(var.getValue());
                this.varValueFont.add(Color.BLACK);
            }
            rowData.add(var.getUnit());
            tableData.add(rowData);
        }
        this.varTableModel.setDataVector(tableData, this.varTableColumnIds);
        this.varTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.varTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.varTable.getColumnModel().getColumn(2).setMaxWidth(35);
        this.varTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.varTable.getColumnModel().getColumn(5).setPreferredWidth(30);
    }

    public void reset(String clazz) {
        for (JTextField text : this.textFields.values()) {
            text.setText(DEFAULT_STRING);
        }
        this.textFields.get("type").setText(clazz);
    }

    private void setComponentName() {
        String name = this.textFields.get("name").getText();
        if (this.componentDescriptor != null) {
            try {
                this.componentDescriptor.setInstanceName(name);
            }
            catch (JAMSException ex) {
                GUIHelper.showInfoDlg((Component)JUICE.getJuiceFrame(), (String)ex.getMessage(), (String)ex.getHeader());
                Logger.getLogger(ComponentPanel.class.getName()).log(Level.WARNING, null, ex);
            }
            this.textFields.get("name").setText(this.componentDescriptor.getInstanceName());
        }
    }

    private void updateAttributeConfigPanel() {
        if (this.selectedVarRow < 0) {
            this.attributeConfigPanel.cleanup();
            return;
        }
        String attributeName = this.varNameList.get(this.selectedVarRow);
        ComponentField attr = (ComponentField)this.componentDescriptor.getComponentFields().get(attributeName);
        ArrayList<ComponentDescriptor> ancestors = new ArrayList<ComponentDescriptor>();
        for (ModelNode ancestor = (ModelNode)this.componentDescriptor.getNode().getParent(); ancestor != null; ancestor = (ModelNode)ancestor.getParent()) {
            ancestors.add((ComponentDescriptor)ancestor.getUserObject());
        }
        ComponentDescriptor[] ancestorArray = ancestors.toArray(new ComponentDescriptor[ancestors.size()]);
        this.attributeConfigPanel.update(this.componentDescriptor, attr, ancestorArray);
    }
}

