/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.data.DefaultDataFactory;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.tools.StringTools;
import jamsui.juice.JUICE;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class ComponentAttributePanel
extends JPanel {
    private JComboBox contextCombo;
    private InputComponent valueInput;
    private GridBagLayout infoLayout;
    private JTextField localNameText;
    private JTextField linkText;
    private JTextPane descriptionText;
    private JButton customAttributeButton;
    private JPanel listPanel;
    private JPanel infoPanel;
    private JPanel valuePanel;
    private Class type;
    private JList attributeList;
    private JToggleButton linkButton;
    private JToggleButton setButton;
    private ComponentField field;
    private ActionListener linkButtonListener;
    private ActionListener setButtonListener;
    private ItemListener contextComboListener;
    private ListSelectionListener attributeListListener;
    private ComponentDescriptor component;
    private boolean adjusting = false;

    public ComponentAttributePanel() {
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger(this.getClass().getName()));
        this.setLayout(new BorderLayout());
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new BorderLayout());
        this.listPanel.setPreferredSize(new Dimension(200, 300));
        this.infoPanel = new JPanel();
        this.infoLayout = new GridBagLayout();
        this.infoPanel.setLayout(this.infoLayout);
        JPanel detailPanel = new JPanel();
        detailPanel.setLayout(new BorderLayout());
        detailPanel.setBackground(Color.blue);
        this.add((Component)this.infoPanel, "Center");
        this.add((Component)this.listPanel, "East");
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)new JLabel(JAMS.i18n((String)"Local_name:")), (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0, (int)0, (int)18);
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)new JLabel(JAMS.i18n((String)"Link:")), (int)0, (int)15, (int)1, (int)1, (double)0.0, (double)0.0, (int)0, (int)18);
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)new JLabel(JAMS.i18n((String)"Value:")), (int)0, (int)20, (int)1, (int)1, (double)0.0, (double)0.0, (int)0, (int)18);
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)new JLabel(JAMS.i18n((String)"Info:")), (int)0, (int)12, (int)1, (int)1, (double)0.0, (double)0.0, (int)0, (int)18);
        this.localNameText = new JTextField();
        this.localNameText.setEditable(false);
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)this.localNameText, (int)1, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        this.linkText = new JTextField();
        this.linkText.setEditable(false);
        this.linkText.setPreferredSize(new Dimension(320, 0));
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)this.linkText, (int)1, (int)15, (int)1, (int)1, (double)1.0, (double)0.0);
        this.linkButton = new JToggleButton("LINK");
        this.linkButton.setMargin(new Insets(1, 1, 1, 1));
        this.linkButton.setFocusable(false);
        this.linkButton.setPreferredSize(new Dimension(40, 20));
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)this.linkButton, (int)2, (int)15, (int)1, (int)1, (double)0.0, (double)0.0, (int)0, (int)11);
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new BorderLayout());
        this.valuePanel.setPreferredSize(new Dimension(320, 140));
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)this.valuePanel, (int)1, (int)20, (int)1, (int)1, (double)1.0, (double)0.0, (int)1, (int)18);
        this.setButton = new JToggleButton("SET");
        this.setButton.setMargin(new Insets(1, 1, 1, 1));
        this.setButton.setFocusable(false);
        this.setButton.setPreferredSize(new Dimension(40, 20));
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)this.setButton, (int)2, (int)20, (int)1, (int)1, (double)0.0, (double)0.0, (int)0, (int)11);
        this.descriptionText = new JTextPane();
        this.descriptionText.setContentType("text/plain");
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(this.localNameText.getBackground());
        JScrollPane scroll = new JScrollPane(this.descriptionText);
        scroll.setPreferredSize(new Dimension(320, 40));
        GUIHelper.addGBComponent((Container)this.infoPanel, (GridBagLayout)this.infoLayout, (Component)scroll, (int)1, (int)12, (int)1, (int)1, (double)1.0, (double)0.0, (int)1, (int)18);
        this.contextCombo = new JComboBox();
        this.listPanel.add((Component)this.contextCombo, "North");
        this.customAttributeButton = new JButton(JAMS.i18n((String)"Custom_Attribute"));
        this.customAttributeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ContextDescriptor context = (ContextDescriptor)ComponentAttributePanel.this.contextCombo.getSelectedItem();
                    String name = GUIHelper.showInputDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Custom_Attribute"), null);
                    if (name == null) {
                        return;
                    }
                    if (ComponentAttributePanel.this.type.isArray()) {
                        context.addDynamicAttribute(name, DefaultDataFactory.getDataFactory().getBelongingInterface(ComponentAttributePanel.this.type.getComponentType()));
                    } else {
                        context.addDynamicAttribute(name, DefaultDataFactory.getDataFactory().getBelongingInterface(ComponentAttributePanel.this.type));
                    }
                    ComponentAttributePanel.this.updateRepository();
                    ComponentAttributePanel.this.updateAttributeLinkGUI();
                    if (ComponentAttributePanel.this.attributeList.getModel().getSize() > 0) {
                        int listIndex = ComponentAttributePanel.this.attributeList.getNextMatch(name, 0, Position.Bias.Forward);
                        ComponentAttributePanel.this.attributeList.scrollRectToVisible(ComponentAttributePanel.this.attributeList.getCellBounds(listIndex, listIndex));
                    }
                }
                catch (JAMSException ex) {
                    Logger.getLogger(ComponentAttributePanel.class.getName()).warning(ex.getHeader() + "\n" + ex.getMessage());
                }
            }
        });
        this.listPanel.add((Component)this.customAttributeButton, "South");
        this.attributeList = new JList();
        JScrollPane listScroll = new JScrollPane(this.attributeList);
        this.listPanel.add((Component)listScroll, "Center");
        this.createListeners();
        this.addListeners();
        this.cleanup();
    }

    private void setAttributeLink() {
        if (this.adjusting) {
            return;
        }
        String attributeString = "";
        Object[] values = this.attributeList.getSelectedValues();
        if (values.length > 0) {
            for (Object o : values) {
                attributeString = attributeString + ";" + o;
            }
            attributeString = attributeString.substring(1);
        }
        ContextDescriptor context = (ContextDescriptor)this.contextCombo.getSelectedItem();
        if (!attributeString.equals("") && context != null) {
            this.linkButton.setEnabled(true);
        } else {
            this.linkButton.setEnabled(false);
        }
        if (this.linkButton.isSelected() && !attributeString.equals("") && context != null) {
            try {
                this.field.linkToAttribute(context, attributeString);
            }
            catch (JAMSException ex) {
                Logger.getLogger(ComponentAttributePanel.class.getName()).warning(ex.getHeader() + "\n" + ex.getMessage());
            }
            this.linkText.setText(this.field.getContext() + "." + this.field.getAttribute());
        }
        if (!this.linkButton.isSelected()) {
            this.field.unlinkFromAttribute();
            this.linkText.setText("");
        }
        this.component.setChanged();
        this.component.notifyObservers((Object)this.field);
    }

    private void setAttributeValue(boolean setButtonPressed) {
        if (this.adjusting) {
            return;
        }
        if (this.setButton.isSelected()) {
            if (!this.valueInput.verify()) {
                if (setButtonPressed) {
                    GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Invalid_value!"), null);
                }
                return;
            }
            this.field.setValue(this.valueInput.getValue());
        } else {
            this.field.setValue(null);
        }
        this.component.setChanged();
        this.component.notifyObservers((Object)this.field);
    }

    private void updateAttributeLinkGUI() {
        if (this.field.getContextAttributes().isEmpty()) {
            this.linkButton.setSelected(false);
            this.linkText.setText("");
            if (this.contextCombo.getItemCount() > 0) {
                this.contextCombo.setSelectedIndex(0);
            }
            this.attributeList.setSelectedValue(null, true);
        } else {
            this.linkButton.setSelected(true);
            this.linkText.setText(this.field.getContext() + "." + this.field.getAttribute());
            this.contextCombo.setSelectedItem(this.field.getContext());
            if (this.type.isArray()) {
                String[] values = this.field.getAttribute().split(";");
                ArrayList<String> valueList = new ArrayList<String>();
                for (String value : values) {
                    valueList.add(value);
                }
                int[] indices = new int[values.length];
                int c = 0;
                for (int i = 0; i < this.attributeList.getModel().getSize(); ++i) {
                    String value;
                    value = (String)this.attributeList.getModel().getElementAt(i);
                    if (!valueList.contains(value)) continue;
                    indices[c++] = i;
                }
                this.attributeList.setSelectedIndices(indices);
            } else {
                this.attributeList.setSelectedValue(this.field.getAttribute().toString(), true);
            }
        }
        if (StringTools.isEmptyString((String)this.field.getValue())) {
            this.setButton.setSelected(false);
        } else {
            this.setButton.setSelected(true);
        }
        this.valueInput.setValue(this.field.getValue());
        if (this.attributeList.isSelectionEmpty()) {
            this.linkButton.setEnabled(false);
        } else {
            this.linkButton.setEnabled(true);
        }
    }

    public void update(ComponentDescriptor component, ComponentField var, ComponentDescriptor[] ancestorArray) {
        this.adjusting = true;
        this.field = var;
        this.type = var.getType();
        this.component = component;
        this.localNameText.setText(var.getName());
        this.descriptionText.setText(var.getDescription());
        this.descriptionText.setCaretPosition(0);
        this.contextCombo.setModel(new DefaultComboBoxModel<ComponentDescriptor>(ancestorArray));
        this.updateRepository();
        if (var.getAccessType() == 0 && !this.type.isArray()) {
            this.customAttributeButton.setEnabled(true);
        } else {
            this.customAttributeButton.setEnabled(true);
        }
        if (this.valueInput != null) {
            this.valuePanel.remove(this.valueInput.getComponent());
        }
        this.valueInput = InputComponentFactory.createInputComponent((Class)var.getType(), (boolean)true);
        this.valuePanel.add((Component)this.valueInput.getComponent(), "North");
        this.valuePanel.updateUI();
        this.setButton.setEnabled(true);
        this.updateAttributeLinkGUI();
        this.valueInput.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged() {
                ComponentAttributePanel.this.setAttributeValue(false);
            }
        });
        this.adjusting = false;
    }

    private void updateRepository() {
        ContextDescriptor context = (ContextDescriptor)this.contextCombo.getSelectedItem();
        if (context == null) {
            return;
        }
        ArrayList<ContextAttribute> attributes = new ArrayList<ContextAttribute>();
        for (ContextAttribute attribute : context.getAttributes(this.type).values()) {
            attributes.add(attribute);
        }
        Collections.sort(attributes, new Comparator<ContextAttribute>(){

            @Override
            public int compare(ContextAttribute a1, ContextAttribute a2) {
                return a1.toString().compareTo(a2.toString());
            }
        });
        if (this.type.isArray()) {
            // empty if block
        }
        DefaultListModel<String> lModel = new DefaultListModel<String>();
        if (attributes != null) {
            Collections.sort(attributes, new Comparator<ContextAttribute>(){

                @Override
                public int compare(ContextAttribute a1, ContextAttribute a2) {
                    return a1.toString().compareTo(a2.toString());
                }
            });
            for (int i = 0; i < attributes.size(); ++i) {
                String attributeName = ((ContextAttribute)attributes.get(i)).toString();
                lModel.addElement(attributeName);
            }
        }
        if (this.type.isArray()) {
            this.attributeList.setSelectionMode(2);
            this.attributeList.setEnabled(true);
        } else {
            this.attributeList.setSelectionMode(0);
            this.attributeList.setEnabled(true);
        }
        this.attributeList.setModel(lModel);
    }

    public void cleanup() {
        this.adjusting = true;
        this.contextCombo.setModel(new DefaultComboBoxModel());
        this.attributeList.setModel(new DefaultListModel());
        this.localNameText.setText(null);
        this.descriptionText.setText(null);
        this.linkText.setText(null);
        if (this.valueInput != null) {
            this.valuePanel.remove(this.valueInput.getComponent());
            this.valuePanel.updateUI();
        }
        this.linkButton.setSelected(false);
        this.linkButton.setEnabled(false);
        this.setButton.setSelected(false);
        this.setButton.setEnabled(false);
        this.customAttributeButton.setEnabled(false);
        this.adjusting = false;
    }

    private void createListeners() {
        this.linkButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentAttributePanel.this.setAttributeLink();
            }
        };
        this.setButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentAttributePanel.this.setAttributeValue(true);
            }
        };
        this.contextComboListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ComponentAttributePanel.this.updateRepository();
                }
            }
        };
        this.attributeListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ComponentAttributePanel.this.setAttributeLink();
                }
            }
        };
    }

    private void removeListeners_() {
        this.linkButton.removeActionListener(this.linkButtonListener);
        this.setButton.removeActionListener(this.setButtonListener);
        this.contextCombo.removeItemListener(this.contextComboListener);
        this.attributeList.removeListSelectionListener(this.attributeListListener);
    }

    private void addListeners() {
        this.linkButton.addActionListener(this.linkButtonListener);
        this.setButton.addActionListener(this.setButtonListener);
        this.contextCombo.addItemListener(this.contextComboListener);
        this.attributeList.addListSelectionListener(this.attributeListListener);
    }
}

