/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.CompoundAnimator;
import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.gl2.GLUgl2;

public class ViewUtil {
    public static AngleAnimator createHeadingAnimator(View view, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = AnimationSupport.getScaledTimeMillisecs(angle, angle2, Angle.POS180, 500L, 3000L);
        return new AngleAnimator(new ScheduledInterpolator(l), angle, angle2, new ViewPropertyAccessor.HeadingAccessor(view));
    }

    public static AngleAnimator createPitchAnimator(View view, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = AnimationSupport.getScaledTimeMillisecs(angle, angle2, Angle.POS180, 500L, 3000L);
        return new AngleAnimator(new ScheduledInterpolator(l), angle, angle2, new ViewPropertyAccessor.PitchAccessor(view));
    }

    public static AngleAnimator createRollAnimator(View view, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = AnimationSupport.getScaledTimeMillisecs(angle, angle2, Angle.POS180, 500L, 3000L);
        return new AngleAnimator(new ScheduledInterpolator(l), angle, angle2, new ViewPropertyAccessor.RollAccessor(view));
    }

    public static CompoundAnimator createHeadingPitchRollAnimator(View view, Angle angle, Angle angle2, Angle angle3, Angle angle4, Angle angle5, Angle angle6) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null || angle5 == null || angle6 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = AnimationSupport.getScaledTimeMillisecs(angle, angle2, Angle.POS180, 500L, 3000L);
        long l2 = AnimationSupport.getScaledTimeMillisecs(angle3, angle4, Angle.POS90, 500L, 1500L);
        long l3 = AnimationSupport.getScaledTimeMillisecs(angle5, angle6, Angle.POS90, 500L, 1500L);
        long l4 = l + l2 + l3;
        AngleAnimator angleAnimator = ViewUtil.createHeadingAnimator(view, angle, angle2);
        AngleAnimator angleAnimator2 = ViewUtil.createPitchAnimator(view, angle3, angle4);
        AngleAnimator angleAnimator3 = ViewUtil.createRollAnimator(view, angle5, angle6);
        CompoundAnimator compoundAnimator = new CompoundAnimator(new ScheduledInterpolator(l4), angleAnimator, angleAnimator2, angleAnimator3);
        return compoundAnimator;
    }

    public static PositionAnimator createEyePositionAnimator(View view, long l, Position position, Position position2) {
        return new PositionAnimator(new ScheduledInterpolator(l), position, position2, ViewPropertyAccessor.createEyePositionAccessor(view));
    }

    public static Point subtract(Point point, Point point2) {
        if (point == null || point2 == null) {
            return null;
        }
        return new Point((int)(point.getX() - point2.getX()), (int)(point.getY() - point2.getY()));
    }

    public static Matrix computeTransformMatrix(Globe globe, Position position, Angle angle, Angle angle2, Angle angle3) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.PitchIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(Matrix.fromAxisAngle(angle3, 0.0, 0.0, 1.0));
        matrix = matrix.multiply(Matrix.fromAxisAngle(angle2, -1.0, 0.0, 0.0));
        matrix = matrix.multiply(Matrix.fromAxisAngle(angle, 0.0, 0.0, 1.0));
        matrix = matrix.multiply(ViewUtil.computePositionTransform(globe, position));
        return matrix;
    }

    public static Matrix computePositionTransform(Globe globe, Position position) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = globe.computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude());
        return Matrix.fromViewLookAt(vec4, vec43, vec44);
    }

    public static Matrix computeModelViewMatrix(Globe globe, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = "nullValue.EyePointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec42 == null) {
            String string = "nullValue.CenterPointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec43 == null) {
            String string = "nullValue.UpIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        return matrix;
    }

    public static Vec4 getUpVector(Globe globe, Vec4 vec4) {
        return globe.computeSurfaceNormalAtPoint(vec4);
    }

    public static ViewState computeViewState(Globe globe, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = "nullValue.EyePointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec42 == null) {
            String string = "nullValue.CenterPointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec43 == null) {
            vec43 = ViewUtil.getUpVector(globe, vec42);
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        return ViewUtil.computeModelCoordinates(globe, matrix, vec42, vec4);
    }

    public static ViewState computeModelCoordinates(Globe globe, Matrix matrix, Vec4 vec4, Vec4 vec42) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = "nullValue.ModelTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = globe.computePositionFromPoint(vec4);
        Matrix matrix2 = ViewUtil.computePositionTransform(globe, position);
        Matrix matrix3 = matrix2.getInverse();
        if (matrix3 == null) {
            String string = Logging.getMessage("generic.NoninvertibleMatrix");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Matrix matrix4 = matrix.multiply(matrix3);
        Angle angle = ViewUtil.computeHeading(matrix4);
        Angle angle2 = ViewUtil.computePitch(matrix4);
        if (angle == null || angle2 == null) {
            return null;
        }
        Position position2 = globe.computePositionFromPoint(vec42);
        return new ViewState(position2, angle, angle2, Angle.ZERO);
    }

    public static Angle computeHeading(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return matrix.getRotationZ();
    }

    public static Angle computePitch(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = matrix.getRotationX();
        if (angle != null) {
            angle = angle.multiply(-1.0);
        }
        return angle;
    }

    public static Angle computeRoll(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return matrix.getRotationY();
    }

    public static Position computePosition(Globe globe, Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = matrix.getTranslation();
        Position position = globe.computePositionFromPoint(vec4);
        return position != null ? position : Position.ZERO;
    }

    public static boolean validateViewState(ViewState viewState) {
        return viewState != null && viewState.position != null && viewState.position.getLatitude().degrees >= -90.0 && viewState.position.getLatitude().degrees <= 90.0 && viewState.heading != null && viewState.pitch != null && viewState.pitch.degrees >= 0.0 && viewState.pitch.degrees <= 90.0;
    }

    public static Position normalizedEyePosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Position(Angle.normalizedLatitude(position.getLatitude()), Angle.normalizedLongitude(position.getLongitude()), position.getElevation());
    }

    public static Angle normalizedHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    public static Angle normalizedPitch(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    public static Angle normalizedRoll(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    public static Line computeRayFromScreenPoint(View view, double d, double d2, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (matrix == null || matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix3 = matrix.getInverse();
        if (matrix3 == null) {
            return null;
        }
        Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix3);
        if (vec4 == null) {
            return null;
        }
        double d3 = (double)rectangle.height - d2 - 1.0;
        Vec4 vec42 = view.unProject(new Vec4(d, d3, 0.0, 0.0));
        Vec4 vec43 = view.unProject(new Vec4(d, d3, 1.0, 0.0));
        if (vec42 == null || vec43 == null) {
            return null;
        }
        return new Line(vec4, vec43.subtract3(vec42).normalize3());
    }

    public static double computePixelSizeAtDistance(double d, Angle angle, Rectangle rectangle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = rectangle.getWidth();
        double d3 = 2.0 * angle.tanHalfAngle() / (d2 <= 0.0 ? 1.0 : d2);
        return Math.abs(d) * d3;
    }

    public static double computeHorizonDistance(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = globe.getMaximumRadius();
        return Math.sqrt(d * (2.0 * d2 + d));
    }

    public static Angle computeVerticalFieldOfView(Angle angle, Rectangle rectangle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.FOVIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = rectangle.getHeight() / rectangle.getWidth();
        double d2 = 1.0 / angle.tanHalfAngle();
        double d3 = 2.0 * Math.atan(d / d2);
        return Angle.fromRadians(d3);
    }

    public static double computeElevationAboveSurface(DrawContext drawContext, Position position) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        if (globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = null;
        Vec4 vec4 = drawContext.getPointOnTerrain(position.getLatitude(), position.getLongitude());
        if (vec4 != null) {
            position2 = globe.computePositionFromPoint(vec4);
        }
        if (position2 == null) {
            position2 = new Position(position, globe.getElevation(position.getLatitude(), position.getLongitude()) * drawContext.getVerticalExaggeration());
        }
        return position.getElevation() - position2.getElevation();
    }

    public static double computePerspectiveNearDistance(Angle angle, double d) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.FOVIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.DistanceLessThanZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = angle.tanHalfAngle();
        return d / (2.0 * Math.sqrt(2.0 * d2 * d2 + 1.0));
    }

    public static double computePerspectiveNearDistance(double d, double d2, int n) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.DistanceLessThanZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ResolutionLessThanZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.DepthBitsLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d3 = (1L << n) - 1L;
        return d / (d3 / (1.0 - d2 / d) - d3 + 1.0);
    }

    public static Vec4 project(Vec4 vec4, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.ModelViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix2 == null) {
            String string = Logging.getMessage("nullValue.ProjectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GLUgl2 gLUgl2 = new GLUgl2();
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        matrix.toArray(dArray, 0, false);
        matrix2.toArray(dArray2, 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!((GLU)gLUgl2).gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3(dArray3, 0);
    }

    public static Vec4 unProject(Vec4 vec4, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.ModelViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix2 == null) {
            String string = Logging.getMessage("nullValue.ProjectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GLUgl2 gLUgl2 = new GLUgl2();
        double[] dArray = matrix.toArray(new double[16], 0, false);
        double[] dArray2 = matrix2.toArray(new double[16], 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!((GLU)gLUgl2).gluUnProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3(dArray3, 0);
    }

    public static class ViewState {
        protected Position position;
        protected Angle heading;
        protected Angle pitch;
        protected Angle roll;

        public ViewState(Position position, Angle angle, Angle angle2, Angle angle3) {
            this.position = position;
            this.heading = angle;
            this.pitch = angle2;
            this.roll = angle3;
        }

        public Position getPosition() {
            return this.position;
        }

        public void setPosition(Position position) {
            this.position = position;
        }

        public Angle getRoll() {
            return this.roll;
        }

        public void setRoll(Angle angle) {
            this.roll = angle;
        }

        public Angle getPitch() {
            return this.pitch;
        }

        public void setPitch(Angle angle) {
            this.pitch = angle;
        }

        public Angle getHeading() {
            return this.heading;
        }

        public void setHeading(Angle angle) {
            this.heading = angle;
        }
    }
}

