/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.xml;

import gov.nasa.worldwind.ogc.kml.KMLParserContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class XMLEventParserContextFactory {
    protected static List<ParserTableEntry> parsers = new CopyOnWriteArrayList<ParserTableEntry>();

    public static void addParserContext(String[] stringArray, XMLEventParserContext xMLEventParserContext) {
        if (stringArray == null || stringArray.length == 0) {
            String string = Logging.getMessage("nullValue.MimeTypeListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (xMLEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        parsers.add(new ParserTableEntry(stringArray, xMLEventParserContext));
    }

    public static void prependParserContext(String[] stringArray, XMLEventParserContext xMLEventParserContext) {
        if (stringArray == null || stringArray.length == 0) {
            String string = Logging.getMessage("nullValue.MimeTypeListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (xMLEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        parsers.add(0, new ParserTableEntry(stringArray, xMLEventParserContext));
    }

    public static XMLEventParserContext createParserContext(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.MimeTypeIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        for (ParserTableEntry parserTableEntry : parsers) {
            for (String string4 : parserTableEntry.mimeTypes) {
                String string5;
                if (!string4.equals(string) || !(string5 = (string5 = parserTableEntry.prototypeParser.getDefaultNamespaceURI()) != null ? string5 : "").equals(string2 = string2 != null ? string2 : "")) continue;
                try {
                    return XMLEventParserContextFactory.createInstanceFromPrototype(parserTableEntry.prototypeParser);
                }
                catch (Exception exception) {
                    String string6 = Logging.getMessage("XML.ExceptionCreatingParserContext", exception.getMessage());
                    Logging.logger().log(Level.WARNING, string6);
                }
            }
        }
        return null;
    }

    protected static XMLEventParserContext createInstanceFromPrototype(XMLEventParserContext xMLEventParserContext) throws Exception {
        Constructor<?> constructor = xMLEventParserContext.getClass().getConstructor(xMLEventParserContext.getClass());
        return (XMLEventParserContext)constructor.newInstance(xMLEventParserContext);
    }

    static {
        String[] stringArray = new String[]{"application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kmz"};
        parsers.add(new ParserTableEntry(stringArray, new KMLParserContext("http://www.opengis.net/kml/2.2")));
        parsers.add(new ParserTableEntry(stringArray, new KMLParserContext("")));
    }

    protected static class ParserTableEntry {
        protected List<String> mimeTypes = new ArrayList<String>();
        XMLEventParserContext prototypeParser;

        public ParserTableEntry(String[] stringArray, XMLEventParserContext xMLEventParserContext) {
            for (String string : stringArray) {
                this.mimeTypes.add(string);
            }
            this.prototypeParser = xMLEventParserContext;
            try {
                xMLEventParserContext.getClass().getConstructor(xMLEventParserContext.getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string = Logging.getMessage("XML.NoCopyConstructor");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
        }
    }
}

