/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.tree.TreeAttributes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

public class BasicTreeAttributes
implements TreeAttributes {
    protected boolean rootVisible;
    protected Color textColor;
    protected Font font;
    protected Font descriptionFont;
    protected int rowSpacing;
    protected Color checkBoxColor1;
    protected Color checkBoxColor2;
    protected Dimension iconSize;
    protected int iconSpace;

    public BasicTreeAttributes() {
        this.rootVisible = true;
        this.textColor = Color.BLACK;
        this.font = Font.decode("Arial-BOLD-14");
        this.descriptionFont = Font.decode("Arial-12");
        this.rowSpacing = 8;
        this.checkBoxColor1 = new Color(29, 78, 169);
        this.checkBoxColor2 = new Color(93, 158, 223);
        this.iconSize = new Dimension(16, 16);
        this.iconSpace = 5;
    }

    public BasicTreeAttributes(TreeAttributes treeAttributes) {
        if (treeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.copy(treeAttributes);
    }

    @Override
    public boolean isRootVisible() {
        return this.rootVisible;
    }

    @Override
    public void setRootVisible(boolean bl) {
        this.rootVisible = bl;
    }

    @Override
    public Color getColor() {
        return this.textColor;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textColor = color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    @Override
    public void setDescriptionFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.descriptionFont = font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.font = font;
    }

    @Override
    public int getRowSpacing() {
        return this.rowSpacing;
    }

    @Override
    public void setRowSpacing(int n) {
        this.rowSpacing = n;
    }

    @Override
    public Dimension getIconSize() {
        return this.iconSize;
    }

    @Override
    public void setIconSize(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.iconSize = dimension;
    }

    @Override
    public int getIconSpace() {
        return this.iconSpace;
    }

    @Override
    public void setIconSpace(int n) {
        this.iconSpace = n;
    }

    @Override
    public Color[] getCheckBoxColor() {
        return new Color[]{this.checkBoxColor1, this.checkBoxColor2};
    }

    @Override
    public void setCheckBoxColor(Color color, Color color2) {
        if (color == null || color2 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.checkBoxColor1 = color;
        this.checkBoxColor2 = color2;
    }

    @Override
    public BasicTreeAttributes copy() {
        return new BasicTreeAttributes(this);
    }

    @Override
    public void copy(TreeAttributes treeAttributes) {
        if (treeAttributes != null) {
            this.rootVisible = treeAttributes.isRootVisible();
            this.textColor = treeAttributes.getColor();
            this.font = treeAttributes.getFont();
            this.descriptionFont = treeAttributes.getDescriptionFont();
            this.rowSpacing = treeAttributes.getRowSpacing();
            Color[] colorArray = treeAttributes.getCheckBoxColor();
            this.checkBoxColor1 = colorArray[0];
            this.checkBoxColor2 = colorArray[1];
            this.iconSize = treeAttributes.getIconSize();
            this.iconSpace = treeAttributes.getIconSpace();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicTreeAttributes basicTreeAttributes = (BasicTreeAttributes)object;
        if (this.rootVisible != basicTreeAttributes.rootVisible) {
            return false;
        }
        if (this.textColor != null ? !this.textColor.equals(basicTreeAttributes.textColor) : basicTreeAttributes.textColor != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(basicTreeAttributes.font) : basicTreeAttributes.font != null) {
            return false;
        }
        if (this.descriptionFont != null ? !this.descriptionFont.equals(basicTreeAttributes.descriptionFont) : basicTreeAttributes.descriptionFont != null) {
            return false;
        }
        if (this.rowSpacing != basicTreeAttributes.rowSpacing) {
            return false;
        }
        if (!this.iconSize.equals(basicTreeAttributes.iconSize)) {
            return false;
        }
        if (this.checkBoxColor1 != null ? !this.checkBoxColor1.equals(basicTreeAttributes.checkBoxColor1) : basicTreeAttributes.checkBoxColor1 != null) {
            return false;
        }
        if (this.checkBoxColor2 != null ? !this.checkBoxColor2.equals(basicTreeAttributes.checkBoxColor2) : basicTreeAttributes.checkBoxColor2 != null) {
            return false;
        }
        return this.iconSpace == basicTreeAttributes.iconSpace;
    }

    public int hashCode() {
        int n = this.rootVisible ? 1 : 0;
        n = 31 * n + (this.textColor != null ? this.textColor.hashCode() : 0);
        n = 31 * n + (this.font != null ? this.font.hashCode() : 0);
        n = 31 * n + (this.descriptionFont != null ? this.descriptionFont.hashCode() : 0);
        n = 31 * n + this.rowSpacing;
        n = 31 * n + (this.iconSize != null ? this.iconSize.hashCode() : 0);
        n = 31 * n + this.iconSpace;
        return n;
    }
}

