/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.layertree;

import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLDocument;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLink;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.util.layertree.KMLContainerTreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

public class KMLNetworkLinkTreeNode
extends KMLContainerTreeNode {
    public KMLNetworkLinkTreeNode(KMLNetworkLink kMLNetworkLink) {
        super(kMLNetworkLink);
    }

    @Override
    public KMLNetworkLink getFeature() {
        return (KMLNetworkLink)super.getFeature();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getFeature().getRoot().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("gov.nasa.worldwind.avkey.RetrievalStateSuccessful".equals(propertyChangeEvent.getPropertyName()) && KMLNetworkLinkTreeNode.this.getFeature() == propertyChangeEvent.getNewValue()) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        KMLNetworkLinkTreeNode.this.refresh();
                        KMLNetworkLinkTreeNode.this.firePropertyChange("gov.nasa.worldwind.avkey.RetrievalStateSuccessful", null, this);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KMLNetworkLinkTreeNode.this.refresh();
                                KMLNetworkLinkTreeNode.this.firePropertyChange("gov.nasa.worldwind.avkey.RetrievalStateSuccessful", null, this);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    protected void refresh() {
        super.refresh();
        KMLRoot kMLRoot = this.getFeature().getNetworkResource();
        if (kMLRoot == null || kMLRoot.getFeature() == null) {
            return;
        }
        if (kMLRoot.getFeature() instanceof KMLDocument) {
            KMLDocument kMLDocument = (KMLDocument)kMLRoot.getFeature();
            for (KMLAbstractFeature kMLAbstractFeature : kMLDocument.getFeatures()) {
                if (kMLAbstractFeature == null) continue;
                this.addFeatureNode(kMLAbstractFeature);
            }
        } else {
            this.addFeatureNode(kMLRoot.getFeature());
        }
    }
}

