/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

public class GeometryBuilder {
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int COUNTER_CLOCKWISE = 0;
    public static final int CLOCKWISE = 1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    protected static final int LEADER_LOCATION_INSIDE = 0;
    protected static final int LEADER_LOCATION_TOP = 1;
    protected static final int LEADER_LOCATION_BOTTOM = 2;
    protected static final int LEADER_LOCATION_RIGHT = 4;
    protected static final int LEADER_LOCATION_LEFT = 8;
    private int orientation = 0;
    private static final int ICOSAHEDRON_INDEX_COUNT = 60;
    private static final int ICOSAHEDRON_VERTEX_COUNT = 12;
    private static final float X = 0.5257311f;
    private static final float Z = 0.8506508f;
    private static float[] icosahedronVertexArray = new float[]{-0.5257311f, 0.0f, 0.8506508f, 0.5257311f, 0.0f, 0.8506508f, -0.5257311f, 0.0f, -0.8506508f, 0.5257311f, 0.0f, -0.8506508f, 0.0f, 0.8506508f, 0.5257311f, 0.0f, 0.8506508f, -0.5257311f, 0.0f, -0.8506508f, 0.5257311f, 0.0f, -0.8506508f, -0.5257311f, 0.8506508f, 0.5257311f, 0.0f, -0.8506508f, 0.5257311f, 0.0f, 0.8506508f, -0.5257311f, 0.0f, -0.8506508f, -0.5257311f, 0.0f};
    private static int[] icosahedronIndexArray = new int[]{1, 4, 0, 4, 9, 0, 4, 5, 9, 8, 5, 4, 1, 8, 4, 1, 10, 8, 10, 3, 8, 8, 3, 5, 3, 2, 5, 3, 7, 2, 3, 10, 7, 10, 6, 7, 6, 11, 7, 6, 0, 11, 6, 1, 0, 10, 1, 6, 11, 0, 9, 2, 11, 9, 5, 2, 9, 11, 2, 7};
    private static final int BOX_INDEX_COUNT = 36;
    private static final int BOX_VERTEX_COUNT = 24;
    private static final float B = 1.0f;
    private static float[] boxVertexArray = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f};
    private static int[] boxIndexArray = new int[]{2, 3, 1, 2, 1, 0, 4, 6, 7, 4, 7, 5, 8, 10, 11, 8, 11, 9, 12, 14, 15, 12, 15, 13, 16, 18, 19, 16, 19, 17, 20, 22, 23, 20, 23, 21};
    private static int[] boxFacesIndexArray = new int[]{2, 3, 1, 2, 1, 0, 0, 2, 3, 0, 3, 1, 0, 2, 3, 0, 3, 1, 0, 2, 3, 0, 3, 1, 0, 2, 3, 0, 3, 1, 0, 2, 3, 0, 3, 1};
    private static final int PYRAMID_INDEX_COUNT = 18;
    private static final int PYRAMID_VERTEX_COUNT = 16;
    private static final float P = 1.0f;
    private static float[] pyramidVertexArray = new float[]{0.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    private static int[] pyramidIndexArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 12, 15, 13};
    private static int[] pyramidFacesIndexArray = new int[]{0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 2, 3, 0, 3, 1};

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public IndexedTriangleArray tessellateSphere(float f, int n) {
        int n2;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[60];
        float[] fArray = new float[36];
        System.arraycopy(icosahedronIndexArray, 0, nArray, 0, 60);
        System.arraycopy(icosahedronVertexArray, 0, fArray, 0, 36);
        if (this.orientation == 1) {
            for (int i = 0; i < 60; i += 3) {
                n2 = nArray[i];
                nArray[i] = nArray[i + 2];
                nArray[i + 2] = n2;
            }
        }
        IndexedTriangleArray indexedTriangleArray = new IndexedTriangleArray(60, nArray, 12, fArray);
        for (n2 = 0; n2 < n; ++n2) {
            this.subdivideIndexedTriangleArray(indexedTriangleArray);
            fArray = indexedTriangleArray.getVertices();
            for (int i = 0; i < indexedTriangleArray.vertexCount; ++i) {
                this.norm3AndSet(fArray, 3 * i);
            }
        }
        if (f != 1.0f) {
            fArray = indexedTriangleArray.getVertices();
            for (n2 = 0; n2 < indexedTriangleArray.vertexCount; ++n2) {
                this.mul3AndSet(fArray, 3 * n2, f);
            }
        }
        return indexedTriangleArray;
    }

    public IndexedTriangleBuffer tessellateSphereBuffer(float f, int n) {
        int n2;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(60);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(36);
        intBuffer.put(icosahedronIndexArray, 0, 60);
        floatBuffer.put(icosahedronVertexArray, 0, 36);
        if (this.orientation == 1) {
            for (int i = 0; i < 60; i += 3) {
                n2 = intBuffer.get(i);
                intBuffer.put(i, intBuffer.get(i + 2));
                intBuffer.put(i + 2, n2);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(60, intBuffer, 12, floatBuffer);
        for (n2 = 0; n2 < n; ++n2) {
            this.subdivideIndexedTriangleBuffer(indexedTriangleBuffer);
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.getVertexCount(); ++i) {
                this.norm3AndSet(floatBuffer, 3 * i);
            }
        }
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (n2 = 0; n2 < indexedTriangleBuffer.vertexCount; ++n2) {
                this.mul3AndSet(floatBuffer, 3 * n2, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateEllipsoidBuffer(float f, float f2, float f3, int n) {
        IndexedTriangleBuffer indexedTriangleBuffer = this.tessellateSphereBuffer(f, n);
        float f4 = f2 / f;
        float f5 = f3 / f;
        FloatBuffer floatBuffer = indexedTriangleBuffer.getVertices();
        for (int i = 0; i < indexedTriangleBuffer.getVertexCount(); ++i) {
            this.mulAndSet(floatBuffer, 3 * i, f4, 2);
            this.mulAndSet(floatBuffer, 3 * i, f5, 1);
        }
        indexedTriangleBuffer.vertices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateBoxBuffer(float f, int n) {
        int n2;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(36);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(72);
        intBuffer.put(boxIndexArray, 0, 36);
        floatBuffer.put(boxVertexArray, 0, 72);
        if (this.orientation == 1) {
            for (int i = 0; i < 36; i += 3) {
                n2 = intBuffer.get(i);
                intBuffer.put(i, intBuffer.get(i + 2));
                intBuffer.put(i + 2, n2);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(36, intBuffer, 24, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (n2 = 0; n2 < indexedTriangleBuffer.vertexCount; ++n2) {
                this.mul3AndSet(floatBuffer, 3 * n2, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateBoxBuffer(int n, float f, int n2) {
        int n3;
        int n4;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= 6) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "face < 0 or face >= 6");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(6);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(12);
        int[] nArray = new int[6];
        for (int i = 0; i < 6; ++i) {
            nArray[i] = boxFacesIndexArray[n * 36 / 6 + i];
        }
        intBuffer.put(nArray, 0, 6);
        float[] fArray = new float[12];
        for (n4 = 0; n4 < 12; ++n4) {
            fArray[n4] = boxVertexArray[n * 3 * 24 / 6 + n4];
        }
        floatBuffer.put(fArray, 0, 12);
        if (this.orientation == 1) {
            for (n4 = 0; n4 < 6; n4 += 3) {
                n3 = intBuffer.get(n4);
                intBuffer.put(n4, intBuffer.get(n4 + 2));
                intBuffer.put(n4 + 2, n3);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(6, intBuffer, 4, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (n3 = 0; n3 < indexedTriangleBuffer.vertexCount; ++n3) {
                this.mul3AndSet(floatBuffer, 3 * n3, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellatePyramidBuffer(float f, int n) {
        int n2;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(18);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(48);
        intBuffer.put(pyramidIndexArray, 0, 18);
        floatBuffer.put(pyramidVertexArray, 0, 48);
        if (this.orientation == 1) {
            for (int i = 0; i < 18; i += 3) {
                n2 = intBuffer.get(i);
                intBuffer.put(i, intBuffer.get(i + 2));
                intBuffer.put(i + 2, n2);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(18, intBuffer, 16, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (n2 = 0; n2 < indexedTriangleBuffer.vertexCount; ++n2) {
                this.mul3AndSet(floatBuffer, 3 * n2, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellatePyramidBuffer(int n, float f, int n2) {
        int n3;
        int n4;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 3;
        int n6 = 3;
        int n7 = n * n5;
        int n8 = n * 3 * n6;
        if (n == 4) {
            n7 = 4 * n5;
            n8 = 12 * n6;
            n5 = 6;
            n6 = 4;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n5);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n6);
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = pyramidFacesIndexArray[n7 + i];
        }
        intBuffer.put(nArray, 0, n5);
        float[] fArray = new float[3 * n6];
        for (n4 = 0; n4 < 3 * n6; ++n4) {
            fArray[n4] = pyramidVertexArray[n8 + n4];
        }
        floatBuffer.put(fArray, 0, 3 * n6);
        if (this.orientation == 1) {
            for (n4 = 0; n4 < n5; n4 += 3) {
                n3 = intBuffer.get(n4);
                intBuffer.put(n4, intBuffer.get(n4 + 2));
                intBuffer.put(n4 + 2, n3);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n5, intBuffer, n6, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (n3 = 0; n3 < indexedTriangleBuffer.vertexCount; ++n3) {
                this.mul3AndSet(floatBuffer, 3 * n3, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateCylinderBuffer(float f, int n) {
        int n2;
        float f2;
        float f3;
        float f4;
        int n3;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = (int)Math.pow(2.0, 2 + n);
        float f5 = (float)Math.PI * 2 / (float)n4;
        int n5 = 12 * n4;
        int n6 = 4 * n4 + 4;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n5);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n6);
        floatBuffer.put(0, 0.0f);
        floatBuffer.put(1, 0.0f);
        floatBuffer.put(2, 1.0f);
        floatBuffer.put(3 * (n4 + 1), 0.0f);
        floatBuffer.put(3 * (n4 + 1) + 1, 0.0f);
        floatBuffer.put(3 * (n4 + 1) + 2, -1.0f);
        for (n3 = 0; n3 < n4; ++n3) {
            float f6 = (float)n3 * f5;
            f4 = (float)Math.sin(f6);
            f3 = (float)Math.cos(f6);
            f2 = 1.0f;
            n2 = 3 * n3 + 3;
            floatBuffer.put(n2, f4 * f);
            floatBuffer.put(n2 + 1, f3 * f);
            floatBuffer.put(n2 + 2, f2);
            floatBuffer.put((n2 += 3) + 3 * n4, f4 * f);
            floatBuffer.put(n2 + 3 * n4 + 1, f3 * f);
            floatBuffer.put(n2 + 3 * n4 + 2, -f2);
            floatBuffer.put(n2 += 6 * n4 + 3 * n3, f4 * f);
            floatBuffer.put(n2 + 1, f3 * f);
            floatBuffer.put(n2 + 2, f2);
            floatBuffer.put(n2 + 3, f4 * f);
            floatBuffer.put(n2 + 4, f3 * f);
            floatBuffer.put(n2 + 5, -f2);
        }
        int n7 = 3 * (4 * n4 + 2);
        f4 = (float)Math.sin(0.0);
        f3 = (float)Math.cos(0.0);
        f2 = 1.0f;
        floatBuffer.put(n7, f4 * f);
        floatBuffer.put(n7 + 1, f3 * f);
        floatBuffer.put(n7 + 2, f2);
        floatBuffer.put(n7 + 3, f4 * f);
        floatBuffer.put(n7 + 4, f3 * f);
        floatBuffer.put(n7 + 5, -f2);
        int n8 = 2 * n4 + 2;
        boolean bl = false;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 3 * n3;
            intBuffer.put(n2, 0);
            intBuffer.put(n2 + 1, n3 < n4 - 1 ? n3 + 2 : 1);
            intBuffer.put(n2 + 2, n3 + 1);
            n2 = 3 * (n4 + n3);
            intBuffer.put(n2, n4 + 1);
            intBuffer.put(n2 + 1, n3 < n4 - 1 ? n4 + 1 + n3 + 2 : n4 + 1 + 1);
            intBuffer.put(n2 + 2, n4 + 1 + n3 + 1);
            n2 = 6 * (n4 + n3);
            intBuffer.put(n2, n8);
            intBuffer.put(n2 + 1, n8 + 1);
            intBuffer.put(n2 + 2, n8 + 2);
            intBuffer.put(n2 + 3, n8 + 2);
            intBuffer.put(n2 + 4, n8 + 1);
            intBuffer.put(n2 + 5, n8 + 3);
            n8 += 2;
        }
        if (this.orientation == 1) {
            for (n2 = 0; n2 < n5; n2 += 3) {
                int n9 = intBuffer.get(n2);
                intBuffer.put(n2, intBuffer.get(n2 + 2));
                intBuffer.put(n2 + 2, n9);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n5, intBuffer, n6, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.vertexCount; ++i) {
                this.mul3AndSet(floatBuffer, 3 * i, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateCylinderBuffer(int n, float f, int n2) {
        int n3;
        int n4;
        float f2;
        float f3;
        float f4;
        float f5;
        int n5;
        int n6;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n7 = (int)Math.pow(2.0, 2 + n2);
        float f6 = (float)Math.PI * 2 / (float)n7;
        int n8 = 3 * n7;
        int n9 = n7 + 1;
        if (n == 2) {
            n8 = 6 * n7;
            n9 = 2 * n7 + 2;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n8);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n9);
        if (n == 0 || n == 1) {
            n6 = 1;
            if (n == 1) {
                n6 = -1;
            }
            floatBuffer.put(0, 0.0f);
            floatBuffer.put(1, 0.0f);
            floatBuffer.put(2, (float)n6 * 1.0f);
            for (n5 = 0; n5 < n7; ++n5) {
                f5 = (float)n5 * f6;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                f2 = 1.0f;
                n4 = 3 * n5 + 3;
                floatBuffer.put(n4, f4 * f);
                floatBuffer.put(n4 + 1, f3 * f);
                floatBuffer.put(n4 + 2, (float)n6 * f2);
            }
        } else if (n == 2) {
            for (n5 = 0; n5 < n7; ++n5) {
                f5 = (float)n5 * f6;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                f2 = 1.0f;
                n4 = 6 * n5;
                floatBuffer.put(n4, f4 * f);
                floatBuffer.put(n4 + 1, f3 * f);
                floatBuffer.put(n4 + 2, f2);
                floatBuffer.put(n4 + 3, f4 * f);
                floatBuffer.put(n4 + 4, f3 * f);
                floatBuffer.put(n4 + 5, -f2);
            }
            n6 = 3 * (2 * n7);
            f4 = (float)Math.sin(0.0);
            f3 = (float)Math.cos(0.0);
            f2 = 1.0f;
            floatBuffer.put(n6, f4 * f);
            floatBuffer.put(n6 + 1, f3 * f);
            floatBuffer.put(n6 + 2, f2);
            floatBuffer.put(n6 + 3, f4 * f);
            floatBuffer.put(n6 + 4, f3 * f);
            floatBuffer.put(n6 + 5, -f2);
        }
        n6 = 0;
        if (n == 0 || n == 1) {
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = 3 * n5;
                intBuffer.put(n4, 0);
                intBuffer.put(n4 + 1, n5 < n7 - 1 ? n5 + 2 : 1);
                intBuffer.put(n4 + 2, n5 + 1);
            }
        } else if (n == 2) {
            n3 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = 6 * n5;
                intBuffer.put(n4, n3);
                intBuffer.put(n4 + 1, n3 + 1);
                intBuffer.put(n4 + 2, n3 + 2);
                intBuffer.put(n4 + 3, n3 + 2);
                intBuffer.put(n4 + 4, n3 + 1);
                intBuffer.put(n4 + 5, n3 + 3);
                n3 += 2;
            }
        }
        if (this.orientation == 1) {
            for (n4 = 0; n4 < n8; n4 += 3) {
                n3 = intBuffer.get(n4);
                intBuffer.put(n4, intBuffer.get(n4 + 2));
                intBuffer.put(n4 + 2, n3);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n8, intBuffer, n9, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.vertexCount; ++i) {
                this.mul3AndSet(floatBuffer, 3 * i, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateWedgeBuffer(float f, int n, Angle angle) {
        int n2;
        float f2;
        float f3;
        float f4;
        int n3;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.getRadians() < 0.0 || angle.getRadians() > Math.PI * 2) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "angle < 0 or angle > 2 PI");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = (int)Math.pow(2.0, 2 + n);
        float f5 = (float)angle.getRadians() / (float)n4;
        int n5 = 12 * n4 + 12;
        int n6 = 4 * (n4 + 1) + 2 + 8;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n5);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n6);
        floatBuffer.put(0, 0.0f);
        floatBuffer.put(1, 0.0f);
        floatBuffer.put(2, 1.0f);
        floatBuffer.put(3 * (n4 + 2), 0.0f);
        floatBuffer.put(3 * (n4 + 2) + 1, 0.0f);
        floatBuffer.put(3 * (n4 + 2) + 2, -1.0f);
        for (n3 = 0; n3 <= n4; ++n3) {
            float f6 = (float)n3 * f5;
            f4 = (float)Math.sin(f6);
            f3 = (float)Math.cos(f6);
            f2 = 1.0f;
            n2 = 3 * n3 + 3;
            floatBuffer.put(n2, f4 * f);
            floatBuffer.put(n2 + 1, f3 * f);
            floatBuffer.put(n2 + 2, f2);
            floatBuffer.put((n2 += 3) + 3 * (n4 + 1), f4 * f);
            floatBuffer.put(n2 + 3 * (n4 + 1) + 1, f3 * f);
            floatBuffer.put(n2 + 3 * (n4 + 1) + 2, -f2);
            n2 = 3 * (2 * n4 + 4 + 2 * n3);
            floatBuffer.put(n2, f4 * f);
            floatBuffer.put(n2 + 1, f3 * f);
            floatBuffer.put(n2 + 2, f2);
            floatBuffer.put(n2 + 3, f4 * f);
            floatBuffer.put(n2 + 4, f3 * f);
            floatBuffer.put(n2 + 5, -f2);
        }
        for (n3 = 0; n3 < 2; ++n3) {
            f4 = (float)Math.sin((double)n3 * angle.getRadians());
            f3 = (float)Math.cos((double)n3 * angle.getRadians());
            f2 = 1.0f;
            n2 = 3 * (4 * (n4 + 1 + n3) + 2);
            floatBuffer.put(n2, 0.0f);
            floatBuffer.put(n2 + 1, 0.0f);
            floatBuffer.put(n2 + 2, f2);
            floatBuffer.put(n2 + 3, 0.0f);
            floatBuffer.put(n2 + 4, 0.0f);
            floatBuffer.put(n2 + 5, -f2);
            floatBuffer.put(n2 + 6, f4 * f);
            floatBuffer.put(n2 + 7, f3 * f);
            floatBuffer.put(n2 + 8, f2);
            floatBuffer.put(n2 + 9, f4 * f);
            floatBuffer.put(n2 + 10, f3 * f);
            floatBuffer.put(n2 + 11, -f2);
        }
        int n7 = 2 * (n4 + 1) + 2;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 3 * n3;
            intBuffer.put(n2, 0);
            intBuffer.put(n2 + 1, n3 + 2);
            intBuffer.put(n2 + 2, n3 + 1);
            n2 = 3 * (n4 + n3);
            intBuffer.put(n2, n4 + 2);
            intBuffer.put(n2 + 1, n4 + 2 + n3 + 2);
            intBuffer.put(n2 + 2, n4 + 2 + n3 + 1);
            n2 = 6 * (n4 + n3);
            intBuffer.put(n2 + 0, n7 + 0);
            intBuffer.put(n2 + 1, n7 + 1);
            intBuffer.put(n2 + 2, n7 + 2);
            intBuffer.put(n2 + 3, n7 + 2);
            intBuffer.put(n2 + 4, n7 + 1);
            intBuffer.put(n2 + 5, n7 + 3);
            n7 += 2;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            n2 = 3 * (4 * n4) + 6 * n3;
            n7 = 4 * (n4 + 1) + 2 + n3 * 4;
            intBuffer.put(n2 + 0, n7 + 0);
            intBuffer.put(n2 + 1, n7 + 2);
            intBuffer.put(n2 + 2, n7 + 1);
            intBuffer.put(n2 + 3, n7 + 1);
            intBuffer.put(n2 + 4, n7 + 2);
            intBuffer.put(n2 + 5, n7 + 3);
        }
        if (this.orientation == 1) {
            for (n2 = 0; n2 < n5; n2 += 3) {
                int n8 = intBuffer.get(n2);
                intBuffer.put(n2, intBuffer.get(n2 + 2));
                intBuffer.put(n2 + 2, n8);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n5, intBuffer, n6, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.vertexCount; ++i) {
                this.mul3AndSet(floatBuffer, 3 * i, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateWedgeBuffer(int n, float f, int n2, Angle angle) {
        int n3;
        float f2;
        float f3;
        float f4;
        float f5;
        int n4;
        int n5;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.getRadians() < 0.0 || angle.getRadians() > Math.PI * 2) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "angle < 0 or angle > 2 PI");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = (int)Math.pow(2.0, 2 + n2);
        float f6 = (float)angle.getRadians() / (float)n6;
        int n7 = 6;
        int n8 = 4;
        if (n == 0 || n == 1) {
            n7 = 3 * n6;
            n8 = n6 + 2;
        } else if (n == 2) {
            n7 = 6 * n6;
            n8 = 2 * n6 + 2;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n7);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n8);
        if (n == 0 || n == 1) {
            n5 = 1;
            if (n == 1) {
                n5 = -1;
            }
            floatBuffer.put(0, 0.0f);
            floatBuffer.put(1, 0.0f);
            floatBuffer.put(2, (float)n5 * 1.0f);
            for (n4 = 0; n4 <= n6; ++n4) {
                f5 = (float)n4 * f6;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                f2 = 1.0f;
                n3 = 3 * n4 + 3;
                floatBuffer.put(n3, f4 * f);
                floatBuffer.put(n3 + 1, f3 * f);
                floatBuffer.put(n3 + 2, (float)n5 * f2);
            }
        } else if (n == 2) {
            for (n4 = 0; n4 <= n6; ++n4) {
                f5 = (float)n4 * f6;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                f2 = 1.0f;
                n3 = 3 * (2 * n4);
                floatBuffer.put(n3, f4 * f);
                floatBuffer.put(n3 + 1, f3 * f);
                floatBuffer.put(n3 + 2, f2);
                floatBuffer.put(n3 + 3, f4 * f);
                floatBuffer.put(n3 + 4, f3 * f);
                floatBuffer.put(n3 + 5, -f2);
            }
        } else if (n == 3 || n == 4) {
            n4 = n - 3;
            f4 = (float)Math.sin((double)n4 * angle.getRadians());
            f3 = (float)Math.cos((double)n4 * angle.getRadians());
            f2 = 1.0f;
            n3 = 0;
            floatBuffer.put(n3, 0.0f);
            floatBuffer.put(n3 + 1, 0.0f);
            floatBuffer.put(n3 + 2, f2);
            floatBuffer.put(n3 + 3, 0.0f);
            floatBuffer.put(n3 + 4, 0.0f);
            floatBuffer.put(n3 + 5, -f2);
            floatBuffer.put(n3 + 6, f4 * f);
            floatBuffer.put(n3 + 7, f3 * f);
            floatBuffer.put(n3 + 8, f2);
            floatBuffer.put(n3 + 9, f4 * f);
            floatBuffer.put(n3 + 10, f3 * f);
            floatBuffer.put(n3 + 11, -f2);
        }
        if (n == 0 || n == 1) {
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = 3 * n4;
                intBuffer.put(n3, 0);
                intBuffer.put(n3 + 1, n4 + 2);
                intBuffer.put(n3 + 2, n4 + 1);
            }
        } else if (n == 2) {
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = 6 * n4;
                intBuffer.put(n3 + 0, n5 + 0);
                intBuffer.put(n3 + 1, n5 + 1);
                intBuffer.put(n3 + 2, n5 + 2);
                intBuffer.put(n3 + 3, n5 + 2);
                intBuffer.put(n3 + 4, n5 + 1);
                intBuffer.put(n3 + 5, n5 + 3);
                n5 += 2;
            }
        } else if (n == 3 || n == 4) {
            intBuffer.put(0, 0);
            intBuffer.put(1, 2);
            intBuffer.put(2, 1);
            intBuffer.put(3, 1);
            intBuffer.put(4, 2);
            intBuffer.put(5, 3);
        }
        if (this.orientation == 1) {
            for (n3 = 0; n3 < n7; n3 += 3) {
                n5 = intBuffer.get(n3);
                intBuffer.put(n3, intBuffer.get(n3 + 2));
                intBuffer.put(n3 + 2, n5);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n7, intBuffer, n8, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.vertexCount; ++i) {
                this.mul3AndSet(floatBuffer, 3 * i, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateConeBuffer(float f, int n) {
        int n2;
        float f2;
        float f3;
        float f4;
        int n3;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = (int)Math.pow(2.0, 2 + n);
        float f5 = (float)Math.PI * 2 / (float)n4;
        int n5 = 12 * n4;
        int n6 = 4 * n4 + 4;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n5);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n6);
        floatBuffer.put(0, 0.0f);
        floatBuffer.put(1, 0.0f);
        floatBuffer.put(2, -1.0f);
        for (n3 = 0; n3 < n4; ++n3) {
            float f6 = (float)n3 * f5;
            f4 = (float)Math.sin(f6);
            f3 = (float)Math.cos(f6);
            f2 = 1.0f;
            n2 = 3 * n3 + 3;
            floatBuffer.put(n2, f4 * f);
            floatBuffer.put(n2 + 1, f3 * f);
            floatBuffer.put(n2 + 2, -f2);
            floatBuffer.put(n2 += 3 * n4 + 3 * n3, 0.0f);
            floatBuffer.put(n2 + 1, 0.0f);
            floatBuffer.put(n2 + 2, f2);
            floatBuffer.put(n2 + 3, f4 * f);
            floatBuffer.put(n2 + 4, f3 * f);
            floatBuffer.put(n2 + 5, -f2);
        }
        int n7 = 3 * (3 * n4 + 1);
        f4 = (float)Math.sin(0.0);
        f3 = (float)Math.cos(0.0);
        f2 = 1.0f;
        floatBuffer.put(n7, 0.0f);
        floatBuffer.put(n7 + 1, 0.0f);
        floatBuffer.put(n7 + 2, f2);
        floatBuffer.put(n7 + 3, f4 * f);
        floatBuffer.put(n7 + 4, f3 * f);
        floatBuffer.put(n7 + 5, -f2);
        int n8 = n4 + 1;
        boolean bl = false;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 3 * n3;
            intBuffer.put(n2, 0);
            intBuffer.put(n2 + 1, n3 < n4 - 1 ? n3 + 2 : 1);
            intBuffer.put(n2 + 2, n3 + 1);
            intBuffer.put(n2 += 3 * (n4 + n3), n8);
            intBuffer.put(n2 + 1, n8 + 1);
            intBuffer.put(n2 + 2, n8 + 2);
            intBuffer.put(n2 + 3, n8 + 2);
            intBuffer.put(n2 + 4, n8 + 1);
            intBuffer.put(n2 + 5, n8 + 3);
            n8 += 2;
        }
        if (this.orientation == 1) {
            for (n2 = 0; n2 < n5; n2 += 3) {
                int n9 = intBuffer.get(n2);
                intBuffer.put(n2, intBuffer.get(n2 + 2));
                intBuffer.put(n2 + 2, n9);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n5, intBuffer, n6, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.vertexCount; ++i) {
                this.mul3AndSet(floatBuffer, 3 * i, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public IndexedTriangleBuffer tessellateConeBuffer(int n, float f, int n2) {
        int n3;
        int n4;
        int n5;
        float f2;
        float f3;
        float f4;
        float f5;
        int n6;
        if (f < 0.0f) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n7 = (int)Math.pow(2.0, 2 + n2);
        float f6 = (float)Math.PI * 2 / (float)n7;
        int n8 = 3 * n7;
        int n9 = n7 + 1;
        if (n == 1) {
            n8 = 6 * n7;
            n9 = 2 * n7 + 2;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(n8);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(3 * n9);
        if (n == 0) {
            floatBuffer.put(0, 0.0f);
            floatBuffer.put(1, 0.0f);
            floatBuffer.put(2, -1.0f);
            for (n6 = 0; n6 < n7; ++n6) {
                f5 = (float)n6 * f6;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                f2 = 1.0f;
                n5 = 3 * n6 + 3;
                floatBuffer.put(n5, f4 * f);
                floatBuffer.put(n5 + 1, f3 * f);
                floatBuffer.put(n5 + 2, -f2);
            }
        } else if (n == 1) {
            for (n6 = 0; n6 < n7; ++n6) {
                f5 = (float)n6 * f6;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                f2 = 1.0f;
                n5 = 6 * n6;
                floatBuffer.put(n5, 0.0f);
                floatBuffer.put(n5 + 1, 0.0f);
                floatBuffer.put(n5 + 2, f2);
                floatBuffer.put(n5 + 3, f4 * f);
                floatBuffer.put(n5 + 4, f3 * f);
                floatBuffer.put(n5 + 5, -f2);
            }
            n4 = 3 * (2 * n7);
            f4 = (float)Math.sin(0.0);
            f3 = (float)Math.cos(0.0);
            f2 = 1.0f;
            floatBuffer.put(n4, 0.0f);
            floatBuffer.put(n4 + 1, 0.0f);
            floatBuffer.put(n4 + 2, f2);
            floatBuffer.put(n4 + 3, f4 * f);
            floatBuffer.put(n4 + 4, f3 * f);
            floatBuffer.put(n4 + 5, -f2);
        }
        n4 = 0;
        if (n == 0) {
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = 3 * n6;
                intBuffer.put(n5, 0);
                intBuffer.put(n5 + 1, n6 < n7 - 1 ? n6 + 2 : 1);
                intBuffer.put(n5 + 2, n6 + 1);
            }
        } else if (n == 1) {
            n3 = 0;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = 6 * n6;
                intBuffer.put(n5, n3);
                intBuffer.put(n5 + 1, n3 + 1);
                intBuffer.put(n5 + 2, n3 + 2);
                intBuffer.put(n5 + 3, n3 + 2);
                intBuffer.put(n5 + 4, n3 + 1);
                intBuffer.put(n5 + 5, n3 + 3);
                n3 += 2;
            }
        }
        if (this.orientation == 1) {
            for (n5 = 0; n5 < n8; n5 += 3) {
                n3 = intBuffer.get(n5);
                intBuffer.put(n5, intBuffer.get(n5 + 2));
                intBuffer.put(n5 + 2, n3);
            }
        }
        IndexedTriangleBuffer indexedTriangleBuffer = new IndexedTriangleBuffer(n8, intBuffer, n9, floatBuffer);
        if (f != 1.0f) {
            floatBuffer = indexedTriangleBuffer.getVertices();
            for (int i = 0; i < indexedTriangleBuffer.vertexCount; ++i) {
                this.mul3AndSet(floatBuffer, 3 * i, f);
            }
        }
        indexedTriangleBuffer.vertices.rewind();
        indexedTriangleBuffer.indices.rewind();
        return indexedTriangleBuffer;
    }

    public int getCylinderVertexCount(int n, int n2) {
        return n * (n2 + 1);
    }

    public int getCylinderIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getCylinderOutlineIndexCount(int n, int n2) {
        return n * 4;
    }

    public int getCylinderDrawMode() {
        return 5;
    }

    public int getCylinderOutlineDrawMode() {
        return 1;
    }

    public void makeCylinderVertices(float f, float f2, int n, int n2, float[] fArray) {
        int n3 = this.getCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f3 = (float)n2 != 0.0f ? f2 / (float)n2 : 0.0f;
        float f4 = (float)Math.PI * 2 / (float)n;
        for (int i = 0; i < n; ++i) {
            float f5 = (float)i * f4;
            float f6 = (float)Math.sin(f5);
            float f7 = (float)Math.cos(f5);
            float f8 = 0.0f;
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                fArray[n5] = f6 * f;
                fArray[n5 + 1] = f7 * f;
                fArray[n5 + 2] = f8;
                f8 += f3;
            }
        }
    }

    public void makeCylinderNormals(int n, int n2, float[] fArray) {
        int n3 = this.getCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = (float)Math.PI * 2 / (float)n;
        float f2 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[3];
        for (int i = 0; i < n; ++i) {
            float f3 = (float)i * f;
            float f4 = (float)Math.sin(f3);
            float f5 = (float)Math.cos(f3);
            fArray2[0] = f4 * f2;
            fArray2[1] = f5 * f2;
            fArray2[2] = 0.0f;
            this.norm3AndSet(fArray2, 0);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makeCylinderIndices(int n, int n2, int[] nArray) {
        int n3 = this.getCylinderIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                n5 = this.orientation == 1 ? i + 1 : i;
                nArray[n4++] = n5;
                nArray[n4++] = n5;
            }
            for (int j = 0; j <= n; ++j) {
                n5 = j == n ? i : i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5 + 1;
                    nArray[n4++] = n5;
                    continue;
                }
                nArray[n4++] = n5;
                nArray[n4++] = n5 + 1;
            }
        }
    }

    public void makeCylinderOutlineIndices(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = this.getCylinderOutlineIndexCount(n, n2);
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1);
            nArray[n6++] = n3;
            nArray[n6++] = n4 != n - 1 ? n3 + n2 + 1 : 0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1) + n2;
            nArray[n6++] = n3;
            nArray[n6++] = n4 != n - 1 ? n3 + n2 + 1 : n2;
        }
    }

    public int getPartialCylinderVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getPartialCylinderIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getPartialCylinderOutlineIndexCount(int n, int n2) {
        return n * 4;
    }

    public int getPartialCylinderDrawMode() {
        return 5;
    }

    public int getPartialCylinderOutlineDrawMode() {
        return 1;
    }

    public void makePartialCylinderVertices(float f, float f2, int n, int n2, float f3, float f4, float[] fArray) {
        int n3 = this.getPartialCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = (float)n2 != 0.0f ? f2 / (float)n2 : 0.0f;
        float f6 = f4 / (float)n;
        for (int i = 0; i <= n; ++i) {
            float f7 = (float)i * f6 + f3;
            float f8 = (float)Math.sin(f7);
            float f9 = (float)Math.cos(f7);
            float f10 = 0.0f;
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                fArray[n5] = f8 * f;
                fArray[n5 + 1] = f9 * f;
                fArray[n5 + 2] = f10;
                f10 += f5;
            }
        }
    }

    public void makePartialCylinderNormals(float f, float f2, int n, int n2, float f3, float f4, float[] fArray) {
        int n3 = this.getPartialCylinderVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4 / (float)n;
        float f6 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[3];
        for (int i = 0; i <= n; ++i) {
            float f7 = (float)i * f5 + f3;
            float f8 = (float)Math.sin(f7);
            float f9 = (float)Math.cos(f7);
            fArray2[0] = f8 * f6;
            fArray2[1] = f9 * f6;
            fArray2[2] = 0.0f;
            this.norm3AndSet(fArray2, 0);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makePartialCylinderIndices(int n, int n2, int[] nArray) {
        int n3 = this.getPartialCylinderIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = i + n * (n2 + 1);
                    nArray[n4++] = n5 - 1;
                    n5 = i + 1;
                    nArray[n4++] = n5;
                } else {
                    n5 = i + n * (n2 + 1);
                    nArray[n4++] = n5;
                    n5 = i;
                    nArray[n4++] = n5;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5 + 1;
                    nArray[n4++] = n5;
                    continue;
                }
                nArray[n4++] = n5;
                nArray[n4++] = n5 + 1;
            }
        }
    }

    public void makePartialCylinderOutlineIndices(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = this.getPartialCylinderOutlineIndexCount(n, n2);
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1);
            nArray[n6++] = n3;
            nArray[n6++] = n3 + n2 + 1;
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * (n2 + 1) + n2;
            nArray[n6++] = n3;
            nArray[n6++] = n3 + n2 + 1;
        }
    }

    public int getDiskVertexCount(int n, int n2) {
        return n * (n2 + 1);
    }

    public int getDiskIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getDiskDrawMode() {
        return 5;
    }

    public void makeDiskVertices(float f, float f2, int n, int n2, float[] fArray) {
        int n3 = this.getDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f3 = (float)Math.PI * 2 / (float)n;
        float f4 = (f2 - f) / (float)n2;
        for (int i = 0; i < n; ++i) {
            float f5 = (float)i * f3;
            float f6 = (float)Math.sin(f5);
            float f7 = (float)Math.cos(f5);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                float f8 = f + (float)j * f4;
                fArray[n5] = f8 * f6;
                fArray[n5 + 1] = f8 * f7;
                fArray[n5 + 2] = 0.0f;
            }
        }
    }

    public void makeDiskNormals(int n, int n2, float[] fArray) {
        int n3 = this.getDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f * f};
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makeDiskVertexNormals(float f, float f2, int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = this.getDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f3 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n2; ++i) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (i == 0 || i == n2) {
                if (i == 0 && f == 0.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    for (n9 = 0; n9 < n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        n7 = i + (n9 + 1) * (n2 + 1);
                        if (n9 == n - 1) {
                            n7 = i;
                        }
                        n6 = n8 + 1;
                        this.facenorm(fArray, n8, n7 + 1, n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    this.mul3AndSet(fArray3, 0, f3);
                    this.norm3AndSet(fArray3, 0);
                    for (n9 = 0; n9 < n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                    }
                    continue;
                }
                for (n9 = 0; n9 < n; ++n9) {
                    n8 = i + n9 * (n2 + 1);
                    n7 = i + (n9 - 1) * (n2 + 1);
                    n6 = i + (n9 + 1) * (n2 + 1);
                    if (n9 == 0) {
                        n7 = i + (n - 1) * (n2 + 1);
                    } else if (n9 == n - 1) {
                        n6 = i;
                    }
                    n5 = i == 0 ? n8 + 1 : n8 - 1;
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    if (i == 0) {
                        this.facenorm(fArray, n8, n6, n5, fArray5);
                    } else {
                        this.facenorm(fArray, n8, n5, n6, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    if (i == 0) {
                        this.facenorm(fArray, n8, n5, n7, fArray5);
                    } else {
                        this.facenorm(fArray, n8, n7, n5, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f3);
                    this.norm3AndSet(fArray3, 0);
                    System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                }
                continue;
            }
            for (n9 = 0; n9 < n; ++n9) {
                n8 = i + n9 * (n2 + 1);
                n7 = i + (n9 - 1) * (n2 + 1);
                n6 = i + (n9 + 1) * (n2 + 1);
                if (n9 == 0) {
                    n7 = i + (n - 1) * (n2 + 1);
                } else if (n9 == n - 1) {
                    n6 = i;
                }
                n5 = n8 - 1;
                int n10 = n8 + 1;
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                this.facenorm(fArray, n8, n7, n7 - 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n7 - 1, n5, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n5, n6 - 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n6 - 1, n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n6, n6 + 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n6 + 1, n10, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n10, n7 + 1, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n8, n7 + 1, n7, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.mul3AndSet(fArray3, 0, f3);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
            }
        }
    }

    public void makeDiskIndices(int n, int n2, int[] nArray) {
        int n3 = this.getDiskIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = i;
                    nArray[n4++] = n5;
                    nArray[n4++] = n5;
                } else {
                    n5 = i - 1;
                    nArray[n4++] = n5;
                    n5 = i + 1;
                    nArray[n4++] = n5;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = j == n ? i : i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n5 + 1;
                    continue;
                }
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5;
            }
        }
    }

    public int getPartialDiskVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getPartialDiskIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getPartialDiskDrawMode() {
        return 5;
    }

    public void makePartialDiskVertices(float f, float f2, int n, int n2, float f3, float f4, float[] fArray) {
        int n3 = this.getPartialDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4 / (float)n;
        float f6 = (f2 - f) / (float)n2;
        for (int i = 0; i <= n; ++i) {
            float f7 = (float)i * f5 + f3;
            float f8 = (float)Math.sin(f7);
            float f9 = (float)Math.cos(f7);
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                float f10 = f + (float)j * f6;
                fArray[n5] = f10 * f8;
                fArray[n5 + 1] = f10 * f9;
                fArray[n5 + 2] = 0.0f;
            }
        }
    }

    public void makePartialDiskNormals(int n, int n2, float[] fArray) {
        int n3 = this.getPartialDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f * f};
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n5 = j + i * (n2 + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makePartialDiskVertexNormals(float f, float f2, int n, int n2, float f3, float f4, float[] fArray, float[] fArray2) {
        int n3 = this.getPartialDiskVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n2; ++i) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (i == 0 || i == n2) {
                if (i == 0 && f == 0.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    for (n9 = 0; n9 < n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        n7 = i + (n9 + 1) * (n2 + 1);
                        n6 = n8 + 1;
                        this.facenorm(fArray, n8, n7 + 1, n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    this.mul3AndSet(fArray3, 0, f5);
                    this.norm3AndSet(fArray3, 0);
                    for (n9 = 0; n9 <= n; ++n9) {
                        n8 = i + n9 * (n2 + 1);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                    }
                    continue;
                }
                for (n9 = 0; n9 <= n; ++n9) {
                    n8 = i + n9 * (n2 + 1);
                    n5 = i == 0 ? n8 + 1 : n8 - 1;
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    if (n9 > 0) {
                        n7 = i + (n9 - 1) * (n2 + 1);
                        if (i == 0) {
                            this.facenorm(fArray, n8, n5, n7, fArray5);
                        } else {
                            this.facenorm(fArray, n8, n7, n5, fArray5);
                        }
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    if (n9 < n) {
                        n6 = i + (n9 + 1) * (n2 + 1);
                        if (i == 0) {
                            this.facenorm(fArray, n8, n6, n5, fArray5);
                        } else {
                            this.facenorm(fArray, n8, n5, n6, fArray5);
                        }
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    this.mul3AndSet(fArray3, 0, f5);
                    this.norm3AndSet(fArray3, 0);
                    System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
                }
                continue;
            }
            for (n9 = 0; n9 <= n; ++n9) {
                n8 = i + n9 * (n2 + 1);
                n5 = n8 - 1;
                int n10 = n8 + 1;
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                if (n9 > 0) {
                    n7 = i + (n9 - 1) * (n2 + 1);
                    this.facenorm(fArray, n8, n7, n7 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n7 - 1, n5, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n10, n7 + 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n7 + 1, n7, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                }
                if (n9 < n) {
                    n6 = i + (n9 + 1) * (n2 + 1);
                    this.facenorm(fArray, n8, n5, n6 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n6 - 1, n6, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n6, n6 + 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.facenorm(fArray, n8, n6 + 1, n10, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                }
                this.mul3AndSet(fArray3, 0, f5);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n8, 3);
            }
        }
    }

    public void makePartialDiskIndices(int n, int n2, int[] nArray) {
        int n3 = this.getPartialDiskIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n + " loops=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = i + n * (n2 + 1);
                    nArray[n4++] = n5;
                    n5 = i;
                    nArray[n4++] = n5;
                } else {
                    n5 = i - 1 + n * (n2 + 1);
                    nArray[n4++] = n5;
                    n5 = i;
                    nArray[n4++] = n5 + 1;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = i + j * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n5 + 1;
                    continue;
                }
                nArray[n4++] = n5 + 1;
                nArray[n4++] = n5;
            }
        }
    }

    public int getRadialWallVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getRadialWallIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getRadialWallOutlineIndexCount(int n, int n2) {
        return n * 4;
    }

    public int getRadialWallDrawMode() {
        return 5;
    }

    public int getRadialWallOutlineDrawMode() {
        return 1;
    }

    public void makeRadialWallVertices(float f, float f2, float f3, float f4, int n, int n2, float[] fArray) {
        int n3 = this.getRadialWallVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4;
        float f6 = (float)Math.sin(f5);
        float f7 = (float)Math.cos(f5);
        float f8 = 0.0f;
        float f9 = (float)n2 != 0.0f ? f3 / (float)n2 : 0.0f;
        float f10 = (f2 - f) / (float)n;
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j <= n; ++j) {
                int n5 = j + i * (n + 1);
                n5 = 3 * n5;
                float f11 = f + (float)j * f10;
                fArray[n5] = f11 * f6;
                fArray[n5 + 1] = f11 * f7;
                fArray[n5 + 2] = f8;
            }
            f8 += f9;
        }
    }

    public void makeRadialWallNormals(float f, float f2, float f3, float f4, int n, int n2, float[] fArray) {
        int n3 = this.getRadialWallVertexCount(n, n2);
        int n4 = 3 * n3;
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f5 = f4;
        float f6 = (float)Math.cos(f5);
        float f7 = (float)(-Math.sin(f5));
        float f8 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{f6 * f8, f7 * f8, 0.0f};
        this.norm3AndSet(fArray2, 0);
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j <= n; ++j) {
                int n5 = j + i * (n + 1);
                n5 = 3 * n5;
                System.arraycopy(fArray2, 0, fArray, n5, 3);
            }
        }
    }

    public void makeRadialWallIndices(int n, int n2, int[] nArray) {
        int n3 = this.getRadialWallIndexCount(n, n2);
        if (n3 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (i != 0) {
                if (this.orientation == 1) {
                    n5 = n + i * (n + 1);
                    nArray[n4++] = n5;
                    n5 = i * (n + 1);
                    nArray[n4++] = n5;
                } else {
                    n5 = n + (i - 1) * (n + 1);
                    nArray[n4++] = n5;
                    n5 = (i + 1) * (n + 1);
                    nArray[n4++] = n5;
                }
            }
            for (int j = 0; j <= n; ++j) {
                n5 = j + i * (n + 1);
                if (this.orientation == 1) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n5 + (n + 1);
                    continue;
                }
                nArray[n4++] = n5 + (n + 1);
                nArray[n4++] = n5;
            }
        }
    }

    public void makeRadialWallOutlineIndices(int n, int n2, int[] nArray) {
        int n3;
        int n4 = this.getRadialWallOutlineIndexCount(n, n2);
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n + " stacks=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            n3 = n6++;
            nArray[n5++] = n3;
            nArray[n5++] = n3 + 1;
        }
        for (n6 = 0; n6 < n; ++n6) {
            n3 = n6 + n2 * (n + 1);
            nArray[n5++] = n3;
            nArray[n5++] = n3 + 1;
        }
    }

    public int getLongCylinderVertexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n4 * (n3 + 1);
    }

    public int getLongCylinderIndexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n3 * 2 * (n4 + 1) + 2 * (n3 - 1);
    }

    public int getLongCylinderOutlineIndexCount(int n, int n2, int n3) {
        return (n + n2) * 2 * 4;
    }

    public int getLongCylinderDrawMode() {
        return 5;
    }

    public int getLongCylinderOutlineDrawMode() {
        return 1;
    }

    public void makeLongCylinderVertices(float f, float f2, float f3, int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongCylinderVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f4 = (float)Math.PI / (float)n;
        float f5 = f2 / (float)n2;
        float f6 = (float)n3 != 0.0f ? f3 / (float)n3 : 0.0f;
        float f7 = 0.0f;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            float f8;
            float f9;
            float f10;
            int n7;
            for (n7 = 0; n7 <= n; ++n7) {
                f10 = (float)n7 * f4 + 4.712389f;
                f9 = (float)Math.sin(f10);
                f8 = (float)Math.cos(f10);
                fArray[n6++] = f9 * f;
                fArray[n6++] = f8 * f + f2;
                fArray[n6++] = f7;
            }
            for (n7 = n2 - 1; n7 >= 1; --n7) {
                fArray[n6++] = f;
                fArray[n6++] = (float)n7 * f5;
                fArray[n6++] = f7;
            }
            for (n7 = 0; n7 <= n; ++n7) {
                f10 = (float)n7 * f4 + 1.5707964f;
                f9 = (float)Math.sin(f10);
                f8 = (float)Math.cos(f10);
                fArray[n6++] = f9 * f;
                fArray[n6++] = f8 * f;
                fArray[n6++] = f7;
            }
            for (n7 = 1; n7 < n2; ++n7) {
                fArray[n6++] = -f;
                fArray[n6++] = (float)n7 * f5;
                fArray[n6++] = f7;
            }
            f7 += f6;
        }
    }

    public void makeLongCylinderNormals(int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongCylinderVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = (float)Math.PI / (float)n;
        float f2 = this.orientation == 0 ? 1.0f : -1.0f;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            float f3;
            float f4;
            float f5;
            int n7;
            for (n7 = 0; n7 <= n; ++n7) {
                f5 = (float)n7 * f + 4.712389f;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                fArray[n6++] = f4 * f2;
                fArray[n6++] = f3 * f2;
                fArray[n6++] = 0.0f;
            }
            for (n7 = n2 - 1; n7 >= 1; --n7) {
                fArray[n6++] = 1.0f * f2;
                fArray[n6++] = 0.0f;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 0; n7 <= n; ++n7) {
                f5 = (float)n7 * f + 1.5707964f;
                f4 = (float)Math.sin(f5);
                f3 = (float)Math.cos(f5);
                fArray[n6++] = f4 * f2;
                fArray[n6++] = f3 * f2;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 1; n7 < n2; ++n7) {
                fArray[n6++] = -1.0f * f2;
                fArray[n6++] = 0.0f;
                fArray[n6++] = 0.0f;
            }
        }
    }

    public void makeLongCylinderIndices(int n, int n2, int n3, int[] nArray) {
        int n4 = this.getLongCylinderIndexCount(n, n2, n3);
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 2 * (n + 1) + 2 * (n2 - 1);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (i != 0) {
                if (this.orientation == 1) {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                    n7 = i * n5;
                    nArray[n6++] = n7;
                } else {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7 + n5;
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                }
            }
            for (int j = 0; j <= n5; ++j) {
                n7 = j == n5 ? i * n5 : j + i * n5;
                if (this.orientation == 1) {
                    nArray[n6++] = n7 + n5;
                    nArray[n6++] = n7;
                    continue;
                }
                nArray[n6++] = n7;
                nArray[n6++] = n7 + n5;
            }
        }
    }

    public void makeLongCylinderOutlineIndices(int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5;
        int n6 = this.getLongCylinderOutlineIndexCount(n, n2, n3);
        if (n6 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " stacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n6) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n7 = 2 * (n + 1) + 2 * (n2 - 1);
        int n8 = 0;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5;
            nArray[n8++] = n4;
            nArray[n8++] = n5 != n7 - 1 ? n4 + 1 : 0;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5 + n7 * n3;
            nArray[n8++] = n4;
            nArray[n8++] = n5 != n7 - 1 ? n4 + 1 : n7 * n3;
        }
    }

    public int getLongDiskVertexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n4 * (n3 + 1);
    }

    public int getLongDiskIndexCount(int n, int n2, int n3) {
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        return n3 * 2 * (n4 + 1) + 2 * (n3 - 1);
    }

    public int getLongDiskDrawMode() {
        return 5;
    }

    public void makeLongDiskVertices(float f, float f2, float f3, int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongDiskVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f4 = f3 / (float)n2;
        float f5 = (float)Math.PI / (float)n;
        float f6 = (f2 - f) / (float)n3;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            float f7;
            float f8;
            float f9;
            int n7;
            float f10 = f + (float)i * f6;
            for (n7 = 0; n7 <= n; ++n7) {
                f9 = (float)n7 * f5 + 4.712389f;
                f8 = (float)Math.sin(f9);
                f7 = (float)Math.cos(f9);
                fArray[n6++] = f8 * f10;
                fArray[n6++] = f7 * f10 + f3;
                fArray[n6++] = 0.0f;
            }
            for (n7 = n2 - 1; n7 >= 1; --n7) {
                fArray[n6++] = f10;
                fArray[n6++] = (float)n7 * f4;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 0; n7 <= n; ++n7) {
                f9 = (float)n7 * f5 + 1.5707964f;
                f8 = (float)Math.sin(f9);
                f7 = (float)Math.cos(f9);
                fArray[n6++] = f8 * f10;
                fArray[n6++] = f7 * f10;
                fArray[n6++] = 0.0f;
            }
            for (n7 = 1; n7 < n2; ++n7) {
                fArray[n6++] = -f10;
                fArray[n6++] = (float)n7 * f4;
                fArray[n6++] = 0.0f;
            }
        }
    }

    public void makeLongDiskNormals(int n, int n2, int n3, float[] fArray) {
        int n4 = this.getLongDiskVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 2 * (n + 1) + 2 * (n2 - 1);
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f * f};
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n7 = j + i * n6;
                n7 = 3 * n7;
                System.arraycopy(fArray2, 0, fArray, n7, 3);
            }
        }
    }

    public void makeLongDiskVertexNormals(float f, float f2, float f3, int n, int n2, int n3, float[] fArray, float[] fArray2) {
        int n4 = this.getLongDiskVertexCount(n, n2, n3);
        int n5 = 3 * n4;
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n5) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = 2 * (n + 1) + 2 * (n2 - 1);
        float f4 = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n3; ++i) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            if (i == 0 || i == n3) {
                if (i == 0 && f == 0.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    n11 = 0;
                    while (n11 <= n) {
                        n10 = n11++;
                        this.facenorm(fArray, n10, n10 + n6 + 1, n10 + n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    n10 = n;
                    this.facenorm(fArray, n10, n10 + 1, n10 + n6, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    n10 = 0;
                    this.facenorm(fArray, n10, n10 + n6, n10 + n6 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f4);
                    this.norm3AndSet(fArray3, 0);
                    n11 = 0;
                    while (n11 <= n) {
                        n10 = n11++;
                        System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                    }
                    for (n11 = 1; n11 < n2; ++n11) {
                        n10 = n11 + n;
                        n9 = n6 - n11;
                        System.arraycopy(fArray4, 0, fArray3, 0, 3);
                        this.facenorm(fArray, n10, n10 + n6, n10 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n10, n10 + 1, n10 + n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        if (n11 == 1) {
                            this.facenorm(fArray, n9, n9 - n6 + 1, n9 + n6, fArray5);
                        } else {
                            this.facenorm(fArray, n9, n9 + 1, n9 + n6, fArray5);
                        }
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n9, n9 + n6, n9 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.mul3AndSet(fArray3, 0, f4);
                        this.norm3AndSet(fArray3, 0);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                        System.arraycopy(fArray3, 0, fArray2, 3 * n9, 3);
                    }
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    for (n11 = 0; n11 <= n; ++n11) {
                        n10 = n11 + n + n2;
                        this.facenorm(fArray, n10, n10 + n6 + 1, n10 + n6, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    n10 = n + n2;
                    this.facenorm(fArray, n10, n10 + n6, n10 - 1, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    n10 = 2 * n + n2;
                    this.facenorm(fArray, n10, n10 + 1, n10 + n6, fArray5);
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f4);
                    this.norm3AndSet(fArray3, 0);
                    for (n11 = 0; n11 <= n; ++n11) {
                        n10 = n11 + n + n2;
                        System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                    }
                    continue;
                }
                for (n11 = 0; n11 < n6; ++n11) {
                    n10 = n11 + i * n6;
                    n9 = n10 - 1;
                    n8 = n10 + 1;
                    if (n11 == 0) {
                        n9 = i * n6;
                    } else if (n11 == n6 - 1) {
                        n8 = i;
                    }
                    n7 = i == 0 ? n10 + n6 : n10 - n6;
                    System.arraycopy(fArray4, 0, fArray3, 0, 3);
                    if (i == 0) {
                        this.facenorm(fArray, n10, n8, n7, fArray5);
                    } else {
                        this.facenorm(fArray, n10, n7, n8, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    if (i == 0) {
                        this.facenorm(fArray, n10, n7, n9, fArray5);
                    } else {
                        this.facenorm(fArray, n10, n9, n7, fArray5);
                    }
                    this.add3AndSet(fArray3, 0, fArray5, 0);
                    this.mul3AndSet(fArray3, 0, f4);
                    this.norm3AndSet(fArray3, 0);
                    System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
                }
                continue;
            }
            for (n11 = 0; n11 < n6; ++n11) {
                n10 = n11 + i * n6;
                n9 = n10 - 1;
                n8 = n10 + 1;
                if (n11 == 0) {
                    n9 = n6 - 1 + i * n6;
                } else if (n11 == n6 - 1) {
                    n8 = i * n6;
                }
                n7 = n10 - n6;
                int n12 = n10 + n6;
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                this.facenorm(fArray, n10, n9, n9 - n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n9 - n6, n7, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n7, n8 - n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n8 - n6, n8, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n8, n8 + n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n8 + n6, n12, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n12, n9 + n6, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.facenorm(fArray, n10, n9 + n6, n9, fArray5);
                this.add3AndSet(fArray3, 0, fArray5, 0);
                this.mul3AndSet(fArray3, 0, f4);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n10, 3);
            }
        }
    }

    public void makeLongDiskIndices(int n, int n2, int n3, int[] nArray) {
        int n4 = this.getLongDiskIndexCount(n, n2, n3);
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n + " lengthSlices=" + n2 + " loops=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n5 = 2 * (n + 1) + 2 * (n2 - 1);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (i != 0) {
                if (this.orientation == 1) {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7 + n5;
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                } else {
                    n7 = (i - 1) * n5;
                    nArray[n6++] = n7;
                    n7 = i * n5;
                    nArray[n6++] = n7;
                }
            }
            for (int j = 0; j <= n5; ++j) {
                n7 = j == n5 ? i * n5 : j + i * n5;
                if (this.orientation == 1) {
                    nArray[n6++] = n7;
                    nArray[n6++] = n7 + n5;
                    continue;
                }
                nArray[n6++] = n7 + n5;
                nArray[n6++] = n7;
            }
        }
    }

    public int computePolygonWindingOrder2(int n, int n2, Vec4[] vec4Array) {
        float f = this.computePolygonArea2(n, n2, vec4Array);
        int n3 = f < 0.0f ? 1 : 0;
        return n3;
    }

    public float computePolygonArea2(int n, int n2, Vec4[] vec4Array) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pos=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = "nullValue.PointsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "points.length < " + (n + n2));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = i == n2 - 1 ? n : n + i + 1;
            f = (float)((double)f + vec4Array[n3].x * vec4Array[n4].y);
            f = (float)((double)f - vec4Array[n4].x * vec4Array[n3].y);
        }
        return f /= 2.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedTriangleArray tessellatePolygon(int n, int n2, float[] fArray, Vec4 vec4) {
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3 * n2];
        if (vec4 == null) {
            vec4 = Vec4.UNIT_Z;
        }
        TessellatorCallback tessellatorCallback = new TessellatorCallback(this, n2, fArray);
        GLUTessellatorSupport gLUTessellatorSupport = new GLUTessellatorSupport();
        gLUTessellatorSupport.beginTessellation(tessellatorCallback, vec4);
        try {
            GLU.gluTessBeginPolygon(gLUTessellatorSupport.getGLUtessellator(), null);
            GLU.gluTessBeginContour(gLUTessellatorSupport.getGLUtessellator());
            for (int i = 0; i < n2; ++i) {
                int n3 = 3 * (n + i);
                int n4 = 3 * i;
                dArray[n4] = fArray[n3];
                dArray[n4 + 1] = fArray[n3 + 1];
                dArray[n4 + 2] = fArray[n3 + 2];
                GLU.gluTessVertex(gLUTessellatorSupport.getGLUtessellator(), dArray, n4, n + i);
            }
            GLU.gluTessEndContour(gLUTessellatorSupport.getGLUtessellator());
            GLU.gluTessEndPolygon(gLUTessellatorSupport.getGLUtessellator());
        }
        finally {
            gLUTessellatorSupport.endTessellation();
        }
        return new IndexedTriangleArray(tessellatorCallback.getIndexCount(), tessellatorCallback.getIndices(), tessellatorCallback.getVertexCount(), tessellatorCallback.getVertices());
    }

    public IndexedTriangleArray tessellatePolygon2(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.tessellatePolygon(n, n2, fArray, Vec4.UNIT_Z);
    }

    public int getIndexedTriangleBufferDrawMode() {
        return 4;
    }

    public void subdivideIndexedTriangleBuffer(IndexedTriangleBuffer indexedTriangleBuffer) {
        int n;
        int n2;
        int n3;
        if (indexedTriangleBuffer == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = indexedTriangleBuffer.getIndexCount();
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>();
        for (n3 = 0; n3 < n4; n3 += 3) {
            for (int i = 0; i < 3; ++i) {
                n2 = indexedTriangleBuffer.indices.get(n3 + i);
                Edge edge = new Edge(n2, n = indexedTriangleBuffer.indices.get(i < 2 ? n3 + i + 1 : n3));
                Integer n5 = (Integer)hashMap.get(edge);
                if (n5 != null) continue;
                n5 = this.splitVertex(indexedTriangleBuffer, n2, n);
                hashMap.put(edge, n5);
            }
        }
        for (n3 = 0; n3 < n4; n3 += 3) {
            n2 = indexedTriangleBuffer.indices.get(n3);
            n = indexedTriangleBuffer.indices.get(n3 + 1);
            int n6 = indexedTriangleBuffer.indices.get(n3 + 2);
            int n7 = (Integer)hashMap.get(new Edge(n2, n));
            int n8 = (Integer)hashMap.get(new Edge(n, n6));
            int n9 = (Integer)hashMap.get(new Edge(n6, n2));
            this.indexSplitTriangle(indexedTriangleBuffer, n3, n2, n, n6, n7, n8, n9);
        }
    }

    public void makeIndexedTriangleBufferNormals(IndexedTriangleBuffer indexedTriangleBuffer, FloatBuffer floatBuffer) {
        if (indexedTriangleBuffer == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 3 * indexedTriangleBuffer.vertexCount;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n) {
            String string = "generic.DestinationArrayInvalidLength " + floatBuffer.capacity();
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeIndexedTriangleBufferNormals(0, indexedTriangleBuffer.getIndexCount(), indexedTriangleBuffer.getIndices(), 0, indexedTriangleBuffer.getVertexCount(), indexedTriangleBuffer.getVertices(), floatBuffer);
    }

    public void makeIndexedTriangleBufferNormals(int n, int n2, IntBuffer intBuffer, int n3, int n4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n5;
        int n6;
        if (intBuffer == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer.capacity() < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + intBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2.capacity() < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer2.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray = new float[3];
        int[] nArray = new int[3];
        for (int i = 0; i < n2; i += 3) {
            nArray[0] = intBuffer.get(n + i);
            nArray[1] = intBuffer.get(n + i + 1);
            nArray[2] = intBuffer.get(n + i + 2);
            this.facenorm(floatBuffer, nArray[0], nArray[1], nArray[2], fArray);
            for (n6 = 0; n6 < 3; ++n6) {
                n5 = 3 * nArray[n6];
                this.add3AndSet(floatBuffer2, n5, fArray, 0);
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            n5 = 3 * (n3 + n6);
            this.mul3AndSet(floatBuffer2, n5, f);
            this.norm3AndSet(floatBuffer2, n5);
        }
        floatBuffer2.rewind();
    }

    private int splitVertex(IndexedTriangleBuffer indexedTriangleBuffer, int n, int n2) {
        int n3 = indexedTriangleBuffer.vertices.capacity();
        int n4 = 3 * (indexedTriangleBuffer.getVertexCount() + 1);
        while (n4 > n3) {
            int n5 = 2 * n3;
            indexedTriangleBuffer.vertices = this.copyOf(indexedTriangleBuffer.vertices, n5);
            n3 = n5;
        }
        int n6 = indexedTriangleBuffer.getVertexCount();
        int n7 = 3 * n6;
        int n8 = 3 * n;
        int n9 = 3 * n2;
        indexedTriangleBuffer.vertices.put(n7, (indexedTriangleBuffer.vertices.get(n8) + indexedTriangleBuffer.vertices.get(n9)) / 2.0f);
        indexedTriangleBuffer.vertices.put(n7 + 1, (indexedTriangleBuffer.vertices.get(n8 + 1) + indexedTriangleBuffer.vertices.get(n9 + 1)) / 2.0f);
        indexedTriangleBuffer.vertices.put(n7 + 2, (indexedTriangleBuffer.vertices.get(n8 + 2) + indexedTriangleBuffer.vertices.get(n9 + 2)) / 2.0f);
        indexedTriangleBuffer.vertexCount++;
        return n6;
    }

    public void makeEllipsoidNormals(IndexedTriangleBuffer indexedTriangleBuffer, FloatBuffer floatBuffer) {
        if (indexedTriangleBuffer == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 3 * indexedTriangleBuffer.vertexCount;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n) {
            String string = "generic.DestinationArrayInvalidLength " + floatBuffer.capacity();
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeEllipsoidNormals(0, indexedTriangleBuffer.getIndexCount(), indexedTriangleBuffer.getIndices(), 0, indexedTriangleBuffer.getVertexCount(), indexedTriangleBuffer.getVertices(), floatBuffer);
    }

    public void makeEllipsoidNormals(int n, int n2, IntBuffer intBuffer, int n3, int n4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (intBuffer == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer.capacity() < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + intBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2.capacity() < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer2.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        for (int i = 0; i < 3 * n4; ++i) {
            floatBuffer2.put(i, floatBuffer.get(i));
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = 3 * (n3 + i);
            this.mul3AndSet(floatBuffer2, n5, f);
            this.norm3AndSet(floatBuffer2, n5);
        }
        floatBuffer2.rewind();
    }

    public void makeCylinderNormals(IndexedTriangleBuffer indexedTriangleBuffer, FloatBuffer floatBuffer) {
        if (indexedTriangleBuffer == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 3 * indexedTriangleBuffer.vertexCount;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n) {
            String string = "generic.DestinationArrayInvalidLength " + floatBuffer.capacity();
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeCylinderNormals(0, indexedTriangleBuffer.getIndexCount(), indexedTriangleBuffer.getIndices(), 0, indexedTriangleBuffer.getVertexCount(), indexedTriangleBuffer.getVertices(), floatBuffer);
    }

    public void makeCylinderNormals(int n, int n2, IntBuffer intBuffer, int n3, int n4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (intBuffer == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer.capacity() < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + intBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2.capacity() < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer2.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        for (int i = 0; i < 3 * n4; ++i) {
            if (i % 3 == 2) {
                floatBuffer2.put(i, 0.0f);
                continue;
            }
            floatBuffer2.put(i, -floatBuffer.get(i));
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = 3 * (n3 + i);
            this.mul3AndSet(floatBuffer2, n5, f);
            this.norm3AndSet(floatBuffer2, n5);
        }
        floatBuffer2.rewind();
    }

    private void indexSplitTriangle(IndexedTriangleBuffer indexedTriangleBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = indexedTriangleBuffer.indices.capacity();
        int n9 = indexedTriangleBuffer.getIndexCount() + 9;
        while (n9 > n8) {
            int n10 = 2 * n8;
            indexedTriangleBuffer.indices = this.copyOf(indexedTriangleBuffer.indices, n10);
            n8 = n10;
        }
        indexedTriangleBuffer.indices.put(n, n2);
        indexedTriangleBuffer.indices.put(n + 1, n5);
        indexedTriangleBuffer.indices.put(n + 2, n7);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n5);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n6);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n7);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n5);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n3);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n6);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n7);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n6);
        indexedTriangleBuffer.indices.put(indexedTriangleBuffer.indexCount++, n4);
    }

    public void fixSphereSeam(IndexedTriangleBuffer indexedTriangleBuffer, float f) {
        int n = -1;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = indexedTriangleBuffer.getIndexCount();
        for (int i = 0; i < n2; i += 3) {
            double d;
            double d2;
            int n3 = indexedTriangleBuffer.indices.get(i);
            int n4 = indexedTriangleBuffer.indices.get(i + 1);
            int n5 = indexedTriangleBuffer.indices.get(i + 2);
            double d3 = indexedTriangleBuffer.vertices.get(3 * n3);
            double d4 = indexedTriangleBuffer.vertices.get(3 * n3 + 1);
            double d5 = indexedTriangleBuffer.vertices.get(3 * n4);
            double d6 = indexedTriangleBuffer.vertices.get(3 * n4 + 1);
            double d7 = indexedTriangleBuffer.vertices.get(3 * n5);
            double d8 = indexedTriangleBuffer.vertices.get(3 * n5 + 1);
            double d9 = Math.atan2(d4, d3);
            if (d9 < 0.0) {
                d9 += Math.PI * 2;
            }
            if ((d2 = Math.atan2(d6, d5)) < 0.0) {
                d2 += Math.PI * 2;
            }
            if ((d = Math.atan2(d8, d7)) < 0.0) {
                d += Math.PI * 2;
            }
            if (Math.abs(d9 - d2) > (double)f) {
                n = Math.abs(d9 - d) > (double)f ? i : i + 1;
            } else if (Math.abs(d2 - d) > (double)f) {
                n = i + 2;
            }
            if (n < 0) continue;
            Integer n6 = indexedTriangleBuffer.indices.get(n);
            Integer n7 = (Integer)hashMap.get(n6);
            if (n7 != null) {
                indexedTriangleBuffer.indices.put(n, n7);
            } else {
                n7 = this.duplicateVertex(indexedTriangleBuffer, n6);
                hashMap.put(n6, n7);
                indexedTriangleBuffer.indices.put(n, n7);
            }
            n = -1;
        }
    }

    private int duplicateVertex(IndexedTriangleBuffer indexedTriangleBuffer, int n) {
        if (indexedTriangleBuffer == null) {
            String string = Logging.getMessage("nullValue.IndexedTriangleBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n >= indexedTriangleBuffer.vertexCount) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "sourceIndex > vertexCount");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = indexedTriangleBuffer.vertices.capacity();
        int n3 = 3 * indexedTriangleBuffer.getVertexCount() + 3;
        while (n3 > n2) {
            int n4 = 2 * n2;
            indexedTriangleBuffer.vertices = this.copyOf(indexedTriangleBuffer.vertices, n4);
            n2 = n4;
        }
        int n5 = indexedTriangleBuffer.getVertexCount();
        indexedTriangleBuffer.vertices.put(3 * n5, indexedTriangleBuffer.vertices.get(3 * n));
        indexedTriangleBuffer.vertices.put(3 * n5 + 1, indexedTriangleBuffer.vertices.get(3 * n + 1));
        indexedTriangleBuffer.vertices.put(3 * n5 + 2, indexedTriangleBuffer.vertices.get(3 * n + 2));
        indexedTriangleBuffer.vertexCount++;
        return indexedTriangleBuffer.vertexCount - 1;
    }

    public void makeUnitSphereTextureCoordinates(IndexedTriangleBuffer indexedTriangleBuffer, FloatBuffer floatBuffer) {
        if (indexedTriangleBuffer == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 2 * indexedTriangleBuffer.vertexCount;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n) {
            String string = "generic.DestinationArrayInvalidLength " + floatBuffer.capacity();
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeUnitSphereTextureCoordinates(indexedTriangleBuffer.getVertexCount(), indexedTriangleBuffer.getVertices(), floatBuffer, -1);
    }

    public void makeUnitSphereTextureCoordinates(IndexedTriangleBuffer indexedTriangleBuffer, FloatBuffer floatBuffer, int n) {
        if (indexedTriangleBuffer == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 2 * indexedTriangleBuffer.vertexCount;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < n2) {
            String string = "generic.DestinationArrayInvalidLength " + floatBuffer.capacity();
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeUnitSphereTextureCoordinates(indexedTriangleBuffer.getVertexCount(), indexedTriangleBuffer.getVertices(), floatBuffer, n);
    }

    public void makeUnitSphereTextureCoordinates(int n, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n2) {
        double d;
        int n3;
        if (floatBuffer == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < 3 * n) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer2.capacity() < 2 * n) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer2.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (n3 = 0; n3 < n; ++n3) {
            double d2 = floatBuffer.get(3 * n3);
            double d3 = floatBuffer.get(3 * n3 + 1);
            double d4 = floatBuffer.get(3 * n3 + 2);
            double d5 = Math.atan2(d3, d2);
            double d6 = Math.acos(d4);
            if (d5 < 0.0) {
                d5 += Math.PI * 2;
            }
            d = d5 / (Math.PI * 2);
            double d7 = (Math.PI - d6) / Math.PI;
            floatBuffer2.put(2 * n3, (float)d);
            floatBuffer2.put(2 * n3 + 1, (float)d7);
        }
        if (n2 > 0) {
            for (n3 = n2; n3 < n; ++n3) {
                d = floatBuffer2.get(2 * n3);
                if (d < 0.5) {
                    floatBuffer2.put(2 * n3, (float)d + 1.0f);
                    continue;
                }
                floatBuffer2.put(2 * n3, (float)d - 1.0f);
            }
        }
        floatBuffer2.rewind();
    }

    public void makeUnitBoxTextureCoordinates(FloatBuffer floatBuffer, int n) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < 2 * n) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < n; i += 4) {
            floatBuffer.put(2 * i, 0.0f);
            floatBuffer.put(2 * i + 1, 1.0f);
            floatBuffer.put(2 * i + 2, 1.0f);
            floatBuffer.put(2 * i + 3, 1.0f);
            floatBuffer.put(2 * i + 4, 0.0f);
            floatBuffer.put(2 * i + 5, 0.0f);
            floatBuffer.put(2 * i + 6, 1.0f);
            floatBuffer.put(2 * i + 7, 0.0f);
        }
        floatBuffer.rewind();
    }

    public void makeUnitBoxTextureCoordinates(int n, FloatBuffer floatBuffer, int n2) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < 2 * n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < n2; i += 4) {
            floatBuffer.put(2 * i, 0.0f);
            floatBuffer.put(2 * i + 1, 1.0f);
            floatBuffer.put(2 * i + 2, 1.0f);
            floatBuffer.put(2 * i + 3, 1.0f);
            floatBuffer.put(2 * i + 4, 0.0f);
            floatBuffer.put(2 * i + 5, 0.0f);
            floatBuffer.put(2 * i + 6, 1.0f);
            floatBuffer.put(2 * i + 7, 0.0f);
        }
        floatBuffer.rewind();
    }

    public void makeUnitPyramidTextureCoordinates(FloatBuffer floatBuffer, int n) {
        int n2;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < 2 * n) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < n - 4; n2 += 3) {
            floatBuffer.put(2 * n2, 0.5f);
            floatBuffer.put(2 * n2 + 1, 1.0f);
            floatBuffer.put(2 * n2 + 2, 0.0f);
            floatBuffer.put(2 * n2 + 3, 0.0f);
            floatBuffer.put(2 * n2 + 4, 1.0f);
            floatBuffer.put(2 * n2 + 5, 0.0f);
        }
        floatBuffer.put(2 * n2, 0.0f);
        floatBuffer.put(2 * n2 + 1, 1.0f);
        floatBuffer.put(2 * n2 + 2, 1.0f);
        floatBuffer.put(2 * n2 + 3, 1.0f);
        floatBuffer.put(2 * n2 + 4, 0.0f);
        floatBuffer.put(2 * n2 + 5, 0.0f);
        floatBuffer.put(2 * n2 + 6, 1.0f);
        floatBuffer.put(2 * n2 + 7, 0.0f);
        floatBuffer.rewind();
    }

    public void makeUnitPyramidTextureCoordinates(int n, FloatBuffer floatBuffer, int n2) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer.capacity() < 2 * n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + floatBuffer.capacity());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        if (n == 4) {
            floatBuffer.put(2 * n3, 0.0f);
            floatBuffer.put(2 * n3 + 1, 1.0f);
            floatBuffer.put(2 * n3 + 2, 1.0f);
            floatBuffer.put(2 * n3 + 3, 1.0f);
            floatBuffer.put(2 * n3 + 4, 0.0f);
            floatBuffer.put(2 * n3 + 5, 0.0f);
            floatBuffer.put(2 * n3 + 6, 1.0f);
            floatBuffer.put(2 * n3 + 7, 0.0f);
        } else {
            for (n3 = 0; n3 < n2; n3 += 3) {
                floatBuffer.put(2 * n3, 0.5f);
                floatBuffer.put(2 * n3 + 1, 1.0f);
                floatBuffer.put(2 * n3 + 2, 0.0f);
                floatBuffer.put(2 * n3 + 3, 0.0f);
                floatBuffer.put(2 * n3 + 4, 1.0f);
                floatBuffer.put(2 * n3 + 5, 0.0f);
            }
        }
        floatBuffer.rewind();
    }

    public void makeUnitCylinderTextureCoordinates(int n, FloatBuffer floatBuffer, int n2) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)Math.pow(2.0, 2 + n2);
        float f = (float)Math.PI * 2 / (float)n3;
        if (n == 2) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                float f2 = (float)i * f;
                float f3 = 1.0f - f2 / ((float)Math.PI * 2);
                floatBuffer.put(n4, f3);
                floatBuffer.put(n4 + 1, 1.0f);
                floatBuffer.put(n4 + 2, f3);
                floatBuffer.put(n4 + 3, 0.0f);
                n4 += 4;
            }
            floatBuffer.put(n4, 0.0f);
            floatBuffer.put(n4 + 1, 1.0f);
            floatBuffer.put(n4 + 2, 0.0f);
            floatBuffer.put(n4 + 3, 0.0f);
        } else {
            floatBuffer.put(0, 0.5f);
            floatBuffer.put(1, 0.5f);
            for (int i = 0; i < n3; ++i) {
                float f4 = (float)i * f;
                float f5 = (float)Math.sin(f4);
                float f6 = (float)Math.cos(f4);
                float f7 = f5 / 2.0f + 0.5f;
                float f8 = f6 / 2.0f + 0.5f;
                if (n == 1) {
                    f7 = 1.0f - f7;
                }
                floatBuffer.put(2 * (i + 1), f7);
                floatBuffer.put(2 * (i + 1) + 1, f8);
            }
        }
        floatBuffer.rewind();
    }

    public void makeWedgeTextureCoordinates(FloatBuffer floatBuffer, int n, Angle angle) {
        int n2;
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)Math.pow(2.0, 2 + n);
        float f = (float)angle.getRadians() / (float)n3;
        int n4 = 4 * (n3 + 2);
        floatBuffer.put(0, 0.5f);
        floatBuffer.put(1, 0.5f);
        floatBuffer.put(2 * (n3 + 2), 0.5f);
        floatBuffer.put(2 * (n3 + 2) + 1, 0.5f);
        for (n2 = 0; n2 <= n3; ++n2) {
            float f2 = (float)n2 * f;
            float f3 = (float)Math.sin(f2);
            float f4 = (float)Math.cos(f2);
            float f5 = f3 / 2.0f + 0.5f;
            float f6 = f4 / 2.0f + 0.5f;
            floatBuffer.put(2 * (n2 + 1), f5);
            floatBuffer.put(2 * (n2 + 1) + 1, f6);
            floatBuffer.put(2 * (n3 + n2 + 3), 1.0f - f5);
            floatBuffer.put(2 * (n3 + n2 + 3) + 1, f6);
            f5 = 1.0f - f2 / ((float)Math.PI * 2);
            floatBuffer.put(n4, f5);
            floatBuffer.put(n4 + 1, 1.0f);
            floatBuffer.put(n4 + 2, f5);
            floatBuffer.put(n4 + 3, 0.0f);
            n4 += 4;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            int n5 = 2 * (4 * (n3 + 1 + n2) + 2);
            floatBuffer.put(n5, 0.0f);
            floatBuffer.put(n5 + 1, 1.0f);
            floatBuffer.put(n5 + 2, 0.0f);
            floatBuffer.put(n5 + 3, 0.0f);
            floatBuffer.put(n5 + 4, 1.0f);
            floatBuffer.put(n5 + 5, 1.0f);
            floatBuffer.put(n5 + 6, 1.0f);
            floatBuffer.put(n5 + 7, 0.0f);
        }
        floatBuffer.rewind();
    }

    public void makeUnitWedgeTextureCoordinates(int n, FloatBuffer floatBuffer, int n2, Angle angle) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)Math.pow(2.0, 2 + n2);
        float f = (float)angle.getRadians() / (float)n3;
        if (n == 0 || n == 1) {
            floatBuffer.put(0, 0.5f);
            floatBuffer.put(1, 0.5f);
            for (int i = 0; i <= n3; ++i) {
                float f2 = (float)i * f;
                float f3 = (float)Math.sin(f2);
                float f4 = (float)Math.cos(f2);
                float f5 = f3 / 2.0f + 0.5f;
                float f6 = f4 / 2.0f + 0.5f;
                if (n == 1) {
                    f5 = 1.0f - f5;
                }
                floatBuffer.put(2 * (i + 1), f5);
                floatBuffer.put(2 * (i + 1) + 1, f6);
            }
        } else if (n == 2) {
            int n4 = 0;
            for (int i = 0; i <= n3; ++i) {
                float f7 = (float)i * f;
                float f8 = 1.0f - f7 / ((float)Math.PI * 2);
                floatBuffer.put(n4, f8);
                floatBuffer.put(n4 + 1, 1.0f);
                floatBuffer.put(n4 + 2, f8);
                floatBuffer.put(n4 + 3, 0.0f);
                n4 += 4;
            }
        } else if (n == 3) {
            floatBuffer.put(0, 1.0f);
            floatBuffer.put(1, 1.0f);
            floatBuffer.put(2, 1.0f);
            floatBuffer.put(3, 0.0f);
            floatBuffer.put(4, 0.0f);
            floatBuffer.put(5, 1.0f);
            floatBuffer.put(6, 0.0f);
            floatBuffer.put(7, 0.0f);
        } else if (n == 4) {
            floatBuffer.put(0, 0.0f);
            floatBuffer.put(1, 1.0f);
            floatBuffer.put(2, 0.0f);
            floatBuffer.put(3, 0.0f);
            floatBuffer.put(4, 1.0f);
            floatBuffer.put(5, 1.0f);
            floatBuffer.put(6, 1.0f);
            floatBuffer.put(7, 0.0f);
        }
        floatBuffer.rewind();
    }

    public void makeUnitConeTextureCoordinates(FloatBuffer floatBuffer, int n) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = (int)Math.pow(2.0, 2 + n);
        float f = (float)Math.PI * 2 / (float)n2;
        int n3 = 2 * (n2 + 1);
        floatBuffer.put(0, 0.5f);
        floatBuffer.put(1, 0.5f);
        for (int i = 0; i < n2; ++i) {
            float f2 = (float)i * f;
            float f3 = (float)Math.sin(f2);
            float f4 = (float)Math.cos(f2);
            float f5 = f3 / 2.0f + 0.5f;
            float f6 = f4 / 2.0f + 0.5f;
            floatBuffer.put(2 * (i + 1), 1.0f - f5);
            floatBuffer.put(2 * (i + 1) + 1, f6);
            f5 = 1.0f - f2 / ((float)Math.PI * 2);
            floatBuffer.put(n3, f5);
            floatBuffer.put(n3 + 1, 1.0f);
            floatBuffer.put(n3 + 2, f5);
            floatBuffer.put(n3 + 3, 0.0f);
            n3 += 4;
        }
        floatBuffer.put(n3, 0.0f);
        floatBuffer.put(n3 + 1, 1.0f);
        floatBuffer.put(n3 + 2, 0.0f);
        floatBuffer.put(n3 + 3, 0.0f);
        floatBuffer.rewind();
    }

    public void makeUnitConeTextureCoordinates(int n, FloatBuffer floatBuffer, int n2) {
        if (floatBuffer == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)Math.pow(2.0, 2 + n2);
        float f = (float)Math.PI * 2 / (float)n3;
        if (n == 1) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                float f2 = (float)i * f;
                float f3 = 1.0f - f2 / ((float)Math.PI * 2);
                floatBuffer.put(n4, f3);
                floatBuffer.put(n4 + 1, 1.0f);
                floatBuffer.put(n4 + 2, f3);
                floatBuffer.put(n4 + 3, 0.0f);
                n4 += 4;
            }
            floatBuffer.put(n4, 0.0f);
            floatBuffer.put(n4 + 1, 1.0f);
            floatBuffer.put(n4 + 2, 0.0f);
            floatBuffer.put(n4 + 3, 0.0f);
        } else if (n == 0) {
            floatBuffer.put(0, 0.5f);
            floatBuffer.put(1, 0.5f);
            for (int i = 0; i < n3; ++i) {
                float f4 = (float)i * f;
                float f5 = (float)Math.sin(f4);
                float f6 = (float)Math.cos(f4);
                float f7 = f5 / 2.0f + 0.5f;
                float f8 = f6 / 2.0f + 0.5f;
                floatBuffer.put(2 * (i + 1), 1.0f - f7);
                floatBuffer.put(2 * (i + 1) + 1, f8);
            }
        }
        floatBuffer.rewind();
    }

    public int getIndexedTriangleArrayDrawMode() {
        return 4;
    }

    public void subdivideIndexedTriangleArray(IndexedTriangleArray indexedTriangleArray) {
        int n;
        int n2;
        int n3;
        if (indexedTriangleArray == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = indexedTriangleArray.indexCount;
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>();
        for (n3 = 0; n3 < n4; n3 += 3) {
            for (int i = 0; i < 3; ++i) {
                n2 = indexedTriangleArray.indices[n3 + i];
                Edge edge = new Edge(n2, n = indexedTriangleArray.indices[i < 2 ? n3 + i + 1 : n3]);
                Integer n5 = (Integer)hashMap.get(edge);
                if (n5 != null) continue;
                n5 = this.splitVertex(indexedTriangleArray, n2, n);
                hashMap.put(edge, n5);
            }
        }
        for (n3 = 0; n3 < n4; n3 += 3) {
            n2 = indexedTriangleArray.indices[n3];
            n = indexedTriangleArray.indices[n3 + 1];
            int n6 = indexedTriangleArray.indices[n3 + 2];
            int n7 = (Integer)hashMap.get(new Edge(n2, n));
            int n8 = (Integer)hashMap.get(new Edge(n, n6));
            int n9 = (Integer)hashMap.get(new Edge(n6, n2));
            this.indexSplitTriangle(indexedTriangleArray, n3, n2, n, n6, n7, n8, n9);
        }
    }

    public IndexedTriangleArray subdivideIndexedTriangles(int n, int[] nArray, int n2, float[] fArray) {
        int n3 = 3 * n2;
        if (nArray == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n3) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        IndexedTriangleArray indexedTriangleArray = new IndexedTriangleArray(n, nArray, n2, fArray);
        this.subdivideIndexedTriangleArray(indexedTriangleArray);
        return indexedTriangleArray;
    }

    public void makeIndexedTriangleArrayNormals(IndexedTriangleArray indexedTriangleArray, float[] fArray) {
        if (indexedTriangleArray == null) {
            String string = "nullValue.IndexedTriangleArray";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 3 * indexedTriangleArray.vertexCount;
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeIndexedTriangleArrayNormals(0, indexedTriangleArray.indexCount, indexedTriangleArray.indices, 0, indexedTriangleArray.vertexCount, indexedTriangleArray.vertices, fArray);
    }

    public void makeIndexedTriangleArrayNormals(int n, int n2, int[] nArray, int n3, int n4, float[] fArray, float[] fArray2) {
        int n5;
        int n6;
        if (nArray == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n3 + n4) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + fArray2.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        int[] nArray2 = new int[3];
        for (int i = 0; i < n2; i += 3) {
            nArray2[0] = nArray[n + i];
            nArray2[1] = nArray[n + i + 1];
            nArray2[2] = nArray[n + i + 2];
            this.facenorm(fArray, nArray2[0], nArray2[1], nArray2[2], fArray3);
            for (n6 = 0; n6 < 3; ++n6) {
                n5 = 3 * nArray2[n6];
                this.add3AndSet(fArray2, n5, fArray3, 0);
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            n5 = 3 * (n3 + n6);
            this.mul3AndSet(fArray2, n5, f);
            this.norm3AndSet(fArray2, n5);
        }
    }

    public void makeIndexedTriangleStripNormals(int n, int n2, int[] nArray, int n3, int n4, float[] fArray, float[] fArray2) {
        int n5;
        int n6;
        if (nArray == null) {
            String string = "nullValue.IndexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "indices.length=" + nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.VertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < 3 * (n3 + n4)) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < 3 * (n3 + n4)) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "dest.length=" + fArray2.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        int[] nArray2 = new int[3];
        for (int i = 2; i < n2; ++i) {
            if (i % 2 == 0) {
                nArray2[0] = nArray[n + i - 2];
                nArray2[1] = nArray[n + i - 1];
                nArray2[2] = nArray[n + i];
            } else {
                nArray2[0] = nArray[n + i - 1];
                nArray2[1] = nArray[n + i - 2];
                nArray2[2] = nArray[n + i];
            }
            this.facenorm(fArray, nArray2[0], nArray2[1], nArray2[2], fArray3);
            for (n6 = 0; n6 < 3; ++n6) {
                n5 = 3 * nArray2[n6];
                this.add3AndSet(fArray2, n5, fArray3, 0);
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            n5 = 3 * (n3 + n6);
            this.mul3AndSet(fArray2, n5, f);
            this.norm3AndSet(fArray2, n5);
        }
    }

    private int splitVertex(IndexedTriangleArray indexedTriangleArray, int n, int n2) {
        int n3 = indexedTriangleArray.vertices.length;
        int n4 = 3 * (indexedTriangleArray.vertexCount + 1);
        while (n4 > n3) {
            int n5 = 2 * n3;
            IndexedTriangleArray.access$1202(indexedTriangleArray, this.copyOf(indexedTriangleArray.vertices, n5));
            n3 = n5;
        }
        int n6 = indexedTriangleArray.vertexCount;
        int n7 = 3 * n6;
        int n8 = 3 * n;
        int n9 = 3 * n2;
        ((IndexedTriangleArray)indexedTriangleArray).vertices[n7] = (indexedTriangleArray.vertices[n8] + indexedTriangleArray.vertices[n9]) / 2.0f;
        ((IndexedTriangleArray)indexedTriangleArray).vertices[n7 + 1] = (indexedTriangleArray.vertices[n8 + 1] + indexedTriangleArray.vertices[n9 + 1]) / 2.0f;
        ((IndexedTriangleArray)indexedTriangleArray).vertices[n7 + 2] = (indexedTriangleArray.vertices[n8 + 2] + indexedTriangleArray.vertices[n9 + 2]) / 2.0f;
        indexedTriangleArray.vertexCount++;
        return n6;
    }

    private void indexSplitTriangle(IndexedTriangleArray indexedTriangleArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = indexedTriangleArray.indices.length;
        int n9 = indexedTriangleArray.indexCount + 9;
        while (n9 > n8) {
            int n10 = 2 * n8;
            IndexedTriangleArray.access$1102(indexedTriangleArray, this.copyOf(indexedTriangleArray.indices, n10));
            n8 = n10;
        }
        ((IndexedTriangleArray)indexedTriangleArray).indices[n] = n2;
        ((IndexedTriangleArray)indexedTriangleArray).indices[n + 1] = n5;
        ((IndexedTriangleArray)indexedTriangleArray).indices[n + 2] = n7;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n5;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n6;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n7;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n5;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n3;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n6;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n7;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n6;
        ((IndexedTriangleArray)indexedTriangleArray).indices[((IndexedTriangleArray)indexedTriangleArray).indexCount++] = n4;
    }

    public int getSubdivisionPointsVertexCount(int n) {
        return (1 << n) + 1;
    }

    public void makeSubdivisionPoints(float f, float f2, float f3, float f4, float f5, float f6, int n, float[] fArray) {
        int n2 = this.getSubdivisionPointsVertexCount(n);
        int n3 = 3 * n2;
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n3) {
            String string = "generic.DestinationArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        int n5 = n2 - 1;
        int n6 = 3 * n4;
        fArray[n6] = f;
        fArray[n6 + 1] = f2;
        fArray[n6 + 2] = f3;
        n6 = 3 * n5;
        fArray[n6] = f4;
        fArray[n6 + 1] = f5;
        fArray[n6 + 2] = f6;
        this.subdivide(f, f2, f3, f4, f5, f6, n, fArray, n4, n5);
    }

    private void subdivide(float f, float f2, float f3, float f4, float f5, float f6, int n, float[] fArray, int n2, int n3) {
        if (n <= 0) {
            return;
        }
        float f7 = (f + f4) / 2.0f;
        float f8 = (f2 + f5) / 2.0f;
        float f9 = (f3 + f6) / 2.0f;
        int n4 = (n2 + n3) / 2;
        int n5 = n4 * 3;
        fArray[n5] = f7;
        fArray[n5 + 1] = f8;
        fArray[n5 + 2] = f9;
        if (n > 1) {
            this.subdivide(f, f2, f3, f7, f8, f9, n - 1, fArray, n2, n4);
            this.subdivide(f7, f8, f9, f4, f5, f6, n - 1, fArray, n4, n3);
        }
    }

    public int getBilinearSurfaceFillIndexCount(int n, int n2) {
        return n2 * 2 * (n + 1) + 2 * (n2 - 1);
    }

    public int getBilinearSurfaceOutlineIndexCount(int n, int n2, int n3) {
        int n4 = 0;
        if ((n3 & 1) != 0) {
            n4 += 2 * n;
        }
        if ((n3 & 2) != 0) {
            n4 += 2 * n;
        }
        if ((n3 & 4) != 0) {
            n4 += 2 * n2;
        }
        if ((n3 & 8) != 0) {
            n4 += 2 * n2;
        }
        return n4;
    }

    public int getBilinearSurfaceVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    public int getBilinearSurfaceFillDrawMode() {
        return 5;
    }

    public int getBilinearSurfaceOutlineDrawMode() {
        return 1;
    }

    public void makeBilinearSurfaceFillIndices(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = this.getBilinearSurfaceFillIndexCount(n2, n3);
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n5 + n4) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n6 = n4;
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (i != 0) {
                if (this.orientation == 1) {
                    n7 = n2 + i * (n2 + 1);
                    nArray[n6++] = n + n7;
                    n7 = i * (n2 + 1);
                    nArray[n6++] = n + n7;
                } else {
                    n7 = n2 + (i - 1) * (n2 + 1);
                    nArray[n6++] = n + n7;
                    n7 = i * (n2 + 1) + (n2 + 1);
                    nArray[n6++] = n + n7;
                }
            }
            for (int j = 0; j <= n2; ++j) {
                n7 = j + i * (n2 + 1);
                if (this.orientation == 1) {
                    nArray[n6++] = n + n7;
                    nArray[n6++] = n + n7 + (n2 + 1);
                    continue;
                }
                nArray[n6++] = n + n7 + (n2 + 1);
                nArray[n6++] = n + n7;
            }
        }
    }

    public void makeBilinearSurfaceOutlineIndices(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7;
        int n8;
        int n9 = this.getBilinearSurfaceOutlineIndexCount(n2, n3, n4);
        if (n9 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length < n9 + n5) {
            String string = "generic.DestinationArrayInvalidLength " + nArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n10 = n5;
        if ((n4 & 2) != 0) {
            for (n8 = 0; n8 < n2; ++n8) {
                n7 = n8;
                nArray[n10++] = n + n7;
                n7 = n8 + 1;
                nArray[n10++] = n + n7;
            }
        }
        if ((n4 & 8) != 0) {
            for (n6 = 0; n6 < n3; ++n6) {
                n7 = n2 + n6 * (n2 + 1);
                nArray[n10++] = n + n7;
                n7 = n2 + (n6 + 1) * (n2 + 1);
                nArray[n10++] = n + n7;
            }
        }
        if ((n4 & 1) != 0) {
            for (n8 = n2; n8 > 0; --n8) {
                n7 = n8 + n3 * (n2 + 1);
                nArray[n10++] = n + n7;
                n7 = n8 - 1 + n3 * (n2 + 1);
                nArray[n10++] = n + n7;
            }
        }
        if ((n4 & 4) != 0) {
            for (n6 = n3; n6 > 0; --n6) {
                n7 = n6 * (n2 + 1);
                nArray[n10++] = n + n7;
                n7 = (n6 - 1) * (n2 + 1);
                nArray[n10++] = n + n7;
            }
        }
    }

    public void makeBilinearSurfaceVertices(float[] fArray, int n, int n2, int n3, float[] fArray2) {
        int n4 = this.getBilinearSurfaceVertexCount(n2, n3);
        int n5 = 3 * n4;
        if (fArray == null) {
            String string = "nullValue.ControlPointArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < 12) {
            String string = "generic.ControlPointArrayInvalidLength " + fArray.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n4 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n5 + 3 * n) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = 1.0f / (float)n2;
        float f2 = 1.0f / (float)n3;
        for (int i = 0; i <= n3; ++i) {
            float f3 = (float)i * f2;
            float f4 = 1.0f - f3;
            for (int j = 0; j <= n2; ++j) {
                float f5 = (float)j * f;
                float f6 = 1.0f - f5;
                int n6 = j + i * (n2 + 1);
                n6 = 3 * (n + n6);
                float f7 = f6 * f4 * fArray[0] + f5 * f4 * fArray[3] + f5 * f3 * fArray[6] + f6 * f3 * fArray[9];
                float f8 = f6 * f4 * fArray[1] + f5 * f4 * fArray[4] + f5 * f3 * fArray[7] + f6 * f3 * fArray[10];
                float f9 = f6 * f4 * fArray[2] + f5 * f4 * fArray[5] + f5 * f3 * fArray[8] + f6 * f3 * fArray[11];
                fArray2[n6] = f7;
                fArray2[n6 + 1] = f8;
                fArray2[n6 + 2] = f9;
            }
        }
    }

    public void makeBilinearSurfaceVertexNormals(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2) {
        int n5 = this.getBilinearSurfaceVertexCount(n2, n3);
        int n6 = 3 * n5;
        if (n5 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "uStacks=" + n2 + " vStacks=" + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.SourceVertexArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2 == null) {
            String string = "nullValue.DestinationArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray2.length < n6 + 3 * n4) {
            String string = "generic.DestinationArrayInvalidLength " + fArray2.length;
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = this.orientation == 0 ? 1.0f : -1.0f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n7 = j + i * (n2 + 1);
                n7 = n + n7;
                int n8 = n7 - (n2 + 1);
                int n9 = n7 + (n2 + 1);
                System.arraycopy(fArray4, 0, fArray3, 0, 3);
                if (i > 0) {
                    if (j > 0) {
                        this.facenorm(fArray, n7, n7 - 1, n8 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n8 - 1, n8, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    if (j < n2) {
                        this.facenorm(fArray, n7, n8, n8 + 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n8 + 1, n7 + 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                }
                if (i < n3) {
                    if (j > 0) {
                        this.facenorm(fArray, n7, n9, n9 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n9 - 1, n7 - 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                    if (j < n2) {
                        this.facenorm(fArray, n7, n7 + 1, n9 + 1, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                        this.facenorm(fArray, n7, n9 + 1, n9, fArray5);
                        this.add3AndSet(fArray3, 0, fArray5, 0);
                    }
                }
                this.mul3AndSet(fArray3, 0, f);
                this.norm3AndSet(fArray3, 0);
                System.arraycopy(fArray3, 0, fArray2, 3 * n7, 3);
            }
        }
    }

    public FloatBuffer makeEllipse(float f, float f2, float f3, float f4, int n) {
        if (f3 < 0.0f) {
            String string = Logging.getMessage("Geom.RadiusIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f) {
            String string = Logging.getMessage("Geom.RadiusIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.NumSlicesIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 1) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2);
            floatBuffer.rewind();
            return floatBuffer;
        }
        float f5 = (float)Math.PI * 2 / (float)n;
        float f6 = 0.0f;
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(2 * n);
        int n2 = 0;
        while (n2 < n) {
            floatBuffer.put(f + (float)Math.cos(f6) * f3);
            floatBuffer.put(f2 + (float)Math.sin(f6) * f4);
            ++n2;
            f6 += f5;
        }
        floatBuffer.rewind();
        return floatBuffer;
    }

    public FloatBuffer makeEllipseWithLeader(float f, float f2, float f3, float f4, int n, float f5, float f6, float f7) {
        float f8;
        float f9;
        float f10;
        if (f3 < 0.0f) {
            String string = Logging.getMessage("Geom.RadiusIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f) {
            String string = Logging.getMessage("Geom.RadiusIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.NumSlicesIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f7 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f7 == 0.0f) {
            return this.makeEllipse(f, f2, f3, f4, n);
        }
        int n2 = this.computeLeaderLocationCode(f - f3, f2 - f4, f + f3, f2 + f4, f5, f6);
        if (n2 == 0) {
            return this.makeEllipse(f, f2, f3, f4, n);
        }
        if (n <= 1) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n2 & 2) != 0) {
            f10 = 2.0f * f3;
            if (f7 > f10) {
                f7 = f10;
            }
            f9 = f7 / f3;
            f8 = 4.712389f;
        } else if ((n2 & 1) != 0) {
            f10 = 2.0f * f3;
            if (f7 > f10) {
                f7 = f10;
            }
            f9 = f7 / f3;
            f8 = 1.5707964f;
        } else if ((n2 & 8) != 0) {
            f10 = 2.0f * f4;
            if (f7 > f10) {
                f7 = f10;
            }
            f9 = f7 / f4;
            f8 = (float)Math.PI;
        } else if ((n2 & 4) != 0) {
            f10 = 2.0f * f4;
            if (f7 > f10) {
                f7 = f10;
            }
            f9 = f7 / f4;
            f8 = 0.0f;
        } else {
            return this.makeEllipse(f, f2, f3, f4, n);
        }
        f10 = (float)(Math.PI * 2 - (double)f9) / (float)n;
        float f11 = f8 + f9 / 2.0f;
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(2 * n + 6);
        floatBuffer.put(f + (float)Math.cos(f8 + f9 / 2.0f) * f3);
        floatBuffer.put(f2 + (float)Math.sin(f8 + f9 / 2.0f) * f4);
        int n3 = 0;
        while (n3 < n) {
            floatBuffer.put(f + (float)Math.cos(f11) * f3);
            floatBuffer.put(f2 + (float)Math.sin(f11) * f4);
            ++n3;
            f11 += f10;
        }
        floatBuffer.put(f + (float)Math.cos(f8 - f9 / 2.0f) * f3);
        floatBuffer.put(f2 + (float)Math.sin(f8 - f9 / 2.0f) * f4);
        floatBuffer.put(f5);
        floatBuffer.put(f6);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public FloatBuffer makeRectangle(float f, float f2, float f3, float f4) {
        if (f3 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f) {
            String string = Logging.getMessage("Geom.HeightIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(8);
        floatBuffer.put(f);
        floatBuffer.put(f2);
        floatBuffer.put(f + f3);
        floatBuffer.put(f2);
        floatBuffer.put(f + f3);
        floatBuffer.put(f2 + f4);
        floatBuffer.put(f);
        floatBuffer.put(f2 + f4);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public FloatBuffer makeRectangle(float f, float f2, float f3, float f4, float f5, int n) {
        if (f3 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f) {
            String string = Logging.getMessage("Geom.HeightIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f5 < 0.0f) {
            String string = Logging.getMessage("Geom.RadiusIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.NumSlicesIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f6 = Math.min(f3, f4) / 2.0f;
        if (f5 > f6) {
            f5 = f6;
        }
        if (f5 == 0.0f || n == 0) {
            return this.makeRectangle(f, f2, f3, f4);
        }
        float f7 = 1.5707964f;
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(16 + 8 * (n - 1));
        floatBuffer.put(f);
        floatBuffer.put(f2 + f5);
        this.addRectangleRoundedCorner(f + f5, f + f5, f5, (float)Math.PI, f7, n, floatBuffer);
        floatBuffer.put(f + f5);
        floatBuffer.put(f2);
        floatBuffer.put(f + f3 - f5);
        floatBuffer.put(f2);
        this.addRectangleRoundedCorner(f + f3 - f5, f2 + f5, f5, -f7, f7, n, floatBuffer);
        floatBuffer.put(f + f3);
        floatBuffer.put(f2 + f5);
        floatBuffer.put(f + f3);
        floatBuffer.put(f2 + f4 - f5);
        this.addRectangleRoundedCorner(f + f3 - f5, f2 + f4 - f5, f5, 0.0f, f7, n, floatBuffer);
        floatBuffer.put(f + f3 - f5);
        floatBuffer.put(f2 + f4);
        floatBuffer.put(f + f5);
        floatBuffer.put(f2 + f4);
        this.addRectangleRoundedCorner(f + f5, f2 + f4 - f5, f5, f7, f7, n, floatBuffer);
        floatBuffer.put(f);
        floatBuffer.put(f2 + f4 - f5);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public FloatBuffer makeRectangleWithLeader(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f3 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f) {
            String string = Logging.getMessage("Geom.HeightIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f7 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f7 == 0.0f) {
            return this.makeRectangle(f, f2, f3, f4);
        }
        int n = this.computeLeaderLocationCode(f, f2, f + f3, f2 + f4, f5, f6);
        if (n == 0) {
            return this.makeRectangle(f, f2, f3, f4);
        }
        if ((n & 2) != 0) {
            if (f7 > f3) {
                f7 = f3;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(14);
            floatBuffer.put(f + f3 / 2.0f + f7 / 2.0f);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3 / 2.0f - f7 / 2.0f);
            floatBuffer.put(f2);
            floatBuffer.put(f5);
            floatBuffer.put(f6);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n & 1) != 0) {
            if (f7 > f3) {
                f7 = f3;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(14);
            floatBuffer.put(f + f3 / 2.0f - f7 / 2.0f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f + f3 / 2.0f + f7 / 2.0f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f5);
            floatBuffer.put(f6);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n & 8) != 0) {
            if (f7 > f4) {
                f7 = f4;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(14);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 / 2.0f - f7 / 2.0f);
            floatBuffer.put(f);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 / 2.0f + f7 / 2.0f);
            floatBuffer.put(f5);
            floatBuffer.put(f6);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n & 4) != 0) {
            if (f7 > f4) {
                f7 = f4;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(14);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 / 2.0f + f7 / 2.0f);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 / 2.0f - f7 / 2.0f);
            floatBuffer.put(f5);
            floatBuffer.put(f6);
            floatBuffer.rewind();
            return floatBuffer;
        }
        return this.makeRectangle(f, f2, f3, f4);
    }

    public FloatBuffer makeRectangleWithLeader(float f, float f2, float f3, float f4, float f5, int n, float f6, float f7, float f8) {
        if (f3 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f) {
            String string = Logging.getMessage("Geom.HeightIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f5 < 0.0f) {
            String string = Logging.getMessage("Geom.RadiusIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.NumSlicesIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (f8 < 0.0f) {
            String string = Logging.getMessage("Geom.WidthIsNegative");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f9 = Math.min(f3, f4) / 2.0f;
        if (f5 > f9) {
            f5 = f9;
        }
        if (f5 == 0.0f || n == 0) {
            return this.makeRectangleWithLeader(f, f2, f3, f4, f6, f7, f8);
        }
        if (f8 == 0.0f) {
            return this.makeRectangle(f, f2, f3, f4, f5, n);
        }
        int n2 = this.computeLeaderLocationCode(f, f2, f + f3, f2 + f4, f6, f7);
        if (n2 == 0) {
            return this.makeRectangle(f, f2, f3, f4, f5, n);
        }
        float f10 = 1.5707964f;
        if ((n2 & 2) != 0) {
            float f11 = f3 - 2.0f * f5;
            if (f8 > f11) {
                f8 = f11;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(22 + 8 * (n - 1));
            floatBuffer.put(f + f3 / 2.0f + f8 / 2.0f);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f5, f5, -f10, f10, n, floatBuffer);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f5);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 - f5);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f4 - f5, f5, 0.0f, f10, n, floatBuffer);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2 + f4);
            this.addRectangleRoundedCorner(f + f5, f2 + f4 - f5, f5, f10, f10, n, floatBuffer);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 - f5);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f5);
            this.addRectangleRoundedCorner(f + f5, f + f5, f5, (float)Math.PI, f10, n, floatBuffer);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3 / 2.0f - f8 / 2.0f);
            floatBuffer.put(f2);
            floatBuffer.put(f6);
            floatBuffer.put(f7);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n2 & 1) != 0) {
            float f12 = f3 - 2.0f * f5;
            if (f8 > f12) {
                f8 = f12;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(22 + 8 * (n - 1));
            floatBuffer.put(f + f3 / 2.0f - f8 / 2.0f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2 + f4);
            this.addRectangleRoundedCorner(f + f5, f2 + f4 - f5, f5, f10, f10, n, floatBuffer);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 - f5);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f5);
            this.addRectangleRoundedCorner(f + f5, f + f5, f5, (float)Math.PI, f10, n, floatBuffer);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f5, f5, -f10, f10, n, floatBuffer);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f5);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 - f5);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f4 - f5, f5, 0.0f, f10, n, floatBuffer);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f + f3 / 2.0f + f8 / 2.0f);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f6);
            floatBuffer.put(f7);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n2 & 8) != 0) {
            float f13 = f4 - 2.0f * f5;
            if (f8 > f13) {
                f8 = f13;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(22 + 8 * (n - 1));
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 / 2.0f - f8 / 2.0f);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f5);
            this.addRectangleRoundedCorner(f + f5, f + f5, f5, (float)Math.PI, f10, n, floatBuffer);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f5, f5, -f10, f10, n, floatBuffer);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f5);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 - f5);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f4 - f5, f5, 0.0f, f10, n, floatBuffer);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2 + f4);
            this.addRectangleRoundedCorner(f + f5, f2 + f4 - f5, f5, f10, f10, n, floatBuffer);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 - f5);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 / 2.0f + f8 / 2.0f);
            floatBuffer.put(f6);
            floatBuffer.put(f7);
            floatBuffer.rewind();
            return floatBuffer;
        }
        if ((n2 & 4) != 0) {
            float f14 = f4 - 2.0f * f5;
            if (f8 > f14) {
                f8 = f14;
            }
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(22 + 8 * (n - 1));
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 / 2.0f + f8 / 2.0f);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 - f5);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f4 - f5, f5, 0.0f, f10, n, floatBuffer);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2 + f4);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2 + f4);
            this.addRectangleRoundedCorner(f + f5, f2 + f4 - f5, f5, f10, f10, n, floatBuffer);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f4 - f5);
            floatBuffer.put(f);
            floatBuffer.put(f2 + f5);
            this.addRectangleRoundedCorner(f + f5, f + f5, f5, (float)Math.PI, f10, n, floatBuffer);
            floatBuffer.put(f + f5);
            floatBuffer.put(f2);
            floatBuffer.put(f + f3 - f5);
            floatBuffer.put(f2);
            this.addRectangleRoundedCorner(f + f3 - f5, f2 + f5, f5, -f10, f10, n, floatBuffer);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f5);
            floatBuffer.put(f + f3);
            floatBuffer.put(f2 + f4 / 2.0f - f8 / 2.0f);
            floatBuffer.put(f6);
            floatBuffer.put(f7);
            floatBuffer.rewind();
            return floatBuffer;
        }
        return this.makeRectangle(f, f2, f3, f4, f5, n);
    }

    protected void addRectangleRoundedCorner(float f, float f2, float f3, float f4, float f5, int n, FloatBuffer floatBuffer) {
        if ((float)n == 0.0f) {
            return;
        }
        float f6 = f5 / (float)n;
        float f7 = f4 + f6;
        int n2 = 1;
        while (n2 < n) {
            floatBuffer.put(f + (float)Math.cos(f7) * f3);
            floatBuffer.put(f2 + (float)Math.sin(f7) * f3);
            ++n2;
            f7 += f6;
        }
    }

    protected int computeLeaderLocationCode(float f, float f2, float f3, float f4, float f5, float f6) {
        return (f6 > f4 ? 1 : 0) | (f6 < f2 ? 2 : 0) | (f5 > f3 ? 4 : 0) | (f5 < f ? 8 : 0);
    }

    public <T> void reversePoints(int n, int n2, T[] TArray) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pos=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (TArray == null) {
            String string = "nullValue.PointsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (TArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "points.length < " + (n + n2));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        int n4 = n2 >> 1;
        int n5 = n2 - 1;
        while (n3 < n4) {
            T t = TArray[n + n3];
            TArray[n + n3] = TArray[n + n5];
            TArray[n + n5] = t;
            ++n3;
            --n5;
        }
    }

    private int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    private float[] copyOf(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    private IntBuffer copyOf(IntBuffer intBuffer, int n) {
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(n);
        intBuffer.rewind();
        intBuffer2.put(intBuffer);
        return intBuffer2;
    }

    private FloatBuffer copyOf(FloatBuffer floatBuffer, int n) {
        FloatBuffer floatBuffer2 = Buffers.newDirectFloatBuffer(n);
        floatBuffer.rewind();
        floatBuffer2.put(floatBuffer);
        return floatBuffer2;
    }

    private void facenorm(float[] fArray, int n, int n2, int n3, float[] fArray2) {
        int n4 = 3 * n;
        int n5 = 3 * n2;
        int n6 = 3 * n3;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        this.sub3(fArray, n5, fArray, n4, fArray3, 0);
        this.sub3(fArray, n6, fArray, n4, fArray4, 0);
        this.cross3(fArray3, fArray4, fArray2);
        this.norm3AndSet(fArray2, 0);
    }

    private void facenorm(FloatBuffer floatBuffer, int n, int n2, int n3, float[] fArray) {
        int n4 = 3 * n;
        int n5 = 3 * n2;
        int n6 = 3 * n3;
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        this.sub3(floatBuffer, n5, floatBuffer, n4, fArray2, 0);
        this.sub3(floatBuffer, n6, floatBuffer, n4, fArray3, 0);
        this.cross3(fArray2, fArray3, fArray);
        this.norm3AndSet(fArray, 0);
    }

    private void add3AndSet(float[] fArray, int n, float[] fArray2, int n2) {
        fArray[n] = fArray[n] + fArray2[n2];
        fArray[n + 1] = fArray[n + 1] + fArray2[n2 + 1];
        fArray[n + 2] = fArray[n + 2] + fArray2[n2 + 2];
    }

    private void add3AndSet(FloatBuffer floatBuffer, int n, float[] fArray, int n2) {
        floatBuffer.put(n, floatBuffer.get(n) + fArray[n2]);
        floatBuffer.put(n + 1, floatBuffer.get(n + 1) + fArray[n2 + 1]);
        floatBuffer.put(n + 2, floatBuffer.get(n + 2) + fArray[n2 + 2]);
    }

    private void sub3(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray3[n3] = fArray[n] - fArray2[n2];
        fArray3[n3 + 1] = fArray[n + 1] - fArray2[n2 + 1];
        fArray3[n3 + 2] = fArray[n + 2] - fArray2[n2 + 2];
    }

    private void sub3(FloatBuffer floatBuffer, int n, FloatBuffer floatBuffer2, int n2, float[] fArray, int n3) {
        fArray[n3] = floatBuffer.get(n) - floatBuffer2.get(n2);
        fArray[n3 + 1] = floatBuffer.get(n + 1) - floatBuffer2.get(n2 + 1);
        fArray[n3 + 2] = floatBuffer.get(n + 2) - floatBuffer2.get(n2 + 2);
    }

    private void cross3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }

    private void mul3AndSet(float[] fArray, int n, float f) {
        int n2 = n;
        fArray[n2] = fArray[n2] * f;
        int n3 = n + 1;
        fArray[n3] = fArray[n3] * f;
        int n4 = n + 2;
        fArray[n4] = fArray[n4] * f;
    }

    private void mul3AndSet(FloatBuffer floatBuffer, int n, float f) {
        floatBuffer.put(n, floatBuffer.get(n) * f);
        floatBuffer.put(n + 1, floatBuffer.get(n + 1) * f);
        floatBuffer.put(n + 2, floatBuffer.get(n + 2) * f);
    }

    private void mulAndSet(FloatBuffer floatBuffer, int n, float f, int n2) {
        floatBuffer.put(n + n2, floatBuffer.get(n + n2) * f);
    }

    private void norm3AndSet(float[] fArray, int n) {
        float f = fArray[n] * fArray[n] + fArray[n + 1] * fArray[n + 1] + fArray[n + 2] * fArray[n + 2];
        if (f != 0.0f) {
            f = (float)Math.sqrt(f);
            int n2 = n;
            fArray[n2] = fArray[n2] / f;
            int n3 = n + 1;
            fArray[n3] = fArray[n3] / f;
            int n4 = n + 2;
            fArray[n4] = fArray[n4] / f;
        }
    }

    private void norm3AndSet(FloatBuffer floatBuffer, int n) {
        float f = floatBuffer.get(n) * floatBuffer.get(n) + floatBuffer.get(n + 1) * floatBuffer.get(n + 1) + floatBuffer.get(n + 2) * floatBuffer.get(n + 2);
        if (f != 0.0f) {
            f = (float)Math.sqrt(f);
            floatBuffer.put(n, floatBuffer.get(n) / f);
            floatBuffer.put(n + 1, floatBuffer.get(n + 1) / f);
            floatBuffer.put(n + 2, floatBuffer.get(n + 2) / f);
        }
    }

    private int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private static class Edge {
        public final int a;
        public final int b;

        public Edge(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Edge edge = (Edge)object;
            return this.a == edge.a && this.b == edge.b || this.a == edge.b && this.b == edge.a;
        }

        public int hashCode() {
            return this.a + this.b;
        }
    }

    public static class IndexedTriangleArray {
        private int indexCount;
        private int vertexCount;
        private int[] indices;
        private float[] vertices;

        public IndexedTriangleArray(int n, int[] nArray, int n2, float[] fArray) {
            this.indexCount = n;
            this.indices = nArray;
            this.vertexCount = n2;
            this.vertices = fArray;
        }

        public int getIndexCount() {
            return this.indexCount;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public float[] getVertices() {
            return this.vertices;
        }

        static /* synthetic */ float[] access$1202(IndexedTriangleArray indexedTriangleArray, float[] fArray) {
            indexedTriangleArray.vertices = fArray;
            return fArray;
        }

        static /* synthetic */ int[] access$1102(IndexedTriangleArray indexedTriangleArray, int[] nArray) {
            indexedTriangleArray.indices = nArray;
            return nArray;
        }
    }

    public static class IndexedTriangleBuffer {
        private IntBuffer indices;
        private FloatBuffer vertices;
        private int indexCount;
        private int vertexCount;

        public IndexedTriangleBuffer(int n, IntBuffer intBuffer, int n2, FloatBuffer floatBuffer) {
            this.indices = intBuffer;
            this.vertices = floatBuffer;
            this.indexCount = n;
            this.vertexCount = n2;
        }

        public int getIndexCount() {
            return this.indexCount;
        }

        public IntBuffer getIndices() {
            return this.indices;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public FloatBuffer getVertices() {
            return this.vertices;
        }
    }

    private static class TessellatorCallback
    extends GLUtessellatorCallbackAdapter {
        private GeometryBuilder gb;
        private int type;
        private int indexCount;
        private int primIndexCount;
        private int vertexCount;
        private int[] indices;
        private int[] primIndices;
        private float[] vertices;

        private TessellatorCallback(GeometryBuilder geometryBuilder, int n, float[] fArray) {
            this.gb = geometryBuilder;
            this.indexCount = 0;
            this.primIndexCount = 0;
            this.vertexCount = n;
            int n2 = this.gb.nextPowerOfTwo(3 * n);
            this.indices = new int[n2];
            this.primIndices = new int[n2];
            this.vertices = this.gb.copyOf(fArray, n2);
        }

        public int getIndexCount() {
            return this.indexCount;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public float[] getVertices() {
            return this.vertices;
        }

        protected void addTriangle(int n, int n2, int n3) {
            int n4 = this.indexCount + 3;
            int n5 = this.indices.length;
            while (n4 > n5) {
                int n6 = 2 * n5;
                this.indices = this.gb.copyOf(this.indices, n6);
                n5 = n4;
            }
            if (this.gb.orientation == 1) {
                this.indices[this.indexCount++] = this.primIndices[n];
                this.indices[this.indexCount++] = this.primIndices[n3];
                this.indices[this.indexCount++] = this.primIndices[n2];
            } else {
                this.indices[this.indexCount++] = this.primIndices[n];
                this.indices[this.indexCount++] = this.primIndices[n2];
                this.indices[this.indexCount++] = this.primIndices[n3];
            }
        }

        @Override
        public void begin(int n) {
            this.type = n;
            this.primIndexCount = 0;
        }

        @Override
        public void vertex(Object object) {
            int n = this.primIndices.length;
            int n2 = this.primIndexCount + 1;
            while (n2 > n) {
                int n3 = 2 * n;
                this.primIndices = this.gb.copyOf(this.primIndices, n3);
                n = n3;
            }
            int n4 = (Integer)object;
            this.primIndices[this.primIndexCount++] = n4;
        }

        @Override
        public void end() {
            block5: {
                block6: {
                    block4: {
                        if (this.type != 4) break block4;
                        for (int i = 2; i < this.primIndexCount; ++i) {
                            if ((i + 1) % 3 != 0) continue;
                            this.addTriangle(i - 2, i - 1, i);
                        }
                        break block5;
                    }
                    if (this.type != 5) break block6;
                    for (int i = 2; i < this.primIndexCount; ++i) {
                        if (i % 2 == 0) {
                            this.addTriangle(i - 2, i - 1, i);
                            continue;
                        }
                        this.addTriangle(i - 1, i - 2, i);
                    }
                    break block5;
                }
                if (this.type != 6) break block5;
                for (int i = 2; i < this.primIndexCount; ++i) {
                    this.addTriangle(0, i - 1, i);
                }
            }
        }

        @Override
        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = objectArray[0];
        }
    }
}

