/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

public class DecisionTree<T, C> {
    protected Controller<T, C> controller;

    public DecisionTree(Controller<T, C> controller) {
        this.controller = controller;
    }

    public void traverse(T t, C c) {
        if (!this.controller.isVisible(t, c)) {
            return;
        }
        if (this.controller.isTerminal(t, c)) {
            return;
        }
        for (T t2 : this.controller.split(t, c)) {
            this.traverse(t2, c);
        }
    }

    public static interface Controller<T, C> {
        public boolean isVisible(T var1, C var2);

        public boolean isTerminal(T var1, C var2);

        public T[] split(T var1, C var2);
    }
}

