/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class HoldingLine
extends AbstractMilStd2525TacticalGraphic {
    public static final int DEFAULT_NUM_INTERVALS = 32;
    public static final double DEFAULT_CURVATURE = 0.3;
    protected Path path;
    protected double curvature = 0.3;
    protected int intervals = 32;
    protected Position position1;
    protected Position position2;
    protected Position position3;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-SLH--------", "G-G-SLB--------");
    }

    public HoldingLine(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.position1 = iterator.next();
            this.position2 = iterator.next();
            this.position3 = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.path = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position1, this.position2, this.position3);
    }

    @Override
    public Position getReferencePosition() {
        return this.position1;
    }

    public double getCurvature() {
        return this.curvature;
    }

    public void setCurvature(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.curvature = d;
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    protected void onShapeChanged() {
        this.path = null;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.path == null) {
            this.createShape(drawContext);
        }
        this.path.render(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.path != null) {
            this.path.setDelegateOwner(object);
        }
    }

    protected void createShape(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromLocation(this.position1);
        Vec4 vec42 = globe.computePointFromLocation(this.position2);
        Vec4 vec43 = globe.computePointFromLocation(this.position3);
        LatLon latLon = LatLon.interpolateGreatCircle(0.5, this.position1, this.position2);
        Vec4 vec44 = globe.computePointFromLocation(latLon);
        Vec4 vec45 = vec43.subtract3(vec44);
        double d = vec4.subtract3(vec42).getLength3();
        double d2 = vec45.getLength3();
        double d3 = Math.min(d, d2) * this.getCurvature();
        Vec4 vec46 = vec4.add3(vec45);
        Vec4 vec47 = vec42.add3(vec45);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int n = this.getIntervals();
        arrayList.add(this.position1);
        this.computeRoundCorner(globe, arrayList, vec4, vec46, vec43, d3, n);
        arrayList.add(this.position3);
        this.computeRoundCorner(globe, arrayList, vec43, vec47, vec42, d3, n);
        arrayList.add(this.position2);
        this.path = this.createPath();
        this.path.setPositions(arrayList);
    }

    protected void computeRoundCorner(Globe globe, List<Position> list, Vec4 vec4, Vec4 vec42, Vec4 vec43, double d, int n) {
        Vec4 vec44;
        Vec4 vec45 = vec4.subtract3(vec42);
        Angle angle = vec45.angleBetween3(vec44 = vec43.subtract3(vec42));
        if (Angle.ZERO.equals(angle)) {
            return;
        }
        double d2 = d * angle.tanHalfAngle();
        Vec4 vec46 = vec42.add3(vec45.normalize3().multiply3(d));
        Vec4 vec47 = vec42.add3(vec44.normalize3().multiply3(d));
        Vec4 vec48 = globe.computeSurfaceNormalAtPoint(vec46);
        Vec4 vec49 = vec48.cross3(vec45);
        Vec4 vec410 = vec49.normalize3().multiply3(d2);
        double d3 = vec49.dot3(vec44);
        if (d3 < 0.0) {
            vec410 = vec410.multiply3(-1.0);
        }
        Vec4 vec411 = vec46.add3(vec410);
        Position position = globe.computePositionFromPoint(vec411);
        Position position2 = globe.computePositionFromPoint(vec46);
        Position position3 = globe.computePositionFromPoint(vec47);
        this.computeArc(globe, list, position, LatLon.greatCircleAzimuth(position, position2), LatLon.greatCircleAzimuth(position, position3), d2, n);
    }

    protected void computeArc(Globe globe, List<Position> list, Position position, Angle angle, Angle angle2, double d, int n) {
        Angle angle3 = angle2.subtract(angle).normalizedLongitude();
        Angle angle4 = angle3.divide(n);
        double d2 = globe.getRadiusAt(position.getLatitude(), position.getLongitude());
        double d3 = d / d2;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)i * angle4.radians + angle.radians;
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, d4, d3);
            list.add(new Position(latLon, 0.0));
        }
    }

    @Override
    protected void createLabels() {
        String string = this.getGraphicLabel();
        this.addLabel(string);
        this.addLabel(string);
    }

    protected String getGraphicLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PL ");
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(string);
        }
        if ("G-G-SLH--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            stringBuilder.append("\n(HOLDING LINE)");
        } else if ("G-G-SLB--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            stringBuilder.append("\n(BRIDGEHEAD LINE)");
        }
        return stringBuilder.toString();
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        TacticalGraphicLabel tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(0);
        TacticalGraphicLabel tacticalGraphicLabel2 = (TacticalGraphicLabel)this.labels.get(1);
        tacticalGraphicLabel.setPosition(this.position1);
        tacticalGraphicLabel2.setPosition(this.position2);
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

