/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SectorRangeFan
extends AbstractMilStd2525TacticalGraphic
implements PreRenderable {
    public static final int DEFAULT_NUM_INTERVALS = 32;
    public static final double DEFAULT_CENTER_OF_SECTOR_LENGTH = 1.2;
    public static final double DEFAULT_ARROWHEAD_LENGTH = 0.05;
    public static final Angle DEFAULT_ARROWHEAD_ANGLE = Angle.fromDegrees(60.0);
    protected static final double AZIMUTH_LABEL_OFFSET = 0.03;
    public static final NumberFormat DEFAULT_NUMBER_FORMAT = new DecimalFormat("#");
    protected Angle arrowAngle = DEFAULT_ARROWHEAD_ANGLE;
    protected double arrowLength = 0.05;
    protected double centerOfSectorLength = 1.2;
    protected int intervals = 32;
    protected NumberFormat azimuthFormat = DEFAULT_NUMBER_FORMAT;
    protected NumberFormat radiusFormat = DEFAULT_NUMBER_FORMAT;
    protected Position position;
    protected List<Path> paths;
    protected SurfacePolygon arrowHead;
    protected TacticalSymbol symbol;
    protected TacticalSymbolAttributes symbolAttributes;
    protected Iterable<Double> radii;
    protected Iterable<? extends Angle> azimuths;
    protected Iterable<String> altitudes;
    protected Angle centerAzimuth;
    protected double maxRadius;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-AXS--------");
    }

    public SectorRangeFan(String string) {
        super(string);
    }

    public Angle getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0 || angle.degrees >= 90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowAngle = angle;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowLength = d;
    }

    public double getCenterOfSectorLength() {
        return this.centerOfSectorLength;
    }

    public void setCenterOfSector(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerOfSectorLength = d;
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.reset();
    }

    public NumberFormat getAzimuthFormat() {
        return this.azimuthFormat;
    }

    public void setAzimuthFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.azimuthFormat = numberFormat;
    }

    public NumberFormat getRadiusFormat() {
        return this.radiusFormat;
    }

    public void setRadiusFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.radiusFormat = numberFormat;
    }

    public Position getPosition() {
        return this.getReferencePosition();
    }

    public void setPosition(Position position) {
        this.moveTo(position);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = iterator.next();
        this.reset();
        if (this.symbol != null) {
            this.symbol.setPosition(this.position);
        }
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("AM".equals(string)) {
            if (object instanceof Iterable) {
                this.setRadii((Iterable)object);
            } else if (object instanceof Double) {
                this.setRadii(Arrays.asList((Double)object));
            }
        } else if ("AN".equals(string)) {
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                this.setAzimuths(iterable);
            } else if (object instanceof Angle) {
                this.setAzimuths(Arrays.asList((Angle)object));
            }
        } else if ("X".equals(string)) {
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                this.setAltitudes(iterable);
            } else if (object != null) {
                this.setAltitudes(Arrays.asList(object.toString()));
            }
        } else if ("A".equals(string) && object instanceof String) {
            this.setSymbol((String)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("AM".equals(string)) {
            return this.getRadii();
        }
        if ("AN".equals(string)) {
            return this.getAzimuths();
        }
        if ("X".equals(string)) {
            return this.getAltitudes();
        }
        if ("A".equals(string)) {
            return this.getSymbol();
        }
        return super.getModifier(string);
    }

    public Iterable<Double> getRadii() {
        if (this.radii != null) {
            return this.radii;
        }
        return Collections.emptyList();
    }

    public void setRadii(Iterable<Double> iterable) {
        this.radii = iterable;
        this.onModifierChanged();
        this.reset();
    }

    public Iterable<? extends Angle> getAzimuths() {
        if (this.azimuths != null) {
            return this.azimuths;
        }
        return Collections.emptyList();
    }

    public void setAzimuths(Iterable<? extends Angle> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.azimuths = iterable;
        this.onModifierChanged();
        this.reset();
    }

    public Iterable<String> getAltitudes() {
        if (this.altitudes != null) {
            return this.altitudes;
        }
        return Collections.emptyList();
    }

    public void setAltitudes(Iterable<String> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.altitudes = iterable;
    }

    public String getSymbol() {
        return this.symbol != null ? this.symbol.getIdentifier() : null;
    }

    public void setSymbol(String string) {
        if (string != null) {
            if (this.symbolAttributes == null) {
                this.symbolAttributes = new BasicTacticalSymbolAttributes();
            }
            this.symbol = this.createSymbol(string, this.getPosition(), this.symbolAttributes);
        } else {
            this.symbol = null;
            this.symbolAttributes = null;
        }
        this.onModifierChanged();
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position);
    }

    @Override
    public Position getReferencePosition() {
        return this.position;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes();
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        if (this.arrowHead != null) {
            this.arrowHead.preRender(drawContext);
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        for (Path path : this.paths) {
            path.render(drawContext);
        }
        if (this.arrowHead != null) {
            this.arrowHead.render(drawContext);
        }
    }

    @Override
    protected void doRenderGraphicModifiers(DrawContext drawContext) {
        super.doRenderGraphicModifiers(drawContext);
        if (this.symbol != null) {
            this.symbol.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths != null) {
            for (Path path : this.paths) {
                path.setDelegateOwner(object);
            }
        }
        if (this.arrowHead != null) {
            this.arrowHead.setDelegateOwner(object);
        }
    }

    protected void reset() {
        this.paths = null;
    }

    protected void createShapes(DrawContext drawContext) {
        boolean bl;
        this.paths = new ArrayList<Path>();
        Iterator<Double> iterator = this.getRadii().iterator();
        Iterator<? extends Angle> iterator2 = this.getAzimuths().iterator();
        Angle angle = Angle.NEG180;
        Angle angle2 = Angle.POS180;
        double d = 0.0;
        while (iterator.hasNext()) {
            double d2 = iterator.next();
            if (d2 > this.maxRadius) {
                this.maxRadius = d2;
            }
            Angle angle3 = iterator2.hasNext() ? iterator2.next() : angle;
            Angle angle4 = iterator2.hasNext() ? iterator2.next() : angle2;
            angle3 = this.normalizeAzimuth(angle3);
            angle4 = this.normalizeAzimuth(angle4);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            this.createArc(drawContext, d, Angle.max(angle3, angle), angle3, arrayList);
            this.createArc(drawContext, d2, angle3, angle4, arrayList);
            this.createArc(drawContext, d, angle4, Angle.min(angle4, angle2), arrayList);
            this.paths.add(this.createPath(arrayList));
            d = d2;
            angle = angle3;
            angle2 = angle4;
        }
        boolean bl2 = bl = Math.abs(angle.subtract((Angle)angle2).degrees) >= 360.0;
        if (!bl) {
            this.centerAzimuth = this.computeCenterSectorAngle(angle, angle2);
            this.createCenterOfSectorArrow(drawContext, this.centerAzimuth, d);
        } else {
            this.centerAzimuth = Angle.POS180;
        }
    }

    protected void createCenterOfSectorArrow(DrawContext drawContext, Angle angle, double d) {
        Position position = this.getPosition();
        List<Position> list = new ArrayList<Position>();
        list.add(position);
        this.createArc(drawContext, d * this.getCenterOfSectorLength(), angle, angle, list);
        this.paths.add(this.createPath(list));
        Position position2 = (Position)list.get(list.size() - 1);
        this.arrowHead = this.createPolygon();
        list = this.computeArrowheadPositions(drawContext, position, position2, this.getArrowLength(), this.getArrowAngle());
        this.arrowHead.setLocations(list);
    }

    protected Angle computeCenterSectorAngle(Angle angle, Angle angle2) {
        return angle.add(angle2).divide(2.0);
    }

    protected void createArc(DrawContext drawContext, double d, Angle angle, Angle angle2, List<Position> list) {
        Globe globe = drawContext.getGlobe();
        int n = this.getIntervals();
        Position position = this.getPosition();
        double d2 = globe.getRadiusAt(position.getLatitude(), position.getLongitude());
        double d3 = d / d2;
        if (angle.equals(angle2)) {
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle.radians, d3);
            list.add(new Position(latLon, 0.0));
            return;
        }
        Angle angle3 = angle2.subtract(angle);
        Angle angle4 = angle3.divide(n);
        for (int i = 0; i < n + 1; ++i) {
            double d4 = (double)i * angle4.radians + angle.radians;
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, d4, d3);
            list.add(new Position(latLon, 0.0));
        }
    }

    protected List<Position> computeArrowheadPositions(DrawContext drawContext, Position position, Position position2, double d, Angle angle) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec42);
        Vec4 vec45 = vec44.cross3(vec43);
        double d2 = d * vec43.getLength3();
        double d3 = d2 * angle.tanHalfAngle();
        vec45 = vec45.normalize3().multiply3(d3);
        vec43 = vec43.normalize3().multiply3(d2);
        Vec4 vec46 = vec42.add3(vec43).add3(vec45);
        Vec4 vec47 = vec42.add3(vec43).subtract3(vec45);
        return TacticalGraphicUtil.asPositionList(globe, vec46, vec47, vec42);
    }

    @Override
    protected void createLabels() {
        Iterable<Double> iterable = this.getRadii();
        if (iterable == null) {
            return;
        }
        Iterator<String> iterator = this.getAltitudes().iterator();
        Iterator<? extends Angle> iterator2 = this.getAzimuths().iterator();
        Angle angle = null;
        Angle angle2 = null;
        for (Double d : iterable) {
            if (iterator2.hasNext()) {
                angle = iterator2.next();
            }
            if (iterator2.hasNext()) {
                angle2 = iterator2.next();
            }
            String string = null;
            if (iterator.hasNext()) {
                string = iterator.next();
            }
            this.addLabel(this.createRangeLabelString(d, string));
            if (angle != null) {
                this.addLabel(this.createAzimuthLabelString(angle));
            }
            if (angle2 == null) continue;
            this.addLabel(this.createAzimuthLabelString(angle2));
        }
    }

    protected void createAzimuthLabels() {
        Iterable<? extends Angle> iterable = this.getAzimuths();
        if (iterable == null) {
            return;
        }
        for (Angle angle : iterable) {
            this.addLabel(this.createAzimuthLabelString(angle));
        }
    }

    protected String createRangeLabelString(double d, String string) {
        NumberFormat numberFormat = this.getRadiusFormat();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RG ").append(numberFormat.format(d));
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append("\nALT ").append(string);
        }
        return stringBuilder.toString();
    }

    protected String createAzimuthLabelString(Angle angle) {
        NumberFormat numberFormat = this.getAzimuthFormat();
        return numberFormat.format(angle.degrees);
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (this.labels == null) {
            return;
        }
        Position position = this.getPosition();
        Iterator iterator = this.labels.iterator();
        Iterator<Double> iterator2 = this.getRadii().iterator();
        Iterator<? extends Angle> iterator3 = this.getAzimuths().iterator();
        Angle angle = null;
        Angle angle2 = null;
        double d = 0.0;
        double d2 = drawContext.getGlobe().getRadiusAt(position);
        while (iterator2.hasNext() && iterator.hasNext()) {
            LatLon latLon;
            if (iterator3.hasNext()) {
                angle = iterator3.next();
            }
            if (iterator3.hasNext()) {
                angle2 = iterator3.next();
            }
            angle = this.normalizeAzimuth(angle);
            angle2 = this.normalizeAzimuth(angle2);
            TacticalGraphicLabel tacticalGraphicLabel = (TacticalGraphicLabel)iterator.next();
            TacticalGraphicLabel tacticalGraphicLabel2 = null;
            TacticalGraphicLabel tacticalGraphicLabel3 = null;
            if (angle != null && iterator.hasNext()) {
                tacticalGraphicLabel2 = (TacticalGraphicLabel)iterator.next();
            }
            if (angle2 != null && iterator.hasNext()) {
                tacticalGraphicLabel3 = (TacticalGraphicLabel)iterator.next();
            }
            double d3 = iterator2.next();
            double d4 = (d3 + d) / 2.0;
            double d5 = d4 / d2;
            Position position2 = this.determineRangeLabelPosition(position, this.centerAzimuth, angle, angle2, d5);
            tacticalGraphicLabel.setPosition(position2);
            double d6 = this.computeAzimuthLabelOffset(d4, this.maxRadius);
            if (angle != null && tacticalGraphicLabel2 != null) {
                latLon = LatLon.greatCircleEndPosition((LatLon)position, angle.radians - d6, d5);
                tacticalGraphicLabel2.setPosition(new Position(latLon, 0.0));
            }
            if (angle2 != null && tacticalGraphicLabel3 != null) {
                latLon = LatLon.greatCircleEndPosition((LatLon)position, angle2.radians + d6, d5);
                tacticalGraphicLabel3.setPosition(new Position(latLon, 0.0));
            }
            d = d3;
        }
    }

    protected double computeAzimuthLabelOffset(double d, double d2) {
        return Math.asin(0.03 * d2 / d);
    }

    protected Position determineRangeLabelPosition(Position position, Angle angle, Angle angle2, Angle angle3, double d) {
        angle2 = angle2 != null ? angle2 : angle;
        angle3 = angle3 != null ? angle3 : angle;
        double d2 = Math.abs(angle.subtract((Angle)angle2).degrees);
        double d3 = Math.abs(angle.subtract((Angle)angle3).degrees);
        Angle angle4 = d2 > d3 ? angle2 : angle3;
        angle4 = angle4.add(angle).divide(2.0);
        LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle4.radians, d);
        return new Position(latLon, 0.0);
    }

    protected Angle normalizeAzimuth(Angle angle) {
        if (angle != null) {
            return Angle.normalizedLongitude(angle);
        }
        return null;
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        Material material = this.getDefaultMaterial();
        shapeAttributes.setInteriorMaterial(material);
        shapeAttributes.setDrawInterior(true);
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setScale(this.activeOverrides.getScale());
        }
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }

    protected SurfacePolygon createPolygon() {
        SurfacePolygon surfacePolygon = new SurfacePolygon();
        surfacePolygon.setDelegateOwner(this.getActiveDelegateOwner());
        surfacePolygon.setAttributes(this.getActiveShapeAttributes());
        return surfacePolygon;
    }
}

